#ifndef _HTTP_UPGRADE_H_
#define _HTTP_UPGRADE_H_
#include <common.h>
#include "image_header.h"
/* Error code for uboot upgrade. */
#define ERR_NONE                           0
#define ERR_GENERIC                       -1
#define ERR_RSA_CHECK_FAIL                -2
#define ERR_HWID_NOT_FOUND                -3
#define ERR_FWID_NOT_FOUND                -4
#define ERR_HWID_NOT_SUPPORTED            -5
#define ERR_FWID_NOT_SUPPORTED            -6
#define ERR_PARTITION_TYPE_NOT_SUPPORTED  -7
#define ERR_INCORRECT_FILE_SIZE           -8
#define ERR_READ_FLASH                    -9
#define ERR_WRITE_FLASH                   -10
#define ERR_ERASE_FLASH                   -11
#define ERR_BAD_ADDRESS                   -12
#define ERR_MEMORY_ALLOC                  -13
#define ERR_INVALID_TP_HEADER             -14
#define ERR_PARTITION_VALIDATION_FAILED   -15

#define RECOVERY_UPGRADE_VEBOSE
//#define RECOVERY_UPGRADE_UNIT_TEST

#ifdef RECOVERY_UPGRADE_VEBOSE
#define DBG(fmt, ...)   printf( fmt "\n", ## __VA_ARGS__ ); 
#else
#define DBG(fmt,...) 
#endif

#ifdef RECOVERY_UPGRADE_UNIT_TEST
#define DBG_UNIT DBG
#else
#define DBG_UNIT(...)
#endif

#define ERR(fmt, ...) { \
	printf("error: " fmt "\n", \
	## __VA_ARGS__ ); \
} 

typedef struct _RSA_SIGN_INFO
{
	unsigned char rsasign[256];
	unsigned short rsaLen;
}RSA_SIGN_INFO;

/* board specific implementation */
extern int do_http_check(const ulong size);
extern int do_http_upgrade(const ulong size);
extern int do_http_progress(const int state);
extern int validateLocalFirmware();

#endif //_HTTP_UPGRADE_H_
