/*  Copyright(c) 2009-2020 Shenzhen TP-LINK Technologies Co.Ltd.
 *
 * file		dns.h
 * brief	
 * details	
 *
 * version	
 * date		04Nov20
 *
 * history 	\arg	
 */

#ifndef __DNS_H__
#define __DNS_H__
#include "common.h"


#define DNS_PORT 53
#define DNS_TYPE_AND_CLASS_LEN 4
#define DNS_RESPONSE_POINTER (0xc00c)
#define DNS_RESPONSE_TYPE (0x0001)
#define	DNS_QUERY_CLASS (0x0001)
#define DNS_ANSWER_TTL 1
#define DNS_ANSWER_LEN (0x0004)

#define DNS_MAX_QUERIES_LEN 512

#ifdef CONFIG_MERCUSYS_IP
#define CONFIG_DNS_IP  0xC0A80101 /* 192.168.1.1 */
#else
#define CONFIG_DNS_IP  0xC0A80001 /* 192.168.0.1 */
#endif

typedef struct dns_packet{
	unsigned short id;
	unsigned short flags;
	unsigned short questions;
	unsigned short answerRRs;
	unsigned short authorityRRs;
	unsigned short additionalRRs;
	char data[DNS_MAX_QUERIES_LEN];
};


/**************************************************************************************************/
/*                                           FUNCTIONS                                            */
/**************************************************************************************************/


int getDNSReqLen(char* DNSReqData);

void dns_init(void);

void handle_dns(void);

void create_dns_msg(void);

void dns_appcall(void);

#endif	/* __DNS_H__ */

