/*
 * Copyright (C) 2013 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * Purpose : RTL8367/RTL8367C switch high-level API
 *
 * Feature : The file includes Trap module high-layer VLAN defination
 *
 */

#ifndef __RTK_VLAN_H__
#define __RTK_VLAN_H__

#include "rtl-eth.h"

/****************************************************************/
/* Constant Definition                                          */
/****************************************************************/
#define RTL8367C_PROTOVLAN_GIDX_MAX 3
#define RTL8367C_PROTOVLAN_GROUPNO  4

#define	RTL8367C_VLAN_BUSY_CHECK_NO		(10)


/****************************************************************/
/* Type Definition                                              */
/****************************************************************/
typedef struct  VLANCONFIGSMI
{
#ifdef _LITTLE_ENDIAN
	rtk_uint16	mbr:11;
	rtk_uint16  reserved:5;

	rtk_uint16	fid_msti:4;
	rtk_uint16  reserved2:12;

	rtk_uint16	vbpen:1;
	rtk_uint16	vbpri:3;
	rtk_uint16	envlanpol:1;
	rtk_uint16	meteridx:6;
	rtk_uint16	reserved3:5;

	rtk_uint16	evid:13;
	rtk_uint16  reserved4:3;
#else
	rtk_uint16  reserved:5;
	rtk_uint16	mbr:11;

	rtk_uint16  reserved2:12;
	rtk_uint16	fid_msti:4;

	rtk_uint16	reserved3:5;
	rtk_uint16	meteridx:6;
	rtk_uint16	envlanpol:1;
	rtk_uint16	vbpri:3;
	rtk_uint16	vbpen:1;

	rtk_uint16  reserved4:3;
	rtk_uint16	evid:13;
#endif

}rtl8367c_vlanconfigsmi;

typedef struct  VLANCONFIGUSER
{
    rtk_uint16 	evid;
	rtk_uint16 	mbr;
    rtk_uint16  fid_msti;
    rtk_uint16  envlanpol;
    rtk_uint16  meteridx;
    rtk_uint16  vbpen;
    rtk_uint16  vbpri;
}rtl8367c_vlanconfiguser;

typedef struct  VLANTABLE
{
#ifdef _LITTLE_ENDIAN
	rtk_uint16 	mbr:8;
 	rtk_uint16 	untag:8;

 	rtk_uint16 	fid_msti:4;
 	rtk_uint16 	vbpen:1;
	rtk_uint16	vbpri:3;
	rtk_uint16	envlanpol:1;
	rtk_uint16	meteridx:5;
	rtk_uint16	ivl_svl:1;
	rtk_uint16	mbr_ext_0:1;

	rtk_uint16	mbr_ext_1_2:2;
	rtk_uint16	untagset_ext:3;
	rtk_uint16	mtr_idx_ext:1;
	rtk_uint16	reserved:10;
#else
 	rtk_uint16 	untag:8;
	rtk_uint16 	mbr:8;

	rtk_uint16	mbr_ext_0:1;
	rtk_uint16	ivl_svl:1;
	rtk_uint16	meteridx:5;
	rtk_uint16	envlanpol:1;
	rtk_uint16	vbpri:3;
 	rtk_uint16 	vbpen:1;
 	rtk_uint16 	fid_msti:4;

	rtk_uint16	reserved:10;
	rtk_uint16	mtr_idx_ext:1;
	rtk_uint16	untagset_ext:3;
	rtk_uint16	mbr_ext_1_2:2;

#endif
}rtl8367c_vlan4kentrysmi;

typedef struct  USER_VLANTABLE{

	rtk_uint16 	vid;
	rtk_uint16 	mbr;
 	rtk_uint16 	untag;
    rtk_uint16  fid_msti;
    rtk_uint16  envlanpol;
    rtk_uint16  meteridx;
    rtk_uint16  vbpen;
    rtk_uint16  vbpri;
	rtk_uint16 	ivl_svl;

}rtl8367c_user_vlan4kentry;

typedef enum
{
    FRAME_TYPE_BOTH = 0,
    FRAME_TYPE_TAGGED_ONLY,
    FRAME_TYPE_UNTAGGED_ONLY,
    FRAME_TYPE_MAX_BOUND
} rtl8367c_accframetype;

typedef enum
{
    EG_TAG_MODE_ORI = 0,
    EG_TAG_MODE_KEEP,
    EG_TAG_MODE_PRI_TAG,
    EG_TAG_MODE_REAL_KEEP,
    EG_TAG_MODE_END
} rtl8367c_egtagmode;

typedef enum
{
    PPVLAN_FRAME_TYPE_ETHERNET = 0,
    PPVLAN_FRAME_TYPE_LLC,
    PPVLAN_FRAME_TYPE_RFC1042,
    PPVLAN_FRAME_TYPE_END
} rtl8367c_provlan_frametype;

enum RTL8367C_STPST
{
	STPST_DISABLED = 0,
	STPST_BLOCKING,
	STPST_LEARNING,
	STPST_FORWARDING
};

enum RTL8367C_RESVIDACT
{
	RES_VID_ACT_UNTAG = 0,
	RES_VID_ACT_TAG,
	RES_VID_ACT_END
};

typedef struct
{
    rtl8367c_provlan_frametype  frameType;
    rtk_uint32                      etherType;
} rtl8367c_protocolgdatacfg;

typedef struct
{
    rtk_uint32 valid;
    rtk_uint32 vlan_idx;
    rtk_uint32 priority;
} rtl8367c_protocolvlancfg;

typedef struct rtk_portmask_s
{
    rtk_uint32  bits[1];
} rtk_portmask_t;


/*
 * Data Type Declaration
 */
#define RTK_MAX_NUM_OF_PROTO_TYPE                   0xFFFF
#define RTK_MAX_NUM_OF_MSTI                         0xF
#define RTK_FID_MAX                                 0xF

typedef struct  rtk_vlan_cfg_s
{
	rtk_portmask_t 	mbr;
    rtk_portmask_t 	untag;
    rtk_uint16      ivl_en;
    rtk_uint16      fid_msti;
    rtk_uint16      envlanpol;
    rtk_uint16      meteridx;
    rtk_uint16      vbpen;
    rtk_uint16      vbpri;
}rtk_vlan_cfg_t;

typedef struct  rtk_vlan_mbrcfg_s
{
    rtk_uint16 	    evid;
	rtk_portmask_t 	mbr;
    rtk_uint16      fid_msti;
    rtk_uint16      envlanpol;
    rtk_uint16      meteridx;
    rtk_uint16      vbpen;
    rtk_uint16      vbpri;
}rtk_vlan_mbrcfg_t;

typedef rtk_uint32  rtk_stp_msti_id_t;     /* MSTI ID  */

typedef enum rtk_stp_state_e
{
    STP_STATE_DISABLED = 0,
    STP_STATE_BLOCKING,
    STP_STATE_LEARNING,
    STP_STATE_FORWARDING,
    STP_STATE_END
} rtk_stp_state_t;

typedef rtk_uint32  rtk_vlan_proto_type_t;     /* protocol and port based VLAN protocol type  */


typedef enum rtk_vlan_acceptFrameType_e
{
    ACCEPT_FRAME_TYPE_ALL = 0,             /* untagged, priority-tagged and tagged */
    ACCEPT_FRAME_TYPE_TAG_ONLY,         /* tagged */
    ACCEPT_FRAME_TYPE_UNTAG_ONLY,     /* untagged and priority-tagged */
    ACCEPT_FRAME_TYPE_END
} rtk_vlan_acceptFrameType_t;


/* frame type of protocol vlan - reference 802.1v standard */
typedef enum rtk_vlan_protoVlan_frameType_e
{
    FRAME_TYPE_ETHERNET = 0,
    FRAME_TYPE_LLCOTHER,
    FRAME_TYPE_RFC1042,
    FRAME_TYPE_END
} rtk_vlan_protoVlan_frameType_t;

/* Protocol-and-port-based Vlan structure */
typedef struct rtk_vlan_protoAndPortInfo_s
{
    rtk_uint32                         proto_type;
    rtk_vlan_protoVlan_frameType_t frame_type;
    rtk_vlan_t                     cvid;
    rtk_pri_t                     cpri;
}rtk_vlan_protoAndPortInfo_t;

/* tagged mode of VLAN - reference realtek private specification */
typedef enum rtk_vlan_tagMode_e
{
    VLAN_TAG_MODE_ORIGINAL = 0,
    VLAN_TAG_MODE_KEEP_FORMAT,
    VLAN_TAG_MODE_PRI,
    VLAN_TAG_MODE_REAL_KEEP_FORMAT,
    VLAN_TAG_MODE_END
} rtk_vlan_tagMode_t;

typedef enum rtk_vlan_resVidAction_e
{
    RESVID_ACTION_UNTAG = 0,
    RESVID_ACTION_TAG,
    RESVID_ACTION_END
}
rtk_vlan_resVidAction_t;

/* Function Name:
 *      rtk_vlan_init
 * Description:
 *      Initialize VLAN.
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 * Note:
 *      VLAN is disabled by default. User has to call this API to enable VLAN before
 *      using it. And It will set a default VLAN(vid 1) including all ports and set
 *      all ports PVID to the default VLAN.
 */
extern rtk_api_ret_t rtk_vlan_init(void);

/* Function Name:
 *      rtk_vlan_set
 * Description:
 *      Set a VLAN entry.
 * Input:
 *      vid - VLAN ID to configure.
 *      pVlanCfg - VLAN Configuration
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK                   - OK
 *      RT_ERR_FAILED               - Failed
 *      RT_ERR_SMI                  - SMI access error
 *      RT_ERR_INPUT 		        - Invalid input parameters.
 *      RT_ERR_L2_FID               - Invalid FID.
 *      RT_ERR_VLAN_PORT_MBR_EXIST  - Invalid member port mask.
 *      RT_ERR_VLAN_VID             - Invalid VID parameter.
 * Note:
 *
 */
extern rtk_api_ret_t rtk_vlan_set(rtk_vlan_t vid, rtk_vlan_cfg_t *pVlanCfg);



#endif /* __RTK_API_VLAN_H__ */
