#include <config.h>
#include <asm/regdef.h>
#include <asm/mipsregs.h>
#include "led_definition.h"

/*
 * GPIO_WAN  7
 * GPIO_SYS  42
 * GPIO_LAN  43
 * GPIO_WIFI 72
 */

#define RALINK_SYSCTL_BASE		0xB0000000
#define RALINK_PIO_BASE			0xB0000600

#define RALINK_SYSCTL_ADDR		RALINK_SYSCTL_BASE	// system control
#define RALINK_PRGIO_ADDR		RALINK_PIO_BASE // Programmable I/O

#define RALINK_REG_GPIOMODE		(RALINK_SYSCTL_ADDR + 0x60)

#define RALINK_REG_PIODATA		(RALINK_PRGIO_ADDR + 0x20)	//00-23
#define RALINK_REG_PIODIR		(RALINK_PRGIO_ADDR + 0x24)	//00-23
#define RALINK_REG_PIOSET		(RALINK_PRGIO_ADDR + 0x2C)	//00-23
#define RALINK_REG_PIORESET		(RALINK_PRGIO_ADDR + 0x30)	//00-23
#define RALINK_REG_PIO2DATA		(RALINK_PRGIO_ADDR + 0x48)	//24-39
#define RALINK_REG_PIO2DIR		(RALINK_PRGIO_ADDR + 0x4C)	//24-39
#define RALINK_REG_PIO2SET		(RALINK_PRGIO_ADDR + 0x54)	//24-39
#define RALINK_REG_PIO2RESET	(RALINK_PRGIO_ADDR + 0x58)	//24-39
#define RALINK_REG_PIO3DATA		(RALINK_PRGIO_ADDR + 0x70)	//40-71
#define RALINK_REG_PIO3DIR		(RALINK_PRGIO_ADDR + 0x74)	//40-71
#define RALINK_REG_PIO3SET		(RALINK_PRGIO_ADDR + 0x7C)	//40-71
#define RALINK_REG_PIO3RESET	(RALINK_PRGIO_ADDR + 0x80)	//40-71
#define RALINK_REG_PIO4DATA		(RALINK_PRGIO_ADDR + 0x98)	//00-23
#define RALINK_REG_PIO4DIR		(RALINK_PRGIO_ADDR + 0x9C)	//72
#define RALINK_REG_PIO4SET		(RALINK_PRGIO_ADDR + 0xA4)	//72
#define RALINK_REG_PIO4RESET	(RALINK_PRGIO_ADDR + 0xA8)	//72

	.globl lightOnAllLED
	.ent lightOnAllLED
	.set noreorder

lightOnAllLED:
	/* 1. set GPIO mode*/
	li	t0, RALINK_REG_GPIOMODE
	lw	t1, 0(t0)
	/* EPHY_LED_GPIO_MODE(bit15) | WLEN_GPIO_MODE(bit13) */
	li	t2, 0x0000A000
	or	t1, t2
	sw	t1, 0(t0)

	/* 2. set GPIO direction */
	li	t0, RALINK_REG_PIODIR
	lw	t1, 0(t0)
	li	t2, (1<<7)            /*GPIO7-WAN*/
	or	t1, t2
	sw	t1, 0(t0)

	li	t0, RALINK_REG_PIO3DIR
	lw	t1, 0(t0)
	li	t2, ((1<<2) | (1<<3)) /*GPIO42-SYS GPIO43-LAN*/
	or	t1, t2
	sw	t1, 0(t0)

	li	t0, RALINK_REG_PIO4DIR
	lw	t1, 0(t0)
	li	t2, 1                 /*GPIO72-WLAN*/
	or	t1, t2
	sw	t1, 0(t0)

	/*3. set gpio data*/
	li	t0, RALINK_REG_PIODATA
	lw	t1, 0(t0)
	li	t2, (1<<7)            /* GPIO7-WAN */
	not	t3, t2
	and	t1, t3
	sw	t1, 0(t0)

	li	t0, RALINK_REG_PIO3DATA
	lw	t1, 0(t0)
	li	t2, ((1<<2) | (1<<3)) /*GPIO42-SYS GPIO43-LAN*/
	not	t3, t2
	and	t1, t3
	sw	t1, 0(t0)

	li	t0, RALINK_REG_PIO4DATA
	lw	t1, 0(t0)
	li	t2, 1                 /* GPIO72-WLAN */
	not	t3, t2
	and	t1, t3
	sw	t1, 0(t0)

	/* return */
	jr	ra
	nop

	.globl lightOffNonSysLED
	.ent lightOffNonSysLED
	.set noreorder

lightOffNonSysLED:
	/*set gpio data*/
	li	t0, RALINK_REG_PIODATA
	lw	t1, 0(t0)
	li	t2, (1<<7)            /* GPIO7-WAN */
	or	t1, t2
	sw	t1, 0(t0)

	li	t0, RALINK_REG_PIO3DATA
	lw	t1, 0(t0)
	li	t2, (1<<3)            /*GPIO43-LAN*/
	or	t1, t2
	sw	t1, 0(t0)

	li	t0, RALINK_REG_PIO4DATA
	lw	t1, 0(t0)
	li	t2, 1                 /* GPIO72-WLAN */
	or	t1, t2
	sw	t1, 0(t0)

	/* return */
	jr	ra
	nop
