/*  Copyright(c) 2009-2020 Shenzhen TP-LINK Technologies Co.Ltd.
 *
 * file		mt7620Gpio.c
 * brief	mt7620 gpio definition
 * details	
 * version	
 * date		30Oct20
 *
 * history 	\arg	create file
 */


#ifndef __GPIO_DRIVER_H__
#define __GPIO_DRIVER_H__

#include "gpio.h"

/*!
	@brief		set gpio dir
*/
void set_gpio_dir(ULONG gpioNum, GPIO_DIR dir);

/*!
	@brief		set gpio int type
*/
void set_gpio_int(ULONG gpioNum, GPIO_INT_TYPE type);

/*!
	@brief		get interrupt type 
*/
GPIO_INT_TYPE get_gpio_int_status(ULONG gpioNum);

/*!
	@brief		read gpio value
*/
GPIO_LEVEL read_gpio_value(ULONG gpioNum);

/*!
	@brief		write gpio value
*/
void write_gpio_value(ULONG gpioNum, GPIO_LEVEL value);

/*!
	@brief		Clear all gpio interrupts status
*/
void clear_gpio_int(ULONG gpioNum);

/*!
	@brief		Set gpio pin mode. Optional.
*/
void set_gpio_pin_mode(ULONG gpioNum, GPIO_PIN_MODE mode);

#endif

