/*  Copyright(c) 2009-2020 Shenzhen TP-LINK Technologies Co.Ltd.
 *
 * file		mt7620Gpio.c
 * brief	mt7620 gpio definition
 * details	
 * version	
 * date		30Oct20
 *
 * history 	\arg	create file
 */


#ifndef _GPIO_H
#define _GPIO_H

typedef unsigned long ULONG;
typedef unsigned long ulong;

typedef unsigned int BOOL;
#define LOCAL static;


#define NELEMENTS(_arr) (sizeof(_arr)/sizeof(_arr[0]))
typedef struct
{
	int gpioNum;			/*!< gpio num. 
								note that this num is not the same as pin num. 
								Should reference the datasheet */
	int gpioDir;			/*!< gpio dir, GPIO_DIR_OUT or GPIO_DIR_IN */
	int gpioLevel;			/*!< enable level, default is 0 - low level */
	int isLed;				/*!< if this gpio is mapped to a LED */
	int isButton;			/*!< if this gpio is mapped to a button */
}
GPIO_INIT;


/*!
	@brief	GPIO MODE
*/
typedef enum
{
	GPIO_PIN_MODE_GPIO = 0,			/*!<	For GPIO */
	GPIO_PIN_MODE_PER = 1,			/*!<	For peripheral */
}GPIO_PIN_MODE;


/*!
	@brief		GPIO DIR
*/
typedef enum 
{
	GPIO_DIR_INPUT = 0,			/*!<	input */
	GPIO_DIR_OUTPUT = 1			/*!<	output */
}GPIO_DIR;


/*!
	@brief		GPIO TYPE
*/
typedef enum
{
	GPIO_INT_DIS = 0,			/*!<	int is disabled on this gpio. */
	GPIO_INT_RISE = 1,			/*!<	Enable rise int */
	GPIO_INT_FALL = 2,			/*!<	Enable fall int */
	GPIO_INT_LOW = 4,			/*!<	Enable low level int */
	GPIO_INT_HIGH = 8			/*!<	Enable high level int */

}
GPIO_INT_TYPE;


/*!
	@brief		GPIO LEVEL
*/
typedef enum 
{
	GPIO_LEVEL_LOW = 0,			/*!< low level */
	GPIO_LEVEL_HIGH = 1,		/*!< high level */
	GPIO_LEVEL_NONE = 2, 		/*!< nothing */
}GPIO_LEVEL;

#endif

