/*  Copyright(c) 2009-2020 Shenzhen TP-LINK Technologies Co.Ltd.
 *
 * file		MR30GV1.c
 * brief	MR30GV1 led gpio
 * details	
 *
 * version	
 * date		30Oct20
 *
 * history 	\arg	
 */

#include "gpio.h"
#include "gpioDriver.h"

 enum {
	GPIO_NUM_RESET_BUTTON = 13,
	GPIO_NUM_SYS_GREEN = 42,
	GPIO_NUM_SYS_ORANGE=43,
	GPIO_NUM_WAN_LED = 52,
	GPIO_NUM_LAN1_LED = 53,
	GPIO_NUM_LAN2_LED = 46,
	
 };
 
 
 GPIO_INIT gpioInits[] = {
 	 {
		 .gpioNum = GPIO_NUM_RESET_BUTTON,
		 .gpioDir = GPIO_DIR_INPUT,
		 .isButton = 1,
	 },
 	{
		 .gpioNum = GPIO_NUM_SYS_GREEN,
		 .gpioDir = GPIO_DIR_OUTPUT
	 },
	 {
		 .gpioNum = GPIO_NUM_SYS_ORANGE,
		 .gpioDir = GPIO_DIR_OUTPUT
	 },
	 {
		 .gpioNum = GPIO_NUM_WAN_LED,
		 .gpioDir = GPIO_DIR_OUTPUT,
		 .isLed = 1,
		 .gpioLevel = GPIO_LEVEL_HIGH,
	 },
	 {
		 .gpioNum = GPIO_NUM_LAN1_LED,
		 .gpioDir = GPIO_DIR_OUTPUT,
		 .isLed = 1,
		 .gpioLevel = GPIO_LEVEL_HIGH,
	 },
	 	 {
		 .gpioNum = GPIO_NUM_LAN2_LED,
		 .gpioDir = GPIO_DIR_OUTPUT,
		 .isLed = 1,
		 .gpioLevel = GPIO_LEVEL_HIGH,
	 }
 };
 
 void setLed(ulong num, ulong value)
 {
	 int i = 0;
	 int level = 0;
 
	 for (i = 0; i < NELEMENTS(gpioInits); i++)
	 {
		 if (gpioInits[i].gpioNum != num)
			 continue;
 
		 if (!gpioInits[i].isLed)
			 return;
			 
		 level = gpioInits[i].gpioLevel;
		 if (value == 0)
			 level = 1 - level;
			 
		 write_gpio_value(gpioInits[i].gpioNum, level);
		 return;
	 }
 
	 return;
 }
 
 void board_gpio_init(void)
 {
	 int i = 0;

	for (i = 0; i < NELEMENTS(gpioInits); i++)
	 {
		 set_gpio_pin_mode(gpioInits[i].gpioNum, GPIO_PIN_MODE_GPIO);
		 set_gpio_dir(gpioInits[i].gpioNum, gpioInits[i].gpioDir);
	 }
 }

 static void sys_led_on(int on)
 {
	 int green = 0;
	 int orange = 0;
	 
	 if (on == 0)
	 {
		 green = 0;
		 orange = 0;
		 set_gpio_dir(GPIO_NUM_SYS_GREEN, GPIO_DIR_OUTPUT);
		 write_gpio_value(GPIO_NUM_SYS_GREEN, green);
		 write_gpio_value(GPIO_NUM_SYS_ORANGE, orange);
	 }
	 else if (on == 1)
	 {
		 green = 1;
		 orange = 0;
		 set_gpio_dir(GPIO_NUM_SYS_GREEN, GPIO_DIR_OUTPUT);
		 write_gpio_value(GPIO_NUM_SYS_GREEN, green);
		 write_gpio_value(GPIO_NUM_SYS_ORANGE, orange);
	 }
	 else if (on == 2)
	 {
		 green = 0;
		 orange = 1;
		 set_gpio_dir(GPIO_NUM_SYS_GREEN, GPIO_DIR_INPUT);
		 write_gpio_value(GPIO_NUM_SYS_ORANGE, orange);
	 }
	 else
	 {
		 return;
	 }
 
 }
 
 /*!
	 @brief 		 turn on all LED.
					 If 2-color LED exists, use its 'OK' color.
 */
 void all_leds_on(int on)
 {
	int i = 0;
	
	for (i = 0; i < NELEMENTS(gpioInits); i++)
	{
		 if (gpioInits[i].isLed)
			 setLed(gpioInits[i].gpioNum, on);
	 }
 }
 
 /*!
	 @brief 		 Turn on all LEDs for 1s and turn them off to check LED lighting in sys init.
					 If 2-color LED(s) exist(s), this LED(s) should light all colors in sequence.
 */
 void all_leds_check(void)
 {
	all_leds_on(1);

	sys_led_on(1);

	mdelay(500);

	sys_led_on(2);

	mdelay(500);
 
	/* turn off all led */
	all_leds_on(0);

	/* sys灯主颜色常亮 */
	sys_led_on(1);
 }
 
 
 static int is_button_pressed(int num)
 {
	 int i = 0;
	 int level = 0;
	 for (i = 0; i < NELEMENTS(gpioInits); i++)
	 {
		 if (gpioInits[i].gpioNum != num)
			 continue;
			 
		 if (!gpioInits[i].isButton)
			 return 0;
	 
		 if ((level = read_gpio_value(num)) < 0)
			 return 0;
 
		 if (gpioInits[i].gpioLevel == level)
			 return 1;
 
		 return 0;
	 }
 
	 return 0;
 }
 
 
 /*!
	 @brief 	 check if reset button is pressed
 */
 int is_reset_button_pressed(void)
 {
	 return is_button_pressed(GPIO_NUM_RESET_BUTTON);
 
 }


