/*  Copyright(c) 2009-2020 Shenzhen TP-LINK Technologies Co.Ltd.
 *
 * file		AC12GV1.c
 * brief	AC12G led gpio
 * details	
 *
 * version	
 * date		30Oct20
 *
 * history 	\arg	
 */

#include "gpio.h"
#include "gpioDriver.h"

 enum {
	GPIO_NUM_RESET_BUTTON = 13,
	GPIO_NUM_SYS_LED = 42,
	GPIO_NUM_WIFI_LED = 72,
	GPIO_NUM_WAN_LED = 7,
	GPIO_NUM_LAN_LED = 43,
 };
 
 
 GPIO_INIT gpioInits[] = {
 	 {
		 .gpioNum = GPIO_NUM_RESET_BUTTON,
		 .gpioDir = GPIO_DIR_INPUT,
		 .isButton = 1,
	 },
 	{
		 .gpioNum = GPIO_NUM_SYS_LED,
		 .gpioDir = GPIO_DIR_OUTPUT,
		 .isLed = 1,
	 },
	 {
		 .gpioNum = GPIO_NUM_WIFI_LED,
		 .gpioDir = GPIO_DIR_OUTPUT,
		 .isLed = 1,
	 },
	 {
		 .gpioNum = GPIO_NUM_WAN_LED,
		 .gpioDir = GPIO_DIR_OUTPUT,
		 .isLed = 1,
	 },
	 {
		 .gpioNum = GPIO_NUM_LAN_LED,
		 .gpioDir = GPIO_DIR_OUTPUT,
		 .isLed = 1,
	 },
 };
 
 void setLed(ulong num, ulong value)
 {
	 int i = 0;
	 int level = 0;
 
	 for (i = 0; i < NELEMENTS(gpioInits); i++)
	 {
		 if (gpioInits[i].gpioNum != num)
			 continue;
 
		 if (!gpioInits[i].isLed)
			 return;
			 
		 level = gpioInits[i].gpioLevel;
		 if (value == 0)
			 level = 1 - level;
			 
		 write_gpio_value(gpioInits[i].gpioNum, level);
		 return;
	 }
 
	 return;
 }
 
 void board_gpio_init(void)
 {
	 int i = 0;

	for (i = 0; i < NELEMENTS(gpioInits); i++)
	 {
		 set_gpio_pin_mode(gpioInits[i].gpioNum, GPIO_PIN_MODE_GPIO);
		 set_gpio_dir(gpioInits[i].gpioNum, gpioInits[i].gpioDir);
	 }
 }
 

 static void sys_led_on(int on)
 {
	setLed(GPIO_NUM_SYS_LED, on);
 }
 
 /*!
	 @brief 		 turn on all LED.
					 If 2-color LED exists, use its 'OK' color.
 */
 void all_leds_on(int on)
 {
	int i = 0;
	
	for (i = 0; i < NELEMENTS(gpioInits); i++)
	{
		 if (gpioInits[i].isLed)
			 setLed(gpioInits[i].gpioNum, on);
	 }
 }
 
 /*!
	 @brief 		 Turn on all LEDs for 1s and turn them off to check LED lighting in sys init.
					 If 2-color LED(s) exist(s), this LED(s) should light all colors in sequence.
 */
 void all_leds_check(void)
 {
	 int i = 0;


	all_leds_on(1);

	mdelay(500);
 
	/* turn off all led */
	all_leds_on(0);

	mdelay(500);

	sys_led_on(1);
 }
 
 
 static int is_button_pressed(int num)
 {
	 int i = 0;
	 int level = 0;
	 for (i = 0; i < NELEMENTS(gpioInits); i++)
	 {
		 if (gpioInits[i].gpioNum != num)
			 continue;
			 
		 if (!gpioInits[i].isButton)
			 return 0;
	 
		 if ((level = read_gpio_value(num)) < 0)
			 return 0;
 
		 if (gpioInits[i].gpioLevel == level)
			 return 1;
 
		 return 0;
	 }
 
	 return 0;
 }
 
 
 /*!
	 @brief 	 check if reset button is pressed
 */
 int is_reset_button_pressed(void)
 {
	 return is_button_pressed(GPIO_NUM_RESET_BUTTON);
 
 }


