#
# Copyright (c) 2016 TP-LINK Technologies CO.,LTD.
#
# All Rights Reserved.
#

include $(INCLUDE_DIR)/kernel.mk
include $(T_PRODUCT_CONFIG_DIR)/$(PR_NAME)/wlan.config

# Name and release number of this package
WLAN_DRV_PKG_VERSION_WQ:=wq9001_v1.0.624

ifdef CONFIG_WLAN_DRIVER_VERSION
	WLAN_DRV_PKG_VERSION_WQ:=$(CONFIG_WLAN_DRIVER_VERSION)
endif

ifeq ($(CONFIG_WLAN_MULTI_CHIP), y)
ifdef CONFIG_WLAN_DRIVER_VERSION_WQ
	WLAN_DRV_PKG_VERSION_WQ:=$(CONFIG_WLAN_DRIVER_VERSION_WQ)
endif
endif

WLAN_DRV_MAKE_ARGS:= \
	CROSS_COMPILE="$(KERNEL_CROSS)" \
	ARCH="$(LINUX_KARCH)" \
	KLIB_BUILD="$(LINUX_DIR)"

ifeq ($(CONFIG_WLAN_MULTI_CHIP), y)
WLAN_DRV_LOCAL_SRC_WQ:=$(WLAN_DRV_DIR)/wq/$(WLAN_DRV_PKG_NAME_WQ)/$(WLAN_DRV_PKG_VERSION_WQ)
else
WLAN_DRV_LOCAL_SRC_WQ:=$(WLAN_DRV_DIR)/$(WLAN_DRV_PKG_NAME)/$(WLAN_DRV_PKG_VERSION_WQ)
endif

##### Config Related #####
USER_EXTRA_CONFIGS = 
USER_EXTRA_CONFIGS += SUPPORT_CONCURRENT=y
USER_EXTRA_CONFIGS += CONFIG_TARGET_mstar=$(CONFIG_TARGET_mstar)
USER_EXTRA_CONFIGS += CONFIG_TARGET_ingenic=$(CONFIG_TARGET_ingenic)
#USER_EXTRA_CONFIGS += CONFIG_SUPPORT_WLAN_DRIVER_ERROR_RECOVERY=$(CONFIG_SUPPORT_WLAN_DRIVER_ERROR_RECOVERY)

define KernelPackage/wlan_driver
  SUBMENU:=kernel modules
  SECTION:=ko util
  CATEGORY:=TP-LINK Proprietary Software
  DEFAULT:=y
  TITLE:=WLAN driver for wq9001
  VERSION:=$(LINUX_VERSION)+$(WLAN_DRV_PKG_NAME)_$(WLAN_DRV_PKG_VERSION_WQ)
  FILES:= $(PKG_BUILD_DIR)/hawk_usb.ko
  MENU:=1
  VARIANT:=wlan_driver
endef

# Uncomment portion below for Kamikaze and delete DESCRIPTION variable above
define KernelPackage/wlan_driver/description
	WQ wq9001/wq9001 wifi driver.
endef

define Build/Prepare/wlan_driver
	mkdir -p $(PKG_BUILD_DIR)
	$(CP) $(WLAN_DRV_LOCAL_SRC_WQ)/* $(PKG_BUILD_DIR)/
endef

define Build/Compile/wlan_driver
	+$(MAKE) -C "$(PKG_BUILD_DIR)" $(WLAN_DRV_MAKE_ARGS) CFLAGS="$(TARGET_CFLAGS)" KBUILD_TOP="$(PKG_BUILD_DIR)" KSRC="$(LINUX_DIR)" KVER="$(LINUX_VERSION)" $(USER_EXTRA_CONFIGS) modules $(MAKE_J)
endef

define KernelPackage/wlan_driver/install
	$(INSTALL_DIR) $(1)/usr/bin
endef


define KernelPackage/wlan_driver_wq9001
  SUBMENU:=kernel modules
  SECTION:=ko util
  CATEGORY:=TP-LINK Proprietary Software
  DEFAULT:=y
  TITLE:=Only WLAN driver for wq9001
  VERSION:=$(LINUX_VERSION)+$(WLAN_DRV_PKG_NAME_WQ)_$(WLAN_DRV_PKG_VERSION_WQ)
  FILES:= $(PKG_BUILD_DIR)/hawk_usb.ko
  MENU:=1
  VARIANT:=wlan_driver_wq9001
endef

define KernelPackage/wlan_driver_wq9001/description
	WQ wq9001/wq9001 wifi driver.
endef

define Build/Prepare/wlan_driver_wq9001
	mkdir -p $(PKG_BUILD_DIR)
	$(CP) $(WLAN_DRV_LOCAL_SRC_WQ)/* $(PKG_BUILD_DIR)/
endef

define Build/Compile/wlan_driver_wq9001
	+$(MAKE) -C "$(PKG_BUILD_DIR)" $(WLAN_DRV_MAKE_ARGS) CFLAGS="$(TARGET_CFLAGS)" KBUILD_TOP="$(PKG_BUILD_DIR)" KSRC="$(LINUX_DIR)" KVER="$(LINUX_VERSION)" $(USER_EXTRA_CONFIGS) modules $(MAKE_J)
endef

define KernelPackage/wlan_driver_wq9001/install
	$(INSTALL_DIR) $(1)/usr/bin
endef
