#ifndef _PPC_REDBOOT_H
#define _PPC_REDBOOT_H

//=========================================================================
// include/asm-ppc/redboot.h
//   Copyright (c) 2002, 2003 Gary Thomas (<gary@mlbassoc.com>
//   Copyright (c) 1997 Dan Malek (dmalek@jlc.net)

#define TP_HEADER_VERSION 	0x00000100

#define FW_DESC_LEN		   12
#define FW_ID_LEN		   16
#define FW_VERSION_LEN	   32
#define MAGIC_LEN 			20
#define CRC_LEN 			16
#define FWID_BL_MAX_NUM 		2		/* max number of BL fwID is fixed to 2 */

typedef struct _TP_HEADER
{
	unsigned int headerVersion;
	unsigned char magicNumber[MAGIC_LEN];

	unsigned int kernelLoadAddress;
	unsigned int kernelEntryPoint;

	unsigned short vendorId;
	unsigned short zoneCode;

	unsigned int partitionNum;
	unsigned int factoryBootOffset;
	unsigned int factoryBootLen;
	unsigned int factoryInfoOffset;
	unsigned int factoryInfoLen;
	unsigned int radioOffset;
	unsigned int radioLen;
	unsigned int ucOffset;
	unsigned int ucLen;
	unsigned int bootloaderOffset;
	unsigned int bootloaderLen;
	unsigned int tpHeaderOffset;
	unsigned int tpHeaderLen;
	unsigned int kernelOffset;
	unsigned int kernelLen;
	unsigned int romFsOffset;
	unsigned int romFsLen;
	unsigned int jffs2FsOffset;
	unsigned int jffs2FsLen;

	unsigned char factoryInfoCRC[CRC_LEN];
	unsigned char radioCRC[CRC_LEN];
	unsigned char ubootCRC[CRC_LEN];
	unsigned char kernelAndRomfsCRC[CRC_LEN];

	unsigned char fwId[FW_ID_LEN];
	unsigned char fwDescription[FW_DESC_LEN];
	unsigned int fwIdBLNum;
//	unsigned char fwIdBL[FWID_BL_MAX_NUM][FW_ID_LEN];
	unsigned char serviceCRC[CRC_LEN];
	unsigned int  isVerified;
	unsigned int  jffs2RealFsLen;
	unsigned int  upbootOffset;
	unsigned int  upbootLen;
	unsigned int ispOffset;
	unsigned int ispLen;
	unsigned int ldOffset;
	unsigned int ldLen;
	unsigned int uitronExtOffset;
	unsigned int uitronExtLen;
	unsigned int uitronOffset;
	unsigned int uitronLen;
    unsigned char ldCRC[CRC_LEN];
	unsigned char uitronExtCRC[CRC_LEN];
	unsigned char uItronCRC[CRC_LEN];
} TP_HEADER;

//
// Board specific details, as provided by RedBoot
//

/* A Board Information structure that is given to a program when
 * RedBoot starts it up.  Note: not all fields make sense for all
 * architectures and it's up to the platform specific code to fill
 * in the details.
 */
typedef struct bd_info {
    unsigned int   bi_tag;        /* Should be 0x42444944 "BDID" */
    unsigned int   bi_size;       /* Size of this structure */
    unsigned int   bi_revision;   /* revision of this structure */
    unsigned int   bi_bdate;      /* bootstrap date, i.e. 0x19971106 */
    unsigned int   bi_memstart;   /* Memory start address */
    unsigned int   bi_memsize;    /* Memory (end) size in bytes */
    unsigned int   bi_intfreq;    /* Internal Freq, in Hz */
    unsigned int   bi_busfreq;    /* Bus Freq, in Hz */
    unsigned int   bi_cpmfreq;    /* CPM Freq, in Hz */
    unsigned int   bi_brgfreq;    /* BRG Freq, in Hz */
    unsigned int   bi_vco;        /* VCO Out from PLL */
    unsigned int   bi_pci_freq;   /* PCI Freq, in Hz */
    unsigned int   bi_baudrate;   /* Default console baud rate */
    unsigned int   bi_immr;       /* IMMR when called from boot rom */
    unsigned char  bi_enetaddr[6];
    unsigned int   bi_flashbase;  /* Physical address of FLASH memory */
    unsigned int   bi_flashsize;  /* Length of FLASH memory */
    int            bi_flashwidth; /* Width (8,16,32,64) */
    unsigned char *bi_cmdline;    /* Pointer to command line */
    unsigned char  bi_esa[3][6];  /* Ethernet station addresses */
    unsigned int   bi_ramdisk_begin, bi_ramdisk_end;
    struct {                      /* Information about [main] video screen */
        short x_res;              /*   Horizontal resolution in pixels */
        short y_res;              /*   Vertical resolution in pixels */
        short bpp;                /*   Bits/pixel */
        short mode;               /*   Type of pixels (packed, indexed) */
        unsigned long fb;         /*   Pointer to frame buffer (pixel) memory */
    } bi_video;
    void         (*bi_cputc)(char);   /* Write a character to the RedBoot console */
    char         (*bi_cgetc)(void);   /* Read a character from the RedBoot console */
    int          (*bi_ctstc)(void);   /* Test for input on the RedBoot console */
} bd_t;

#define BI_REV 0x0102    /* Version 1.02 */

#define LD_MTD_NAME					"ld"
#define UITRON_EXT_MTD_NAME			"uitron_ext"
#define FACTORY_BOOT_MTD_NAME		"factory_boot"
#define UITRON_MTD_NAME				"uitron"
#define DSP_MTD_NAME				"dsp"
#define ISP_MTD_NAME				"isp"
#define FACTORY_INFO_MTD_NAME		"factory_info"
#define RADIO_MTD_NAME				"art"
#define AF_MTD_NAME					"af"
#define UC_MTD_NAME					"config"
#define NORMAL_BOOT_MTD_NAME		"normal_boot"
#define KERNEL_MTD_NAME				"kernel"
#define ROMFS_MTD_NAME				"rootfs"
#define JFFS2_MTD_NAME				"rootfs_data"
#define FIRMWARE_MTD_NAME			"firmware"
#define TP_HEADER_MTD_NAME			"tp_header"
#define KERNEL_AND_ROMFS_MTD_NAME	"kernel_romfs"
#ifdef CONFIG_USER_DATA_PARTITION
#define USER_RECORD_MTD_NAME		"user_record"
#endif
#ifdef CONFIG_TP_TAPO_SPMINIOS
#define VERIFY_MTD_NAME	"verify"
#endif
#ifdef CONFIG_TAPO_NAND_UPGRADE
#define UPBOOT_MTD_NAME                  "upboot"
#endif
#define TP_HEADER_FWID_NAME			"fwId"
#define TP_HEADER_FWDESC_NAME		"fwDescription"

#define bi_pci_busfreq bi_pci_freq
#define bi_immr_base   bi_immr

int get_info_from_mtd_partition_name(char* partition_name, int *offset, int *size);

#endif
