/*
 * Ingenic isvp setup code
 *
 * Copyright (c) 2017 Ingenic Semiconductor Co.,Ltd
 * Author: Zoro <ykli@ingenic.cn>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <nand.h>
#include <net.h>
#include <netdev.h>
#include <asm/gpio.h>
#include <asm/arch/cpm.h>
#include <asm/arch/nand.h>
#include <asm/arch/mmc.h>
#include <asm/arch/clk.h>
#include <power/d2041_core.h>
#include <asm/io.h>

//************************* PWM ********************************
#define POLARITY (1<<8) //极性
#define PWM_EN (1<<7)
//Select XXX as the timer clock input
#define EXTAL_EN (0x1 << 2)	 //EXT_EN 24M
#define RTCCLK_EN (0x1 << 1) //RTC_EN
#define PCLK_EN (0x1 << 0)	 //PCK_EN 100M
//时钟分频
#define CLK_1 (0 << 3)
#define CLK_4 (1 << 3)
#define CLK_16 (2 << 3)
#define CLK_64 (3 << 3)
#define CLK_256 (4 << 3)
#define CLK_1024 (5 << 3)

#define TDFR0 0x40
#define TDHR0 0x44
#define TCSR0 0x4C

#define TDFR1 0x50
#define TDHR1 0x54
#define TCSR1 0x5C

#define TDFR2 0x60
#define TDHR2 0x64
#define TCSR2 0x6C

#define TCSTR 0x14

#define TCU_BASE_PHY 0xb0002000

#define PERIOD (480 - 1) /* 50KHz CLK1_RATE = 24M ,对其进行480分频得到50KHz */
#define PWM_DUTY (PERIOD >> 1)

//PB18 pwm1 FUNCTION0
//PB27 pwm2 FUNCTION1
void ir_led_pwm_init()
{
/* pwm1的demo，代码暂时先保留，供后续参考 */
//	gpio_set_func(GPIO_PORT_B, GPIO_FUNC_0, 1 << 18);
//	writel(PERIOD, TCU_BASE_PHY + TDFR1);//配置pwm频率
//	writel(PWM_DUTY, TCU_BASE_PHY + TDHR1);//配置占空比
//	writel(POLARITY|PWM_EN|EXTAL_EN|CLK_1, TCU_BASE_PHY + TCSR1);
//	writel(1<<1, TCU_BASE_PHY + TCSTR);
#if defined(IR_LED_GPIO_NUM) && (IR_LED_GPIO_NUM==59) /* PWM2 复用GPIO59*/
	/* pwm2 */
	gpio_set_func(GPIO_PORT_B,GPIO_FUNC_1,1<<27);
	writel(PERIOD, TCU_BASE_PHY + TDFR2);
	writel(PWM_DUTY, TCU_BASE_PHY + TDHR2);
	writel(POLARITY|PWM_EN|EXTAL_EN|CLK_1, TCU_BASE_PHY + TCSR2);
	writel(1<<2, TCU_BASE_PHY + TCSTR);
#endif
}
//*************************** PWM END **********************************

//*************************** GPIO *************************************
void ir_cut_init()
{
#if defined(IR_CUT_DOUBLE_GPIO1) && defined(IR_CUT_DOUBLE_GPIO2)
	gpio_request(IR_CUT_DOUBLE_GPIO1, "ir_cut");
	gpio_request(IR_CUT_DOUBLE_GPIO2, "ir_cut");
	gpio_direction_output(IR_CUT_DOUBLE_GPIO1, 0);
	gpio_direction_output(IR_CUT_DOUBLE_GPIO2, 0);
	gpio_set_value(IR_CUT_DOUBLE_GPIO1, 0);
	udelay(150000);
	gpio_set_value(IR_CUT_DOUBLE_GPIO1, 1);
	udelay(150000);
	gpio_set_value(IR_CUT_DOUBLE_GPIO1, 0);
	udelay(150000);
	gpio_set_value(IR_CUT_DOUBLE_GPIO2, 0);
	udelay(150000);
	gpio_set_value(IR_CUT_DOUBLE_GPIO2, 1);
	udelay(150000);
	gpio_set_value(IR_CUT_DOUBLE_GPIO2, 0);
	udelay(150000);
	gpio_free(IR_CUT_DOUBLE_GPIO1);
	gpio_free(IR_CUT_DOUBLE_GPIO2);
#endif
#if defined(IR_CUT_GPIO_NUM) && (IR_CUT_GPIO_NUM != 999)
	gpio_request(IR_CUT_GPIO_NUM, "ir_cut");
	gpio_direction_output(IR_CUT_GPIO_NUM, 0);
	gpio_set_value(IR_CUT_GPIO_NUM, 0);
	udelay(150000);
	gpio_set_value(IR_CUT_GPIO_NUM, 1);
	udelay(150000);
	gpio_set_value(IR_CUT_GPIO_NUM, 0);
	gpio_free(IR_CUT_GPIO_NUM);
#endif
}

//*************************** GPIO END *********************************


extern int jz_net_initialize(bd_t *bis);
struct cgu_clk_src cgu_clk_src[] = {
#ifdef CONFIG_DDR_588M
	{AVPU, VPLL},
	{MACPHY, VPLL},
#else
	{AVPU, MPLL},
	{MACPHY, CONFIG_MACPHY_SEL_PLL},
#endif
	{MSC, APLL},
#ifdef CONFIG_DDR_588M
	{SSI, VPLL},
#else
	{SSI, MPLL},
#endif
	{CIM, MPLL},
#ifdef CONFIG_DDR_588M
	{ISP, VPLL},
#else
	{ISP, MPLL},
#endif
	{I2S_SPK, APLL}, //i2s使用APLL
	{I2S_MIC, APLL}, //i2s使用APLL
	{SRC_EOF,SRC_EOF}
};

int board_early_init_f(void)
{
	/* uart1 PB23/PB24上拉，防止客户没有外接上拉电阻*/
	*(volatile unsigned int *)0xb0011114 = 0x1800000;
	*(volatile unsigned int *)0xb0011128 = 0x1800000;

	/* PB06 qmac txclk配置输入下拉，减少耦合时钟*/
	*(volatile unsigned int *)0xb0011118 = 0x40;
	*(volatile unsigned int *)0xb0011124 = 0x40;

	/* MSCO GPIO默认输出低，解决MSCO GPIO漏电问题*/
	*(volatile unsigned int*)0xb0011018 = 0x3f;
	*(volatile unsigned int*)0xb0011024 = 0x3f;
	*(volatile unsigned int*)0xb0011038 = 0x3f;
	*(volatile unsigned int*)0xb0011048 = 0x3f;
	return 0;
}

#ifdef CONFIG_USB_GADGET
int jz_udc_probe(void);
void board_usb_init(void)
{
	printf("USB_udc_probe\n");
	jz_udc_probe();
}
#endif /* CONFIG_USB_GADGET */

int misc_init_r(void)
{
#if 0 /* TO DO */
	uint8_t mac[6] = { 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc };

	/* set MAC address */
	eth_setenv_enetaddr("ethaddr", mac);
#endif
	/* used for usb_dete */
	gpio_enable_pull_up(GPIO_PB(24));//UART1 rx
	ir_cut_init();
	ir_led_pwm_init();
	return 0;
}



#ifdef CONFIG_MMC
int board_mmc_init(bd_t *bd)
{
	jz_mmc_init();
	return 0;
}
#endif

#ifdef CONFIG_SYS_NAND_SELF_INIT
void board_nand_init(void)
{
	return;
}
#endif

int board_eth_init(bd_t *bis)
{
	int ret = 0;
#ifdef CONFIG_USB_ETHER_ASIX
	if (0 == strncmp(getenv("ethact"), "asx", 3)) {
		run_command("usb start", 0);
	}
#endif
#ifdef CONFIG_NET_GMAC
	ret += jz_net_initialize(bis);
#endif
	return ret;
}

#ifdef CONFIG_SPL_NOR_SUPPORT
int spl_start_uboot(void)
{
	return 1;
}
#endif
/* U-Boot common routines */
int checkboard(void)
{
	puts("Board: ISVP (Ingenic XBurst T23 SoC)\n");
	return 0;
}

#ifdef CONFIG_SPL_BUILD

void spl_board_init(void)
{
}

#endif /* CONFIG_SPL_BUILD */
