#ifndef T23_PHY
#define T23_PHY
#include <asm/io.h>

#define PHY_BASE               (0xb3011000)
#define APB_BASE               (0xb3012000)
#define AHB_BASE               (0xb34f0000)

/**********          PHY ADDR  ********************/
#define INNO_CHANNEL_EN        0x0
#define INNO_MEM_CFG           0x04
#define INNO_TRAINING_CTRL     0x08
#define INNO_WL_MODE1          0x0C
#define INNO_WL_MODE2          0x10
#define INNO_CL                0x14
#define INNO_AL                0x18

#define INNO_CWL               0x1C
#define INNO_DQ_WIDTH          0x7C

#define INNO_A_DQL_TXPLL       (0x44 * 4)
#define INNO_A_DQS0_TXPLL      (0x45 * 4)
#define INNO_A_DQS1_TXPLL      (0x55 * 4)

#define INNO_PLL_FBDIV         0x80
#define INNO_PLL_CTRL          0x84
#define INNO_PLL_PDIV          0x88

#define INNO_WL_DONE           0xC0
#define INNO_PLL_LOCK          0xC8
#define INNO_CALIB_DONE        0xCC

#define INNO_INIT_COMP         0xD0

#define T23_CHANNEL_EN         (PHY_BASE + 0x0)
#define T23_MEM_CFG            (PHY_BASE + 0x04)
#define T23_TRANING_CTRL       (PHY_BASE + 0x08)
#define T23_WRITE_LEVEL_MODE1  (PHY_BASE + 0x0C)
#define T23_WRITE_LEVEL_MODE2  (PHY_BASE + 0x10)
#define T23_CL                 (PHY_BASE + 0x14)
#define T23_AL                 (PHY_BASE + 0x18)

#define T23_CWL                (PHY_BASE + 0x1C)
#define T23_DQ_WIDTH           (PHY_BASE + 0x7C)

#define T23_PLL_FBDIV          (PHY_BASE + 0x80)
#define T23_PLL_CTRL           (PHY_BASE + 0x84)
#define T23_PLL_PDIV           (PHY_BASE + 0x88)

#define T23_WL_DONE            (PHY_BASE + 0xc0)
#define T23_DDR_PLL_LOCK       (PHY_BASE + 0xc8)
#define T23_CALIB_DONE         (PHY_BASE + 0xcc)

#define T23_INIT_COMP          (PHY_BASE + 0xd0)
/**************        PHY ADDR  END    ****************/

/**************        PHY 附加寄存器   ****************/
#define T23_DQS_DELAY_L        (PHY_BASE + 0x120)
#define T23_DQS_DELAY_H        (PHY_BASE + 0x160)

//#define T23_REG02            (PHY_BASE + 0x8)
//#define T23_REG08            (PHY_BASE + 0x20)
#define T23_REG46              (PHY_BASE + 0x118)
#define T23_REG56              (PHY_BASE + 0x158)

#define DDR_APB_PHY_INIT       (APB_BASE + 0x8c)

#define REG_DDR_CTRL           (AHB_BASE + 0x008)
#define REG_DDR_CFG            (AHB_BASE + 0x004)
#define REG_DDR_LMR            (AHB_BASE + 0x00c)
/*************       PHY END         *******************/

/***********                  PHY REGISTER  BEGIN                 ****************/
#define PHY_CHANNEL_EN     (*(volatile unsigned int *)T23_CHANNEL_EN       )
#define PHY_RST            (*(volatile unsigned int *)T23_PHY_RST          )
#define PHY_MEM_CFG        (*(volatile unsigned int *)T23_MEM_SEL          )
#define PHY_TRANING_CTRL   (*(volatile unsigned int *)T23_TRANING_CTRL     )
#define PHY_WL_MODE1       (*(volatile unsigned int *)T23_WRITE_LEVEL_MODE1)
#define PHY_WL_MODE2       (*(volatile unsigned int *)T23_WRITE_LEVEL_MODE2)

#define PHY_CL             (*(volatile unsigned int *)T23_CL               )
#define PHY_AL             (*(volatile unsigned int *)T23_AL               )
#define PHY_CWL            (*(volatile unsigned int *)T23_CWL              )

#define PHY_DQ_WIDTH       (*(volatile unsigned int *)T23_DQ_WIDTH         )
#define PHY_PLL_FBDIV      (*(volatile unsigned int *)T23_PLL_FBDIV        )
#define PHY_PLL_CTRL       (*(volatile unsigned int *)T23_PLL_CTRL         )
#define PHY_PLL_PDIV       (*(volatile unsigned int *)T23_PLL_PDIV         )

#define PHY_WL_DONE        (*(volatile unsigned int *)T23_WL_DONE          )
#define PHY_CALIB_DONE     (*(volatile unsigned int *)T23_CALIB_DONE       )

#define PHY_INIT_COMP      (*(volatile unsigned int *)T23_INIT_COMP        )
/***********                  PHY REGISTER  END                    ****************/


#define phy_writel(value, reg)  writel((value), PHY_BASE+reg)
#define phy_readl(reg)          readl(PHY_BASE+reg)

enum
{
    /* par */
    ODT_PD, // 0
    ODT_PU,
    CMD_RC_PD,
    CMD_RC_PU,
    CLK_RC_PD,
    CLK_RC_PU,
    DQX_RC_PD,
    DQX_RC_PU,
    VREF,
    KGD_ODT,
    KGD_DS,
    KGD_RTT_DIC,
    SKEW_DQS0R,
    SKEW_DQS1R,
    SKEW_DQRX,
    SKEW_DQS0T,
    SKEW_DQS1T,
    SKEW_DQTX,
    SKEW_TRX,
    /* flag */
    INDEX_EN,
    INDEX_ODT_PU,
    INDEX_ODT_PD,
    INDEX_CMD_PU,
    INDEX_CMD_PD,
    INDEX_CLK_PU,
    INDEX_CLK_PD,
    INDEX_DQ_PU,
    INDEX_DQ_PD,
    INDEX_VREF,
    INDEX_KGD,
    INDEX_DQSR,
    INDEX_DQST,
    INDEX_DQRX,
    INDEX_DQTX,
    DDR_PAR_NUM,
};

typedef struct
{
    int odt[5];
    int cmd_rc[5];
    int ck_rc[5];
    int dq_rc[5];
    int kgd_odt[3];
    int kgd_ds[2];
    int vref[8];
} hanming_ddr_data;

#endif

