ifeq ($(CONFIG_COMPILE_factory_boot),y)
ifneq ($(CONFIG_COMPILE_normal_boot),y)
	export FACTORY_BOOT_ONLY := y
endif
endif

#MACRO shared by normal boot and factory boot
FACTORYBOOT_MAKEOPTS+=LZMA=$(STAGING_DIR_HOST)/bin/lzma
FACTORYBOOT_MAKEOPTS+=ARCH=mips
FACTORYBOOT_MAKEOPTS+=CPU=mips
FACTORYBOOT_MAKEOPTS+=CROSS_COMPILE=$(KERNEL_CROSS)

WIFI_RESET_GPIO_NUM:=$(CONFIG_WIFI_RESET_GPIO_NUM)
WIFI_RESET_ACTIVE_LEVEL:=$(CONFIG_WIFI_RESET_ACTIVE_LEVEL)
export WIFI_RESET_GPIO_NUM WIFI_RESET_ACTIVE_LEVEL

IR_CUT_GPIO_NUM:=$(CONFIG_IR_CUT_GPIO_NUM)
IR_LED_GPIO_NUM:=$(CONFIG_IR_LED_GPIO_NUM)
IR_WTL_LED_PWM_PORT_NUM:=$(CONFIG_IR_WTL_LED_PWM_PORT_NUM)
export IR_CUT_GPIO_NUM IR_LED_GPIO_NUM IR_WTL_LED_PWM_PORT_NUM

IR_CUT_DOUBLE_GPIO1:=$(CONFIG_IR_CUT_DOUBLE_GPIO1)
IR_CUT_DOUBLE_GPIO2:=$(CONFIG_IR_CUT_DOUBLE_GPIO2)
export IR_CUT_DOUBLE_GPIO1 IR_CUT_DOUBLE_GPIO2

IR_CUT_GROUP2_DOUBLE_GPIO1:=$(CONFIG_IR_CUT_GROUP2_DOUBLE_GPIO1)
IR_CUT_GROUP2_DOUBLE_GPIO2:=$(CONFIG_IR_CUT_GROUP2_DOUBLE_GPIO2)
export IR_CUT_GROUP2_DOUBLE_GPIO1 IR_CUT_GROUP2_DOUBLE_GPIO2

# export white lamp gpio number
WHITE_LAMP_GPIO_NUM:=$(CONFIG_WHITE_LAMP_GPIO_NUM)
export WHITE_LAMP_GPIO_NUM

ifeq ($(CONFIG_WTL_GPIO_ACTIVE_LOW),y)
	export WTL_GPIO_ACTIVE_LOW := y
endif

#export wireless red LED
LED_RED_GPIO:=$(CONFIG_LED_RED_GPIO)
export LED_RED_GPIO
LED_GREEN_GPIO:=$(CONFIG_LED_GREEN_GPIO)
export LED_GREEN_GPIO
LED_GPIO_ACTIVE_LOW:=$(CONFIG_LED_GPIO_ACTIVE_LOW)
export LED_GPIO_ACTIVE_LOW

#export upgrade led gpio num
UPGRADE_LED_GPIO_NUM:=$(CONFIG_FACTORYBOOT_UPGRADE_LED_GPIO_NUM)
export UPGRADE_LED_GPIO_NUM

PULL_DOWN_MMC_PWR_GPIO:=$(CONFIG_PULL_DOWN_MMC_PWR_GPIO)
export PULL_DOWN_MMC_PWR_GPIO

ifdef CONFIG_TARGET_ingenic_t23
FACTORYBOOT_MAKEOPTS+= SOC_T23=y
endif

ifeq ($(CONFIG_ISP_IN_FLASH),y)
	export ISP_IN_FLASH := y
endif

ifeq ($(CONFIG_IR_WTL_LED_SHARE_SAME_PWM),y)
	export IR_WTL_LED_SHARE_SAME_PWM := y
endif

ifdef CONFIG_ISP_BLOCK_SIZE
export ISP_BLOCK_SIZE := $(CONFIG_ISP_BLOCK_SIZE)
endif

ifdef CONFIG_DDR_540M
    export CONFIG_DDR_540M=y
endif

ifdef CONFIG_DDR_588M_SUPPORT
	export DDR_588M_SUPPORT=y
endif

ifdef CONFIG_IR_LED_GPIO_ACTIVE_LOW
	export IR_LED_GPIO_ACTIVE_LOW=y
endif

ifeq ($(CONFIG_FACTORY_BOOT_UIP),y)
	export CONFIG_UIP := y
endif

ifeq ($(CONFIG_FACTORY_BOOT_HTTP_CLIENT),y)
	export CONFIG_HTTP_CLIENT := y
	export CONFIG_ZLIB := y
endif

ifeq ($(CONFIG_FACTORY_BOOT_HTTPS_CLIENT),y)
	export CONFIG_HTTPS_CLIENT := y
	export CONFIG_ZLIB := y
	export CONFIG_LIB_RAND := y
endif

ifeq ($(CONFIG_NEW_UC_DATA_FORMAT),y)
	export NEW_UC_DATA_FORMAT := y
endif

ifeq ($(CONFIG_DN_STATUS_GPIO_VALUE_INVERSED),y)
	export DN_STATUS_GPIO_VALUE_INVERSED := y
endif

FACTORY_BOOT_FLASH_SIZE:=$(CONFIG_FACTORY_BOOT_FLASH_SIZE)
export FACTORY_BOOT_FLASH_SIZE

ifeq ($(CONFIG_EXT_FW_UPGRADE),y)
        export CONFIG_EXT_FW_UPGRADE := y
endif

ifeq ($(CONFIG_WHITE_LAMP_ONLY),y)
        export WHITE_LAMP_ONLY := y
endif

ifneq ($(CONFIG_FACTORY_BOOT_CFG_EXTRA_FW),)
	FACTORYBOOT_MAKEOPTS+=CFG_EXTRA_FW=1
endif

ifdef CONFIG_USE_NAND_FLASH
FACTORYBOOT_MAKEOPTS+=CONFIG_USE_NAND_FLASH=y
export USE_NAND_FLASH := $(CONFIG_USE_NAND_FLASH)
endif

ifdef IMG_FACTORY_BOOT_OFFSET
export FACTORY_BOOT_OFFSET := $(IMG_FACTORY_BOOT_OFFSET)
endif

ifdef IMG_FACTORY_BOOT_LEN
export FACTORY_BOOT_LEN := $(IMG_FACTORY_BOOT_LEN)
endif

ifdef IMG_FACTORY_INFO_OFFSET
export FACTORY_INFO_OFFSET := $(IMG_FACTORY_INFO_OFFSET)
endif

ifdef IMG_FACTORY_INFO_LEN
export FACTORY_INFO_LEN := $(IMG_FACTORY_INFO_LEN)
endif

ifdef IMG_BOOTLOADER_OFFSET
export BOOTLOADER_OFFSET := $(IMG_BOOTLOADER_OFFSET)
else
export BOOTLOADER_OFFSET := 0x0
endif

ifdef IMG_BOOTLOADER_LEN
export BOOTLOADER_LEN := $(IMG_BOOTLOADER_LEN)
else
export BOOTLOADER_LEN := 0x17000
endif



