/*
 * (C) Copyright 2005
 * 2N Telekomunikace, a.s. <www.2n.cz>
 * Ladislav Michl <michl@2n.cz>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
#include <stdio.h>
#include <string.h>
#include "tool-util.h"
#include "nand.h"

DECLARE_GLOBAL_DATA_PTR;

extern struct platform_info info;

int nand_curr_device = -1;
nand_info_t nand_info[CONFIG_SYS_MAX_NAND_DEVICE];

static const char default_nand_name[] = "nand";
static char dev_name[CONFIG_SYS_MAX_NAND_DEVICE][8];

static void nand_init_chip(struct mtd_info *mtd)
{
	int i = 0, ret;
    printf("%s:%d enter\n", __func__, __LINE__);
	if(info.nandtype == NAND)
		ret = board_nand_init(NULL);
	else if(info.nandtype == SPINAND)
		ret = board_spinand_init();
	if(ret < 0){
		printf("[%s]: failed\n", __func__);
		return;
	}

	if (nand_scan(mtd) == 0) {
		if (!mtd->name)
			mtd->name = (char *)default_nand_name;

		/*
		* Add MTD device so that we can reference it later
		* via the mtdcore infrastructure (e.g. ubi).
		*/
		sprintf(dev_name[i], "nand%d", i);
		mtd->name = dev_name[i++];
		add_mtd_device(mtd);

	}
	else
		mtd->name = NULL;


}

void nand_init(void)
{
	int i;
	unsigned int size = 0;
    printf("%s:%d enter\n", __func__, __LINE__);
	for (i = 0; i < CONFIG_SYS_MAX_NAND_DEVICE; i++) {
		nand_init_chip(&nand_info[i]);
		size += nand_info[i].size / 1024;
		if (nand_curr_device == -1)
			nand_curr_device = i;
	}
	printf("%u MiB\n", size / 1024);
}
