 	//<MStar Software>
//******************************************************************************
// MStar Software
// Copyright (c) 2010 - 2012 MStar Semiconductor, Inc. All rights reserved.
// All software, firmware and related documentation herein ("MStar Software") are
// intellectual property of MStar Semiconductor, Inc. ("MStar") and protected by
// law, including, but not limited to, copyright law and international treaties.
// Any use, modification, reproduction, retransmission, or republication of all
// or part of MStar Software is expressly prohibited, unless prior written
// permission has been granted by MStar.
//
// By accessing, browsing and/or using MStar Software, you acknowledge that you
// have read, understood, and agree, to be bound by below terms ("Terms") and to
// comply with all applicable laws and regulations:
//
// 1. MStar shall retain any and all right, ownership and interest to MStar
//    Software and any modification/derivatives thereof.
//    No right, ownership, or interest to MStar Software and any
//    modification/derivatives thereof is transferred to you under Terms.
//
// 2. You understand that MStar Software might include, incorporate or be
//    supplied together with third party`s software and the use of MStar
//    Software may require additional licenses from third parties.
//    Therefore, you hereby agree it is your sole responsibility to separately
//    obtain any and all third party right and license necessary for your use of
//    such third party`s software.
//
// 3. MStar Software and any modification/derivatives thereof shall be deemed as
//    MStar`s confidential information and you agree to keep MStar`s
//    confidential information in strictest confidence and not disclose to any
//    third party.
//
// 4. MStar Software is provided on an "AS IS" basis without warranties of any
//    kind. Any warranties are hereby expressly disclaimed by MStar, including
//    without limitation, any warranties of merchantability, non-infringement of
//    intellectual property rights, fitness for a particular purpose, error free
//    and in conformity with any international standard.  You agree to waive any
//    claim against MStar for any loss, damage, cost or expense that you may
//    incur related to your use of MStar Software.
//    In no event shall MStar be liable for any direct, indirect, incidental or
//    consequential damages, including without limitation, lost of profit or
//    revenues, lost or damage of data, and unauthorized system use.
//    You agree that this Section 4 shall still apply without being affected
//    even if MStar Software has been modified by MStar in accordance with your
//    request or instruction for your use, except otherwise agreed by both
//    parties in writing.
//
// 5. If requested, MStar may from time to time provide technical supports or
//    services in relation with MStar Software to you for your use of
//    MStar Software in conjunction with your or your customer`s product
//    ("Services").
//    You understand and agree that, except otherwise agreed by both parties in
//    writing, Services are provided on an "AS IS" basis and the warranty
//    disclaimer set forth in Section 4 above shall apply.
//
// 6. Nothing contained herein shall be construed as by implication, estoppels
//    or otherwise:
//    (a) conferring any license or right to use MStar name, trademark, service
//        mark, symbol or any other identification;
//    (b) obligating MStar or any of its affiliates to furnish any person,
//        including without limitation, you and your customers, any assistance
//        of any kind whatsoever, or any information; or
//    (c) conferring any license or right under any intellectual property right.
//
// 7. These terms shall be governed by and construed in accordance with the laws
//    of Taiwan, R.O.C., excluding its conflict of law rules.
//    Any and all dispute arising out hereof or related hereto shall be finally
//    settled by arbitration referred to the Chinese Arbitration Association,
//    Taipei in accordance with the ROC Arbitration Law and the Arbitration
//    Rules of the Association by three (3) arbitrators appointed in accordance
//    with the said Rules.
//    The place of arbitration shall be in Taipei, Taiwan and the language shall
//    be English.
//    The arbitration award shall be final and binding to both parties.
//
//******************************************************************************
//<MStar Software>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "../../inc/common/drvNAND.h"
#include "../../inc/common/drvNAND_utl.h"

void dump_nand_info(NAND_FLASH_INFO_t *pNandInfo)
{
	int i;
	printf("###############################################\n");
	printf("#        NAND INFO                            #\n");
	printf("###############################################\n");

	printf("pNandInfo: 0x%08lx\n", (U32)pNandInfo);
	printf("au8_Tag          : [");
	for (i = 0; i < 16; i++)
		printf("%c", pNandInfo->au8_Tag[i]);
	printf("]\n");

	printf("u8_IDByteCnt     : 0x%04x\n", pNandInfo->u8_IDByteCnt);

	printf("au8_ID           : 0x[ ");
	for (i = 0; i < pNandInfo->u8_IDByteCnt; i++)
		printf("%02X ", pNandInfo->au8_ID[i]);
	printf("]\n");

	printf("u32_ChkSum       : 0x%04lx\n", pNandInfo->u32_ChkSum);
	printf("u16_SpareByteCnt : 0x%04x\n", pNandInfo->u16_SpareByteCnt);
    printf("u16_PhyOobsize   : 0x%04x\n", pNandInfo->u16_PhyOobsize);
	printf("u16_PageByteCnt  : 0x%04x\n", pNandInfo->u16_PageByteCnt);
	printf("u16_BlkPageCnt   : 0x%04x\n", pNandInfo->u16_BlkPageCnt);
	printf("u16_BlkCnt       : 0x%04x\n", pNandInfo->u16_BlkCnt);
	printf("u32_Config       : 0x%08lx\n", pNandInfo->u32_Config);
	printf("u16_ECCType      : 0x%04x\n", pNandInfo->u16_ECCType);
	printf("u16_tRC: 0x%04x\n", pNandInfo->u16_tRC);
}

void dump_part_records(PARTITION_RECORD_t *records, int cnt)
{
	int i;

	if (cnt > 1024) {
		printf( "broken\n");
		return;
	}

	for (i = 0; i < cnt; i++) {
		printf( "record[%d]       : 0x%04x, 0x%04x, 0x%04x, 0x%04x\n", i,
				records[i].u16_StartBlk, records[i].u16_BlkCnt,
				records[i].u16_PartType, records[i].u16_BackupBlkCnt);
	}
}

void dump_general_blk_info(BLK_INFO_t *pBlkInfo)
{
	printf("u8_BadBlkIdx    : 0x%04x\n", pBlkInfo->u8_BadBlkMark);
	printf("u8_PartType     : 0x%04x\n", pBlkInfo->u8_PartType);
	printf("u16_BlkAddr     : 0x%04x\n", pBlkInfo->u16_BlkAddr);
	//printf( "au8_Misc        : 0x%04x\n", *(U16*)pBlkInfo->au8_Misc);
}

void dump_part_info(PARTITION_INFO_t *pPartInfo)
{
	printf("###############################################\n");
	printf("#        PART INFO                            #\n");
	printf("###############################################\n");

	printf("pPartInfo: 0x%08lx\n", (U32)pPartInfo);
	printf("u32_ChkSum      : 0x%04lx\n", pPartInfo->u32_ChkSum);
//	printf("u32_BLSectorCnt : 0x%04lx\n", pPartInfo->u32_BLSectorCnt);
//	printf("u32_OSSectorCnt : 0x%04lx\n", pPartInfo->u32_OSSectorCnt);
	printf("u16_PartCnt     : 0x%04x\n", pPartInfo->u16_PartCnt);
	printf("u16_UnitByteCnt : 0x%04x\n", pPartInfo->u16_UnitByteCnt);

	dump_part_records(pPartInfo->records, pPartInfo->u16_PartCnt);
}

void dump_miu_records(MIU_RECORD_t *pRecords, int cnt)
{
	int i;

	if (cnt > (1024 - 8)) {
		printf("broken\n");
		return;
	}
	for (i = 0; i < (cnt >> 3); i++)
		printf("miu record[%02d]  : 0x%08lx, 0x%08lx\n",
				i, pRecords[i].u32_RegAddr, pRecords[i].u32_RegValue);
}

void dump_miu_part(MIU_PART_t *pMiuPart)
{
	printf("###############################################\n");
	printf("#        MIU PART                             #\n");
	printf( "###############################################\n");

	printf("pMiuPart: 0x%08lx\n", (U32)pMiuPart);
	printf("u32_ChkSum      : 0x%04lx\n", pMiuPart->u32_ChkSum);
	printf("u32_ByteCnt     : 0x%04lx\n", pMiuPart->u32_ByteCnt);

	dump_miu_records(pMiuPart->records, pMiuPart->u32_ByteCnt);
}

void dump_nand_driver(NAND_DRIVER *pNandDrv)
{
	printf("###############################################\n");
	printf("#        DRIVER INFO                          #\n");
	printf("###############################################\n");
	printf("  BlkCnt                 : 0x%X\n", pNandDrv->u16_BlkCnt);
	printf("  BlkPageCnt             : 0x%X\n", pNandDrv->u16_BlkPageCnt);
	printf("  BlkSectorCnt           : 0x%X\n", pNandDrv->u16_BlkSectorCnt);
	printf("  PageByteCnt            : 0x%X\n", pNandDrv->u16_PageByteCnt);
	printf("  SpareByteCnt           : 0x%X\n\n", pNandDrv->u16_SpareByteCnt);

	printf("  BlkPageCntBits         : 0x%X\n", pNandDrv->u8_BlkPageCntBits);
	printf("  BlkSectorCntBits       : 0x%X\n", pNandDrv->u8_BlkSectorCntBits);
	printf("  PageByteCntBits        : 0x%X\n", pNandDrv->u8_PageByteCntBits);

	printf("  BlkPageCntMask         : 0x%X\n", pNandDrv->u16_BlkPageCntMask);
	printf("  BlkSectorCntMask       : 0x%X\n", pNandDrv->u16_BlkSectorCntMask);
	printf("  PageByteCntMask        : 0x%X\n", pNandDrv->u16_PageByteCntMask);

	printf("  PageSectorCnt          : 0x%X\n", pNandDrv->u16_PageSectorCnt);
	printf("  SectorByteCnt          : 0x%X\n", pNandDrv->u16_SectorByteCnt);
	printf("  SectorSpareByteCnt     : 0x%X\n", pNandDrv->u16_SectorSpareByteCnt);
	printf("  ECCCodeByteCnt         : 0x%X\n\n", pNandDrv->u16_ECCCodeByteCnt);

	printf("  PageSectorCntBits      : 0x%X\n", pNandDrv->u8_PageSectorCntBits);
	printf("  SectorByteCntBits      : 0x%X\n", pNandDrv->u8_SectorByteCntBits);
	printf("  PageSectorCntMask      : 0x%X\n", pNandDrv->u16_PageSectorCntMask);
	printf("  SectorByteCntMask      : 0x%X\n\n", pNandDrv->u16_SectorByteCntMask);

	printf("  u8_OpCode_Erase_AdrCycle      : 0x%X\n", pNandDrv->u8_OpCode_Erase_AdrCycle);
	printf("  u8_OpCode_RW_AdrCycle      : 0x%X\n\n", pNandDrv->u8_OpCode_RW_AdrCycle);

    printf("  u16_ECCType    : 0x%04x\n", pNandDrv->u16_ECCType);
	printf("  u16_tRC;      : 0x%X\n", pNandDrv->u16_tRC);
	printf("  u8_tRP      : 0x%X\n", pNandDrv->u8_tRP);
	printf("  u8_tREH      : 0x%X\n", pNandDrv->u8_tREH);
	printf("  u8_tREA      : 0x%X\n", pNandDrv->u8_tREA);
	printf("  u8_tRR      : 0x%X\n", pNandDrv->u8_tRR);
	printf("  u16_tADL      : 0x%X\n", pNandDrv->u16_tADL);
	printf("  u16_tRHW      : 0x%X\n", pNandDrv->u16_tRHW);
	printf("  u16_tWHR      : 0x%X\n", pNandDrv->u16_tWHR);
	printf("  u16_tCCS      : 0x%X\n", pNandDrv->u16_tCCS);
	printf("  u8_tCS      : 0x%X\n", pNandDrv->u8_tCS);
	printf("  u16_tWC      : 0x%X\n", pNandDrv->u16_tWC);
	printf("  u8_tWP      : 0x%X\n", pNandDrv->u8_tWP);
	printf("  u8_tWH      : 0x%X\n", pNandDrv->u8_tWH);
	printf("  u16_tCWAW      : 0x%X\n", pNandDrv->u16_tCWAW);
	printf("  u8_tCLHZ      : 0x%X\n", pNandDrv->u8_tCLHZ);
	printf("  u16_tWW      : 0x%X\n", pNandDrv->u16_tWW);
	printf("  u8_AddrCycleIdx      : 0x%X\n", pNandDrv->u8_AddrCycleIdx);
	printf("  u8_HashPBA[0]    : 0x%X 0x%X\n", pNandDrv->u8_HashPBA[0][0], pNandDrv->u8_HashPBA[0][1]);
	printf("  u8_HashPBA[1]    : 0x%X 0x%X\n", pNandDrv->u8_HashPBA[1][0], pNandDrv->u8_HashPBA[1][1]);
	printf("  u8_HashPBA[2]    : 0x%X 0x%X\n\n", pNandDrv->u8_HashPBA[2][0], pNandDrv->u8_HashPBA[2][1]);
}

U8 drvNAND_CountBits(U32 u32_x)
{
	U8 u8_i = 0;

    if(u32_x==0) return u8_i;

	while (u32_x) {
		u8_i++;
		u32_x >>= 1;
	}

	return u8_i-1;
}

U32 drvNAND_CheckSum(U8 *pu8_Data, U16 u16_ByteCnt)
{
	U32 u32_Sum = 0;

	while (u16_ByteCnt--)
		u32_Sum += *pu8_Data++;

	return u32_Sum;
}

/* return 0: same, 1: different */
U32 drvNAND_CompareCISTag(U8 *tag)
{
	const char *str = "MSTARSEMIUNFDCIS";
	int i = 0;

	for (i = 0; i < 16; i++) {
		if (tag[i] != str[i])
			return 1;
	}
	return 0;
}

void drvNAND_ParseNandInfo(NAND_FLASH_INFO_t *pNandInfo)
{
	int i;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();

    if(pNandInfo->u16_PhyOobsize == 0)
        pNandInfo->u16_PhyOobsize = pNandInfo->u16_SpareByteCnt;

	dump_nand_info(pNandInfo);

	pNandDrv->u16_PageByteCnt  = pNandInfo->u16_PageByteCnt;
	pNandDrv->u16_SpareByteCnt = pNandInfo->u16_SpareByteCnt;
    pNandDrv->u16_PhyOobsize   = pNandInfo->u16_PhyOobsize;
	pNandDrv->u16_BlkPageCnt   = pNandInfo->u16_BlkPageCnt;
	pNandDrv->u16_BlkCnt       = pNandInfo->u16_BlkCnt;
	pNandDrv->u16_ECCType      = pNandInfo->u16_ECCType;
	pNandDrv->u8_IDByteCnt     = pNandInfo->u8_IDByteCnt;
	pNandDrv->u32_Config       = pNandInfo->u32_Config;
	pNandDrv->u16_tRC          = pNandInfo->u16_tRC;
	pNandDrv->u8_tRP           = pNandInfo->u8_tRP;
	pNandDrv->u8_tREH          = pNandInfo->u8_tREH;
	pNandDrv->u8_tREA          = pNandInfo->u8_tREA;
	pNandDrv->u8_tRR           = pNandInfo->u8_tRR;
	pNandDrv->u16_tADL         = pNandInfo->u16_tADL;
	pNandDrv->u16_tRHW         = pNandInfo->u16_tRHW;
	pNandDrv->u16_tWHR         = pNandInfo->u16_tWHR;
	pNandDrv->u16_tCCS         = pNandInfo->u16_tCCS;
	pNandDrv->u8_tCS           = pNandInfo->u8_tCS;
	pNandDrv->u16_tWC          = pNandInfo->u16_tWC;
	pNandDrv->u8_tWP           = pNandInfo->u8_tWP;
	pNandDrv->u8_tWH           = pNandInfo->u8_tWH;
	pNandDrv->u16_tCWAW        = pNandInfo->u16_tCWAW;
	pNandDrv->u8_tCLHZ		   = pNandInfo->u8_tCLHZ;
	pNandDrv->u16_tWW		   = pNandInfo->u16_tWW;
	pNandDrv->u8_AddrCycleIdx  = pNandInfo->u8_AddrCycleIdx;

	/*
	if(pNandDrv->u8_AddrCycleIdx != 0)
	{
		pNandDrv->u8_OpCode_Erase_AdrCycle = seq[pNandDrv->u8_AddrCycleIdx].u8_OpCode_Erase_AdrCycle;
		pNandDrv->u8_OpCode_RW_AdrCycle = seq[pNandDrv->u8_AddrCycleIdx].u8_OpCode_RW_AdrCycle;
		pNandDrv->u16_One_Col_Addr = seq[pNandDrv->u8_AddrCycleIdx].u16_Reg48_Spare;
		pNandDrv->u16_Reg48_Spare &= ~BIT_NC_ONE_COL_ADDR;
		pNandDrv->u16_Reg48_Spare |= seq[pNandDrv->u8_AddrCycleIdx].u16_Reg48_Spare;
	}
	*/

	memcpy(pNandDrv->u8_Vendor, pNandInfo->u8_Vendor, 16);
	memcpy(pNandDrv->u8_PartNumber, pNandInfo->u8_PartNumber, 16);

	pNandDrv->u8_CellType      = pNandDrv->u32_Config&0x1;
	pNandDrv->u8_BadBlkMarker      = (pNandDrv->u32_Config>>1)&0x7;
	pNandDrv->u8_PlaneCnt      = ((pNandDrv->u32_Config>>4)&0x7)+1;
	pNandDrv->u8_RequireRandomizer		= (pNandDrv->u32_Config>>8) & 0x1;
	pNandDrv->u8_NANDInterface	= ((pNandDrv->u32_Config>>9) & 3);
	pNandDrv->u8_CacheProgram	= ((pNandDrv->u32_Config >> 11) & 3);
	pNandDrv->u8_CacheRead		= ((pNandDrv->u32_Config >> 13) & 3);
	pNandDrv->u8_RequireReadRetry = ((pNandDrv->u32_Config>>15) & 1);

	pNandDrv->u8_PairPageMapLoc = pNandInfo->u8_PairPageMapLoc;
	pNandDrv->u8_ReadRetryType =	pNandInfo->u8_ReadRetryType;
	pNandDrv->u16_BitflipThreshold = pNandInfo->u8_BitflipThreshold;

	memcpy((void *) &pNandDrv->tDefaultDDR, (const void *) &pNandInfo->tDefaultDDR, sizeof(DDR_TIMING_GROUP_t));
	memcpy((void *) &pNandDrv->tMaxDDR, (const void *) &pNandInfo->tMaxDDR, sizeof(DDR_TIMING_GROUP_t));
	memcpy((void *) &pNandDrv->tMinDDR, (const void *) &pNandInfo->tMinDDR, sizeof(DDR_TIMING_GROUP_t));


	pNandDrv->u8_BL0PBA = pNandInfo->u8_BL0PBA;
	pNandDrv->u8_BL1PBA = pNandInfo->u8_BL1PBA;
	pNandDrv->u8_UBOOTPBA = pNandInfo->u8_UBOOTPBA;
	pNandDrv->u8_HashPBA[0][0] = pNandInfo->u8_HashPBA[0][0];
	pNandDrv->u8_HashPBA[0][1] = pNandInfo->u8_HashPBA[0][1];
	pNandDrv->u8_HashPBA[1][0] = pNandInfo->u8_HashPBA[1][0];
	pNandDrv->u8_HashPBA[1][1] = pNandInfo->u8_HashPBA[1][1];
	pNandDrv->u8_HashPBA[2][0] = pNandInfo->u8_HashPBA[2][0];
	pNandDrv->u8_HashPBA[2][1] = pNandInfo->u8_HashPBA[2][1];
	pNandDrv->u8_Hash0PageIdx = pNandInfo->u8_Hash0PageIdx;
	pNandDrv->u8_Hash1PageIdx = pNandInfo->u8_Hash1PageIdx;
	pNandDrv->u32_BootSize = pNandInfo->u32_BootSize;

	pNandDrv->u16_BBtPageCheckCount = pNandInfo->u16_BBtPageCheckCount;
	memcpy(pNandDrv->u16_BBtPageIdx, pNandInfo->u16_BBtPageIdx, NAND_BBT_PAGE_COUNT*sizeof(U16));
	memcpy(pNandDrv->u16_BBtMarker, pNandInfo->u16_BBtMarker, NAND_BBT_PAGE_COUNT*sizeof(U16));
}



/* return 1: Good block, 0: Bad block */
U32 drvNAND_IsGoodBlk(U16 u16_PBA)
{
	return 1;
}

U8 drvNAND_CheckAll0xFF(U8* pu8_Buf, U32 u32_ByteCnt)
{
	register U32 u32_i;
    U8 value = 0xFF;

	for(u32_i=0; u32_i<u32_ByteCnt; u32_i++)
		if(value != pu8_Buf[u32_i])
			return 0;

	return value;
}

U32 drvNAND_MarkBadBlk(U16 u16_PBA)
{
	return UNFD_ST_SUCCESS;
}

U32 drvNAND_ErasePhyBlk(U16 u16_PBA)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();

	return NC_EraseBlk (u16_PBA << pNandDrv->u8_BlkPageCntBits);
}


U32 drvNAND_ReadPhyPage(U32 u32_PageIdx, U8 *pu8_Data, U8 *pu8_Spare)
{
	return NC_ReadPages(u32_PageIdx, pu8_Data, pu8_Spare, 1);
}

U32 drvNAND_WritePhyPage(U32 u32_PageIdx, U8 *pu8_Data, U8 *pu8_Spare)
{
	return NC_WritePages(u32_PageIdx, pu8_Data, pu8_Spare, 1);
}

U32 drvNAND_LFSRReadPhyPage(U32 u32_PageIdx, U8 *pu8_Data, U8 *pu8_Spare)
{
	return NC_ReadPages(u32_PageIdx, pu8_Data, pu8_Spare, 1);
}

U32 drvNAND_LFSRWritePhyPage(U32 u32_PageIdx, U8 *pu8_Data, U8 *pu8_Spare)
{
	return NC_WritePages(u32_PageIdx, pu8_Data, pu8_Spare, 1);
}
