//<MStar Software>
//******************************************************************************
// MStar Software
// Copyright (c) 2010 - 2012 MStar Semiconductor, Inc. All rights reserved.
// All software, firmware and related documentation herein ("MStar Software") are
// intellectual property of MStar Semiconductor, Inc. ("MStar") and protected by
// law, including, but not limited to, copyright law and international treaties.
// Any use, modification, reproduction, retransmission, or republication of all
// or part of MStar Software is expressly prohibited, unless prior written
// permission has been granted by MStar.
//
// By accessing, browsing and/or using MStar Software, you acknowledge that you
// have read, understood, and agree, to be bound by below terms ("Terms") and to
// comply with all applicable laws and regulations:
//
// 1. MStar shall retain any and all right, ownership and interest to MStar
//    Software and any modification/derivatives thereof.
//    No right, ownership, or interest to MStar Software and any
//    modification/derivatives thereof is transferred to you under Terms.
//
// 2. You understand that MStar Software might include, incorporate or be
//    supplied together with third party`s software and the use of MStar
//    Software may require additional licenses from third parties.
//    Therefore, you hereby agree it is your sole responsibility to separately
//    obtain any and all third party right and license necessary for your use of
//    such third party`s software.
//
// 3. MStar Software and any modification/derivatives thereof shall be deemed as
//    MStar`s confidential information and you agree to keep MStar`s
//    confidential information in strictest confidence and not disclose to any
//    third party.
//
// 4. MStar Software is provided on an "AS IS" basis without warranties of any
//    kind. Any warranties are hereby expressly disclaimed by MStar, including
//    without limitation, any warranties of merchantability, non-infringement of
//    intellectual property rights, fitness for a particular purpose, error free
//    and in conformity with any international standard.  You agree to waive any
//    claim against MStar for any loss, damage, cost or expense that you may
//    incur related to your use of MStar Software.
//    In no event shall MStar be liable for any direct, indirect, incidental or
//    consequential damages, including without limitation, lost of profit or
//    revenues, lost or damage of data, and unauthorized system use.
//    You agree that this Section 4 shall still apply without being affected
//    even if MStar Software has been modified by MStar in accordance with your
//    request or instruction for your use, except otherwise agreed by both
//    parties in writing.
//
// 5. If requested, MStar may from time to time provide technical supports or
//    services in relation with MStar Software to you for your use of
//    MStar Software in conjunction with your or your customer`s product
//    ("Services").
//    You understand and agree that, except otherwise agreed by both parties in
//    writing, Services are provided on an "AS IS" basis and the warranty
//    disclaimer set forth in Section 4 above shall apply.
//
// 6. Nothing contained herein shall be construed as by implication, estoppels
//    or otherwise:
//    (a) conferring any license or right to use MStar name, trademark, service
//        mark, symbol or any other identification;
//    (b) obligating MStar or any of its affiliates to furnish any person,
//        including without limitation, you and your customers, any assistance
//        of any kind whatsoever, or any information; or
//    (c) conferring any license or right under any intellectual property right.
//
// 7. These terms shall be governed by and construed in accordance with the laws
//    of Taiwan, R.O.C., excluding its conflict of law rules.
//    Any and all dispute arising out hereof or related hereto shall be finally
//    settled by arbitration referred to the Chinese Arbitration Association,
//    Taipei in accordance with the ROC Arbitration Law and the Arbitration
//    Rules of the Association by three (3) arbitrators appointed in accordance
//    with the said Rules.
//    The place of arbitration shall be in Taipei, Taiwan and the language shall
//    be English.
//    The arbitration award shall be final and binding to both parties.
//
//******************************************************************************
//<MStar Software>

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <nand.h>
#include <malloc.h>

#include "common.h"
#include "BCH_bench.h"
#include "tool-util.h"
#include "../../inc/common/drvNAND.h"
#include "../../inc/common/drvNAND_utl.h"

extern struct platform_info info;
extern char *outfile;


//(1)The ecc_type structure is used to claim the relationship of
//ecc type between unfd driver and ecc calculate lib.
struct ecc_pair{
	int v_fcie3;
	int v_fcie4;
	int v_fcie5;
};
struct ecc_pair ecc_type[] = {
	{LIBBCH_NOT_SUPPORT, LIBBCH_NOT_SUPPORT, LIBBCH_NOT_SUPPORT},
	{LIBBCH_NOT_SUPPORT, LIBBCH_NOT_SUPPORT, LIBBCH_NOT_SUPPORT},		                     //ECC_TYPE_RS = 1
	//Fcie5 change 4bit ecc to 8bit ecc automatically
	{LIBBCH_FCIE3_4BIT_512BYTE, LIBBCH_FCIE4_4BIT_512BYTE, LIBBCH_FCIE5_8BIT},		//ECC_TYPE_4BIT = 2
	{LIBBCH_FCIE3_8BIT_512BYTE, LIBBCH_FCIE4_8BIT_512BYTE, LIBBCH_FCIE5_8BIT},		//ECC_TYPE_8BIT = 3
	{LIBBCH_FCIE3_12BIT_512BYTE, LIBBCH_FCIE4_12BIT_512BYTE, LIBBCH_NOT_SUPPORT},	//ECC_TYPE_12BIT = 4
	{LIBBCH_FCIE3_16BIT_512BYTE, LIBBCH_FCIE4_16BIT_512BYTE, LIBBCH_FCIE5_16BIT},	       //ECC_TYPE_16BIT = 5
	{LIBBCH_FCIE3_20BIT_512BYTE, LIBBCH_FCIE4_20BIT_512BYTE, LIBBCH_NOT_SUPPORT},	//ECC_TYPE_20BIT = 6
	{LIBBCH_FCIE3_24BIT_512BYTE, LIBBCH_FCIE4_24BIT_512BYTE, LIBBCH_FCIE5_24BIT},        //ECC_TYPE_24BIT = 7
	{LIBBCH_FCIE3_24BIT_1024BYTE, LIBBCH_FCIE4_24BIT_1024BYTE, LIBBCH_FCIE5_24BIT},	//ECC_TYPE_24BIT1KB = 8
	{LIBBCH_FCIE3_32BIT_1024BYTE, LIBBCH_FCIE4_32BIT_1024BYTE, LIBBCH_FCIE5_32BIT},	//ECC_TYPE_32BIT1KB = 9
	{LIBBCH_NOT_SUPPORT, LIBBCH_FCIE4_40BIT_1024BYTE, LIBBCH_FCIE5_40BIT},                  //ECC_TYPE_40BIT1KB = 10
	{LIBBCH_NOT_SUPPORT, LIBBCH_NOT_SUPPORT, LIBBCH_FCIE5_8BIT},                                 //ECC_TYPE_8BIT1KB = 11
	{LIBBCH_NOT_SUPPORT, LIBBCH_NOT_SUPPORT, LIBBCH_FCIE5_16BIT},                               //ECC_TYPE_16BIT1KB = 12
	{LIBBCH_NOT_SUPPORT, LIBBCH_NOT_SUPPORT, LIBBCH_FCIE5_32BIT},                               //ECC_TYPE_32BIT = 13
	{LIBBCH_NOT_SUPPORT, LIBBCH_NOT_SUPPORT, LIBBCH_FCIE5_40BIT},                               //ECC_TYPE_40BIT = 14
	{LIBBCH_NOT_SUPPORT, LIBBCH_NOT_SUPPORT, LIBBCH_FCIE5_60BIT},                               //ECC_TYPE_60BIT = 15
	{LIBBCH_NOT_SUPPORT, LIBBCH_FCIE4_60BIT_1024BYTE, LIBBCH_FCIE5_60BIT}                  //ECC_TYPE_60BIT1KB = 16
};

static int enble_lfsr;

//========================================================
// HAL function definitions
//========================================================
U32 NC_ResetFCIE(void)
{
	return UNFD_ST_SUCCESS;
}

U32 NC_EnableLFSR(void){

	enble_lfsr = 1;
	return UNFD_ST_SUCCESS;
}

U32 NC_DisableLFSR(void){

	enble_lfsr = 0;
	return UNFD_ST_SUCCESS;
}

U32 NC_ConfigContext(void)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

	if (pNandDrv->u16_ECCType < ECC_TYPE_24BIT1KB || pNandDrv->u16_ECCType == ECC_TYPE_32BIT ||
		pNandDrv->u16_ECCType == ECC_TYPE_40BIT || pNandDrv->u16_ECCType == ECC_TYPE_60BIT)
		pNandDrv->u16_SectorByteCnt = 0x200;
	else
		pNandDrv->u16_SectorByteCnt = 0x400;

	pNandDrv->u8_BlkPageCntBits = drvNAND_CountBits(pNandDrv->u16_BlkPageCnt);
	pNandDrv->u8_PageByteCntBits = drvNAND_CountBits(pNandDrv->u16_PageByteCnt);
	//pNandDrv->u8_SpareByteCntBits = drvNAND_CountBits(pNandDrv->u16_SpareByteCnt);
	pNandDrv->u8_SectorByteCntBits = drvNAND_CountBits(pNandDrv->u16_SectorByteCnt);

	pNandDrv->u16_BlkPageCntMask = (1<<pNandDrv->u8_BlkPageCntBits)-1;
	pNandDrv->u16_PageByteCntMask = (1<<pNandDrv->u8_PageByteCntBits)-1;
	pNandDrv->u16_SectorByteCntMask = (1<<pNandDrv->u8_SectorByteCntBits)-1;
	//pNandDrv->u16_SpareByteCntMask = (1<<pNandDrv->u8_SpareByteCntBits)-1;

	pNandDrv->u16_PageSectorCnt = pNandDrv->u16_PageByteCnt >> pNandDrv->u8_SectorByteCntBits;
	pNandDrv->u8_PageSectorCntBits = drvNAND_CountBits(pNandDrv->u16_PageSectorCnt);
	pNandDrv->u16_PageSectorCntMask = (1<<pNandDrv->u8_PageSectorCntBits)-1;
	pNandDrv->u16_SectorSpareByteCnt = pNandDrv->u16_SpareByteCnt >> pNandDrv->u8_PageSectorCntBits;
	pNandDrv->u16_SectorSpareByteCnt &= ~1;
	pNandDrv->u16_SpareByteCnt = pNandDrv->u16_SectorSpareByteCnt << pNandDrv->u8_PageSectorCntBits;
	//pNandDrv->u8_SectorSpareByteCntBits = drvNAND_CountBits(pNandDrv->u16_SectorSpareByteCnt);

	pNandDrv->u8_BlkSectorCntBits = pNandDrv->u8_BlkPageCntBits + pNandDrv->u8_PageSectorCntBits;
	pNandDrv->u16_BlkSectorCnt = 1<<pNandDrv->u8_BlkSectorCntBits;
	pNandDrv->u16_BlkSectorCntMask = pNandDrv->u16_BlkSectorCnt-1;

	return UNFD_ST_SUCCESS;
}

U32 NC_Init(void)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();

	switch (pNandDrv->u16_ECCType)
	{
	case ECC_TYPE_RS:
		printf("Error, ECC_TYPE_RS is not supported\n");
		return UNFD_ST_ERR_INVALID_PARAM;
	case ECC_TYPE_4BIT:
		if(info.fcietype == FCIE3)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE3_4BIT;
		else if (info.fcietype == FCIE4)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE4_4BIT;
		else{
			//Fcie5 change 4bit ecc to 8bit ecc automaticly
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE5_8BIT;
			pNandDrv->u16_BitflipThreshold = 4;
		}
		if(!pNandDrv->u16_BitflipThreshold)
			pNandDrv->u16_BitflipThreshold = 2;
		break;
	case ECC_TYPE_8BIT:
		if(info.fcietype == FCIE3)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE3_8BIT;
		else if (info.fcietype == FCIE4)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE4_8BIT;
		else
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE5_8BIT;
        if(!pNandDrv->u16_BitflipThreshold)
				pNandDrv->u16_BitflipThreshold = 4;
		break;
	case ECC_TYPE_12BIT:
		if(info.fcietype == FCIE3)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE3_12BIT;
		else if (info.fcietype == FCIE4)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE4_12BIT;
		else{
			printf("Error, ECC_TYPE_12BIT is not supported for FCIE%d\n", info.fcietype);
			return UNFD_ST_ERR_INVALID_PARAM;
		}
        if(!pNandDrv->u16_BitflipThreshold)
				pNandDrv->u16_BitflipThreshold = 6;
		break;
	case ECC_TYPE_16BIT:
		if(info.fcietype == FCIE3)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE3_16BIT;
		else if (info.fcietype == FCIE4)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE4_16BIT;
		else
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE5_16BIT;
        if(!pNandDrv->u16_BitflipThreshold)
				pNandDrv->u16_BitflipThreshold = 8;
		break;
	case ECC_TYPE_20BIT:
		if(info.fcietype == FCIE3)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE3_20BIT;
		else if (info.fcietype == FCIE4)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE4_20BIT;
		else{
			printf("Error, ECC_TYPE_12BIT is not supported for FCIE%d\n", info.fcietype);
			return UNFD_ST_ERR_INVALID_PARAM;
		}
        if(!pNandDrv->u16_BitflipThreshold)
				pNandDrv->u16_BitflipThreshold = 10;
		break;
	case ECC_TYPE_24BIT:
		if(info.fcietype == FCIE3)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE3_24BIT;
		else if (info.fcietype == FCIE4)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE4_24BIT;
		else
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE5_24BIT;
        if(!pNandDrv->u16_BitflipThreshold)
				pNandDrv->u16_BitflipThreshold = 12;
		break;
	case ECC_TYPE_32BIT:
		if(info.fcietype == FCIE3 || info.fcietype == FCIE4){
			printf("Error, ECC_TYPE_32BIT is not supported for FCIE%d\n", info.fcietype);
			return UNFD_ST_ERR_INVALID_PARAM;
		}
		else
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE5_32BIT;
        if(!pNandDrv->u16_BitflipThreshold)
				pNandDrv->u16_BitflipThreshold = 16;
		break;
	case ECC_TYPE_40BIT:
		if(info.fcietype == FCIE3 || info.fcietype == FCIE4){
			printf("Error, ECC_TYPE_40BIT is not supported for FCIE%d\n", info.fcietype);
			return UNFD_ST_ERR_INVALID_PARAM;
		}
		else
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE5_40BIT;
        if(!pNandDrv->u16_BitflipThreshold)
				pNandDrv->u16_BitflipThreshold = 20;
		break;
	case ECC_TYPE_24BIT1KB:
		if(info.fcietype == FCIE3)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE3_24BIT1KB;
		else if (info.fcietype == FCIE4)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE4_24BIT1KB;
		else
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE5_24BIT1KB;
        if(!pNandDrv->u16_BitflipThreshold)
				pNandDrv->u16_BitflipThreshold = 12;
		break;
	case ECC_TYPE_32BIT1KB:
		if(info.fcietype == FCIE3)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE3_32BIT1KB;
		else if (info.fcietype == FCIE4)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE4_32BIT1KB;
		else
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE5_32BIT1KB;
        if(!pNandDrv->u16_BitflipThreshold)
				pNandDrv->u16_BitflipThreshold = 16;
		break;
	case ECC_TYPE_40BIT1KB:
		if(info.fcietype == FCIE3){
			printf("Error, ECC_TYPE_40BIT1KB is not supported for FCIE%d\n", info.fcietype);
			return UNFD_ST_ERR_INVALID_PARAM;
		}
		else if (info.fcietype == FCIE4)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE4_40BIT1KB;
		else
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE5_40BIT1KB;
        if(!pNandDrv->u16_BitflipThreshold)
				pNandDrv->u16_BitflipThreshold = 20;
		break;
	case ECC_TYPE_60BIT1KB:
		if(info.fcietype == FCIE3){
			printf("Error, ECC_TYPE_40BIT1KB is not supported for FCIE%d\n", info.fcietype);
			return UNFD_ST_ERR_INVALID_PARAM;
		}
		else if (info.fcietype == FCIE4)
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE4_60BIT1KB;
		else
			pNandDrv->u16_ECCCodeByteCnt = ECC_CODE_BYTECNT_FCIE5_60BIT1KB;
        if(!pNandDrv->u16_BitflipThreshold)
				pNandDrv->u16_BitflipThreshold = 30;
		break;
	default:
		printf("ERROR: invalid ECC Type: %Xh \r\n", pNandDrv->u16_ECCType);
		return UNFD_ST_ERR_INVALID_PARAM;
	}

	NC_Config();
	return UNFD_ST_SUCCESS;
}

U32 NC_ReInit(void)
{
	return NC_Init();
}


U32 NC_ResetNandFlash(void)
{
	return UNFD_ST_SUCCESS;
}

U32 NC_PlatformInit(void)
{
	return UNFD_ST_SUCCESS;
}


void NC_Config(void)
{
	return;
}

void NC_ReConfig(void) // re-config FCIE3 for NFIE mode
{
	return;
}

U32 NC_RegInit(void)
{
	return NC_Init();
}

U32 NC_ConfigNandFlashContext(void)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

	if (pNandDrv->u16_ECCType < ECC_TYPE_24BIT1KB)
		pNandDrv->u16_SectorByteCnt = 0x200;
	else
		pNandDrv->u16_SectorByteCnt = 0x400;

	pNandDrv->u8_BlkPageCntBits = drvNAND_CountBits(pNandDrv->u16_BlkPageCnt);
	pNandDrv->u8_PageByteCntBits = drvNAND_CountBits(pNandDrv->u16_PageByteCnt);
	//pNandDrv->u8_SpareByteCntBits = drvNAND_CountBits(pNandDrv->u16_SpareByteCnt);
	pNandDrv->u8_SectorByteCntBits = drvNAND_CountBits(pNandDrv->u16_SectorByteCnt);

	pNandDrv->u16_BlkPageCntMask = (1<<pNandDrv->u8_BlkPageCntBits)-1;
	pNandDrv->u16_PageByteCntMask = (1<<pNandDrv->u8_PageByteCntBits)-1;
	pNandDrv->u16_SectorByteCntMask = (1<<pNandDrv->u8_SectorByteCntBits)-1;
	//pNandDrv->u16_SpareByteCntMask = (1<<pNandDrv->u8_SpareByteCntBits)-1;

	pNandDrv->u16_PageSectorCnt = pNandDrv->u16_PageByteCnt >> pNandDrv->u8_SectorByteCntBits;
	pNandDrv->u8_PageSectorCntBits = drvNAND_CountBits(pNandDrv->u16_PageSectorCnt);
	pNandDrv->u16_PageSectorCntMask = (1<<pNandDrv->u8_PageSectorCntBits)-1;
	pNandDrv->u16_SectorSpareByteCnt = pNandDrv->u16_SpareByteCnt >> pNandDrv->u8_PageSectorCntBits;
	pNandDrv->u16_SectorSpareByteCnt &= ~1;
	pNandDrv->u16_SpareByteCnt = pNandDrv->u16_SectorSpareByteCnt << pNandDrv->u8_PageSectorCntBits;
	//pNandDrv->u8_SectorSpareByteCntBits = drvNAND_CountBits(pNandDrv->u16_SectorSpareByteCnt);

	pNandDrv->u8_BlkSectorCntBits = pNandDrv->u8_BlkPageCntBits + pNandDrv->u8_PageSectorCntBits;
	pNandDrv->u16_BlkSectorCnt = 1<<pNandDrv->u8_BlkSectorCntBits;
	pNandDrv->u16_BlkSectorCntMask = pNandDrv->u16_BlkSectorCnt-1;

	return UNFD_ST_SUCCESS;
}

U32 NC_ReadID()
{
	U8 i;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

	for(i = 0; i < NAND_ID_BYTE_CNT; i++){
		pNandDrv->au8_ID[i] = info.nand_id[i];
	}

	return UNFD_ST_SUCCESS;
}

static u32 empty_check(const void *buf, u32 len)
{
	int i;
	NAND_DRIVER * pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

	//if ((!len) || (len & (meminfo->oobblock + meminfo->oobsize - 1)))
		//return -1;

	for (i = (len >> 2) - 1; i >= 0; i--)
		if (((const uint32_t *)buf)[i] != 0xFFFFFFFF)
			break;

	/* The resulting length must be aligned to the minimum flash I/O size */
	len = ALIGN((i + 1) << 2, pNandDrv->u16_PageByteCnt + pNandDrv->u16_SpareByteCnt);
	return len;
}

/*
 * ecc _cal() & Nand_GenSectorEcc() porting from src/ubinize/src/rs_enc_fcie3_new.c
 * gen_ecc_with_sector_size()=>Nand_GenSectorEcc()
 * support fcie5 ecc calculate.
 */
static int ecc_cal(int ECC_MODE,unsigned char *pSourceData,unsigned char *pSpareArea,int REDU_LENGTH,unsigned char *pOutputData,char debug)
{

	#if 0
	if (RS_4_512 == ECC_MODE){
		Calculate_ECC(pSourceData, pSpareArea);
		return 1;
	}
	else
	#endif
	{
		return encode_fcie(info.fcietype, ECC_MODE, pSourceData, pSpareArea, REDU_LENGTH, pOutputData, debug);
	}
}

static int Nand_GenSectorEcc(char *SourceBuffer, char *SpareBuf, int ECC_Mode)
{
	int ret, ecc_offset, ecc_len;
	int ECC_Mode_Lib;
	U16 u16_tmp;
	U8  u8_tmp[512];
	NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

	ecc_len = pNandDrv->u16_ECCCodeByteCnt;
	u16_tmp = 4 - ((pNandDrv->u16_SectorSpareByteCnt - ecc_len) % 4);

	if(info.fcietype== FCIE3)
		ECC_Mode_Lib = ecc_type[ECC_Mode].v_fcie3;
	if(info.fcietype == FCIE4)
		ECC_Mode_Lib = ecc_type[ECC_Mode].v_fcie4;
	else if(info.fcietype == FCIE5)
		ECC_Mode_Lib = ecc_type[ECC_Mode].v_fcie5;

	if(ECC_Mode_Lib == LIBBCH_NOT_SUPPORT){
		printf("[%s]: Invalid ecc type %d for fcie%d\n", __func__, ECC_Mode, info.fcietype);
		return 1;
	}

	if(info.fcietype == FCIE5){
		ecc_offset = (pNandDrv->u16_SectorSpareByteCnt - ecc_len) + u16_tmp;
		switch(u16_tmp){
		case 1:
			SpareBuf[pNandDrv->u16_SectorSpareByteCnt - ecc_len] = 0;
			break;
		case 2:
			SpareBuf[pNandDrv->u16_SectorSpareByteCnt - ecc_len] = 0;
			SpareBuf[pNandDrv->u16_SectorSpareByteCnt - ecc_len + 1] = 0;
			break;
		case 3:
			SpareBuf[pNandDrv->u16_SectorSpareByteCnt - ecc_len] = 0;
			SpareBuf[pNandDrv->u16_SectorSpareByteCnt - ecc_len + 1] = 0;
			SpareBuf[pNandDrv->u16_SectorSpareByteCnt - ecc_len + 2] = 0;
			break;
		default:
			break;
		}
	}
	else
		ecc_offset = pNandDrv->u16_SectorSpareByteCnt - ecc_len;

	if(info.fcietype == FCIE5){
		ret = ecc_cal(ECC_Mode_Lib, SourceBuffer, SpareBuf, ecc_offset, u8_tmp, 0);
	}
	else{
		ret = ecc_cal(ECC_Mode_Lib, SourceBuffer, SpareBuf, ecc_offset, SpareBuf + ecc_offset, 0);
	}
	if(info.fcietype == FCIE5)
		memcpy(SpareBuf + ecc_offset - u16_tmp, u8_tmp, ecc_len);

	return ret;
}


U32 NC_WritePages(U32 u32_PhyRowIdx, U8 *pu8_DataBuf, U8 *pu8_SpareBuf, U32 u32_PageCnt)
{
	int fd, ecc_offset, ecctype,ret,ret1;
	int page_idx, sector_idx;
	off_t offset;

	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();
	NAND_FLASH_INFO_t *pNandInfo = (NAND_FLASH_INFO_t *)drvNAND_get_DrvContext_NandInfo();

	if((u32_PhyRowIdx & (pNandDrv->u16_BlkPageCnt - 1)) + u32_PageCnt > pNandDrv->u16_BlkPageCnt){
		printf("[%s]: Cannot across block\n", __func__);
		return 1;
	}

	fd = open(outfile, O_RDWR);
	if(fd < 0){
		printf("[%s]: open file %s failed, %d\n", __func__, outfile, fd);
		return 1;
	}

	for(page_idx = 0; page_idx < u32_PageCnt; page_idx++){

		offset = (off_t)u32_PhyRowIdx * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize);
		if(pNandDrv->u16_Reg48_Spare & (1 << 12))
		offset = (off_t)u32_PhyRowIdx * (pNandInfo->u16_PageByteCnt + pNandInfo->u16_PhyOobsize);
		lseek64(fd, offset, SEEK_SET);

		memset(pNandDrv->PlatCtx_t.pu8_PageDataBuf, 0xFF, pNandDrv->u16_PageByteCnt);
		if(pu8_DataBuf){
			memcpy(pNandDrv->PlatCtx_t.pu8_PageDataBuf, pu8_DataBuf, pNandDrv->u16_PageByteCnt);
		}
		memset(pNandDrv->PlatCtx_t.pu8_PageSpareBuf, 0xFF, pNandDrv->u16_SpareByteCnt);
		if(pu8_SpareBuf){
			memcpy(pNandDrv->PlatCtx_t.pu8_PageSpareBuf, pu8_SpareBuf, pNandDrv->u16_SpareByteCnt);
		}

        //ret = empty_check(pu8_DataBuf, pNandDrv->u16_PageByteCnt);
        //ret1 = empty_check(pu8_SpareBuf, pNandDrv->u16_SpareByteCnt);
      //  if(ret !=0 || ret1 !=0)
      //  {
            if(info.haveecc == 0)
            {
        		for(sector_idx = 0; sector_idx < pNandDrv->u16_PageSectorCnt; sector_idx++){
        			ret = Nand_GenSectorEcc(pNandDrv->PlatCtx_t.pu8_PageDataBuf + sector_idx * pNandDrv->u16_SectorByteCnt,
        				pNandDrv->PlatCtx_t.pu8_PageSpareBuf + sector_idx * pNandDrv->u16_SectorSpareByteCnt,
        				pNandDrv->u16_ECCType);
        			if(ret){
        				printf("[%s]: Calculate ecc fail\n", __func__);
        				return ret;
        			}
        		}
            }
        //}
		if(pNandDrv->u16_Reg48_Spare & (1 << 12)){
			for(sector_idx = 0; sector_idx < pNandDrv->u16_PageSectorCnt; sector_idx++){
				ret = write(fd,
					pNandDrv->PlatCtx_t.pu8_PageDataBuf + sector_idx * pNandDrv->u16_SectorByteCnt,
					pNandDrv->u16_SectorByteCnt);
				if(ret < 0){
					printf("[%s]: write main data failed, page %lu\n", __func__, u32_PhyRowIdx);
					close(fd);
					return 1;
				}
				ret = write(fd,
					pNandDrv->PlatCtx_t.pu8_PageSpareBuf + sector_idx * pNandDrv->u16_SectorSpareByteCnt,
					pNandDrv->u16_SectorSpareByteCnt);
				if(ret < 0){
					printf("[%s]: write main data failed, page %lu\n", __func__, u32_PhyRowIdx);
					close(fd);
					return 1;
				}
			}
		}
		else{
			ret = write(fd, pNandDrv->PlatCtx_t.pu8_PageDataBuf, pNandDrv->u16_PageByteCnt);
			if(ret < 0){
				printf("[%s]: write main data failed, page %lu\n", __func__, u32_PhyRowIdx);
				close(fd);
				return 1;
			}
			ret = write(fd, pNandDrv->PlatCtx_t.pu8_PageSpareBuf, pNandDrv->u16_SpareByteCnt);
			if(ret < 0){
				printf("[%s]: write spare data failed, page %lu\n", __func__, u32_PhyRowIdx);
				close(fd);
				return 1;
			}
		}

		if(page_idx + 1>= u32_PageCnt)
			break;
		if(pu8_DataBuf)
			pu8_DataBuf += pNandDrv->u16_PageByteCnt;
        	if(pu8_SpareBuf)
			pu8_SpareBuf += pNandDrv->u16_SpareByteCnt;
		u32_PhyRowIdx++;
	}
//	fsync(fd);
	close(fd);
	return UNFD_ST_SUCCESS;
}

U32 NC_WritePages2P(U32 u32_PlaneRowIdx, U8 *pu8_DataBuf, U8 *pu8_SpareBuf, U32 u32_PageCnt)
{
	int ret;
	int plane_idx, page_idx;
	U32 u32_LBA;
	U32 u32_Page;
	U32 u32_PhyRowIdx;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();

	for(page_idx = 0; page_idx < u32_PageCnt; page_idx++){

		u32_LBA = u32_PlaneRowIdx / pNandDrv->u16_BlkPageCnt;
		u32_Page = u32_PlaneRowIdx & (pNandDrv->u16_BlkPageCnt - 1);
		u32_PhyRowIdx = u32_LBA * pNandDrv->u16_BlkPageCnt * pNandDrv->u8_PlaneCnt + u32_Page;

		for(plane_idx = 0; plane_idx < pNandDrv->u8_PlaneCnt; plane_idx++){
			ret = NC_WritePages(u32_PhyRowIdx, pu8_DataBuf, pu8_SpareBuf, 1);
			if(ret){
				printf("[%s]: write page %lu failed\n", __func__, u32_PhyRowIdx);
				return ret;
			}
			pu8_DataBuf += pNandDrv->u16_PageByteCnt;
			u32_PhyRowIdx += pNandDrv->u16_BlkPageCnt;
		}
		u32_PlaneRowIdx++;
	}

	return UNFD_ST_SUCCESS;
}

U32 NC_ReadPages(U32 u32_PhyRowIdx, U8 *pu8_DataBuf, U8 *pu8_SpareBuf, U32 u32_PageCnt)
{
	int fd, ret;
	U32 page_idx, sector_idx;
	off_t offset;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();
	NAND_FLASH_INFO_t *pNandInfo = (NAND_FLASH_INFO_t *)drvNAND_get_DrvContext_NandInfo();

	if(outfile == NULL)
		return 1;

	fd = open(outfile, O_RDWR);
	if(fd < 0){
		printf("[%s]: open file %s failed, %d\n", __func__, outfile, fd);
		return 1;
	}

	for(page_idx = 0; page_idx < u32_PageCnt; page_idx++){
		if(pNandDrv->u16_Reg48_Spare & (1 << 12)){

			offset = (off_t)u32_PhyRowIdx * (pNandInfo->u16_PageByteCnt + pNandInfo->u16_PhyOobsize);
			lseek64(fd, offset, SEEK_SET);

			for(sector_idx = 0; sector_idx < pNandDrv->u16_PageSectorCnt; sector_idx++){
				ret = read(fd,
					pNandDrv->PlatCtx_t.pu8_PageDataBuf + sector_idx * pNandDrv->u16_SectorByteCnt,
					pNandDrv->u16_SectorByteCnt);
				if(ret < 0){
					printf("[%s]: read main data failed, page %lu\n", __func__, u32_PhyRowIdx);
					close(fd);
					return 1;
				}
				ret = read(fd,
					pNandDrv->PlatCtx_t.pu8_PageSpareBuf + sector_idx * pNandDrv->u16_SectorSpareByteCnt,
					pNandDrv->u16_SectorSpareByteCnt);
				if(ret < 0){
					printf("[%s]: read spare data failed, page %lu\n", __func__, u32_PhyRowIdx);
					close(fd);
					return 1;
				}
			}
		}
		else{
			offset = (off_t)u32_PhyRowIdx * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize);
			lseek64(fd, offset, SEEK_SET);
			ret = read(fd, pNandDrv->PlatCtx_t.pu8_PageDataBuf, pNandDrv->u16_PageByteCnt);
			if(ret < 0){
				printf("[%s]: read main data failed, page %lu\n", __func__, u32_PhyRowIdx);
				close(fd);
				return 1;
			}
			ret = read(fd, pNandDrv->PlatCtx_t.pu8_PageSpareBuf, pNandDrv->u16_SpareByteCnt);
			if(ret < 0){
				printf("[%s]: read spare data failed, page %lu\n", __func__, u32_PhyRowIdx);
				close(fd);
				return 1;
			}

		}

		if(pu8_DataBuf){
				memcpy(pu8_DataBuf, pNandDrv->PlatCtx_t.pu8_PageDataBuf, pNandDrv->u16_PageByteCnt);
				pu8_DataBuf += pNandDrv->u16_PageByteCnt;
		}
			if(pu8_SpareBuf){
				memcpy(pu8_SpareBuf, pNandDrv->PlatCtx_t.pu8_PageSpareBuf, pNandDrv->u16_SpareByteCnt);
				  pu8_SpareBuf += pNandDrv->u16_SpareByteCnt;
		}

		if(page_idx + 1>= u32_PageCnt)
		{
			if(pu8_DataBuf)
				pu8_DataBuf -= pNandDrv->u16_PageByteCnt;

			 if(pu8_SpareBuf)
					  pu8_SpareBuf -= pNandDrv->u16_SpareByteCnt;
			break;
		}

		u32_PhyRowIdx++;
	}


	close(fd);
	return UNFD_ST_SUCCESS;
}


U32 NC_ReadPages2P(U32 u32_PlaneRowIdx, U8 *pu8_DataBuf, U8 *pu8_SpareBuf, U32 u32_PageCnt)
{
	int ret;
	int plane_idx, page_idx;
	U32 u32_LBA;
	U32 u32_Page;
	U32 u32_PhyRowIdx;

	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();

	if(!pu8_DataBuf){
		printf("[%s]: No data buffer\n", __func__);
		return 1;
	}

	for(page_idx = 0; page_idx < u32_PageCnt; page_idx++){

		u32_LBA = u32_PlaneRowIdx / pNandDrv->u16_BlkPageCnt;
		u32_Page = u32_PlaneRowIdx & (pNandDrv->u16_BlkPageCnt - 1) ;
		u32_PhyRowIdx = u32_LBA * pNandDrv->u16_BlkPageCnt * pNandDrv->u8_PlaneCnt + u32_Page;

		for(plane_idx = 0; plane_idx < pNandDrv->u8_PlaneCnt; plane_idx++){
			ret = NC_ReadPages(u32_PhyRowIdx, pu8_DataBuf, pu8_SpareBuf, 1);
			if(ret){
				printf("[%s]: read page %lu failed\n", __func__, u32_PhyRowIdx);
				return ret;
			}
			pu8_DataBuf += pNandDrv->u16_PageByteCnt;
			pu8_SpareBuf += pNandDrv->u16_SpareByteCnt;
			u32_PhyRowIdx += pNandDrv->u16_BlkPageCnt;
		}
		u32_PlaneRowIdx++;
	}

	return UNFD_ST_SUCCESS;
}

U32  NC_ReadSectors(U32 u32_PhyRowIdx, U8 u8_SectorInPage, U8 *pu8_DataBuf, U8 *pu8_SpareBuf, U32 u32_SectorCnt)
{
	int fd, ret, i;
	off_t offset;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();
	NAND_FLASH_INFO_t *pNandInfo = (NAND_FLASH_INFO_t *)drvNAND_get_DrvContext_NandInfo();

	if(!pu8_DataBuf){
		printf("[%s]: No data buffer\n", __func__);
		return 1;
	}

	fd = open(outfile, O_RDWR);
	if(fd < 0){
		printf("[%s]: open file %s failed\n", __func__, outfile);
		return -1;
	}

	if(pNandDrv->u16_Reg48_Spare & (1 << 12)){
		offset = (off_t)u32_PhyRowIdx * (pNandInfo->u16_PageByteCnt + pNandInfo->u16_PhyOobsize);
		offset += u8_SectorInPage * (pNandDrv->u16_SectorByteCnt+ pNandDrv->u16_SectorSpareByteCnt);
		lseek64(fd, offset, SEEK_SET);
		for(i = 0; i < u32_SectorCnt; i++){
			if(pu8_DataBuf){
				ret = read(fd, pu8_DataBuf, pNandDrv->u16_SectorByteCnt);
				if(ret < 0){
					printf("[%s]: read sector failed\n", __func__);
					close(fd);
					return 1;
				}
			}
			else
				lseek64(fd, pNandDrv->u16_SectorByteCnt, SEEK_CUR);

			if(pu8_SpareBuf){
				ret = read(fd, pu8_SpareBuf, pNandDrv->u16_SectorSpareByteCnt);
				if(ret < 0){
					printf("[%s]: read spare failed\n", __func__);
					close(fd);
					return 1;
				}
			}
			else
				lseek64(fd, pNandDrv->u16_SectorSpareByteCnt, SEEK_CUR);

			if(pu8_DataBuf)
				pu8_DataBuf += pNandDrv->u16_SectorByteCnt;
			if(pu8_SpareBuf)
				pu8_SpareBuf += pNandDrv->u16_SectorSpareByteCnt;

		}
	}
	else{
		offset = (off_t)u32_PhyRowIdx * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize);
		offset += u8_SectorInPage * pNandDrv->u16_SectorByteCnt;
		lseek64(fd, offset, SEEK_SET);

		if(pu8_DataBuf){
			ret = read(fd, pu8_DataBuf, u32_SectorCnt * pNandDrv->u16_SectorByteCnt);
			if(ret < 0){
				printf("[%s]: write failed\n", __func__);
				close(fd);
				return 1;
			}
		}
		else
			lseek64(fd, u32_SectorCnt * pNandDrv->u16_SectorByteCnt, SEEK_CUR);

		if(pu8_SpareBuf){
			offset = (off_t)u32_PhyRowIdx * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize);
			offset += pNandDrv->u16_PageByteCnt;
			offset += u8_SectorInPage * pNandDrv->u16_SectorSpareByteCnt;
			lseek64(fd, offset, SEEK_SET);
			ret = read(fd, pu8_SpareBuf, u32_SectorCnt * pNandDrv->u16_SectorSpareByteCnt);
			if(ret < 0){
				printf("[%s]: read failed\n", __func__);
				close(fd);
				return 1;
			}
		}
	}
	close(fd);

	return UNFD_ST_SUCCESS;
}

U32  NC_ReadSector_RIUMode(U32 u32_PhyRowIdx, U8 u8_SectorInPage, U8 *pu8_DataBuf, U8 *pu8_SpareBuf)
{
	return NC_ReadSectors(u32_PhyRowIdx, u8_SectorInPage, pu8_DataBuf, pu8_SpareBuf, 1);
}

U32  NC_WriteSectors(U32 u32_PhyRowIdx, U8 u8_SectorInPage, U8 *pu8_DataBuf, U8 *pu8_SpareBuf, U32 u32_SectorCnt )
{
	int fd, ret, sector_idx;
	off_t offset;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();
	NAND_FLASH_INFO_t *pNandInfo = (NAND_FLASH_INFO_t *)drvNAND_get_DrvContext_NandInfo();

	if(!pu8_DataBuf){
		printf("[%s]: No data buffer\n", __func__);
		return 1;
	}

	if(u8_SectorInPage + u32_SectorCnt > pNandDrv->u16_PageSectorCnt){
		printf("[%s]: write sectors cannot across page\n", __func__);
		return 1;
	}

	fd = open(outfile, O_RDWR);
	if(fd < 0){
		printf("[%s]: open file %s failed\n", __func__, outfile);
		return 1;
	}

	if(pNandDrv->u16_Reg48_Spare & (1 << 12)){

		offset = (off_t)u32_PhyRowIdx * (pNandInfo->u16_PageByteCnt + pNandInfo->u16_PhyOobsize);
		offset += u8_SectorInPage * (pNandDrv->u16_SectorByteCnt + pNandDrv->u16_SectorSpareByteCnt);
		lseek64(fd, offset, SEEK_SET);

		for(sector_idx = 0; sector_idx < u32_SectorCnt; sector_idx++){
			memset(pNandDrv->PlatCtx_t.pu8_PageDataBuf, 0xFF, pNandDrv->u16_SectorByteCnt);
			if(pu8_DataBuf){
				memcpy(pNandDrv->PlatCtx_t.pu8_PageDataBuf, pu8_DataBuf, pNandDrv->u16_SectorByteCnt);
			}
			memset(pNandDrv->PlatCtx_t.pu8_PageSpareBuf, 0xFF, pNandDrv->u16_SectorSpareByteCnt);
			if(pu8_SpareBuf){
				memcpy(pNandDrv->PlatCtx_t.pu8_PageSpareBuf, pu8_SpareBuf, pNandDrv->u16_SectorSpareByteCnt);
			}
			ret = Nand_GenSectorEcc(pNandDrv->PlatCtx_t.pu8_PageDataBuf,
				pNandDrv->PlatCtx_t.pu8_PageSpareBuf,
				pNandDrv->u16_ECCType);
			if(ret){
				printf("[%s]: Calculate ecc fail\n", __func__);
				return ret;
			}
			printf("[%s]:%d u16_SectorByteCnt=%d\n", __func__, __LINE__, pNandDrv->u16_SectorByteCnt);
			ret = write(fd, pNandDrv->PlatCtx_t.pu8_PageDataBuf,pNandDrv->u16_SectorByteCnt);
			if(ret < 0){
				printf("[%s]: write main space failed\n", __func__);
				close(fd);
				return 1;
			}
			ret = write(fd, pNandDrv->PlatCtx_t.pu8_PageSpareBuf, pNandDrv->u16_SectorSpareByteCnt);
			if(ret < 0){
				printf("[%s]: write spare space failed\n", __func__);
				close(fd);
				return 1;
			}
			if(pu8_DataBuf)
				pu8_DataBuf += pNandDrv->u16_SectorByteCnt;
			if(pu8_SpareBuf)
				pu8_SpareBuf += pNandDrv->u16_SectorSpareByteCnt;
		}
	}
	else{
		memset(pNandDrv->PlatCtx_t.pu8_PageDataBuf, 0xFF, u32_SectorCnt * pNandDrv->u16_SectorByteCnt);
		if(pu8_DataBuf){
			memcpy(pNandDrv->PlatCtx_t.pu8_PageDataBuf, pu8_DataBuf, u32_SectorCnt * pNandDrv->u16_SectorByteCnt);
		}
		memset(pNandDrv->PlatCtx_t.pu8_PageSpareBuf, 0xFF, u32_SectorCnt * pNandDrv->u16_SectorSpareByteCnt);
		if(pu8_SpareBuf){
			memcpy(pNandDrv->PlatCtx_t.pu8_PageSpareBuf, pu8_SpareBuf, u32_SectorCnt * pNandDrv->u16_SectorSpareByteCnt);
		}
		for(sector_idx = 0; sector_idx < u32_SectorCnt; sector_idx++){
			ret = Nand_GenSectorEcc(pNandDrv->PlatCtx_t.pu8_PageDataBuf + sector_idx * pNandDrv->u16_SectorByteCnt,
				pNandDrv->PlatCtx_t.pu8_PageSpareBuf + sector_idx * pNandDrv->u16_SectorSpareByteCnt,
				pNandDrv->u16_ECCType);
			if(ret){
				printf("[%s]: Calculate ecc fail\n", __func__);
				return ret;
			}
		}
		offset = (off_t)u32_PhyRowIdx * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize);
		offset += u8_SectorInPage * pNandDrv->u16_SectorByteCnt;
		lseek64(fd, offset, SEEK_SET);
		printf("[%s]:%d u16_SectorByteCnt=%d\n", __func__, __LINE__, pNandDrv->u16_SectorByteCnt);
		ret = write(fd, pNandDrv->PlatCtx_t.pu8_PageDataBuf, u32_SectorCnt * pNandDrv->u16_SectorByteCnt);
		if(ret < 0){
			printf("[%s]: write main failed\n", __func__);
			close(fd);
			return 1;
		}
		offset = (off_t)u32_PhyRowIdx * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize);
		offset += pNandDrv->u16_PageByteCnt;
		offset += u8_SectorInPage * pNandDrv->u16_SectorSpareByteCnt;
		lseek64(fd, offset, SEEK_SET);
		ret = write(fd, pNandDrv->PlatCtx_t.pu8_PageSpareBuf, u32_SectorCnt * pNandDrv->u16_SectorSpareByteCnt);
		if(ret < 0){
			printf("[%s]: write spare failed\n", __func__);
			close(fd);
			return 1;
		}
	}
//	fsync(fd);
	close(fd);
	return UNFD_ST_SUCCESS;
}

U32 NC_Write_RandomOut(U32 u32_PhyRow, U32 u32_Col, U8 *pu8_DataBuf, U32 u32_DataByteCnt)
{
	return UNFD_ST_SUCCESS;
}

U32 NC_EraseBlk(U32 u32_PhyRowIdx)
{
	int fd, ret, i;
	off_t offset;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();

	u32_PhyRowIdx &= ~(pNandDrv->u16_BlkPageCnt  - 1);

	fd = open(outfile, O_RDWR);
	if(fd < 0){
		printf("[%s]: open file %s failed\n", __func__, outfile);
		return 1;
	}

	memset(pNandDrv->PlatCtx_t.pu8_PageDataBuf, 0xFF, pNandDrv->u16_PageByteCnt);
	memset(pNandDrv->PlatCtx_t.pu8_PageSpareBuf, 0xFF, pNandDrv->u16_SpareByteCnt);

	offset = (off_t)u32_PhyRowIdx * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize);
	lseek64(fd, offset, SEEK_SET);

	for(i = 0; i < pNandDrv->u16_BlkPageCnt; i++){
		ret = write(fd, pNandDrv->PlatCtx_t.pu8_PageDataBuf, pNandDrv->u16_PageByteCnt);
		if(ret < 0){
			printf("[%s]: write main data page %lu failed\n", __func__, u32_PhyRowIdx);
			close(fd);
			return ret;
		}
		ret = write(fd, pNandDrv->PlatCtx_t.pu8_PageSpareBuf, pNandDrv->u16_SpareByteCnt);
		if(ret < 0){
			printf("[%s]: write spare data page %lu failed\n", __func__, u32_PhyRowIdx);
			close(fd);
			return ret;
		}
	}
//	fsync(fd);
	close(fd);
	return UNFD_ST_SUCCESS;
}

U32 NC_EraseBlk2P(U32 u32_PlaneRowIdx)
{
	int ret, i;
	U32 u32_LBA;
	U32 u32_PhyRowIdx;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();

	u32_PlaneRowIdx &= ~(pNandDrv->u16_BlkPageCnt - 1);
	u32_LBA = u32_PlaneRowIdx / pNandDrv->u16_BlkPageCnt;
	u32_PhyRowIdx = u32_LBA * pNandDrv->u16_BlkPageCnt;

	for(i = 0; i < pNandDrv->u8_PlaneCnt; i++){
		ret = NC_EraseBlk( u32_PhyRowIdx);
		if(ret){
			printf("[%s]: erase block %lu failed\n", __func__, u32_PhyRowIdx);
			return ret;
		}
		u32_PhyRowIdx += pNandDrv->u16_BlkPageCnt;
	}

	return UNFD_ST_SUCCESS;
}








//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
void test(void)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();

	unsigned char *data;
	unsigned char *spare;
	int i, j;

	data = (unsigned char *)malloc(pNandDrv->u16_PageByteCnt * 8);
	spare = (unsigned char *)malloc(pNandDrv->u16_SpareByteCnt * 8);

	for(j=0;j<pNandDrv->u16_SpareByteCnt * 8;j++){
		printf("%d ", spare[j]);
	}

/*
	for(i=0;i<8;i++){
		memset(data + i * pNandDrv->u16_PageByteCnt ,  i+1 , pNandDrv->u16_PageByteCnt);
		memset(spare + i * pNandDrv->u16_SpareByteCnt, i+2, pNandDrv->u16_SpareByteCnt);

			for(j=0;j<pNandDrv->u16_SpareByteCnt * 8;j++){
				printf("%d ", spare[j]);
			}
			printf("\n\n");

	}
	spare[1] =0x1;
*/

	printf("----------------------------test---------------------------\n");
	printf("ecc %d, %d\n", pNandDrv->u16_ECCType, pNandDrv->u16_ECCCodeByteCnt);

//	pNandDrv->u8_PlaneCnt = 4;

//	pNandDrv->u16_Reg48_Spare |= (1 << 12);

//	NC_ConfigContext();
//	NC_Init();

//	NC_WritePages2P(0, data, spare, 2);

	NC_ReadPages(0, data,  spare, 2);
	for(j=0;j<pNandDrv->u16_PageByteCnt * 2;j++){
		printf("0x%2X ", data[j]);
	}
	printf("\n\n");
	for(j=0;j<pNandDrv->u16_SpareByteCnt * 2;j++){
		printf("0x%2X ", spare[j]);
	}

}
void test2(void)
{	int fd;
extern char *root_directory;
extern char *image_directory;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();
	char path[128], *data;
	struct stat st;
	printf("333333333333333\n");
	memset(path, 0, sizeof(path));
	printf("444444444444\n");

	sprintf(path, "%s%s%s", root_directory, image_directory, "mboot_nand.bin");
	printf("5555555555555\n");
	fd= open(path, O_RDWR);
	if(fd < 0){
		printf("open %s failed\n", path);
		return ;
	}
printf("2222222222222\n");
	stat(path, &st);
	data = (char *)malloc(st.st_size);
		read(fd, data, st.st_size);
		printf("1111111111111111111\n");
//		NC_WritePages(0, data, NULL, 3);
	nand_write_bootloader(0, data, st.st_size, 0);
}
void test3(void)
{
	printf("Hi--------------------\n");
	drvNAND_WriteCIS_for_ROM(drvNAND_get_DrvContext_NandInfo());
}
void test4(void)
{
	NC_EraseBlk(0);
	NC_EraseBlk(10);
}
void nand_hal_test5(void)
{
	int a, b;
	unsigned char *buf, *suf, *rf1, *rf2;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();
	int len = 2048 * 2;
	buf = (unsigned char *)malloc(len);
	suf =  (unsigned char *)malloc(len);
	rf1 =  (unsigned char *)malloc(len);
	rf2=  (unsigned char *)malloc(len);
	printf("AAAAAAAAAAA\n");
	for(a=0; a < len /256; a++)
	{
		memset(buf + a * 256,a+40, 256);
	}
	printf("BBBBBBBBBB\n");
	for(a=0; a < 1024 /8; a++)
	{
		printf("%d+++++++++, %lX\n", a, (long)suf);
		memset(suf + a * 8, a+10, 8);
	}
	printf("CCCCCCCCC\n");
	NC_WriteSectors(100, 1, buf, suf, 2);
	printf("DDDDDDDDDDD\n");

	pNandDrv->u16_Reg48_Spare |= (1 << 12);

	NC_ConfigContext();
	NC_Init();
	NC_WriteSectors(101, 1, buf, suf, 2);

	//////////////////////////////////////////////////////

	pNandDrv->u16_Reg48_Spare &=  ~(1 << 12);
	NC_ReadSectors(100, 1, rf1, rf2, 2);
	for(a=0;a<1024;a+=16){
		for(b=0;b<16;b++){
			printf("0x%2X ", rf1[a+b]);
		}
		printf("\n");
	}
	for(a=0;a<64;a+=16){
		for(b=0;b<16;b++){
			printf("0x%2X ", rf2[a+b]);
		}
		printf("\n");
	}
	printf("\n\n\n");


	pNandDrv->u16_Reg48_Spare |=  (1 << 12);
	NC_ReadSectors(101, 1, rf1, rf2, 2);
	for(a=0;a<1024;a+=16){
		for(b=0;b<16;b++){
			printf("0x%2X ", rf1[a+b]);
		}
		printf("\n");
	}
	for(a=0;a<64;a+=16){
		for(b=0;b<16;b++){
			printf("0x%2X ", rf2[a+b]);
		}
		printf("\n");
	}

}
void test6(void)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();

	unsigned char *data;
	unsigned char *spare;
	int i, j,a,b;

	data = (unsigned char *)malloc(pNandDrv->u16_PageByteCnt * 8);
	spare = (unsigned char *)malloc(pNandDrv->u16_SpareByteCnt * 8);


	for(i = 0;i<3;i++){
		memset(data+i*pNandDrv->u16_SectorByteCnt, i+40, pNandDrv->u16_SectorByteCnt);
		memset(spare+i*pNandDrv->u16_SectorSpareByteCnt, i+40, pNandDrv->u16_SectorSpareByteCnt);
	}
	pNandDrv->u16_Reg48_Spare |=  (1 << 12);


	NC_WriteSectors(1, 1, data, spare, 1);
	NC_WriteSectors(1, 2, data+pNandDrv->u16_SectorByteCnt, NULL, 1);
/*
	NC_ReadSectors(1, 1, data, spare, 1);

	for(a=0;a<512;a+=16){
		for(b=0;b<16;b++){
			printf("0x%2X ", data[a+b]);
		}
		printf("\n");
	}
	for(a=0;a<32;a+=16){
		for(b=0;b<16;b++){
			printf("0x%2X ", spare[a+b]);
		}
		printf("\n");
	}
	printf("\n");
	NC_ReadSectors(1, 2, NULL, spare, 1);
	for(a=0;a<512;a+=16){
		for(b=0;b<16;b++){
			printf("0x%2X ", data[a+b]);
		}
		printf("\n");
	}

	for(a=0;a<32;a+=16){
		for(b=0;b<16;b++){
			printf("0x%2X ", spare[a+b]);
		}
		printf("\n");
	}
*/
}
