//<MStar Software>
//******************************************************************************
// MStar Software
// Copyright (c) 2010 - 2012 MStar Semiconductor, Inc. All rights reserved.
// All software, firmware and related documentation herein ("MStar Software") are
// intellectual property of MStar Semiconductor, Inc. ("MStar") and protected by
// law, including, but not limited to, copyright law and international treaties.
// Any use, modification, reproduction, retransmission, or republication of all
// or part of MStar Software is expressly prohibited, unless prior written
// permission has been granted by MStar.
//
// By accessing, browsing and/or using MStar Software, you acknowledge that you
// have read, understood, and agree, to be bound by below terms ("Terms") and to
// comply with all applicable laws and regulations:
//
// 1. MStar shall retain any and all right, ownership and interest to MStar
//    Software and any modification/derivatives thereof.
//    No right, ownership, or interest to MStar Software and any
//    modification/derivatives thereof is transferred to you under Terms.
//
// 2. You understand that MStar Software might include, incorporate or be
//    supplied together with third party`s software and the use of MStar
//    Software may require additional licenses from third parties.
//    Therefore, you hereby agree it is your sole responsibility to separately
//    obtain any and all third party right and license necessary for your use of
//    such third party`s software.
//
// 3. MStar Software and any modification/derivatives thereof shall be deemed as
//    MStar`s confidential information and you agree to keep MStar`s
//    confidential information in strictest confidence and not disclose to any
//    third party.
//
// 4. MStar Software is provided on an "AS IS" basis without warranties of any
//    kind. Any warranties are hereby expressly disclaimed by MStar, including
//    without limitation, any warranties of merchantability, non-infringement of
//    intellectual property rights, fitness for a particular purpose, error free
//    and in conformity with any international standard.  You agree to waive any
//    claim against MStar for any loss, damage, cost or expense that you may
//    incur related to your use of MStar Software.
//    In no event shall MStar be liable for any direct, indirect, incidental or
//    consequential damages, including without limitation, lost of profit or
//    revenues, lost or damage of data, and unauthorized system use.
//    You agree that this Section 4 shall still apply without being affected
//    even if MStar Software has been modified by MStar in accordance with your
//    request or instruction for your use, except otherwise agreed by both
//    parties in writing.
//
// 5. If requested, MStar may from time to time provide technical supports or
//    services in relation with MStar Software to you for your use of
//    MStar Software in conjunction with your or your customer`s product
//    ("Services").
//    You understand and agree that, except otherwise agreed by both parties in
//    writing, Services are provided on an "AS IS" basis and the warranty
//    disclaimer set forth in Section 4 above shall apply.
//
// 6. Nothing contained herein shall be construed as by implication, estoppels
//    or otherwise:
//    (a) conferring any license or right to use MStar name, trademark, service
//        mark, symbol or any other identification;
//    (b) obligating MStar or any of its affiliates to furnish any person,
//        including without limitation, you and your customers, any assistance
//        of any kind whatsoever, or any information; or
//    (c) conferring any license or right under any intellectual property right.
//
// 7. These terms shall be governed by and construed in accordance with the laws
//    of Taiwan, R.O.C., excluding its conflict of law rules.
//    Any and all dispute arising out hereof or related hereto shall be finally
//    settled by arbitration referred to the Chinese Arbitration Association,
//    Taipei in accordance with the ROC Arbitration Law and the Arbitration
//    Rules of the Association by three (3) arbitrators appointed in accordance
//    with the said Rules.
//    The place of arbitration shall be in Taipei, Taiwan and the language shall
//    be English.
//    The arbitration award shall be final and binding to both parties.
//
//******************************************************************************
//<MStar Software>
////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2008-2009 MStar Semiconductor, Inc.
// All rights reserved.
//
// Unless otherwise stipulated in writing, any and all information contained
// herein regardless in any format shall remain the sole proprietary of
// MStar Semiconductor Inc. and be kept in strict confidence
// ("MStar Confidential Information") by the recipient.
// Any unauthorized act including without limitation unauthorized disclosure,
// copying, use, reproduction, sale, distribution, modification, disassembling,
// reverse engineering and compiling of the contents of MStar Confidential
// Information is unlawful and strictly prohibited. MStar hereby reserves the
// rights to any and all damages, losses, costs and expenses resulting therefrom.
//
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////
///
/// file    drvSPINAND.c
/// @brief  SPI NAND Flash Driver Interface
/// @author MStar Semiconductor Inc.
///////////////////////////////////////////////////////////////////////////////////////////////////


//-------------------------------------------------------------------------------------------------
//  Include Files
//-------------------------------------------------------------------------------------------------
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h> 

#include "common.h"
#include "tool-util.h"
#include "types.h"
#include "dictionary.h"
#include "libiniparser.h"
#include "../../inc/common/drvSPINAND.h"
#include "../../inc/common/drvSPICMD.h"


//==========================================================================
// Define
//==========================================================================
#define SPINAND_ID_SIZE 2

//==========================================================================
// Global Variable
//==========================================================================
SPINAND_FLASH_INFO_t _gtSpinandInfo;
U8 u8MagicData[] = {0x4D, 0x53, 0x54, 0x41, 0x52, 0x53, 0x45, 0x4D, 0x49, 0x55, 0x53, 0x46, 0x44, 0x43, 0x49, 0x53};

extern struct platform_info info;
extern dictionary *dict;
extern char *root_directory;
extern char *image_directory;
extern char *outfile;
//==========================================================================
// Code
//==========================================================================
SPINAND_FLASH_INFO_t *MDrv_SPINAND_get_SpinandInfo_address()
{
	return &_gtSpinandInfo;
}

static U32 _MDrv_SPINAND_GET_INFO(void)
{
	int fd, ret, i, len;
	char nni_path[128];
	char *nni_name;
	char *nand_id;
	char buf[512];
	struct stat st;
	SPINAND_FLASH_INFO_t *tSpinandInfo;

	nni_name = iniparser_getstring(dict, "cis:nni", "No set");
	if(strcmp(nni_name, "Not set") == 0){
		printf("[%s]: nni file is not set\n", __func__);
		return 1;
	}

	memset(nni_path, 0, sizeof(nni_path));
	sprintf(nni_path, "%s%s%s", root_directory, image_directory, nni_name);
	fd = open(nni_path, O_RDWR);
	if(fd < 0){
		printf("[%s]: Cannot open %s\n", __func__, nni_path);
		return 1;
	}
	
	stat(nni_path, &st);

	for(len = st.st_size; len >= 0x200; len -= 0x200){
		ret = read(fd, buf, 0x200);
		if(ret < 0){
			printf("[%s]: read file %s failed\n", __func__);
			return 1;
		}
		
		if(memcmp(buf, u8MagicData, sizeof(u8MagicData)) !=0)
			continue;

		tSpinandInfo = (SPINAND_FLASH_INFO_t *)(buf + sizeof(u8MagicData));
		for(i = 0; i< tSpinandInfo->u8_IDByteCnt; i++){
			if(info.nand_id[i] != tSpinandInfo->au8_ID[i])
				break;
		}
		if(i >= tSpinandInfo->u8_IDByteCnt){
			memcpy(&_gtSpinandInfo, tSpinandInfo, sizeof(SPINAND_FLASH_INFO_t));
			break;
		}
	}
	close(fd);
	
	if(len < 0x200)
		return 1;
	return 0;
}

U32 MDrv_SPINAND_Init(SPINAND_FLASH_INFO_t *tSpinandInfo)
{
	if(_MDrv_SPINAND_GET_INFO()){
		printf("[%s]: Can not find CIS Nand info\n", __func__);
		return 1;
	}
	else{
		memcpy(tSpinandInfo, &_gtSpinandInfo, sizeof(SPINAND_FLASH_INFO_t));
		printf("###############################################\n");
		printf("#        SPINAND INFO                         #\n");
		printf("###############################################\n");
		printf("[%s]: page size: %d\n", __func__, _gtSpinandInfo.u16_PageByteCnt);
		printf("[%s]: spare size: %d\n", __func__, _gtSpinandInfo.u16_SpareByteCnt);
		printf("[%s]: page count: %d\n", __func__, _gtSpinandInfo.u16_BlkPageCnt);
		printf("[%s]: block count: %d\n", __func__, _gtSpinandInfo.u16_BlkCnt);
	}
	return 0;
}

U32 MDrv_SPINAND_Read(U32 u32_PageIdx, U8 *u8Data, U8 *pu8_SpareBuf)
{
	return HAL_SPINAND_Read(u32_PageIdx, u8Data, pu8_SpareBuf);
}

U32 MDrv_SPINAND_Write(U32 u32_PageIdx, U8 *u8Data, U8 *pu8_SpareBuf)
{
    return HAL_SPINAND_Write(u32_PageIdx, u8Data, pu8_SpareBuf);
}

U32 MDrv_SPINAND_BLOCK_ERASE(U32 u32_PageIdx)
{
    return HAL_SPINAND_BLOCKERASE(u32_PageIdx);
}
