#include <stdio.h>
#include <fcntl.h>
#include <string.h>

#include "tool-util.h"
#include "dictionary.h"
#include "libiniparser.h"
#include "command.h"
#include "global_data.h"
#include "environment.h"

extern dictionary *dict;
extern struct platform_info info;
extern char *inifile;
extern char *root_directory;
extern char *image_directory;
extern char *script_file;
extern char *outpath;
extern gd_t *gd;

/*
 *only create emmc partition table
 */
static char createptbl_only = 0;
static char *emmc_setpartition;

extern int emmc_init(void);
extern int emmc_create_partition_tbl(void);

int emmcbin(int argc, char *argv[])
{
	char *val;
	unsigned char *buf;
	int fd, ret, len, i;
	uint64_t size;
	char cmd[64];

	memset(&info, 0, sizeof(struct platform_info));

	inifile = argv[2];
	printf("[%s]: Parsing ini file %s...\n", __func__, inifile);

	dict = iniparser_load(inifile);
	if(!dict){
		printf("[%s]: Parse ini file failed\n", __func__);
		return 0;
	}

	root_directory = iniparser_getstring(dict, "path:root_directory", "Not Set");
	if(strcmp(root_directory, "Not Set") == 0){
		printf("[%s]: root path is not set\n", __func__);
		return 0;
	}

	image_directory = iniparser_getstring(dict, "path:image_directory", "Not Set");
	if(strcmp(image_directory, "Not Set") == 0){
		printf("[%s]: image path is not set\n", __func__);
		return 0;
	}

	script_file = iniparser_getstring(dict, "path:script_file", "Not Set");
	if(strcmp(script_file, "Not Set") == 0){
		printf("[%s]: mstar script is not set\n", __func__);
		return 0;
	}

	outpath = iniparser_getstring(dict, "path:outpath", "Not Set");
	if(strcmp(outpath, "Not Set") == 0){
		printf("[%s]: out path is not set\n", __func__);
		return 0;
	}

	val = iniparser_getstring(dict, "env:env_type", "Not Set");
	if(strcmp(val, "Not Set") == 0){
		printf("[%s]: env type is Not set, using default EMMC\n", __func__);
		info.envtype == MMCENV;
	}
	else if(strcmp(val, "mmc") == 0 || strcmp(val, "emmc") == 0 ||
		strcmp(val, "MMC") == 0 || strcmp(val, "EMMC") == 0){
		printf("[%s]: env stored in EMMC\n", __func__);
		info.envtype == MMCENV;
	}
	else if(strcmp(val, "spi") == 0 || strcmp(val, "SPI") == 0){
		printf("[%s]: env stored in SPI flash\n", __func__);
		info.envtype == SPIENV;
	}
	else{
		printf("[%s]: Unknown env type %s\n", __func__, val);
		return -1;
	}

	ret = run_command("init_raw_io", 0);
	if(ret < 0){
		printf("[%s]: Raw IO init failed\n", __func__);
		return -1;
	}
	ret = run_command("init_secure_info", 0);
	if(ret < 0){
		printf("[%s]: Raw IO init failed\n", __func__);
		return -1;
	}

	gd = (gd_t *)malloc(sizeof(*gd));

	ret = env_relocate();
	if(ret < 0){
		printf("[%s]: env relocate failed\n", __func__);
		return -1;
	}

	ret = emmc_init();
	if(ret < 0){
		printf("[%s]: emmc init failed\n", __func__);
		return 0;
	}

	/*
	 *Customer function, only create emmc partition table
	 */
	val = iniparser_getstring(dict, "customer:setpartition", "Not Set");
	if(strcmp(val, "Not Set") != 0){
		createptbl_only  = 1;
		emmc_setpartition = val;
		printf("[%s]: Customer set to create partition table only, set partition script is %s\n", __func__, emmc_setpartition);
	}
	if(createptbl_only){
		memset(cmd, 0, sizeof(cmd));
		sprintf(cmd, "mstar %s", emmc_setpartition);
		ret = run_command(cmd, 0);
		if(ret < 0){
			printf("[%s]: set partition failed\n", __func__);
			return ret;
		}
		ret = emmc_create_partition_tbl();
		if(ret < 0){
			printf("[%s]: Create emmc partition table failed\n", __func__);
			return ret;
		}
		printf("\n\n[%s]: Partition table is generated\n\n", __func__);
		return 0;
	}

	/*
	 *Common update flow goes here
	 */
	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "mstar %s", script_file);
	ret = run_command(cmd, 1);
	if(ret < 0){
		printf("[%s]: emmc update failedfailed\n", __func__);
		return -1;
	}

	ret = emmc_finish_update();
	if(ret < 0){
		printf("[%s]: emmc pack bin failed\n", __func__);
		return 0;
	}

	printf("\n\n[%s]: emmc bin done!!!\n\n", __func__);

	return 0;
}
