/*
 * (C) Copyright 2000-2010
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * (C) Copyright 2008
 * Stuart Wood, Lab X Technologies <stuart.wood@labxtechnologies.com>
 *
 * (C) Copyright 2004
 * Jian Zhang, Texas Instruments, jzhang@ti.com.
 *
 * (C) Copyright 2001 Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Andreas Heppel <aheppel@sysgo.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#define DEBUG


#include "dictionary.h"
#include "libiniparser.h"
#include "tool-util.h"
#include "types.h"
#include "common.h"
#include "command.h"
#include "global_data.h"
#include "environment.h"
#include "jiffs2/load_kernel.h"
#include "CusRawIO.h"
#include "MsSystem.h"
#include "MsDebug.h"

extern unsigned int cfg_env_offset;
extern struct platform_info info;
extern dictionary *dict;

DECLARE_GLOBAL_DATA_PTR;

#define CONFIG_ENV_RANGE	CONFIG_ENV_SIZE

//For BFN ubi env
#define DEFAULT_CFG_ENV_OFFSET  2

/* references to names in env_common.c */
extern uchar default_environment[];

char *env_name_spec_ubi = "UBI";
char *env_partition;
char *env_volume;
int ubi_leb_sz = 0;
int env_vol_sz = 0;

char mtdstr[128];
char gbuf[CONFIG_ENV_SIZE];
env_t env_new;

extern env_t *env_ptr;

char IdsStr[] = "nand0=edb64M-nand";

uchar env_get_char_spec_ubi (int index)
{
	return ( *((uchar *)(gd->env_addr + index)) );
}

uint32_t crc32_env_ubi (uint32_t crc, const unsigned char *p, unsigned int len)
{
     return crc32_no_comp(crc ^ 0xffffffffL, p, len) ^ 0xffffffffL;
}
/*
 * This is called before nand_init() so we can't read NAND to
 * validate env data.
 *
 * Mark it OK for now. env_relocate() in env_common.c will call our
 * relocate function which does the real validation.
 *
 * When using a NAND boot image (like sequoia_nand), the environment
 * can be embedded or attached to the U-Boot image in NAND flash.
 * This way the SPL loads not only the U-Boot image from NAND but
 * also the environment.
 */
int env_init_ubi(void)
{
	char *p;
	int ret;
	
	env_partition = NAND_DEFAULT_PARTITION;
	env_volume = NAND_DEFAULT_VOLUME;

	UBOOT_DEBUG("env partition : %s\n", env_partition);
	UBOOT_DEBUG("env volume : %s\n", env_volume);

	if(!env_partition || !env_volume){
		ret = run_command("init_raw_io", 0);
		if(ret < 0){
			UBOOT_ERROR("uboot init IO failed\n");
			return ret;
		}
	}


	printf("[%s]: ubi env init\n", __func__);

	env_partition = NAND_DEFAULT_PARTITION;
	env_volume = NAND_DEFAULT_VOLUME;

	UBOOT_DEBUG("env partition : %s\n", env_partition);
	UBOOT_DEBUG("env volume : %s\n", env_volume);
		
	gd->env_addr  = (ulong)&default_environment[0];
	gd->env_valid = 1;
	
	return 0;
}

/*
 * The legacy NAND code saved the environment in the first NAND device i.e.,
 * nand_dev_desc + 0. This is also the behaviour using the new NAND code.
 */
static int writeenv(size_t offset, u_char *buf)
{
	return ubi_volume_write_offset(env_volume, buf, CONFIG_ENV_SIZE, (off_t)offset);
}

int saveenv_ubi(void)
{
	int ret;
	char cmd_buf[30];
	ssize_t len;
	size_t size;
	char *res;
	struct mtd_device *dev;
	struct part_info *part;
	u8 pnum;
				
	if(find_dev_and_part(env_partition, &dev, &pnum, &part))
	{
		printf("[%s]: Partition %s not found!\n", __func__, env_partition);
		printf("[%s]: save env fail\n", __func__);
		return 1;
	}
	
	if(!ubi_find_volume(env_volume))
	{
		sprintf(cmd_buf, "ubi part %s", env_partition);
		if(run_command(cmd_buf, 0) == -1)
			return 1;
	}
	
	if(!ubi_leb_sz)
		ubi_leb_sz = ubi_get_leb_size();
		
	if(!env_vol_sz)
		env_vol_sz = (ubi_get_avai_peb() - 1) * ubi_leb_sz;

	memset(env_new.data, 0, sizeof(env_new.data));
	
	res = (char *)&env_new.data;
	len = hexport_r(&env_htab, '\0', &res, ENV_SIZE);
	if (len < 0) {
		printf("Cannot export environment\n");
		return 1;
	}
	env_new.crc = crc32_env_ubi(0, env_new.data, ENV_SIZE);

	if(ubi_find_volume(env_volume))
	{
		printf("Write Env to %X...\n", cfg_env_offset);
		ret = writeenv(cfg_env_offset, (u_char *)&env_new);
		if (ret) {
			printf("[%s]:save env failed\n", __func__);
			return ret;
		}
		printf("Write Backup Env to %X...\n", cfg_env_offset + ubi_leb_sz);
		ret = writeenv(cfg_env_offset + ubi_leb_sz, (u_char *) &env_new);
		if (ret)
		{
			printf("[%s]:save env backup  failed\n", __func__);
			return ret;
		}
	}
	else
	{
		printf("Found no %s Volume\n Create %s volume\n", env_volume, env_volume);
		
		ret = ubi_create_vol(env_volume, env_vol_sz, 1);
		if(ret)
		{
			printf("[%s]: create %s volume in %s partition fail with size = %0xX\n", __func__, env_volume, env_partition, env_vol_sz);
			return ret;
		}
		ubi_leb_sz = ubi_get_leb_size();

		MsApiChunkHeader_GetValue(CH_UBOOT_ENVIRONMENT_ROM_OFFSET,&cfg_env_offset);

		if(info.boottype == BFN && info.envtype == UBIENV){
			if(cfg_env_offset == 0)
				cfg_env_offset = DEFAULT_CFG_ENV_OFFSET;
		}
		
		UBOOT_DEBUG("cfg_env_offset : 0x%x\n", cfg_env_offset);
		ubi_get_volume_size(env_volume, &size);
		cfg_env_offset = size - (cfg_env_offset * ubi_leb_sz);
		UBOOT_DEBUG("cfg_env_offset : 0x%x\n", cfg_env_offset);

		printf("[%s]: Write Env to %X...\n", __func__, cfg_env_offset);
		ret = writeenv(cfg_env_offset, (u_char *)&env_new);
		if (ret) {
			puts("Failed\n");
			return ret;
		}
		printf("[%s]: Write Backup Env to %X...\n", __func__, cfg_env_offset + ubi_leb_sz);
		ret = writeenv(cfg_env_offset + ubi_leb_sz, (u_char *) &env_new);
		if (ret)
		{
			puts("Backup Failed\n");
			return ret;
		}
	}
	
	printf("[%s]: done\n", __func__);
	return ret;
}

/*
 * The legacy NAND code saved the environment in the first NAND
 * device i.e., nand_dev_desc + 0. This is also the behaviour using
 * the new NAND code.
 */

void env_relocate_spec_ubi (void)
{
	int ret;
	char cmd_buf[30];
	size_t size;
	struct mtd_device *dev;
	struct part_info *part;
	u8 pnum;
printf("HH---------------------------------------------------\n");
	
	//get mtdpart string from pni
	set_default_env("!set default for mtdparts");

printf("TT---------------------------------------------------\n");
 
	if(info.nandtype == NAND)
		drvNAND_GetMtdParts(mtdstr);
	else if(info.nandtype == SPINAND)
		MDrv_SPINAND_GetMtdParts(mtdstr);

printf("GG---------------------------------------------------\n");

	setenv_uboot("mtdparts", mtdstr);
	setenv_uboot("mtdids", IdsStr);

	printf("[%s]: mtdstr = %s\n", __func__, mtdstr);
	printf("[%s]: IdsStr = %s\n", __func__, IdsStr);

	mtdparts_init();
	if(find_dev_and_part(env_partition, &dev, &pnum, &part))
	{
		printf("[%s]: Partition %s not found!\n", __func__, env_partition);
		printf("[%s]: read env fail\n", __func__);
		return;
	}

	printf("YY---------------------------------------------------\n");

	if(!ubi_find_volume(env_volume))
	{
		memset(cmd_buf, 0, sizeof(cmd_buf));
		sprintf(cmd_buf, "ubi part %s", env_partition);
		if(run_command(cmd_buf, 0) == -1){
			printf("[%s]: ubi part %s failed\n", __func__, env_partition);
			return;
		}
	}
	if(!ubi_leb_sz)
		ubi_leb_sz = ubi_get_leb_size();

	if(!env_vol_sz)
		env_vol_sz = (ubi_get_avai_peb() - 1) * ubi_leb_sz;
	
	printf("UUUU -------------------%d %d %d\n", env_vol_sz, ubi_get_avai_peb(), ubi_leb_sz);
 
	if(cfg_env_offset == 0)
	{
		MsApiChunkHeader_GetValue(CH_UBOOT_ENVIRONMENT_ROM_OFFSET,&cfg_env_offset);

		if(info.boottype == BFN && info.envtype == UBIENV){
			if(cfg_env_offset == 0)
				cfg_env_offset = DEFAULT_CFG_ENV_OFFSET;
		}
		
		UBOOT_DEBUG("cfg_env_offset : 0x%x\n", cfg_env_offset);
		ubi_get_volume_size(env_volume, &size);
		cfg_env_offset = size - (cfg_env_offset * ubi_leb_sz);
		UBOOT_DEBUG("cfg_env_offset : 0x%x\n", cfg_env_offset);
	}
	if(ubi_find_volume(env_volume)){
		printf("[%s]: find env volume %s\n", __func__);
	}
	else
	{
		printf("Found no %s Volume\nCreate %s volume\n", env_volume, env_volume);
		ret = ubi_create_vol(env_volume, env_vol_sz, 1);
		if(ret){
			printf("[%s]: create %s volume in %s partition fail with size = 0x%X\n",  __func__, env_volume, env_partition, env_vol_sz);
			return;
		}

		ubi_leb_sz = ubi_get_leb_size();

		ubi_get_volume_size(env_volume, &size);

		MsApiChunkHeader_GetValue(CH_UBOOT_ENVIRONMENT_ROM_OFFSET,&cfg_env_offset);

		if(info.boottype == BFN && info.envtype == UBIENV){
			if(cfg_env_offset == 0)
				cfg_env_offset = DEFAULT_CFG_ENV_OFFSET;
		}
		
		UBOOT_DEBUG("cfg_env_offset : 0x%x\n", cfg_env_offset);
		cfg_env_offset = size - (cfg_env_offset * ubi_leb_sz);
		UBOOT_DEBUG("cfg_env_offset : 0x%x\n", cfg_env_offset);
	}
	printf("[%s]: Find Env part %s, Env volume %s, Env offset 0x%X\n", __func__, env_partition, env_volume, cfg_env_offset);
}
