/*
 * (C) Copyright 2000-2010
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * (C) Copyright 2008
 * Stuart Wood, Lab X Technologies <stuart.wood@labxtechnologies.com>
 *
 * (C) Copyright 2004
 * Jian Zhang, Texas Instruments, jzhang@ti.com.
 *
 * (C) Copyright 2001 Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Andreas Heppel <aheppel@sysgo.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#define DEBUG
#include <malloc.h>
#include <errno.h>
#include <string.h>
#include "nand.h"
#include "linux/mtd/nand.h"
#include "common.h"
#include "command.h"
#include "environment.h"
#include "global_data.h"
#include "tool-util.h"
#include "jiffs2/load_kernel.h"

//MSTAR start
extern unsigned int cfg_env_offset;
//MSTAR end

/* references to names in env_common.c */
extern uchar default_environment[];

char *env_name_spec = "ENV";

extern env_t *env_ptr;

DECLARE_GLOBAL_DATA_PTR;

extern nand_info_t nand_info[CONFIG_SYS_MAX_NAND_DEVICE];
extern struct platform_info info;

uchar env_get_char_spec_nand (int index)
{
	return ( *((uchar *)(gd->env_addr + index)) );
}

/*
 * This is called before nand_init() so we can't read NAND to
 * validate env data.
 *
 * Mark it OK for now. env_relocate() in env_common.c will call our
 * relocate function which does the real validation.
 *
 * When using a NAND boot image (like sequoia_nand), the environment
 * can be embedded or attached to the U-Boot image in NAND flash.
 * This way the SPL loads not only the U-Boot image from NAND but
 * also the environment.
 */
int env_init_nand(void)
{
	gd->env_addr  = (ulong)&default_environment[0];
	gd->env_valid = 1;

	return (0);
}

extern unsigned int need_blk;
extern unsigned short u16_ENV_Star_Blk;
extern unsigned short u16_ENV_Blk_Region;
static int writeenv(size_t offset, u_char *buf)
{
	size_t amount_saved = 0;
	size_t blocksize;
	unsigned char *rbuf;
	unsigned char *wbuf;
	struct nand_chip *chip = nand_info[0].priv;
	blocksize = nand_info[0].erasesize;
	int i;
    unsigned int write_block;
	unsigned int write_length;
	unsigned int adr_offset=0;

	wbuf = malloc(nand_info[0].writesize+nand_info[0].oobsize);
	if(wbuf ==NULL)
		return 1;

	rbuf = malloc(nand_info[0].writesize+nand_info[0].oobsize);
	if(rbuf ==NULL)
		return 1;

	if (!blocksize)
		return 1;

    if(info.envtype == NANDENV)
    {
        write_block = need_blk;
        write_length = need_blk;
    }
    else
    {
        write_block = need_blk*2;
	    write_length = need_blk*2+2;
    }

	for(i=0;i< write_length;i++)
	{
		chip->ops.ooblen = nand_info[0].oobsize;
		chip->ops.len    = nand_info[0].writesize;
		chip->ops.datbuf = rbuf;
		chip->ops.oobbuf = &rbuf[nand_info[0].writesize];
		chip->ops.ooboffs = 0;
		chip->ops.mode = MTD_OOB_RAW;

		nand_info[0].read_oob(&nand_info[0],offset, &chip->ops);

 		if (chip->ops.oobbuf[chip->badblockpos] != 0xff)
		{
			offset += blocksize;
			continue;
		}
		else
		{
			if(amount_saved >= write_block)
			{
				break;
			}
			else
			{
				if (nand_write(&nand_info[0], offset, &blocksize, buf+adr_offset))
				{
					memset(wbuf, '\0' , nand_info[0].writesize+nand_info[0].oobsize);
					chip->ops.ooblen = nand_info[0].oobsize;
					chip->ops.len    = nand_info[0].writesize;
					chip->ops.datbuf = wbuf;
					chip->ops.oobbuf = &wbuf[nand_info[0].writesize];
					chip->ops.ooboffs = 0;
					chip->ops.mode = MTD_OOB_RAW;

					nand_info[0].write_oob(&nand_info[0],offset,&chip->ops);
					offset += blocksize;
				}
				else
				{
					offset += blocksize;
					amount_saved++;
					if(need_blk >1)//block size smaller than CONFIG_ENV_SIZE
					{
						if(amount_saved == need_blk)
							adr_offset = 0;
						else
							adr_offset += blocksize;
					}
			    }
			}
		}
	}

	free(wbuf);
	free(rbuf);
	if (amount_saved != write_block)
		return 1;

	return 0;
}

int saveenv_nand(void)
{
	int ret = 0;
	env_t	env_new;
	ssize_t	len;
	char	*res;
    struct part_info *part = NULL;
	unsigned char *env_buf;
	nand_erase_options_t nand_erase_options;

    printf("%s:%d [%x]\n", __func__, __LINE__, cfg_env_offset);

    if(cfg_env_offset == 0)
	{
        if(info.envtype == NANDENV)
        {
            part = (struct part_info *)get_mtd_part_by_name(env_name_spec);
            if(part == NULL)
            {
                puts("can not find env part\n");
                return 0;
            }
            cfg_env_offset = (unsigned int)(part->offset);
            need_blk = (unsigned int)(part->size/nand_info[0].erasesize);
            u16_ENV_Star_Blk = (unsigned short)(part->offset/nand_info[0].erasesize);
            u16_ENV_Blk_Region = need_blk;
            printf("%s:%d [%d:%x:%x:%d:%d]\n", __func__, __LINE__, need_blk, CONFIG_ENV_SIZE,cfg_env_offset,u16_ENV_Star_Blk,u16_ENV_Blk_Region);
        }
	}

	memset(&nand_erase_options, 0, sizeof(nand_erase_options));

    if(info.envtype == NANDENV)
    {
        nand_erase_options.length = need_blk*nand_info[0].erasesize;
    }
    else
    {
	    nand_erase_options.length = (need_blk*2+2)*nand_info[0].erasesize;
    }
	nand_erase_options.offset = cfg_env_offset;

	res = (char *)&env_new.data;
	len = hexport_r(&env_htab, '\0', &res, ENV_SIZE);
	if (len < 0) {
		error("Cannot export environment: errno = %d\n", errno);
		return 1;
	}
	env_new.crc   = crc32(0, env_new.data, ENV_SIZE);

	puts("Erasing Nand...\n");
	if (nand_erase_env(&nand_info[0], &nand_erase_options))
		return 1;

	puts("Writing to Nand... \n");

	/*
	 * xiaohui.zhu add: 20150407
	 * env buffer align to block size
	 * in order to solve buffer over flow
	 * in writeenv->nand_write@blocksize
	 */
	env_buf = malloc(ALIGN(sizeof(env_t), nand_info[0].erasesize)*need_blk);
	if(!env_buf){
		printf("[%s]: malloc temp env buffer failed\n", __func__);
		return 1;
	}
	memset(env_buf, 0xFF, ALIGN(sizeof(env_t), nand_info[0].erasesize)*need_blk);
	memcpy(env_buf, (u_char *)&env_new, sizeof(env_t));
    printf("env_buf=%d\n", strlen(env_buf));
	if (writeenv(cfg_env_offset, env_buf)) {
		puts("FAILED!\n");
		return 1;
	}
	puts("done\n");
	return ret;
}

/*
 * The legacy NAND code saved the environment in the first NAND
 * device i.e., nand_dev_desc + 0. This is also the behaviour using
 * the new NAND code.
 */
void env_relocate_spec_nand (void)
{
	set_default_env("!readenv() failed");
	return;
}
