//<MStar Software>
//******************************************************************************
// MStar Software
// Copyright (c) 2010 - 2012 MStar Semiconductor, Inc. All rights reserved.
// All software, firmware and related documentation herein ("MStar Software") are
// intellectual property of MStar Semiconductor, Inc. ("MStar") and protected by
// law, including, but not limited to, copyright law and international treaties.
// Any use, modification, reproduction, retransmission, or republication of all
// or part of MStar Software is expressly prohibited, unless prior written
// permission has been granted by MStar.
//
// By accessing, browsing and/or using MStar Software, you acknowledge that you
// have read, understood, and agree, to be bound by below terms ("Terms") and to
// comply with all applicable laws and regulations:
//
// 1. MStar shall retain any and all right, ownership and interest to MStar
//    Software and any modification/derivatives thereof.
//    No right, ownership, or interest to MStar Software and any
//    modification/derivatives thereof is transferred to you under Terms.
//
// 2. You understand that MStar Software might include, incorporate or be
//    supplied together with third party`s software and the use of MStar
//    Software may require additional licenses from third parties.
//    Therefore, you hereby agree it is your sole responsibility to separately
//    obtain any and all third party right and license necessary for your use of
//    such third party`s software.
//
// 3. MStar Software and any modification/derivatives thereof shall be deemed as
//    MStar`s confidential information and you agree to keep MStar`s
//    confidential information in strictest confidence and not disclose to any
//    third party.
//
// 4. MStar Software is provided on an "AS IS" basis without warranties of any
//    kind. Any warranties are hereby expressly disclaimed by MStar, including
//    without limitation, any warranties of merchantability, non-infringement of
//    intellectual property rights, fitness for a particular purpose, error free
//    and in conformity with any international standard.  You agree to waive any
//    claim against MStar for any loss, damage, cost or expense that you may
//    incur related to your use of MStar Software.
//    In no event shall MStar be liable for any direct, indirect, incidental or
//    consequential damages, including without limitation, lost of profit or
//    revenues, lost or damage of data, and unauthorized system use.
//    You agree that this Section 4 shall still apply without being affected
//    even if MStar Software has been modified by MStar in accordance with your
//    request or instruction for your use, except otherwise agreed by both
//    parties in writing.
//
// 5. If requested, MStar may from time to time provide technical supports or
//    services in relation with MStar Software to you for your use of
//    MStar Software in conjunction with your or your customer`s product
//    ("Services").
//    You understand and agree that, except otherwise agreed by both parties in
//    writing, Services are provided on an "AS IS" basis and the warranty
//    disclaimer set forth in Section 4 above shall apply.
//
// 6. Nothing contained herein shall be construed as by implication, estoppels
//    or otherwise:
//    (a) conferring any license or right to use MStar name, trademark, service
//        mark, symbol or any other identification;
//    (b) obligating MStar or any of its affiliates to furnish any person,
//        including without limitation, you and your customers, any assistance
//        of any kind whatsoever, or any information; or
//    (c) conferring any license or right under any intellectual property right.
//
// 7. These terms shall be governed by and construed in accordance with the laws
//    of Taiwan, R.O.C., excluding its conflict of law rules.
//    Any and all dispute arising out hereof or related hereto shall be finally
//    settled by arbitration referred to the Chinese Arbitration Association,
//    Taipei in accordance with the ROC Arbitration Law and the Arbitration
//    Rules of the Association by three (3) arbitrators appointed in accordance
//    with the said Rules.
//    The place of arbitration shall be in Taipei, Taiwan and the language shall
//    be English.
//    The arbitration award shall be final and binding to both parties.
//
//******************************************************************************
//<MStar Software>

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "MsDebug.h"
#include "MsRawIO.h"
#include "MsSystem.h"
#include "ShareType.h"
#include "linux/list.h"
#include "libiniparser.h"
#include "dictionary.h"
#include "tool-util.h"

extern struct platform_info info;
extern dictionary *dict;
extern int bintype;
//-------------------------------------------------------------------------------------------------
//  Debug Functions
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//  Local Defines
//-------------------------------------------------------------------------------------------------
#define MMC_SECTOR_ALIGNMENT 9//align 512 byte
#define MMC_SECTOR_SIZE 512

#define PARTITION_NAME_LEN 32
#define VOLUME_NAME_LEN 32

typedef struct{
	EN_RAW_DATA_TARGET target;
	char partition[PARTITION_NAME_LEN];
	char volume[VOLUME_NAME_LEN];
	struct list_head list;
}ST_RAW_IO_CONFIG;


//-------------------------------------------------------------------------------------------------
//  Global Variables
//-------------------------------------------------------------------------------------------------
char *nand_raw_io_partition = NULL;
char *nand_raw_io_volume = NULL;
char *mmc_raw_io_partition = NULL;
char *mmc_raw_io_volume = NULL;
//-------------------------------------------------------------------------------------------------
//  Local Variables
//-------------------------------------------------------------------------------------------------
static EN_RAW_DATA_TARGET enTarget=E_RAW_DATA_INVALED;
static BOOLEAN spi_ready = FALSE;
static char partName[PARTITION_NAME_LEN];
static char volName[VOLUME_NAME_LEN];
static struct list_head config_list;
static unsigned int count=0;
static unsigned int raw_io_init = 0;
//-------------------------------------------------------------------------------------------------
//  Extern Functions
//-------------------------------------------------------------------------------------------------

extern struct ubi_volume *ubi_find_volume(char *volume);

//-------------------------------------------------------------------------------------------------
//  Private Functions
//-------------------------------------------------------------------------------------------------
static int raw_read_spi(unsigned int addr, unsigned int offset, unsigned int len);
static int raw_write_spi(unsigned int addr, unsigned int offset, unsigned int len);
static int raw_read_nand(unsigned int addr, unsigned int offset, unsigned int len);
static int raw_write_nand(unsigned int addr, unsigned int offset, unsigned int len);
static int raw_read_mmc(unsigned int addr, unsigned int offset, unsigned int len);
static int raw_write_mmc(unsigned int addr, unsigned int offset, unsigned int len);
//-------------------------------------------------------------------------------------------------
//  Public Functions
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------
int do_raw_io_init(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	char *val;

	if(raw_io_init){
		UBOOT_DEBUG("Raw IO has been init\n");
		return 0;
	}

	nand_raw_io_partition = MSTOOL_FLASH_DEFAULT_PARTITION;
	nand_raw_io_volume = MSTOOL_FLASH_DEFAULT_VOLUME;

	//raw data type
	val = iniparser_getstring(dict, "rawdata:type", "Not Set");
	if(strcmp(val, "Not Set") == 0){
		printf("[%s]: Raw data type is NOT set,using default NAND\n", __func__);
		if(bintype == NANDBIN)
			info.rawdata = TOOL_RAWDATA_NAND;
		else if(bintype == EMMCBIN)
			info.rawdata = TOOL_RAWDATA_MMC;
	}
	else if(strcmp(val, "spi") == 0){
		printf("[%s]: Raw data type is set to spi\n", __func__);
		info.rawdata = TOOL_RAWDATA_SPI;	
	}
	else if(strcmp(val, "nand") == 0){
		printf("[%s]: Raw data type is set to nand\n", __func__);
		info.rawdata = TOOL_RAWDATA_NAND;	
	}
	else if(strcmp(val, "mmc") == 0){
		printf("[%s]: Raw data type is set to mmc\n", __func__);
		info.rawdata = TOOL_RAWDATA_MMC;	
	}
	else{
		printf("[%s]: Raw data type is unknown\n", __func__);
		return -1;
	}

	if(info.rawdata == TOOL_RAWDATA_NAND && bintype == EMMCBIN){
		UBOOT_ERROR("Emmc bin but raw data in nand\n");
		return -1;
	}
	if(info.rawdata == TOOL_RAWDATA_MMC && bintype == NANDBIN){
		UBOOT_ERROR("Nand bin but raw data in emmc\n");
		return -1;
	}
	
	val = iniparser_getstring(dict, "rawdata:partition", "Not Set");
	if(strcmp(val, "Not Set") == 0){
		UBOOT_DEBUG("No raw data partition is set, using default: %s\n", nand_raw_io_partition);
	}
	else{
		nand_raw_io_partition = val;
		UBOOT_DEBUG("Raw data partition is set to %s\n", nand_raw_io_partition);
	}
	
	val = iniparser_getstring(dict, "rawdata:volume", "Not Set");
	if(strcmp(val, "Not Set") == 0){
		UBOOT_DEBUG("No raw data volume is set, using default: %s\n",  nand_raw_io_volume);
	}
	else{
		nand_raw_io_volume = val;
		UBOOT_DEBUG("Raw data volume is set to %s\n", nand_raw_io_volume);
	}

	if(info.rawdata == TOOL_RAWDATA_SPI)
		val = "SPI";
	else if(info.rawdata == TOOL_RAWDATA_NAND)
		val = "NAND";
	else if(info.rawdata == TOOL_RAWDATA_MMC)
		val = "MMC";

	UBOOT_DEBUG("Raw IO type: %s\n", val);
	if(info.rawdata == TOOL_RAWDATA_SPI){
		UBOOT_DEBUG("Raw IO partition: %s\n", SPI_DEFAULT_PARTITION);
		UBOOT_DEBUG("Raw IO volume: %s\n", SPI_DEFAULT_VOLUME);
	}
	else if(info.rawdata == TOOL_RAWDATA_NAND){
		UBOOT_DEBUG("Raw IO partition: %s\n", NAND_DEFAULT_PARTITION);
		UBOOT_DEBUG("Raw IO volume: %s\n", NAND_DEFAULT_VOLUME);
	}
	else if(info.rawdata == TOOL_RAWDATA_MMC){
		UBOOT_DEBUG("Raw IO partition: %s\n", MMC_DEFAULT_PARTITION);
		UBOOT_DEBUG("Raw IO volume: %s\n", MMC_DEFAULT_VOLUME);
	}

	raw_io_init = 1;
	return 0;
}

int do_raw_read(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	int ret=0;
	unsigned int addr;
	unsigned int offset;
	unsigned int len;
	UBOOT_TRACE("IN\n");
	if(argc!=4)
	{
		cmd_usage(cmdtp);
		return -1;
	}
	addr=strtoul(argv[1], 0, 16);
	offset=strtoul(argv[2], 0, 16);    
	len=strtoul(argv[3], 0, 16);    
	ret=raw_read(addr,offset,len);
	if(ret==-1)
	{
		UBOOT_ERROR("do raw_read fail\n");
	}
	else
	{
		UBOOT_TRACE("OK\n");
	}
	return ret;    
}

int do_raw_write(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	int ret=0;
	unsigned int addr;
	unsigned int offset;
	unsigned int len;
	UBOOT_TRACE("IN\n");
	if(argc!=4)
	{
		cmd_usage(cmdtp);
		return -1;
	}
	addr=strtoul(argv[1], 0, 16);
	offset=strtoul(argv[2], 0, 16);    
	len=strtoul(argv[3], 0, 16);    
	ret=raw_write(addr,offset,len);
	if(ret==-1)
	{
		UBOOT_ERROR("do raw_write fail\n");
	}
	else
	{
		UBOOT_TRACE("OK\n");
	}
	return ret;    
}

void raw_io_config_push()
{
}

void raw_io_config_pop(void)
{
}

int mboot_raw_io_Config(void)
{
	UBOOT_TRACE("IN\n");
	UBOOT_TRACE("OK\n");
	if(info.boottype == ROMBOOT)
		return raw_io_config(FLASH_MBOOT_TARGET_NAND ,FLASH_MBOOT_PARTITION_NAND,FLASH_MBOOT_VOLUME_NAND);
	else if(info.boottype == SPIBOOT)
		return raw_io_config(FLASH_MBOOT_TARGET_SPI ,FLASH_MBOOT_PARTITION_SPI,FLASH_MBOOT_VOLUME_SPI);
	else{
		printf("[%s]: Unsupport mboot config type\n", __func__);
		return 0;
	}
}

int raw_io_config(EN_RAW_DATA_TARGET target, char *partition, char *volume)
{
	int ret=0;
	UBOOT_TRACE("IN\n");

	if(partition==NULL)
	{
		UBOOT_ERROR("The input parameter 'partition' is a null pointer\n");
		return -1;
	}

	if(volume==NULL)
	{
		UBOOT_ERROR("The input parameter 'volume' is a null pointer\n");
		return -1;
	}

	if(strlen(partition)>=PARTITION_NAME_LEN)
	{
		UBOOT_ERROR("The partition len is over %x\n",PARTITION_NAME_LEN);
		return -1;
	}

	if(strlen(volume)>=VOLUME_NAME_LEN)
	{
		UBOOT_ERROR("The volume len is over %x\n",VOLUME_NAME_LEN);
		return -1;
	}
 
	if(target>=E_RAW_DATA_INVALED)
	{
		UBOOT_ERROR("wrong target\n");
		return -1;
	}
	else
	{
		enTarget=target;
		memset(partName,0,sizeof(partName));
		memset(volName,0,sizeof(volName));      
		switch(enTarget)
		{
		case E_RAW_DATA_IN_SPI:
			UBOOT_DEBUG("raw data in spi\n");
			if(spi_ready!=TRUE)
			{
				enTarget = E_RAW_DATA_INVALED;
				ret = -1;
			}
			break;
		case E_RAW_DATA_IN_NAND:
			UBOOT_DEBUG("raw data in nand\n"); 
			memset(partName,0,sizeof(partName));
			strcpy(partName,partition);
			memset(volName,0,sizeof(volName));
			strcpy(volName,volume);
			break;
		case E_RAW_DATA_IN_MMC:
			UBOOT_DEBUG("raw data in mmc\n");     
			memset(volName,0,sizeof(volName));
			strcpy(volName,volume);
			break;
		default:
			enTarget = E_RAW_DATA_INVALED;
			UBOOT_ERROR("No availabe target\n");
			ret = -1;
			break;
		}
	}

	if(ret==0)
	{
		UBOOT_TRACE("OK\n");
	}
	else
	{
		UBOOT_ERROR("raw_io_config fail\n");
	}
	return ret;
}

int raw_read(unsigned int addr, unsigned int offset, unsigned int len)
{
	int ret = -1;
	UBOOT_TRACE("IN\n");
	UBOOT_DEBUG("addr : %x\n",(U32)addr);
	UBOOT_DEBUG("offset : %x\n",(U32)offset);
	UBOOT_DEBUG("len : %x\n",(U32)len);  
	if(len==0)
	{
		UBOOT_ERROR("len is zero\n");
		return -1;
	} 
	switch(enTarget)
	{
	case E_RAW_DATA_IN_SPI:
		UBOOT_DEBUG("raw data in spi\n");
		ret=raw_read_spi(addr,offset,len);
		break;
	case E_RAW_DATA_IN_NAND:
		UBOOT_DEBUG("raw data in nand\n");            
		ret=raw_read_nand(addr,offset,len);            
		break;
        case E_RAW_DATA_IN_MMC:
            UBOOT_DEBUG("raw data in mmc\n");                        
            ret=raw_read_mmc(addr,offset,len);            
            break;
	default:
		UBOOT_ERROR("No availabe target\n");
		break;
	}
	if(ret==0)
	{
		UBOOT_TRACE("OK\n");
	}
	else
	{
		UBOOT_ERROR("read raw data fail\n");    
	}
	return ret;
}

int raw_write(unsigned int addr, unsigned int offset, unsigned int len)
{
	int ret = -1;
	UBOOT_TRACE("IN\n");
	if(len==0)
	{
		UBOOT_ERROR("len is zero\n");
		return -1;
	} 
	switch(enTarget)
	{
	case E_RAW_DATA_IN_SPI:
		UBOOT_DEBUG("raw data in spi\n");
		ret=raw_write_spi(addr,offset,len);
		break;
	case E_RAW_DATA_IN_NAND:
		UBOOT_DEBUG("raw data in nand\n");            
		ret=raw_write_nand(addr,offset,len);            
		break;
	case E_RAW_DATA_IN_MMC:
		UBOOT_DEBUG("raw data in mmc\n");                        
		ret=raw_write_mmc(addr,offset,len);            
		break;
	default:
		UBOOT_ERROR("No availabe target\n");
		break;
	}
	if(ret==0)
	{
		UBOOT_TRACE("OK\n");
	}
	else
	{
		UBOOT_ERROR("write raw data fail\n");    
	}
	return ret;
}

static int raw_read_spi(unsigned int addr, unsigned int offset, unsigned int len)
{
	UBOOT_DEBUG("Not support\n");
	return 0;
}

static int raw_write_spi(unsigned int addr, unsigned int offset, unsigned int len)
{
	UBOOT_DEBUG("Not support\n");
	return 0;
}

int check_ubi_partition(char * volName,char *partitionName)
{
	int ret =0;
	char *buffer=NULL;
    
	buffer=malloc(CMD_BUF);
	if(buffer==NULL)
	{
		UBOOT_ERROR("malloc fail\n");
		return -1;
	}    

	if(!ubi_find_volume(volName))
	{       
		memset(buffer,0,CMD_BUF);
		snprintf(buffer,CMD_BUF,"ubi part %s",partitionName);
		UBOOT_DEBUG("cmd=%s\n",buffer);
		ret=run_command(buffer,0);
	}
	free(buffer);    
	return ret;
}

static int raw_read_nand(unsigned int addr, unsigned int offset, unsigned int len)
{
	char *buffer=NULL;
	int ret=0;
	UBOOT_TRACE("IN\n");

	buffer=malloc(CMD_BUF);
	if(buffer==NULL)
	{
		UBOOT_ERROR("malloc fail\n");
		return -1;
	}

	if(strcmp(volName,UNNECESSARY_PARTITION)!=0)
	{ 
		UBOOT_DEBUG("Read Data from ubi:%s partition.\n",volName);
		ret=check_ubi_partition(volName,partName);
		if(ret==-1)
		{
			UBOOT_ERROR("check_ubi_partition: %s fail\n",partName);
			free(buffer);
			return -1;
		}

		memset(buffer,0,CMD_BUF);
		snprintf(buffer,CMD_BUF,"ubi partial_read %x %s %x %x",addr ,volName ,len, offset);
		UBOOT_DEBUG("cmd=%s\n",buffer);
		ret=run_command(buffer,0);
	}
	else
	{             
		UBOOT_DEBUG("Read Data from nand:%s\n",partName);
		memset(buffer,0,CMD_BUF);
		snprintf(buffer,CMD_BUF,"nand read.partial %x %s 0x%x 0x%x",addr ,partName, len,offset);
		UBOOT_DEBUG("cmd=%s\n",buffer);
		ret=run_command(buffer,0);        
	}
	if(ret==-1)
	{
		UBOOT_ERROR("ubi/nand read %s fail\n",volName);
	}
	else
	{
		UBOOT_TRACE("OK\n");
	}
	free(buffer);
	return ret;
}

int raw_write_nand(unsigned int addr, unsigned int offset, unsigned int len)
{
	char *buffer=NULL;
	int ret=0;

	UBOOT_TRACE("IN\n"); 

	buffer=malloc(CMD_BUF);
	if(buffer==NULL)
	{
		UBOOT_ERROR("malloc fail\n");
		return -1;
	}
	if(strcmp(volName,UNNECESSARY_PARTITION)!=0)
	{     
		memset(buffer,0,CMD_BUF);
		snprintf(buffer,CMD_BUF,"ubi part %s",partName);
		UBOOT_DEBUG("cmd=%s\n",buffer);
		ret=run_command(buffer,0);
		if(ret==-1)
		{
			UBOOT_ERROR("ubi part %s fail\n",partName);
			free(buffer);
			return -1;
		}

		memset(buffer,0,CMD_BUF);
		snprintf(buffer,CMD_BUF,"ubi partial_write %x %s %x %x",addr ,volName ,len, offset);
		UBOOT_DEBUG("cmd=%s\n",buffer);
		ret=run_command(buffer,0);
	}
	else
	{
		UBOOT_DEBUG("Write Data from nand:%s\n",partName);
		memset(buffer,0,CMD_BUF);
		snprintf(buffer,CMD_BUF,"nand write.partial %x %s 0x%x 0x%x",addr ,partName, len,offset);
		UBOOT_DEBUG("cmd=%s\n",buffer);
		ret=run_command(buffer,0);           
	}
	if(ret==-1)
	{
		UBOOT_ERROR("ubi write %s fail\n",volName);
	}
	else
	{
		UBOOT_TRACE("OK\n");
	}
	free(buffer);
	return 0;
}

static int raw_read_mmc(unsigned int addr, unsigned int offset, unsigned int len)
{
	UBOOT_DEBUG("Not support\n");
	return 0;
}

static int raw_write_mmc(unsigned int addr, unsigned int offset, unsigned int len)
{
	UBOOT_DEBUG("Not support\n");
	return 0;
}
