#ifndef __TOOL_UTIL_H__
#define __TOOL_UTIL_H__

#define TFTP_BUFFER_NUM 16

/*
 *NANDBIN : Make nand bin
 *EMMCBIN : Make emmc bin
 */
enum tool_bin_type
{
	NANDBIN = 1,
	EMMCBIN ,
};

/*
 *BFN: BFN type for STB, that is MIU/LDR/APP
 *SPIBOOT: Boot from spi flash
 *ROMBOOT: Romboot, as MBOOT/MBOITBAK/UBILD
 *MMCBOOT: Boot from emmc
 */
enum tool_boot_type
{
	BFN = 1,
	SPIBOOT,
	ROMBOOT,
	MMCBOOT,
};

/*
 *NAND: NAND platform
 *SPINAND: SPINAND platform
 */
enum tool_nand_type
{
	NAND = 1,
	SPINAND,
};

/*
 *FCIE3: nand controller fcie3
 *FCIE4: nand controller fcie4
 *FCIE5: nand controller fcie5
 */
enum tool_fcie_type
{
	FCIE3 = 3,
	FCIE4 = 4,
	FCIE5 = 5,
};

/*
 *SPIENV: Env stored in spi flash
 *NANDENV: Env stored in raw nand
 *UBIENV: Env stored in UBILD/MPOOL
 *MMCENV: ENv stored in MMC flash
 */
enum tool_env_type
{
	SPIENV = 1,
	NANDENV,
	UBIENV,
	MMCENV,
};

/*
 *TOOL_RAWDATA_SPI: Raw data stored in spi flash
 *TOOL_RAWDATA_NAND: Raw data stored in nand
 *TOOL_RAWDATA_MMC: Raw data stored in emmc
 */
enum tool_rawdata_type
{
	TOOL_RAWDATA_SPI = 1,
	TOOL_RAWDATA_NAND,
	TOOL_RAWDATA_MMC,
};

/*
 *S_ANDROID: secure data for android system
 *S_ANDROID_STORE: secure data for android system & secure store
 *S_NONE_ANDROID: secure data for NONE android system
 */
enum tool_secure_type
{
	S_ANDROID = 1,
	S_ANDROID_STORE,
	S_NONE_ANDROID,
};

struct tftp_buffer
{
	unsigned long addr;
	unsigned long len;
	unsigned char data[];
};


struct platform_info
{
	unsigned char boottype;
	unsigned char nandtype;
	unsigned char fcietype;
	unsigned char envtype;
	unsigned char cisecctype;
    unsigned char haveecc;
	unsigned char fullblkprg;
	unsigned char set_ftl;
	unsigned char ubilsbbakup;
	unsigned char disablembootbak;

	unsigned char rawdata;
	unsigned char securetype;

	unsigned char nand_id[16];
};
#endif
