/***********************************************************
*
* Copyright (C), 2010-2014, TP-LINK TECHNOLOGIES CO., LTD.
* All rights reserved.
*
* File name  : plugin-handler.h
* Version	 : 1.0
* Description: header file of encrypt-handler
*
* Author	 : Wang FuYu <wangfuyu@tp-link.net>
* Create Date: 2014-04-14
*
* History	 :
*------------------------------------------------------------
*
*01, 14Apr14, Wang FuYu, create file.
************************************************************/
#ifndef _FLASH_HANDLER_H_
#define _FLASH_HANDLER_H_

#include <sys/ioctl.h>
#include <fcntl.h>

#define UC_FLASH_MAGIC_LEN		4
#define UC_FLASH_MAGIC_VALUE	0xAB01CD23
#define UC_FLASH_VER			0x01AB

#define SLP_FLASH_SECTOR_SIZE	0x00010000	// 64k
#define SLP_FLASH_UC_SIZE		0x00010000	// 64k
#define SLP_FLASH_UC_OFFSET		0x020000	// start address in flash to hold uci config data

#define SLP_FLASH_FW_DESCRIPTION 0x400C0
#define SLP_FW_DESCRIPTION_SIZE 12
#define SLP_FW_DESCRIPTION_LEN SLP_FW_DESCRIPTION_SIZE

/* IOCTL Command Codes */
#define IOCTL_SLP_FLASH_READ	0x00
#define IOCTL_SLP_FLASH_WRITE	0x01
#define IOCTL_SLP_FLASH_ERASE	0x02
#define SLP_IOC_MAGIC			0xDF   // some number not existed in ioctl-number.txt
#define SLP_IOC_FLASH_READ	_IOR(SLP_IOC_MAGIC, IOCTL_SLP_FLASH_READ, char)
#define SLP_IOC_FLASH_WRITE	_IOW(SLP_IOC_MAGIC, IOCTL_SLP_FLASH_WRITE, char)
#define SLP_IOC_FLASH_ERASE	_IO(SLP_IOC_MAGIC, IOCTL_SLP_FLASH_ERASE)

typedef unsigned char UINT8;
typedef unsigned long UINT32;

/* flash I/O struct */
typedef struct _ARG
{
	u_int32_t addr;		// flash read addr
	u_int8_t* buf;		// user-space buf
	u_int32_t len;		// erase/write/read length
} ARG;

/* specify user config source */
enum USER_CONF_SRC {
	FLASH_UC_ZONE = 0,  // read user config from flash
	SQUASH_FS_FILE = 1, // read user config from squash_fs
};

/* check firmware update */
unsigned int getUpdateFlag();

/* write buf to flash */
int writeBufToFlash(UINT32 addr, UINT32 buflen, UINT8 *buf);

/* read flash to buf */
int readFlashToBuf(UINT32 addr, UINT32 buflen, UINT8 *buf);

/* read user config data from uc flash */
int ucReadFlash(char *dstDirPathName);

/* write user config data to uc flash */
int ucWriteFlash(char *userConfDirName);

/* read user config data from squash_fs */
int ucReadSquash(char *srcEncryptFileName, char *dstDirPathName);

/* make plugin */
int makePluginPack(const char *dirName, const char *fileName);

#endif

