/***********************************************************
*
* Copyright (C), 2010-2015, TP-LINK TECHNOLOGIES CO., LTD.
* All rights reserved.
*
* File name  : pack-plugin.h
* Version	 : 1.0
* Description: header file of pack-plugin
*
* Author	 : Wang FuYu <wangfuyu@tp-link.net>
* Create Date: 2015-01-23
*
* History	 :
*------------------------------------------------------------
*
*01, 23Jan15, Wang FuYu, create file.
************************************************************/
#ifndef _PAKC_PLUGIN_H_
#define _PAKC_PLUGIN_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#define PLUGIN_TOOLS_VERSION 0
#define PLUGIN_TYPE 0
#define MAX_FILENAME_LEN 	256
#define MAX_PARTS_FILENAME_LEN 64
#define MIN_ARGC_NUM		13
#define MAX_MD5_LEN			16

/* types define. */
typedef char BOOL;
typedef char UINT8;
typedef unsigned int UINT32;

/* _PLUGIN_PARTS_FILE_ and _PLUGIN_PARTS_HAEDER_ same with SDMP */
#define PLUGIN_FILE_MAX_SIZE 0x02000000 /* 32M */
typedef enum
{
	PLUGIN_BIN_FILE = 0,
	PLUGIN_WEB_ICON = 1,
	PLUGIN_APP_WEB = 2,
	PLUGIN_APP_ICON =3,
	PLUGIN_PARTS_MAX,
} PLUGIN_PARTS_TYPE;

typedef struct _PLUGIN_PARTS_FILE_
{
	UINT32 fileOffset;
	UINT32 fileSize;
	UINT8 fileName[MAX_PARTS_FILENAME_LEN];
} PLUGIN_PARTS_FILE;

typedef struct _PLUGIN_PARTS_HAEDER_
{
	UINT32 headerVer;
	UINT8 pluginId[32];
	UINT8 pluginVer[16];
	UINT8 pluginName[32];
	UINT32 pluginSize;
	UINT8 pluginTag[16];
	UINT8 pluginComp[64];
	UINT8 pluginAuthor[64];
	UINT8 osVer[16];
	UINT8 md5[16];
	UINT32 pluginType;
	PLUGIN_PARTS_FILE pluginFile[16];
	UINT8 reserved[256]; 
} PLUGIN_PARTS_HAEDER;

#define PLUGIN_DEBUG 0
#if PLUGIN_DEBUG
#define PLUGIN_LOG(...) do { \
	printf("Function is:%s, Line is:%d.", __FUNCTION__, __LINE__); \
	printf(__VA_ARGS__); \
	printf("\n"); \
} while(0)
#else
#define PLUGIN_LOG(...)
#endif

#define SHOW_USAGE printf


#define FREE_P(x) \
		do{\
			if (NULL != (x)){	\
				free(x);	\
				(x) = NULL;	\
			}\
		}while(0)

#endif
