/***************************************************************
 *
 * Copyright(c) 2005-2007 Shenzhen TP-Link Technologies Co. Ltd.
 * All right reserved.
 *
 * Filename		:	md5sum-half-check.c
 * Version		:	1.0
 * Abstract		:	md5sum check file front and end part date
 * Author		:	YANG JI (yangji1@tp-link.net)
 * Created Date	:	08/12/2020
 ***************************************************************/
#include <fcntl.h>
#include <string.h>
#include <stdio.h>
#include "md5.h"
#include "md5_interface.h"


#define NVMP_PLUGIN_DEBUG 0
#if NVMP_PLUGIN_DEBUG
#define MD5_HALF_LOG printf
#define MD5_HALF_ERROR printf
#else
#define MD5_HALF_LOG(...)
#define MD5_HALF_ERROR(...)
#endif


#define BUF_SIZE			3072
#define SMALL_SIZE			512
#define MD5_READ_SIZE		256
#define NAME_SIZE			256
#define MD5_RES_SIZE		16

static char gMd5FilePath[NAME_SIZE];


void dump_md5_res(unsigned char* res)
{
	int i = 0;
	char data[SMALL_SIZE] = { 0 };
	char *p = &data[0];

	for (i = 0; i < MD5_RES_SIZE; i++)
	{
		sprintf(p, "%02x", res[i]);
		p += 2;
	}

	printf("%s  %s\n", data, gMd5FilePath);
}

int main(int argc, char **argv)
{
	int ret = -1;
	int fileSize = 0;
	int readBytes = 0;
	unsigned int optType = -1;
	FILE* fp = NULL;
	unsigned char buf[BUF_SIZE] = { 0 };
	unsigned char md5HalfRes[MD5_RES_SIZE] = { 0 };
	unsigned char *p_buf = NULL;

	if (NULL == argv[1])
	{
		MD5_HALF_LOG("md5sum-half-check input paras invalid!\n");
		return -1;
	}

	memcpy(gMd5FilePath, argv[1], strlen(argv[1]));

	MD5_HALF_LOG("md5sum-half-check file name: %s\n", gMd5FilePath);

	fp = fopen(gMd5FilePath, "rb");
	if (!fp)
	{
		printf("No such file\n");
		return -1;
	}

	fseek(fp, 0L, SEEK_END);
	fileSize = ftell(fp);
	fseek(fp, 0L, SEEK_SET);

	if (fileSize <= MD5_READ_SIZE)
	{
		MD5_HALF_LOG("md5sum-half-check file size small\n");

		fread(buf, sizeof(unsigned char), fileSize, fp);

		md5_make_digest(md5HalfRes, buf, fileSize);
	}
	else
	{
		MD5_HALF_LOG("md5sum-half-check bigger than %d\n", MD5_READ_SIZE);

		/* 拷贝文件前MD5_READ_SIZE字节内容到buf中 */
		ret = fread(buf, sizeof(unsigned char), MD5_READ_SIZE, fp);
		if (ret != MD5_READ_SIZE)
		{
			MD5_HALF_ERROR("file front read error\n");
			goto close_fp;
		}

		/* 拷贝文件后MD5_READ_SEZE内容到buf + MD5_READ_SIZE中 */
		fseek(fp, fileSize - MD5_READ_SIZE, SEEK_SET);
		ret = fread(buf + MD5_READ_SIZE, sizeof(unsigned char), MD5_READ_SIZE, fp);
		if (ret != MD5_READ_SIZE)
		{
			MD5_HALF_ERROR("file end read error\n");
			goto close_fp;
		}

		md5_make_digest(md5HalfRes, buf, MD5_READ_SIZE * 2);
	}

	dump_md5_res(md5HalfRes);

	fseek(fp, 0L, SEEK_SET);
	fclose(fp);

	return 0;

close_fp:

	fseek(fp, 0L, SEEK_SET);
	fclose(fp);

	return -1;
}


