/***********************************************************
*
* Copyright (C), 2010-2014, TP-LINK TECHNOLOGIES CO., LTD.
* All rights reserved.
*
* File name  : make-plugin.c
* Version	 : 1.0
* Description: make plugin pkt
*
* Author	 : Wang FuYu <wangfuyu@tp-link.net>
* Create Date: 2014-09-16
*
* History	 :
*------------------------------------------------------------
*
*01, 16Sep14, Wang FuYu, create file.
************************************************************/

#include "make-plugin.h"
#include "compress-handler.h"
#include "tar-handler.h"
#include "plugin-handler.h"

char gDirPath[MAX_FILENAME_LEN];
char gFilePath[MAX_FILENAME_LEN];

/******************************************************************************
* FUNCTION		: usage()
* AUTHOR		: wangfuyu<wangfuyu@tp-link.net>
* DESCRIPTION	: show the usage of this plugin.
* INPUT			:
* OUTPUT		:
* RETURN		:
******************************************************************************/
static void usage(char* name)
{
	SHOW_USAGE("%s -t <type> -d <dir> -f<dir>\n", name);
	SHOW_USAGE("\t-t <type>\t type is the type of operation.\n");
	SHOW_USAGE("\t-d <dir>\t dir of source ipk.\n");
	SHOW_USAGE("\t-f <path>\t path to save plugin pkt.\n");
}

/******************************************************************************
* FUNCTION		: getOpt()
* AUTHOR		: wangfuyu <wangfuyu@tp-link.net>
* DESCRIPTION	: get command option from input
* INPUT			:
* OUTPUT		:
* RETURN		:
******************************************************************************/
static int getOpt(int argc, char** argv)
{
	int ch = 0;
	unsigned int optType = -1;
	extern char *optarg;

	if (argc < UC_ARGC_MIN_NUM)
	{
		usage(argv[0]);
		return MK_PLUGIN_ERR;
	}

	memset(gDirPath, 0, MAX_FILENAME_LEN);
	memset(gFilePath, 0, MAX_FILENAME_LEN);
	while ((ch = getopt(argc, argv, "t:d:f:")) !=  MK_PLUGIN_ERR)
	{
		switch (ch)
		{
		case 't':
			MSG_LOG("type: %s\n", optarg);
			optType = (unsigned short)atoi(optarg);
			break;
		case 'd':
			MSG_LOG("directory: %s\n", optarg);
			strncpy(gDirPath, optarg, MAX_FILENAME_LEN);
			break;
		case 'f':
			MSG_LOG("filename: %s\n", optarg);
			strncpy(gFilePath, optarg, MAX_FILENAME_LEN);
			break;
		default:
			usage(argv[0]);
			return -1;
		}
	}

	return optType;
}

/******************************************************************************
* FUNCTION		: main()
* AUTHOR		: wangfuyu <wangfuyu@tp-link.net>
* DESCRIPTION	: entry!
* INPUT			:
* OUTPUT		:
* RETURN		:
******************************************************************************/
int main(int argc, char **argv)
{
	int ret = MK_PLUGIN_ERR;
	unsigned int optType = -1;

	optType = getOpt(argc, argv);
	switch(optType)
	{
	case MAKE_PLUGIN_OPT:
		MSG_LOG("make plugin packet, dir: %s, filename: %s\n", gDirPath, gFilePath);
		return makePluginPack(gDirPath, gFilePath);

	case INST_PLUGIN_OPT:
		MSG_LOG("install plugin prog, dir: %s, filename: %s\n", gDirPath, gFilePath);
		return MK_PLUGIN_OK;
		
	default:
		MSG_ERR("error: input para invalid!\n");
		return MK_PLUGIN_ERR;
	}

	return MK_PLUGIN_OK;
}

