/* This file is the app generic link script. Included by app.ld. */

OUTPUT_FORMAT("elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(app_entry)

 /* The total virtual address space length of the app. 128M by default */
APP_VIRT_ADDR_LEN   = 0x10000000;
/* Static heap length of the app. 1M by default */
APP_STATIC_HEAP_LEN = 0x100000;
/* the start virtual address of app */
APP_VIRT_ADDR_START = APP_ID * APP_VIRT_ADDR_LEN;

/* error check:
 * a. APP_ID >= 0.
 * b. The available virtual address space of APP is between 0x10000000 and 0x80000000 */
ASSERT(APP_ID, "app.ld : app id must be greater than 0")
ASSERT((APP_VIRT_ADDR_START + APP_VIRT_ADDR_LEN) <= 0x80000000, "app.ld : virtual address is too large")

MEMORY
{
    /* The virtual address Spaces between apps cannot overlap */
    RAM (rwx) : ORIGIN = APP_VIRT_ADDR_START, LENGTH = APP_VIRT_ADDR_LEN
}

SECTIONS
{
    . = ORIGIN(RAM);

    _text_start = ALIGN(32);

    .preamble :
    {
        KEEP (*(*.preamble))
    } > RAM

    /* The segment must be placed at the head */
    .text.cmpxchg : ALIGN(32)
    {
        *(.text.cmpxchg)
    }> RAM

    .text.fast : ALIGN(32)
    {
        *(.fastbootcode* .fastbootcode)
        u_m?.o (.text .text*)
        vi_de?.o (.text .text*)
        ?k_vi.o (.text .text*)
        ak_isp_sd?.o (.text .text*)
    }> RAM

    .text : ALIGN(32)
    {
        *(.text .text.*)
    }> RAM

    .init :
    {
        KEEP (*(.init))
    } > RAM

    .fini :
    {
        KEEP (*(.fini))
    } > RAM

    .ARM.exidx : {
       __exidx_start = .;
       *(.ARM.exidx*)
       *(.gnu.linkonce.armexidix.*.*)
       __exidx_end = .;
    } > RAM

    .ctors :
    {
        /* gcc uses crtbegin.o to find the start of
           the constructors, so we make sure it is
           first.  Because this is a wildcard, it
           doesn't matter if the user does not
           actually link against crtbegin.o; the
           linker won't look for a file to match a
           wildcard.  The wildcard also means that it
           doesn't matter which directory crtbegin.o
           is in.  */
        KEEP (*crtbegin.o(.ctors))
            KEEP (*crtbegin?.o(.ctors))
            /* We don't want to include the .ctor section from
               the crtend.o file until after the sorted ctors.
               The .ctor section from the crtend file contains the
               end of ctors marker and it must be last */
            KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))
            KEEP (*(SORT(.ctors.*)))
            KEEP (*(.ctors))

            PROVIDE(__ctors_start__ = .);
        KEEP (*(SORT(.init_array.*)))
            KEEP (*(.init_array))
            PROVIDE(__ctors_end__ = .);
    } > RAM

    .dtors :
    {
        KEEP (*crtbegin.o(.dtors))
            KEEP (*crtbegin?.o(.dtors))
            KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))
            KEEP (*(SORT(.dtors.*)))
            KEEP (*(.dtors))

            PROVIDE(__dtors_start__ = .);
            /*KEEP(*(SORT(.dtors.*)))
            KEEP(*(.dtors))*/
            KEEP(*(SORT(.fini_array.*)))
            KEEP(*(.fini_array))
            PROVIDE(__dtors_end__ = .);
    } > RAM

    .rodata :
    {
        *(.rodata .rodata.*)
    } > RAM

    . = ALIGN(0x1000);
    _text_end = .;

    _data_start = ADDR(.data);
    .data : ALIGN(0x1000)
    {
        *(.data .data.*)
        SORT(CONSTRUCTORS)
    } > RAM

    .got :
    {
        *(.igot .igot.* .got .got.*)
    } > RAM

    .FSymTab :
    {
        _syscall_table_begin = .;
        KEEP(*(FSymTab))
        _syscall_table_end = .;
        . = ALIGN(0x1000);
    } > RAM

    _data_end = .;

    _zero_start = .;
    .bss : ALIGN(32)
    {
        __bss_start = .;
        *(.shbss)
        *(.bss .bss.* .gnu.linkonce.b.*)
        *(COMMON)
        *(.bss)
        __bss_end = .;
    } > RAM

    . = ALIGN(0x1000);

    _heap_start = .;
    _heap_end = _heap_start + APP_STATIC_HEAP_LEN;

    _zero_end = _heap_end;

    _app_text_start = _text_start;
    _app_text_end   = _text_end;

    _app_data_start = _data_start;
    _app_data_end   = _data_end;

    _app_zero_start = _zero_start;
    _app_zero_end   = _zero_end;

    _app_heap_start = _heap_start;
    _app_heap_end   = _heap_end;

    _app_virt_addr_dyn_start = _heap_end;
    _app_virt_addr_dyn_end   = ORIGIN(RAM) + LENGTH(RAM);

    _fini = .;
}




