#! /bin/bash

function collect_package_name() {
	packages_install_status=$1
	cat $packages_install_status|grep "Package:"|awk -F: '{print $2}'
}

function generate_output_with_fixed_length() {
	local package_list=
	local LINE_BOUNDARY=120
	local total_num=0

	output_file=$2
	[ -e $output_file ] && unlink $output_file

	printf "  Generating profile..."
	for package in $1; do
		[ $total_num = 0 ] && _first_line_start=1 || _first_line_start=0

		let "_line_length_sum = ${#package_list} + ${#package}"

		[ $_line_length_sum -gt $LINE_BOUNDARY ] && _break_new_line=1 || _break_new_line=0

		if [ $_first_line_start = 1 ]; then
			package_list="    PACKAGES:=$package"
		elif [ $_break_new_line = 1 ]; then
			package_list="$package_list \\"
			echo "$package_list" >> $output_file
			package_list="      $package"
		else
			package_list="$package_list $package"
		fi

		let "total_num=$total_num + 1"
	done

	echo "$package_list" >> $output_file
	echo "done"
}
