#
# Copyright (c) 2013 The Linux Foundation. All rights reserved.
# Copyright (C) 2006-2007 OpenWrt.org
#
# This is free software, licensed under the GNU General Public License v2.
# See /LICENSE for more information.
#
include $(INCLUDE_DIR)/host.mk
include $(INCLUDE_DIR)/prereq.mk

ifneq ($(DUMP),1)
  all: compile
endif

export QUILT=0
STAMP_PREPARED:=$(RTOS_DIR)/.prepared
STAMP_CONFIGURED:=$(RTOS_DIR)/.configured
include $(INCLUDE_DIR)/rtos-kernel-defaults.mk

define Kernel/Prepare
	$(call Kernel/Prepare/Default)
endef

#define Kernel/Configure
#	$(call Kernel/Configure/Default)
#endef

#define Kernel/CompileModules
#	$(call Kernel/CompileModules/Default)
#endef

#define Kernel/CompileImage
#	$(call Kernel/CompileImage/Default)
#endef

define Kernel/Clean
	$(call Kernel/Clean/Default)
endef

define BuildKernel
  $(STAMP_PREPARED):
	-rm -rf $(KERNEL_BUILD_DIR)
	-mkdir -p $(KERNEL_BUILD_DIR)
	$(Kernel/Prepare)
	touch $$@

  $(STAMP_CONFIGURED): $(STAMP_PREPARED) $(TOPDIR)/.config
	$(Kernel/Configure)
	touch $$@

  $(RTOS_DIR)/.modules: $(STAMP_CONFIGURED) $(RTOS_DIR)/.config FORCE
	$(Kernel/CompileModules)
	touch $$@

  $(RTOS_DIR)/.image: $(STAMP_CONFIGURED) FORCE
	$(Kernel/CompileImage)
	touch $$@

  mostlyclean: FORCE
	$(Kernel/Clean)

  define BuildKernel
  endef

  download:
  prepare: $(STAMP_CONFIGURED)
  compile: $(RTOS_DIR)/.modules
	$(MAKE) -C image compile TARGET_BUILD=

  oldconfig menuconfig nconfig: $(STAMP_PREPARED) $(STAMP_CHECKED) FORCE
	$(call Kernel/Configure/T_Prepare,config)
	rm -f $(STAMP_CONFIGURED)
	$(_SINGLE)$(MAKE) -C $(RTOS_DIR) $(KERNEL_MAKEOPTS) $$@

  install: $(RTOS_DIR)/.image
	+$(MAKE) -C image compile install TARGET_BUILD=

  clean: FORCE
	rm -rf $(KERNEL_BUILD_DIR)

  image-prereq:
	@+$(NO_TRACE_MAKE) -s -C image prereq TARGET_BUILD=

  prereq: image-prereq

endef
