#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <malloc.h>
#include <sys/stat.h>
#include "debug.h"
#include "nand.h"
#include "tool-util.h"
#include "dictionary.h"
#include "libiniparser.h"
#include "command.h"
#include "global_data.h"
#include "environment.h"
#include "mstar/unfd/inc/common/drvNAND.h"

#define NANDBINNAME "nand.bin"

char *outfile;
char *defpath;

extern dictionary *dict;
extern struct platform_info info;
extern char *inifile;

extern char *root_directory;
extern char *image_directory;
extern char *script_file;
extern char *outpath;
extern gd_t *gd;
extern char *env_name_spec;

extern struct mtd_info mtdinfo;
extern nand_info_t nand_info[CONFIG_SYS_MAX_NAND_DEVICE];
extern int nand_scan(struct mtd_info *mtd);
extern void nand_exit(void);
extern void ubi_exit(void);



/////////////////////////////////////////////////////////////////////////
/////////////////////test cmd
/////////////////////test cmd
/////////////////////////////////////////////////////////////////////////
static int cmd_test1(cmd_tbl_t * cmdtp, int flag, int argc, char * const argv[])
{
	printf("              ! ! ! !\n");
	printf("            \\\\ - - //\n");
	printf("             (- -)\n");
	printf("\\ (_) /\n");
	printf(" \\ u /\n");
	printf("oOOo-\n");
	printf(" \n");
	printf("Hello    \n");
	printf("                     \n");
	printf(" \n");
	printf("-oOOo\n");
	return 0;
}
U_BOOT_CMD(cmd_test1, 1, 1, cmd_test1, "cmd test 1", "cmd test 1");
/////////////////////////////////////////////////////////////////////////
/////////////////////test cmd
/////////////////////test cmd
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////env test
//should in specific env file ex env_ubi.c env_nand.c, remember to modify
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////env test

int parse_nandid(char *s)
{
	int len, num = 0, i = 0;
	char id[4];

	printf("[%s]: nand id string: %s\n", __func__, s);
	len = strlen(s);
	while(1){
		len = 0;
		if(*s == '\0')
			break;
		while(*s && *s != '-'){
			s++;
			len++;
		}
		if(len != 4){
			printf("[%s]: Id string in ini file should be written as follows 1: 0xAA-0xBB-0xCC\n", __func__);
			return -1;
		}
		memcpy(id, s - 4, 4);
		if(id[0] != '0' || id[1] != 'x'){
			printf("[%s]: Id string in ini file should be written as follows 2: 0xAA-0xBB-0xCC\n", __func__);
			return -1;
		}
		for(i = 2; i < 4; i++){
			if(id[i] >= '0' && id[i] <= '9')
				info.nand_id[num] = info.nand_id[num] * 16 + (id[i] - '0');
			else if(id[i] >= 'a' && id[i] <= 'f')
				info.nand_id[num] = info.nand_id[num] * 16 + (id[i] - 'a' + 10);
			else if(id[i] >= 'A' && id[i] <= 'F')
				info.nand_id[num] = info.nand_id[num] * 16 + (id[i] - 'A' + 10);
			else{
				printf("[%s]: nand id should be write in hex\n", __func__);
				return -1;
			}
		}
		num++;
		if(*s == '\0')
			break;
		else
			s++;
	}
	printf("[%s]: Nand id: ", __func__);
	for(i = 0; i < num; i++){
		printf("0x%X ", info.nand_id[i]);
	}
	printf("\n");
	return 0;
}

int create_empty_file(void)
{
	int fd, ret, len;
	int64_t size;
	unsigned char *buf;
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

	fd = open(outfile, O_RDWR | O_CREAT | O_TRUNC, S_IRWXU | S_IRWXG | S_IRWXO);
	if(fd < 0){
		printf("[%s]: open %s failed\n", __func__, outfile);
		return -1;
	}

    if(info.nandtype == SPINAND){
		printf("[%s]: SPINAND  type\n", __func__);
        size = (nand_info[0].size / nand_info[0].writesize) * (nand_info[0].writesize + nand_info[0].oobsize);
	    len = nand_info[0].erasesize / nand_info[0].writesize * (nand_info[0].writesize + nand_info[0].oobsize);
	}
	else if(info.nandtype == NAND){
		printf("[%s]: NAND type\n", __func__);
        size = (int64_t)pNandDrv->u16_BlkCnt * pNandDrv->u16_BlkPageCnt * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize);
	    len = pNandDrv->u16_BlkPageCnt * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize);
	}
	//size = (nand_info[0].size / nand_info[0].writesize) * (nand_info[0].writesize + nand_info[0].oobsize);
	//len = nand_info[0].erasesize / nand_info[0].writesize * (nand_info[0].writesize + nand_info[0].oobsize);

	buf = (unsigned char *)malloc(len);
	if(!buf){
		printf("[%s]: malloc buffer failed\n", __func__);
		return -1;
	}
	memset(buf, 0xFF, len);
	while(size > 0){
		ret = write(fd, buf, len);
		if(ret < 0){
			printf("[%s]: Create empty file failed\n", __func__);
			free(buf);
			close(fd);
			return -1;
		}
		size -= len;
	}
	close(fd);
	free(buf);
	return 0;
}

int nand_truncate_outfile(void)
{
	int fd, ret = 0, blocksize, i;
	int64_t offset;
	char path[128];
	unsigned char *truncbuff;
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

	fd = open(outfile, O_RDWR);
	if(fd < 0){
		printf("[%s]: open %s failed\n", __func__, outfile);
		return -1;
	}

    if(info.nandtype == SPINAND){
		printf("[%s]: SPINAND type\n", __func__);
        blocksize = nand_info[0].erasesize / nand_info[0].oobblock * (nand_info[0].oobblock + nand_info[0].oobsize);
	    offset = nand_info[0].size / nand_info[0].oobblock * (nand_info[0].oobblock + nand_info[0].oobsize) - blocksize;

	}
	else if(info.nandtype == NAND){
		printf("[%s]: NAND type\n", __func__);
        blocksize = pNandDrv->u16_BlkPageCnt * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize);
	    offset = (int64_t)pNandDrv->u16_BlkCnt * pNandDrv->u16_BlkPageCnt * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize) - blocksize;

	}

    /*
	blocksize = nand_info[0].erasesize / nand_info[0].oobblock * (nand_info[0].oobblock + nand_info[0].oobsize);
	offset = nand_info[0].size / nand_info[0].oobblock * (nand_info[0].oobblock + nand_info[0].oobsize) - blocksize;
    blocksize = pNandDrv->u16_BlkPageCnt * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize);
	offset = (int64_t)pNandDrv->u16_BlkCnt * pNandDrv->u16_BlkPageCnt * (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize) - blocksize;
    */
	truncbuff = (unsigned char *)malloc(blocksize);
	if(!truncbuff){
		printf("[%s]: malloc truncate buffer failed\n", __func__);
		close(fd);
		return -1;
	}

	while(offset > 0){
		lseek64(fd, offset, SEEK_SET);
		ret = read(fd, truncbuff, blocksize);
		if(ret < 0){
			printf("[%s]: read failed, offset=0x%llx\n", __func__, offset);
			goto out;
		}
		for(i = 0; i < blocksize; i++){
			if(truncbuff[i] != 0xFF)
				break;
		}
		if(i < blocksize)
			break;
		offset -= blocksize;
	}
	close(fd);

	offset += blocksize * 5;
	printf("[%s]: truncate file with length 0x%llx\n", __func__, offset);
	truncate(outfile, offset);
    offset += blocksize;
	free(truncbuff);
	return offset;

out:
	free(truncbuff);
	close(fd);
	return -1;
}

void nand_finish_update(void)
{
	ubi_exit();
	nand_exit();
	if(dict)
		dictionary_del(dict);
	if(gd)
		free(gd);
	if(outfile)
		free(outfile);
}

int write_cis_miu_bfn(void)
{
	unsigned char *miu_buf = NULL;
	struct stat st;
	int fd, ret = 0;
	char cmd[128], path[128];
	char *file;

	//Read miu file
	file = iniparser_getstring(dict, "boot:miu", "Not Set");
	if(strcmp(file, "Not Set") == 0){
		printf("[%s]: MIU file not set, skip pre-update cis & miu\n", __func__);
		return 0;
	}
	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory, image_directory, file);
	stat(path, &st);
	miu_buf = malloc(st.st_size);
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("[%s]: open file %s failed\n", __func__, path);
		goto out;
	}
	ret = read(fd, miu_buf, st.st_size);
	if(ret<0){
		printf("[%s]: read file %s failed\n", __func__, path);
		close(fd);
		goto out;
	}
	close(fd);

	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "nand bfn newcis 0 0x%lx", (long)miu_buf);
	ret = run_command(cmd, 0);
	if(ret)
		printf("[%s]: write bfn cis & miu failed\n", __func__);
out:
	free(miu_buf);
	return ret;
}
int write_cis_bl_uboot(void)
{
	unsigned char *nni_buf = NULL, *pni_buf = NULL, *ppm_buf = NULL, *mboot_buf = NULL;
	struct stat st;
	int fd, ret = 0;
	char cmd[128], path[128];
	char *file;

	//Read nni file
	file = iniparser_getstring(dict, "cis:nni", "Not Set");
	if(strcmp(file, "Not Set") == 0){
		printf("[%s]: nni file not set\n", __func__);
		return -1;
	}
	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory, image_directory, file);
	stat(path, &st);
	nni_buf = malloc(st.st_size);
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("[%s]: open file %s failed\n", __func__, path);
		goto out_nni;
	}
	ret = read(fd, nni_buf, st.st_size);
	if(ret<0){
		printf("[%s]: read file %s failed\n", __func__, path);
		close(fd);
		goto out_nni;
	}
	close(fd);

	//Read pni file
	file = iniparser_getstring(dict, "cis:pni", "Not Set");
	if(strcmp(file, "Not Set") == 0){
		printf("[%s]: nni file not set\n", __func__);
		goto out_nni;
	}
	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory, image_directory, file);
	stat(path, &st);
	pni_buf = malloc(st.st_size);
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("[%s]: open file %s failed\n", __func__, path);
		goto out_pni;
	}
	ret = read(fd, pni_buf, st.st_size);
	if(ret<0){
		printf("[%s]: read file %s failed\n", __func__, path);
		close(fd);
		goto out_pni;
	}
	close(fd);

	//Read ppm file
	file = iniparser_getstring(dict, "cis:ppm", "Not Set");
	if(strcmp(file, "Not Set") == 0){
		printf("[%s]: ppm file is not set!\n", __func__);
		goto out_pni;
	}
	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory, image_directory, file);
	stat(path, &st);
	ppm_buf = malloc(st.st_size);
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("[%s]: open file %s failed\n", __func__, path);
		goto out_ppm;
	}
	ret = read(fd, ppm_buf, st.st_size);
	if(ret<0){
		printf("[%s]: read file %s failed\n", __func__, path);
		close(fd);
		goto out_ppm;
	}
	close(fd);

	//Read mboot file
	file = iniparser_getstring(dict, "boot:mboot", "Not Set");
	if(strcmp(file, "Not Set") == 0){
		printf("[%s]: mboot is not set!\n", __func__);
		goto out_ppm;
	}
	else
		printf("[%s]: Mboot file name: %s\n", __func__, file);
	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory, image_directory, file);
	stat(path, &st);
	mboot_buf = malloc(st.st_size);
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("[%s]: open file %s failed\n", __func__, path);
		goto out_mboot;
	}
	ret = read(fd, mboot_buf, st.st_size);
	if(ret<0){
		printf("[%s]: read file %s failed\n", __func__, path);
		close(fd);
		goto out_mboot;
	}
	close(fd);

	memset(cmd, 0, sizeof(cmd));
	if(info.boottype == ROMBOOT){
		sprintf(cmd, "ncisbl 0x%lx 0x%lx 0x%lx 0x%lx 0x%lx",
			(long)nni_buf,
			(long)ppm_buf,
			(long)pni_buf,
			(long)mboot_buf,
			(long)st.st_size);
		ret = run_command(cmd, 0);
		if(ret < 0){
			printf("[%s]: write cis bootloader & uboot failed\n", __func__);
			goto out_mboot;
		}
	}
	else if(info.boottype == SPIBOOT){
		sprintf(cmd, "ncisbl 0x%lx 0x%lx 0x%lx",
			(long)nni_buf,
			(long)ppm_buf,
			(long)pni_buf);
		//ret = run_command(cmd, 0);
		if(ret < 0){
			printf("[%s]: write cis failed\n", __func__);
			goto out_mboot;
		}
	}
	free(nni_buf);
	free(pni_buf);
	free(ppm_buf);
	free(mboot_buf);
	return 0;


out_mboot:
	free(mboot_buf);
out_ppm:
	free(ppm_buf);
out_pni:
	free(pni_buf);
out_nni:
	free(nni_buf);

	return -1;
}

int write_cis_bl_uboot_hash(void)
{
	unsigned char *nni_buf = NULL, *pni_buf = NULL, *ppm_buf = NULL,*hash0_buf = NULL, *mboot_buf = NULL;
	struct stat st;
	int fd, ret = 0;
	long hash0_size;
	char cmd[128], path[128];
	char *file;

	file = iniparser_getstring(dict, "cis:nni", "Not Set");
	if(strcmp(file, "Not Set") == 0){
		printf("[%s]: nni file not set\n", __func__);
		return -1;
	}
	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory, image_directory, file);
	stat(path, &st);
	nni_buf = malloc(st.st_size);
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("[%s]: open file %s failed\n", __func__, path);
		goto out_nni;
	}
	ret = read(fd, nni_buf, st.st_size);
	if(ret<0){
		printf("[%s]: read file %s failed\n", __func__, path);
		close(fd);
		goto out_nni;
	}
	close(fd);

	file = iniparser_getstring(dict, "cis:pni", "Not Set");
	if(strcmp(file, "Not Set") == 0){
		printf("[%s]: nni file not set\n", __func__);
		goto out_nni;
	}
	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory, image_directory, file);
	stat(path, &st);
	pni_buf = malloc(st.st_size);
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("[%s]: open file %s failed\n", __func__, path);
		goto out_pni;
	}
	ret = read(fd, pni_buf, st.st_size);
	if(ret<0){
		printf("[%s]: read file %s failed\n", __func__, path);
		close(fd);
		goto out_pni;
	}
	close(fd);

	file = iniparser_getstring(dict, "cis:ppm", "Not Set");
	if(strcmp(file, "Not Set") == 0){
		printf("[%s]: ppm file is not set!\n", __func__);
		goto out_pni;
	}
	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory, image_directory, file);
	stat(path, &st);
	ppm_buf = malloc(st.st_size);
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("[%s]: open file %s failed\n", __func__, path);
		goto out_ppm;
	}
	ret = read(fd, ppm_buf, st.st_size);
	if(ret<0){
		printf("[%s]: read file %s failed\n", __func__, path);
		close(fd);
		goto out_ppm;
	}
	close(fd);

	file = iniparser_getstring(dict, "boot:hash0", "Not Set");
	if(strcmp(file, "Not Set") == 0){
		printf("[%s]: hash0 file is not set!\n", __func__);
		goto out_pni;
	}
	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory, image_directory, file);
	stat(path, &st);
	hash0_size = st.st_size;
	hash0_buf= malloc(st.st_size);
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("[%s]: open file %s failed\n", __func__, path);
		goto out_ppm;
	}
	ret = read(fd, hash0_buf, st.st_size);
	if(ret<0){
		printf("[%s]: read file %s failed\n", __func__, path);
		close(fd);
		goto out_hash0;
	}
	close(fd);

	file = iniparser_getstring(dict, "boot:mboot", "Not Set");
	if(strcmp(file, "Not Set") == 0){
		printf("[%s]: mboot is not set!\n", __func__);
		goto out_ppm;
	}
	else
		printf("[%s]: Mboot file name: %s\n", __func__, file);
	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory, image_directory, file);
	stat(path, &st);
	mboot_buf = malloc(st.st_size+0x2000);
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("[%s]: open file %s failed\n", __func__, path);
		goto out_mboot;
	}
	ret = read(fd, mboot_buf, st.st_size);
	if(ret<0){
		printf("[%s]: read file %s failed\n", __func__, path);
		close(fd);
		goto out_mboot;
	}
	close(fd);

	memset(cmd, 0, sizeof(cmd));
	if(info.boottype == ROMBOOT){
        /*
		sprintf(cmd, "ncishash 0x%lx 0x%lx 0x%lx 0x%lx 0x%lx 0x%lx 0x%lx 0x%lx",
			(long)nni_buf,
			(long)ppm_buf,
			(long)pni_buf,
			(long)hash0_buf,
			(long)hash0_size,  //14k for nugget, 10k for other board
			(long)mboot_buf,
			(long)st.st_size,
			(long)0x3200);    // 0x3200 for Nugget, but 0 for other board, whatever, this value is not used now
			*/
			sprintf(cmd, "ncishash 0x%lx 0x%lx 0x%lx 0x%lx 0x%lx 0x%lx 0x%lx 0x%lx",
			(long)nni_buf,
			(long)ppm_buf,
			(long)pni_buf,
			(long)hash0_buf,
			(long)hash0_size,  //14k for nugget, 10k for other board
			(long)mboot_buf,
			(long)st.st_size,
			(long)0x0);
		ret = run_command(cmd, 0);
		if(ret < 0){
			printf("[%s]: write cis bootloader & uboot failed", __func__);
			goto out_mboot;
		}
	}
	else if(info.boottype == SPIBOOT){
		sprintf(cmd, "ncisbl 0x%lx 0x%lx 0x%lx",
			(long)nni_buf,
			(long)ppm_buf,
			(long)pni_buf);
		//ret = run_command(cmd, 0);
		if(ret < 0){
			printf("[%s]: write cis failed\n", __func__);
			goto out_mboot;
		}
	}
	free(nni_buf);
	free(pni_buf);
	free(ppm_buf);
	free(mboot_buf);
	return 0;


out_mboot:
	free(mboot_buf);
out_hash0:
	free(hash0_buf);
out_ppm:
	free(ppm_buf);
out_pni:
	free(pni_buf);
out_nni:
	free(nni_buf);

	return -1;
}



int nandbin_k6lite(int argc, char *argv[])
{
	char *val;
	unsigned char *buf;
	int fd, ret, len, i;
	uint64_t size, filesize;
	char cmd[512];
    info.haveecc= 0;
	info.set_ftl = 0;

	inifile = argv[2];
	printf("[%s]: Parsing ini file %s...\n", __func__, inifile);

	dict = iniparser_load(inifile);
	if(!dict){
		printf("[%s]: Parse ini file failed\n", __func__);
		return -1;
	}

	root_directory = iniparser_getstring(dict, "path:root_directory", "Not Set");
	if(strcmp(root_directory, "Not Set") == 0){
		printf("[%s]: root path is not set\n", __func__);
		return -1;
	}
	image_directory = iniparser_getstring(dict, "path:image_directory", "Not Set");
	if(strcmp(image_directory, "Not Set") == 0){
		printf("[%s]: image path is not set\n", __func__);
		return -1;
	}
	script_file = iniparser_getstring(dict, "path:script_file", "Not Set");
	if(strcmp(script_file, "Not Set") == 0){
		printf("[%s]: mstar script is not set\n", __func__);
		return -1;
	}
	outpath = iniparser_getstring(dict, "path:outpath", "Not Set");
	if(strcmp(outpath, "Not Set") == 0){
		printf("[%s]: out path is not set", __func__);
		return -1;
	}

	defpath = outpath;
	outfile = (char *)malloc(512);
	if(!outfile){
		printf("[%s]: malloc out file path buffer failed\n", __func__);
		return -1;
	}
	memset(outfile, 0, 512);
	sprintf(outfile, "%s%s", outpath, NANDBINNAME);

	printf("[%s]: root directory: %s\n", __func__, root_directory);
	printf("[%s]: image directory: %s\n", __func__, image_directory);
	printf("[%s]: mscript name: %s\n", __func__, script_file);
	printf("[%s]: out file path: %s\n", __func__, outfile);
	printf("[%s]: def file path: %s\n", __func__, defpath);

	memset(&info, 0, sizeof(struct platform_info));

	val = iniparser_getstring(dict, "boot:boottype", "Unknown");
	if(strcmp(val, "BFN") == 0 || strcmp(val, "bfn") == 0)
		info.boottype = BFN;
	else if(strcmp(val, "ROMBOOT") == 0 || strcmp(val, "romboot") == 0)
		info.boottype = ROMBOOT;
	else if(strcmp(val, "SPIBOOT") == 0 || strcmp(val, "spiboot") == 0)
		info.boottype = SPIBOOT;
	else{
		printf("Unknown boot type, boot type should be 'ROMBOOT' or 'SPIBOOT' or 'BFN'\n");
		return -1;
	}

	val = iniparser_getstring(dict, "nand:nandtype", "Unknown");
	if(strcmp(val, "NAND") == 0 || strcmp(val, "nand") == 0)
		info.nandtype = NAND;
	else if(strcmp(val, "SPINAND") == 0 || strcmp(val, "spinand") == 0)
		info.nandtype = SPINAND;
	else{
		printf("Unknown nand type, nand type should be 'NAND' or 'SPINAND'\n");
		return -1;
	}

	val = iniparser_getstring(dict, "nand:nandid", "Not Set");
	if(strcmp(val, "Not Set") == 0){
		printf("[%s]: nand id is not set", __func__);
		return 0;
	}
	ret = parse_nandid(val);
	if(ret < 0){
		printf("[%s]: parse nand id failed\n", __func__);
		return -1;
	}

	val = iniparser_getstring(dict, "fcie:type", "Not Set");
	if(strcmp(val, "fcie3") == 0 || strcmp(val, "FCIE3") == 0)
		info.fcietype = FCIE3;
	else if(strcmp(val, "fcie4") == 0 || strcmp(val, "FCIE4") == 0)
		info.fcietype = FCIE4;
	else if(strcmp(val, "fcie5") == 0 || strcmp(val, "FCIE5") == 0)
		info.fcietype = FCIE5;
	else{
		printf("[%s]: Unkown fcie type\n", __func__);
		return -1;
	}

	gd = (gd_t *)malloc(sizeof(*gd));

	val = iniparser_getstring(dict, "env:env_type", "Not Set");
	if(strcmp(val, "Not Set") == 0){
		printf("[%s]: env type not set!\n", __func__);
		return 0;
	}
	else if(strcmp(val, "UBI") == 0 ||strcmp(val, "ubi") == 0 ){
		info.envtype = UBIENV;
		printf("[%s]: env stored in nand ubi\n", __func__);
	}
	else if(strcmp(val, "NAND") == 0 ||strcmp(val, "nand") == 0 ){
		info.envtype = NANDENV;
		printf("[%s]: env stored in nand\n", __func__);
	}
	else if(strcmp(val, "SPI") == 0 ||strcmp(val, "spi") == 0 ){
		info.envtype = SPIENV;
		printf("[%s]: env stored in spi flash\n", __func__);
	}
	else{
		info.envtype = -1;
		printf("[%s]: unknown env type\n", __func__);
		return -1;
	}

	printf("[%s]:Nand init......\n", __func__);
	ret = nand_init();
	if(ret < 0){
		printf("[%s]: nand init failed\n", __func__);
		return -1;
	}

	if(info.nandtype == NAND){
		char *str = iniparser_getstring(dict, "cis:ecctype", "Not Set");
		if(strcmp(str, "Not Set") == 0){
			printf("[%s]: ecc type of cis partition is NOT set!!\n", __func__);
			return -1;
		}
		info.cisecctype = atoi(str);
		printf("[%s]: Ecc type of cis partition is %d\n", __func__, info.cisecctype);
	}

	if(info.boottype == BFN){
		printf("[%s]: BFN board type\n", __func__);
	}
	else if(info.boottype == SPIBOOT){
		printf("[%s]: SPI boot board type\n", __func__);
	}
	else if(info.boottype == ROMBOOT){
		printf("[%s]: ROM boot board type\n", __func__);
	}

	printf("[%s]: Create empty nand file ......\n", __func__);
	ret = create_empty_file();
	if(ret < 0){
		printf("[%s]: create empty nand file failed\n", __func__);
		return -1;
	}

	#if defined(__VER_UNFD_FTL__) && __VER_UNFD_FTL__
	printf("[%s]: FTL init ......\n", __func__);
	// init
	ret = nand_Init_FTL();
	if(UNFD_ST_SUCCESS != ret)
	{
	   printf("nand_Init_FTL failed!!!\n");
	   return -1;
	}
	#endif //__VER_UNFD_FTL__

	printf("[%s]: UBI init ......\n", __func__);
	val = iniparser_getstring(dict, "ubi:lsbbackup", "Not Set");
	if(strcmp(val, "Not Set") == 0){
		info.ubilsbbakup = 0;
	}
	else if(strcmp(val, "n") == 0){
		info.ubilsbbakup = 0;
	}
	else if(strcmp(val, "y") == 0){
		info.ubilsbbakup = 1;
	}
	else{
		printf("[%s]: Unknown type for determining if to enable ubi lsb backup\n", __func__);
		return -1;
	}

    val = iniparser_getstring(dict, "ubi:fullblkprg", "Not Set");
	if(strcmp(val, "Not Set") == 0){
		info.fullblkprg = 0;
	}
	else if(strcmp(val, "n") == 0){
		info.fullblkprg = 0;
	}
	else if(strcmp(val, "y") == 0){
		info.fullblkprg = 1;
	}
	else{
		printf("[%s]: Unknown type for determining if to enable ubi fullblkprg\n", __func__);
		return -1;
	}

	ubi_init();

	//For test, need to delete later
	//nand_scan(&mtdinfo);
	//

	val = iniparser_getstring(dict, "boot:mbootbak", "Not Set");
	if(strcmp(val, "Not Set") == 0){
		info.disablembootbak = 0;
	}
	else if(strcmp(val, "y") == 0 || strcmp(val, "Y") == 0){
		info.disablembootbak = 0;
	}
	else if(strcmp(val, "n") == 0 || strcmp(val, "N") == 0){
		printf("[%s]: Disable mbootbak\n", __func__);
		info.disablembootbak = 1;
	}
	else{
		printf("[%s]: Unknown type for determining if mbootbak exists\n", __func__);
		return -1;
	}

	if(info.boottype == ROMBOOT){
		printf("[%s]: Romboot platform, write cis & uboot\n", __func__);
		val = iniparser_getstring(dict, "boot:hash0", "Not Set");
		if(strcmp(val, "Not Set") == 0){
			printf("[%s]: No Hash0, Write cis bootloader & uboot ......\n", __func__);
			ret = write_cis_bl_uboot();
			if(ret < 0){
				printf("[%s]: write cis & mboot failed\n", __func__);
				return -1;
			}
		}
		else{
			printf("[%s]: Platform with Hash0, Write cis bootloader, uboot & hash0 ......\n", __func__);
			ret = write_cis_bl_uboot_hash();
			if(ret < 0){
				printf("[%s]: write cis, hash & mboot failed\n", __func__);
				return ret;
			}
		}
	}
	else if(info.boottype == BFN){
		printf("[%s]: BFN platform, Write CIS & MIU...\n", __func__);
		ret = write_cis_miu_bfn();
		if(ret < 0){
			printf("[%s]: write BFN cis failed\n", __func__);
			return ret;
		}
	}
	else if(info.boottype == SPIBOOT){
		printf("[%s]: SPI flash boot type, skip write mboot\n", __func__);
	}
	else{
		printf("[%s]: Unknown boor type, exit\n", __func__);
		return -1;
	}

	if(info.envtype == UBIENV){
		printf("[%s]: Init UBI environment\n", __func__);
		env_init_ubi();
	}
	else if(info.envtype == NANDENV){
		printf("[%s]: Init NAND environment\n", __func__);
		env_init_nand();
	}
	else if(info.envtype == SPIENV){
		printf("[%s]: env stored in spi flash\n", __func__);
	}

	ret = env_relocate();
	if(ret < 0){
		printf("[%s]: env relocate failed\n", __func__);
		return -1;
	}

	ret = run_command("init_raw_io", 0);
	if(ret < 0){
		printf("[%s]: Raw IO init failed\n", __func__);
		return -1;
	}
	ret = run_command("init_secure_info", 0);
	if(ret < 0){
		printf("[%s]: Raw IO init failed\n", __func__);
		return -1;
	}

	memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "mstar %s", script_file);
	printf("[%s]: run main update script......\n", __func__);
	ret = run_command(cmd, 0);
	if(ret){
		printf("[%s]: Build error, update fail, please check log\n", __func__);
		return -1;
	}

    ret = run_command("releasebuf", 0);

	printf("\n\n[%s]: mtd parts: ", __func__);
	ret = run_command("mtdparts", 0);
	if(ret){
		printf("[%s]: print mtd parts fail\n", __func__);
		return -1;
	}

	printf("\n\n[%s]: print env: \n", __func__);
	ret = run_command("printenv", 0);
	if(ret){
		printf("[%s]: printenv fail, build nand.bin fail\n", __func__);
		return -1;
	}

	printf("\n\n[%s]: print nand bin info: \n", __func__);
	ret = run_command("bininfo", 0);
	if(ret){
		printf("[%s]: build error, check binbinfo fail, cannot generate def file\n", __func__);
		return -1;
	}

	filesize = nand_truncate_outfile();
	if(filesize < 0){
		printf("[%s]: truncate out file failed\n", __func__);
		return filesize;
	}

    info.haveecc = 1;
    fullblockprogram_and_randomizer(filesize);

	nand_finish_update();

	printf("\n\n[%s]: Nand bin file done!!!\n\n",  __func__);

	return 0;






/////////////////////////////////////////////////////////////////////////
//////////////////////////////test code///////////////////////////////////

run_command("nand write.e 0x80400000 KL $(filesize)", 0);

run_command("ubi part UBI", 0);



run_command("ubi part UBI", 0);
run_command("ubi create RFS 0x100000", 0);
run_command("ubi create MSLIB 0x100000", 0);
run_command("ubi info l", 0);
	{
		unsigned char *buf0, *buf1;
		unsigned char cmd[32];
		len = 3*62*2048;
		buf0=malloc(len);
		buf1=malloc(len);
		for(i=0;i<len/512;i++){
			memset(buf0+i*512,i+1,512);
			memset(buf1+i*512,i+2,512);
		}

		run_command("ubi part UBI", 0);
		memset(cmd, 0,  sizeof(cmd));
		sprintf(cmd, "ubi write %lX RFS %X %X", (long)buf0, len/2, len);
		run_command(cmd, 0);
		memset(cmd, 0,  sizeof(cmd));
		sprintf(cmd, "ubi write_cont %lX RFS %X", (long)buf0, len/2);
		run_command(cmd, 0);
		memset(cmd, 0,  sizeof(cmd));
		sprintf(cmd, "ubi write %lX MSLIB %X %X", (long)buf0, len, len);
		run_command(cmd, 0);

	}

	return 0;




////////////////////////////////////////////////////////////
///////////////////////code for test///////////////////////////
////////////////////////////////////////////////////////////
///////////////////////code for test///////////////////////////
////////////////////////////////////////////////////////////
///////////////////////code for test///////////////////////////
////////////////////////////////////////////////////////////
///////////////////////code for test///////////////////////////
//	extern void nand_hal_test5(void);
//	nand_hal_test5();
////////////////////////////////////////////////////////////
//printf("???\n");
extern void cmd_test(void);
//extern int run_command(const char * cmd, int flag);
cmd_test();
//run_command("cmd_test1",0);
//run_command("cmd_test4",0);
////////////////////////////////////////////////////////////
///////////////////////code for test///////////////////////////
extern int env_relocate (void);
extern int do_env_print (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[]);
extern int setenv_uboot(char *varname, char *varvalue);


env_relocate();
do_env_print(NULL, 0, 1, NULL);
setenv_uboot("testenv", "success");
do_env_print(NULL, 0, 1, NULL);
	{
		char *res = getenv_uboot("testenv");
		printf("res=%s\n", res);
		res = getenv_uboot("nand_bin_tool_version");
		printf("nand_bin_tool_version=%s\n", res);
	}

	{
		unsigned int aa;
		char *e;
		char *s="0x80400";
		aa = strtoul(s, &e, 16);
		printf("aa=0x%X\n",aa);
	}
printf("---------------------------------\n");
run_command("print", 0);
run_command("mtdparts", 0);
run_command("save", 0);
run_command("saveenv", 0);
setenv_uboot("mtdids", "nand0=edb64M-nand");
setenv_uboot("mtdparts", "mtdparts=edb64M-nand:1408k@1536k(MBOOT),1408k(MBOOTBAK),2048k(UBILD),256k(NPT),256k(KL_BP),5m(UBIRO),3m(KL),3m(CTRL),3m(TBL),-(UBI)");
run_command("dynpart edb64M-nand:0x40000(NPT),0x40000(KL_BP),0x500000(UBIRO),0x300000(KL),3m(CTRL),3m(TBL),-(UBI)", 0);
printf("***********************************\n");
run_command("mtdparts", 0);

///////////////////////test ubi//////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//printf("****************test ubi*******************\n");
//printf("****************test ubi*******************\n");
//printf("****************test ubi*******************\n");
//extern void test_ubi1(void);
//test_ubi1();
///////////////////////////////////////////////////////////////////////

//extern void test_ubi_mtdpart(void);
//test_ubi_mtdpart();

///////////////////////test ubi cmd//////////////////////////////////////
///////////////////////////////////////////////////////////////////////
/*
run_command("ubi part UBI", 0);
run_command("ubi part UBIRO", 0);
run_command("ubi part UBI", 0);
run_command("ubi part UBIRO", 0);


run_command("ubi part UBI", 0);
run_command("ubi create RFS 0x100000", 0);
run_command("ubi create MSLIB 0x100000", 0);
run_command("ubi info l", 0);

run_command("ubi part UBIRO", 0);
run_command("ubi create APP 0x100000", 0);
run_command("ubi create DATA 0x100000", 0);
run_command("ubi info l", 0);

	{
		unsigned char *buf0, *buf1;
		unsigned char cmd[32];
		len = 3*62*2048;
		buf0=malloc(len);
		buf1=malloc(len);
		for(i=0;i<len/512;i++){
			memset(buf0+i*512,i+1,512);
			memset(buf1+i*512,i+2,512);
		}

		run_command("ubi part UBI", 0);
		memset(cmd, 0,  sizeof(cmd));
		sprintf(cmd, "ubi write %lX RFS %X %X", (long)buf0, len/2, len);
		run_command(cmd, 0);
		memset(cmd, 0,  sizeof(cmd));
		sprintf(cmd, "ubi write_cont %lX RFS %lX", buf0, len/2);
		run_command(cmd, 0);


		run_command("ubi part UBIRO", 0);

		memset(cmd, 0,  sizeof(cmd));
		sprintf(cmd, "ubi write %lX APP %lX %lX", (long)buf0, len/2, len);
		run_command(cmd, 0);
		printf("TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT1\n");
		memset(cmd, 0,  sizeof(cmd));
		sprintf(cmd, "ubi write_cont %lX APP %X", (long)buf0, len/2);
		run_command(cmd, 0);
		printf("TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT2\n");
		memset(cmd, 0,  sizeof(cmd));
		sprintf(cmd, "ubi write %lX DATA %X %X", (long)buf0, len, len);
		run_command(cmd, 0);

	}
*/






////////////////////////////////////////////////////////////
extern void nand_cmd_test(void);
//extern void nand_cmd_test2(void);
void test_tftp(void);
nand_cmd_test();
run_command("dynpart edb64M-nand:0x40000(NPT),0x40000(KL_BP),0x500000(UBIRO),0x300000(KL),3m(CTRL),3m(TBL),-(UBI)", 0);
printf("***********************************1\n");
run_command("mtdparts", 0);
printf("***********************************2\n");
	env_relocate();
printf("***********************************3\n");
run_command("saveenv", 0);
printf("***********************************4\n");
//nand_cmd_test2();
run_command("cmd_te", 0);
printf("***********************************5\n");
test_tftp();
printf("***********************************6\n");
run_command("dynpart edb64M-nand:0x40000(NPT),0x40000(KL_BP),0x500000(UBIRO),0x300000(KL),3m(CTRL),3m(TBL),-(UBI)", 0);
////////////////////////////////////////////////////////////
}

int parse_ini_file(char* fileName)
{
    int ret = 0;
    char* readVal;

    memset(&info, 0, sizeof(struct platform_info));

    dbg_info("ini file=%s\n", fileName);
	dict = iniparser_load(fileName);
	if(!dict)
    {
		err_info("Parse ini file failed\n");
		return -1;
	}

    root_directory = iniparser_getstring(dict, "path:root_directory", "Not Set");
	if(strcmp(root_directory, "Not Set") == 0)
    {
        err_info("root path is not set\n");
		return -1;
	}

	image_directory = iniparser_getstring(dict, "path:image_directory", "Not Set");
	if(strcmp(image_directory, "Not Set") == 0)
    {
        err_info("image path is not set\n");
		return -1;
	}

    script_file = iniparser_getstring(dict, "path:script_file", "Not Set");
	if(strcmp(script_file, "Not Set") == 0)
    {
		err_info("script file is not set\n");
		return -1;
	}

	defpath = iniparser_getstring(dict, "path:outpath", "Not Set");
	if(strcmp(defpath, "Not Set") == 0)
    {
		err_info("out path is not set");
		return -1;
	}

	outfile = (char *)malloc(512);
	if(!outfile)
    {
        err_info("malloc output file buffer failed\n");
		return -1;
	}

	memset(outfile, 0, 512);
	sprintf(outfile, "%s%s", defpath, NANDBINNAME);

    dbg_info("script_file=%s\n", script_file);
    dbg_info("output_file=%s\n", outfile);

    readVal = iniparser_getstring(dict, "env:env_type", "Not Set");
	if(strcmp(readVal, "Not Set") == 0)
    {
		err_info("env type not set\n");
		return -1;
	}
	else if(strcmp(readVal, "NANDRAW") != 0 && strcmp(readVal, "NANDRAW") != 0 )
    {
		err_info("env not nand type\n");
        return -1;
	}
    info.envtype = NANDENV;

    env_name_spec = iniparser_getstring(dict, "env:env_part", "Not Set");

    readVal = iniparser_getstring(dict, "nand:nandtype", "Unknown");
	if(strcmp(readVal, "SPINAND") == 0 || strcmp(readVal, "spinand") == 0)
	{
        info.nandtype = SPINAND;
	}
    else if(strcmp(readVal, "PNAND") == 0 || strcmp(readVal, "pnand") == 0)
    {
        info.nandtype = NAND;
    }
    else
	{
        err_info("nand type not spinand or pnand\n");
        return -1;
	}

    if(info.nandtype == NAND)
    {
        readVal = iniparser_getstring(dict, "fcie:type", "Not Set");
    	if(strcmp(readVal, "fcie3") == 0 || strcmp(readVal, "FCIE3") == 0)
    		info.fcietype = FCIE3;
    	else if(strcmp(readVal, "fcie4") == 0 || strcmp(readVal, "FCIE4") == 0)
    		info.fcietype = FCIE4;
    	else if(strcmp(readVal, "fcie5") == 0 || strcmp(readVal, "FCIE5") == 0)
    		info.fcietype = FCIE5;
    	else{
    		printf("[%s]: Unkown fcie type\n", __func__);
    		return -1;
    	}

        readVal = iniparser_getstring(dict, "cis:ecctype", "Not Set");
		if(strcmp(readVal, "Not Set") == 0){
			printf("[%s]: ecc type of cis partition is NOT set!!\n", __func__);
			return -1;
		}
		info.cisecctype = atoi(readVal);
		printf("[%s]: Ecc type of cis partition is %d\n", __func__, info.cisecctype);
    }

    readVal = iniparser_getstring(dict, "nand:nandid", "Not Set");
	if(strcmp(readVal, "Not Set") == 0)
    {
		err_info("nand id is not set\n");
		return -1;
	}

	ret = parse_nandid(readVal);
	if(ret < 0)
    {
        err_info("parse nand id failed\n");
		return -1;
	}

    return 0;

}

int nandbin(int argc, char *argv[])
{
    int ret = 0;
    int filesize = 0;
    char cmd[512];

    ret = parse_ini_file(argv[2]);
    if(ret < 0)
    {
        err_info("parse_ini_file failed\n");
        return ret;
    }

    gd = (gd_t *)malloc(sizeof(*gd));

    nand_init();

    create_empty_file();
    if(ret < 0)
    {
        err_info("create empty nand file failed\n");
		return -1;
	}

    ret = env_relocate();
	if(ret < 0)
    {
        err_info("env relocate failed\n");
		return -1;
	}

    memset(cmd, 0, sizeof(cmd));
	sprintf(cmd, "mstar %s", script_file);

	dbg_info("run main update script......\n");
	ret = run_command(cmd, 0);
	if(ret)
    {
		err_info("update fail, please check log\n");
		return -1;
	}

    ret = run_command("releasebuf", 0);

    dbg_info("print env: \n");
    ret = run_command("printenv", 0);

    dbg_info("mtd parts: \n");
	ret = run_command("mtdparts", 0);
	if(ret)
    {
		err_info("print mtd parts fail\n");
		return -1;
	}

    dbg_info("print nand bin info: \n");
	ret = run_command("nandbininfo", 0);
	if(ret)
    {
		err_info("check binbinfo fail, cannot generate def file\n");
		return -1;
	}

    filesize = nand_truncate_outfile();
	if(filesize < 0)
    {
		err_info("truncate out file failed\n");
		return filesize;
	}

    info.haveecc = 1;

	nand_finish_update();

	dbg_info("Nand bin file done!!!\n\n");

    return 0;
}

