//<MStar Software>
//******************************************************************************
// MStar Software
// Copyright (c) 2010 - 2012 MStar Semiconductor, Inc. All rights reserved.
// All software, firmware and related documentation herein ("MStar Software") are
// intellectual property of MStar Semiconductor, Inc. ("MStar") and protected by
// law, including, but not limited to, copyright law and international treaties.
// Any use, modification, reproduction, retransmission, or republication of all 
// or part of MStar Software is expressly prohibited, unless prior written 
// permission has been granted by MStar. 
//
// By accessing, browsing and/or using MStar Software, you acknowledge that you
// have read, understood, and agree, to be bound by below terms ("Terms") and to
// comply with all applicable laws and regulations:
//
// 1. MStar shall retain any and all right, ownership and interest to MStar
//    Software and any modification/derivatives thereof.
//    No right, ownership, or interest to MStar Software and any
//    modification/derivatives thereof is transferred to you under Terms.
//
// 2. You understand that MStar Software might include, incorporate or be
//    supplied together with third party`s software and the use of MStar
//    Software may require additional licenses from third parties.  
//    Therefore, you hereby agree it is your sole responsibility to separately
//    obtain any and all third party right and license necessary for your use of
//    such third party`s software. 
//
// 3. MStar Software and any modification/derivatives thereof shall be deemed as
//    MStar`s confidential information and you agree to keep MStar`s 
//    confidential information in strictest confidence and not disclose to any
//    third party.  
//
// 4. MStar Software is provided on an "AS IS" basis without warranties of any
//    kind. Any warranties are hereby expressly disclaimed by MStar, including
//    without limitation, any warranties of merchantability, non-infringement of
//    intellectual property rights, fitness for a particular purpose, error free
//    and in conformity with any international standard.  You agree to waive any
//    claim against MStar for any loss, damage, cost or expense that you may
//    incur related to your use of MStar Software.
//    In no event shall MStar be liable for any direct, indirect, incidental or
//    consequential damages, including without limitation, lost of profit or
//    revenues, lost or damage of data, and unauthorized system use.
//    You agree that this Section 4 shall still apply without being affected
//    even if MStar Software has been modified by MStar in accordance with your
//    request or instruction for your use, except otherwise agreed by both
//    parties in writing.
//
// 5. If requested, MStar may from time to time provide technical supports or
//    services in relation with MStar Software to you for your use of
//    MStar Software in conjunction with your or your customer`s product
//    ("Services").
//    You understand and agree that, except otherwise agreed by both parties in
//    writing, Services are provided on an "AS IS" basis and the warranty
//    disclaimer set forth in Section 4 above shall apply.  
//
// 6. Nothing contained herein shall be construed as by implication, estoppels
//    or otherwise:
//    (a) conferring any license or right to use MStar name, trademark, service
//        mark, symbol or any other identification;
//    (b) obligating MStar or any of its affiliates to furnish any person,
//        including without limitation, you and your customers, any assistance
//        of any kind whatsoever, or any information; or 
//    (c) conferring any license or right under any intellectual property right.
//
// 7. These terms shall be governed by and construed in accordance with the laws
//    of Taiwan, R.O.C., excluding its conflict of law rules.
//    Any and all dispute arising out hereof or related hereto shall be finally
//    settled by arbitration referred to the Chinese Arbitration Association,
//    Taipei in accordance with the ROC Arbitration Law and the Arbitration
//    Rules of the Association by three (3) arbitrators appointed in accordance
//    with the said Rules.
//    The place of arbitration shall be in Taipei, Taiwan and the language shall
//    be English.  
//    The arbitration award shall be final and binding to both parties.
//
//******************************************************************************
//<MStar Software>

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <stdio.h>
#include <stdint.h>
#include <fcntl.h>
#include <string.h>
#include <malloc.h>

#include "secure/MsSecureCommon.h"
#include "MsDebug.h"
#include "MsRawIO.h"
#include "MsSystem.h"

#include "tool-util.h"

//-------------------------------------------------------------------------------------------------
//  Debug Functions
//-------------------------------------------------------------------------------------------------
extern struct platform_info info;
extern  int ubi_get_volume_size(char *, size_t* );
extern int ubi_get_leb_size(void);
extern int search_tftp_buffer(unsigned long *addr);
extern void release_tftp_buffer(unsigned long addr);

extern uint32_t  crc32 (uint32_t crc, const unsigned char *p, unsigned int len);
//-------------------------------------------------------------------------------------------------
//  Local Defines
//-------------------------------------------------------------------------------------------------
#define ENV_UPGRADE_COMPLETE        "MstarUpgrade_complete"
#define ENV_UPGRADE_MODE            "upgrade_mode"
#define ENV_FORCE_UPGRADE           "force_upgrade"

//spi
#define FLASH_DEFAULT_TARGET_SPI  E_RAW_DATA_IN_SPI
#define FLASH_DEFAULT_PARTITION_SPI SPI_DEFAULT_PARTITION
#define FLASH_DEFAULT_VOLUME_SPI SPI_DEFAULT_VOLUME
#define SECTOR_SIZE_SPI   0x10000 //64KBytes

//nand
#define FLASH_DEFAULT_TARGET_NAND  E_RAW_DATA_IN_NAND
#define FLASH_DEFAULT_PARTITION_NAND NAND_DEFAULT_PARTITION
#define FLASH_DEFAULT_VOLUME_NAND NAND_DEFAULT_VOLUME
#define SECTOR_SIZE_NAND   ubi_get_leb_size()
#define SECURE_INFOR_BACK_OFFSET_NAND 1 // unit is sectore, so the total offset is 128*512=64KBytes

//emmc
#define FLASH_DEFAULT_TARGET_MMC  E_RAW_DATA_IN_MMC
#define FLASH_DEFAULT_PARTITION_MMC MMC_DEFAULT_PARTITION
#define FLASH_DEFAULT_VOLUME_MMC MMC_DEFAULT_VOLUME
#define SECTOR_SIZE_MMC   0x200 //512Bytes
#define SECURE_INFOR_BACK_OFFSET_MMC 128 // unit is sectore, so the total offset is 128*512=64KBytes

#define NUTTX_HEADER_LEN 0x80
#define ALIGN_BYTES 16
#define FOUR_BIT_SHIFT 4
#define HW_AES_ADDR "E_MMAP_ID_HW_AES_BUF"
#define NUTTX_ADDR "E_MMAP_ID_NUTTX_MEM"


typedef struct
{
    U32 Length;
    U32 Offset;
}ST_HEADER_INFO;

typedef struct
{
    ST_HEADER_INFO stSignature;
    ST_HEADER_INFO stConfig;
}ST_SIGN_CONFIG;


//-------------------------------------------------------------------------------------------------
//  Global Variables
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//  Local Variables
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//  Private Functions
//-------------------------------------------------------------------------------------------------
int get_nconfig_offset(unsigned int *u32NConfigOffset,unsigned int *u32NConfigBakOffset);
int NConfigSave(U8* pBufferAddr, U32 u32NConfigLen);
int NConfigLoad(U32 u32HwAesVABufAddr);
int LoadNConfig(U32 u32HwAesVABufAddr);
int get_nconfig_size(unsigned int *u32NConfigSize);

//-------------------------------------------------------------------------------------------------
//  Public Functions
//-------------------------------------------------------------------------------------------------


int do_save_nconfig(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	#define OBJECT_NAME argv[1]
	#define OBJECT_DRAM_ADDR s_addr 
	int ret=0;
	char s_addr[16];
	unsigned long l_addr;
	
	if(argc<3){
		cmd_usage(cmdtp);
		return -1;   
	}

	if(strcmp(OBJECT_NAME,"NuttxConfig")!=0){
		return -1;
	}

	memset(s_addr, 0, sizeof(s_addr));
	l_addr = strtoul(argv[2], NULL, 16);
	ret = search_tftp_buffer(&l_addr);
	sprintf(s_addr, "%lx", l_addr);
    
	ST_SIGN_CONFIG* pstHeaderInfo = NULL;
	U32 u32SignConfigPhyAddr=strtoul(OBJECT_DRAM_ADDR, NULL, 16);
	U32 u32SignConfigLen=0;
	U32 u32SigPhyAddr=0;
	U32 u32ConfigPhyAddr=0;
	U32 u32SigLen=256;
	U32 u32ConfigLen=0;
	UBOOT_DEBUG("OBJECT_NAME : %s \n",OBJECT_NAME);
	UBOOT_DEBUG("u32SignConfigPhyAddr =%x \n",u32SignConfigPhyAddr);
    
	pstHeaderInfo=(ST_SIGN_CONFIG*)u32SignConfigPhyAddr;
	u32SigPhyAddr=u32SignConfigPhyAddr+pstHeaderInfo->stSignature.Offset;
	u32SigLen=pstHeaderInfo->stSignature.Length;
	u32ConfigPhyAddr=u32SignConfigPhyAddr+pstHeaderInfo->stConfig.Offset;
	u32ConfigLen=pstHeaderInfo->stConfig.Length;
	#define HEADER_LEN 256
	u32SignConfigLen=HEADER_LEN+u32SigLen+u32ConfigLen;

	UBOOT_DEBUG("****u32SignConfigPhyAddr : %x \n",u32SignConfigPhyAddr);
	UBOOT_DEBUG("****u32SigPhyAddr : %x \n",u32SigPhyAddr);
	UBOOT_DEBUG("****u32SigLen : %x \n",u32SigLen);
	UBOOT_DEBUG("****u32ConfigPhyAddr : %x \n",u32ConfigPhyAddr);
	UBOOT_DEBUG("****u32ConfigLen : %x \n",u32ConfigLen);

	ret = NConfigSave((U8*)u32SignConfigPhyAddr, u32SignConfigLen);
	if(EN_SUCCESS != ret){
		UBOOT_ERROR("NConfig Save fail\n");
		release_tftp_buffer(strtoul(argv[2], NULL, 16));
		return -1;    
	}
	
	release_tftp_buffer(strtoul(argv[2], NULL, 16));
	UBOOT_TRACE("OK\n");
	
	return 0;
}

int get_nconfig_size(unsigned int *u32NConfigSize)
{
	int ret = 0;
	unsigned int sector_size = 0;
	UBOOT_DEBUG("IN\n");    
    
	ret = MsApiChunkHeader_GetValue(CH_NUTTX_CONFIG_SIZE,u32NConfigSize);
	if(ret != 0){
		UBOOT_ERROR("MsApiChunkHeader_GetValue fail!\n");
		return -1;
	}

	//test, delete later
	//*u32NConfigSize = 2;
	//test

	if(info.rawdata == TOOL_RAWDATA_SPI)
		sector_size = (unsigned int)SECTOR_SIZE_SPI;
	else if(info.rawdata == TOOL_RAWDATA_NAND)
		sector_size = (unsigned int)SECTOR_SIZE_NAND;
	else if(info.rawdata == TOOL_RAWDATA_MMC)
		sector_size = (unsigned int)SECTOR_SIZE_MMC;
	
	*u32NConfigSize=(*u32NConfigSize)*sector_size;
	UBOOT_DEBUG("sector size = %x\n",sector_size);
	UBOOT_DEBUG("*u32NConfigSize = %x\n",*u32NConfigSize);

	UBOOT_DEBUG("OK\n");    
	return ret;
}

int get_nconfig_offset(unsigned int *u32NConfigOffset,unsigned int *u32NConfigBakOffset)
{
	int ret = 0;
	U32 u32Size=0;

	UBOOT_DEBUG("IN\n");    
    
	ret = MsApiChunkHeader_GetValue(CH_NUTTX_CONFIG_OFFSET,u32NConfigOffset);
	if(ret != 0){
		UBOOT_ERROR("MsApiChunkHeader_GetValue fail!\n");
		return -1;
	}

	//test, delete later
	//*u32NConfigOffset = 8;
	//test
	
	UBOOT_DEBUG("*u32NConfigOffset = %x\n",*u32NConfigOffset);
	
	if(info.rawdata == TOOL_RAWDATA_SPI){
		ret = getSpiSize(&u32Size);
		*u32NConfigOffset = u32Size - ((*u32NConfigOffset)*SECTOR_SIZE_SPI);
		*u32NConfigBakOffset=*u32NConfigOffset+SECTOR_SIZE_SPI;
		UBOOT_DEBUG("u32NConfigOffset : 0x%x\n",*u32NConfigOffset);
		UBOOT_DEBUG("u32NConfigBkOffset : 0x%x\n",*u32NConfigBakOffset);
	}
	else if(info.rawdata == TOOL_RAWDATA_NAND){
		check_ubi_partition(NAND_DEFAULT_VOLUME,NAND_DEFAULT_PARTITION);
		ubi_get_volume_size(NAND_DEFAULT_VOLUME,&u32Size);
		UBOOT_DEBUG("u32Size : 0x%x\n",u32Size);
		UBOOT_DEBUG("ubi_get_leb_size : 0x%x\n",SECTOR_SIZE_NAND);
		*u32NConfigOffset = u32Size - ((*u32NConfigOffset)*SECTOR_SIZE_NAND);
		*u32NConfigBakOffset=*u32NConfigOffset+SECURE_INFOR_BACK_OFFSET_NAND*SECTOR_SIZE_NAND;
		UBOOT_DEBUG("u32NConfigOffset : 0x%x\n",*u32NConfigOffset);
		UBOOT_DEBUG("u32NConfigBkOffset : 0x%x\n",*u32NConfigBakOffset);
	}
	else if(info.rawdata == TOOL_RAWDATA_MMC){
		ret = get_mmc_partsize(MMC_DEFAULT_VOLUME,&u32Size);
		*u32NConfigOffset = u32Size - ((*u32NConfigOffset)*SECTOR_SIZE_MMC);
		*u32NConfigBakOffset=*u32NConfigOffset+SECURE_INFOR_BACK_OFFSET_MMC*SECTOR_SIZE_MMC;
		UBOOT_DEBUG("u32NConfigOffset : 0x%x\n",*u32NConfigOffset);
		UBOOT_DEBUG("u32NConfigBkOffset : 0x%x\n",*u32NConfigBakOffset);
	}
	else{
		printf("[%s]: Unknown nconfig store type\n", __func__);
		return -1;
	}
 
	if(EN_SUCCESS == ret){
		ret=0;
		UBOOT_DEBUG("OK\n");
	}
	else{
		ret=-1;
		UBOOT_DEBUG("get_NConfig_offset fail\n");
	}
    
	UBOOT_DEBUG("OK\n");    

	return ret;
}

int NConfigSave(U8* pBufferAddr, U32 u32NConfigLen)
{   
	int ret=-1;
	int ret_bk =-1;
	unsigned int u32NConfigOffset = 0;  
	unsigned int u32NConfigBkOffset = 0; 
	unsigned int u32NConfigSize=0;
	UBOOT_DEBUG("IN\n");

	if(pBufferAddr==NULL)
	{
		UBOOT_ERROR("The input parameter pBufferAddr' is a null pointer\n");
		return -1;
	}
	
	if(info.rawdata == TOOL_RAWDATA_SPI)
		ret = raw_io_config(FLASH_DEFAULT_TARGET_SPI,FLASH_DEFAULT_PARTITION_SPI,FLASH_DEFAULT_VOLUME_SPI);
	else if(info.rawdata == TOOL_RAWDATA_NAND)
		ret = raw_io_config(FLASH_DEFAULT_TARGET_NAND,FLASH_DEFAULT_PARTITION_NAND,FLASH_DEFAULT_VOLUME_NAND);
	else if(info.rawdata == TOOL_RAWDATA_MMC)
		ret = raw_io_config(FLASH_DEFAULT_TARGET_MMC,FLASH_DEFAULT_PARTITION_MMC,FLASH_DEFAULT_VOLUME_MMC);
	else{
		printf("[%s]: Unknown nconfig store type\n", __func__);
		return -1;
	}
	if(ret != 0)
	{
		UBOOT_ERROR("raw_io_config setting fail!\n");
		return -1;
	}

	ret = get_nconfig_offset(&u32NConfigOffset,&u32NConfigBkOffset);
	if(ret != 0)
	{
		UBOOT_ERROR("get_NConfig_offset fail!\n");
		return -1;
	}

	UBOOT_DEBUG("u32NConfigOffset : 0x%x\n",u32NConfigOffset);
	UBOOT_DEBUG("u32NConfigBkOffset : 0x%x\n",u32NConfigBkOffset);

	ret = get_nconfig_size(&u32NConfigSize);
	if(ret != 0)
	{
		UBOOT_ERROR("get_nconfig_max_size fail!\n");
		return -1;
	}

	#define NCONFIG_RAW_DATA_SIZE (u32NConfigSize-4)
   
	UBOOT_DEBUG("u32NConfigLen =%x\n",u32NConfigLen);
	if(u32NConfigLen>=NCONFIG_RAW_DATA_SIZE)
	{
		UBOOT_ERROR("NCofngi length is larger than %x\n",NCONFIG_RAW_DATA_SIZE);
		return -1;
	}

	unsigned long Crc32=0;
	// update CRC
	Crc32=crc32(0, pBufferAddr,NCONFIG_RAW_DATA_SIZE);
	UBOOT_DEBUG("Crc32 =%lx\n",Crc32);
	memcpy(pBufferAddr+NCONFIG_RAW_DATA_SIZE, &Crc32, sizeof(Crc32));
	UBOOT_DEBUG("Burn NConfig to blcok\n");   
	ret = raw_write((unsigned int)pBufferAddr,u32NConfigOffset,u32NConfigSize);
	UBOOT_DEBUG("Burn NConfig to  backup blcok\n");   
	ret_bk = raw_write((unsigned int)pBufferAddr,u32NConfigBkOffset,u32NConfigSize);

	if(EN_SUCCESS == ret || EN_SUCCESS == ret_bk){
		UBOOT_DEBUG("ret : %d , ret_bk : %d \n",ret,ret_bk);
		UBOOT_TRACE("OK\n");
		ret = 0;       
	}
	else{
		ret= -1;
		UBOOT_ERROR("NConfig Save fail\n");
	}
    
	UBOOT_DEBUG("OK\n");    
	return ret;
	#undef NCONFIG_RAW_DATA_SIZE 
}
