/***********************************************************
*
* Copyright (C), 2010-2014, TP-LINK TECHNOLOGIES CO., LTD.
* All rights reserved.
*
* File name  : plugin-handler.c
* Version	 : 1.0
* Description:
*
* Author	 : Wang FuYu <wangfuyu@tp-link.net>
* Create Date: 2014-04-14
*
* History	 :
*------------------------------------------------------------
*
*01, 14Apr14, Wang FuYu, create file.
************************************************************/

#include "make-plugin.h"
#include "plugin-handler.h"
#include "tar-handler.h"
#include "compress-handler.h"

/******************************************************************************
* FUNCTION		: setPluginMsgHeader()
* AUTHOR		: wangfuyu <wangfuyu@tp-link.net>
* DESCRIPTION	: set message header, include updateFlag, length, magic, version
* INPUT			:
* OUTPUT		:
* RETURN		:
******************************************************************************/
int setPluginMsgHeader(UC_BIN_HEADER *pluginMsgHeaderStr, int pluginMsgBufLen)
{
	if (NULL == pluginMsgHeaderStr || 0 >= pluginMsgBufLen)
	{
		MSG_ERR("flashMsgHeaderStr is NULL or flashMsgBufLen is invalid!\n");
		return MK_PLUGIN_ERR;
	}

	pluginMsgHeaderStr->updateFlag = NO_UPDATE_FIRMWARE;
	pluginMsgHeaderStr->length = pluginMsgBufLen;
	pluginMsgHeaderStr->magic = UC_FLASH_MAGIC_VALUE;
	pluginMsgHeaderStr->ver = 0x01AB;

	pluginMsgHeaderStr->updateFlag = htonl(pluginMsgHeaderStr->updateFlag);
	pluginMsgHeaderStr->length = htonl(pluginMsgHeaderStr->length);
	pluginMsgHeaderStr->magic = htonl(pluginMsgHeaderStr->magic);
	pluginMsgHeaderStr->ver = htons(pluginMsgHeaderStr->ver);

	MSG_LOG("magic is %08x, ver is %08x, length is %08x\n",
		pluginMsgHeaderStr->magic, pluginMsgHeaderStr->ver, pluginMsgHeaderStr->length);
	return MK_PLUGIN_OK;
}

/******************************************************************************
* FUNCTION		: fillHeaderForMsg()
* AUTHOR		: wangfuyu <wangfuyu@tp-link.net>
* DESCRIPTION	: fill message header for config data stream
* INPUT			:
* OUTPUT		:
* RETURN		:
******************************************************************************/
unsigned char *fillHeaderForMsg(unsigned char *desMd5Buf, int desMd5Len, int *pluginMsgBufLen)
{
	int ret = MK_PLUGIN_ERR;
	int pluginMsgHeaderLen = 0;
	unsigned char *pluginMsgBuf = NULL;
	UC_BIN_HEADER pluginMsgHeaderStr;

	if (NULL == desMd5Buf || 0 >= desMd5Len || NULL == pluginMsgBufLen)
	{
		MSG_ERR("desMd5Buf is NULL or desMd5Len is invalid!\n");
		return NULL;
	}

	pluginMsgHeaderLen = sizeof(UC_BIN_HEADER);
	memset(&pluginMsgHeaderStr, 0, pluginMsgHeaderLen);

	*pluginMsgBufLen = desMd5Len + pluginMsgHeaderLen;
	ret = setPluginMsgHeader(&pluginMsgHeaderStr, *pluginMsgBufLen);
	if (MK_PLUGIN_OK != ret)
	{
		MSG_ERR("set flash msg header failed!\n");
		return NULL;
	}

	pluginMsgBuf = (unsigned char*)malloc(*pluginMsgBufLen);
	if (NULL == pluginMsgBuf)
	{
		MSG_ERR("malloc flashMsgBuf failed!\n");
		return NULL;
	}

	memset(pluginMsgBuf, 0, *pluginMsgBufLen);
	memcpy(pluginMsgBuf, &pluginMsgHeaderStr, pluginMsgHeaderLen);
	memcpy(pluginMsgBuf + pluginMsgHeaderLen, desMd5Buf, desMd5Len);

	MSG_LOG("fillHeaderForMsg successfully!\n");
	return pluginMsgBuf;
}

/******************************************************************************
* FUNCTION		: makePluginPack()
* AUTHOR		: wangfuyu <wangfuyu@tp-link.net>
* DESCRIPTION	:
* INPUT			:
* OUTPUT		:
* RETURN		:
******************************************************************************/
int makePluginPack(const char *dirName, const char *fileName)
{
	int ret = MK_PLUGIN_ERR;
	int pluginMsgBufLen = 0;
	int srcCompressBufLen = 0;
	unsigned char *srcCompressBuf = NULL;
	unsigned char *pluginMsgBuf = NULL;

	if (NULL == dirName || NULL == fileName)
	{
		MSG_ERR("dirName or fileName is NULL!\n");
		return MK_PLUGIN_ERR;
	}

	MSG_LOG("pack plugin begin.........................\n");
	srcCompressBuf = packPluginIpk(dirName, &srcCompressBufLen);
	if (NULL == srcCompressBuf || 0 >= srcCompressBufLen)
	{
		MSG_ERR("pack plugin ipk failed!\n");
		return MK_PLUGIN_ERR;
	}

	MSG_LOG("fill header begin.......................\n");
	pluginMsgBuf = fillHeaderForMsg(srcCompressBuf, srcCompressBufLen, &pluginMsgBufLen);
	if (NULL == pluginMsgBuf || 0 >= pluginMsgBufLen)
	{
		MSG_ERR("fill header failed!\n");
		return MK_PLUGIN_ERR;
	}

	MSG_LOG("write file begin........................\n");
	ret = writeBufToFile(fileName, pluginMsgBuf, pluginMsgBufLen);
	if (MK_PLUGIN_OK != ret)
	{
		MSG_ERR("write to %s failed!\n", fileName);
		FREE_P(pluginMsgBuf);
		return MK_PLUGIN_ERR;
	}

	FREE_P(pluginMsgBuf);

	return MK_PLUGIN_OK;
}

