/***********************************************************
*
* Copyright (C), 2010-2014, TP-LINK TECHNOLOGIES CO., LTD.
* All rights reserved.
*
* File name  : make-plugin.h
* Version	 : 1.0
* Description: header file of UciCfg
*
* Author	 : Wang FuYu <wangfuyu@tp-link.net>
* Create Date: 2014-04-03
*
* History	 :
*------------------------------------------------------------
*
*01, 03Apr14, Wang FuYu, create file.
************************************************************/
#ifndef _UCI_CONFIG_H_
#define _UCI_CONFIG_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#define MK_PLUGIN_OK     0
#define MK_PLUGIN_ERR   -1

#define UCI_DIRMODE 0700
#define UCI_FILEMODE 0600

#define UC_ARGC_MIN_NUM 7

#define MAX_FILENAME_LEN 	256

#define PLUGIN_ID_MAX_LEN 8
#define PLUGIN_NAME_MAX_LEN 64
#define PLUGIN_VERSION_MAX_LEN 32
#define PLUGIN_AUTHOR_MAX_LEN 64
#define PLUGIN_TAG_MAX_LEN 64
#define PLUGIN_DESC_MAX_LEN 128
#define PLUGIN_UPDATE_LOG_MAX_LEN 128
#define PLUGIN_ICON_URL_MAX_LEN 512
#define PLUGIN_DATA_URL_MAX_LEN 512
#define PLUGIN_RELEASE_TIME_MAX_LEN 32
#define PLUGIN_MD5_DIGEST_LEN 16
#define PLUGIN_SIGNATURE_MAX_LEN 24
#define PLUGIN_COMPONETS_MAX_NUM 12
#define PLUGIN_HW_ID_MAX_NUM 24
#define PLUGIN_FW_ID_MAX_NUM 24
#define HW_ID_MAX_LEN	40
#define FW_ID_MAX_LEN	40

/* update flag, 0xAABBCCDD means updating */
#define IS_UPDATE_FIRMWARE 0xAABBCCDD
/* 0xFFFFFFFF means general reboot  */
#define NO_UPDATE_FIRMWARE 0xFFFFFFFF

#define SLP_DEBUG 0
#if SLP_DEBUG
#define MSG_ERR printf
#define MSG_LOG printf
#else
#define MSG_ERR(...)
#define MSG_LOG(...)
#endif

#define SHOW_USAGE printf

enum UC_PATH_TYPE
{
	PATH_IS_DIR,
	PATH_IS_FILE,
	UC_PATH_TYPE_MAX,
};

typedef struct _UC_BIN_HEADER_
{
	unsigned int updateFlag;
	unsigned int magic;
	unsigned short ver;
	unsigned short rsv;
	unsigned int length;
} UC_BIN_HEADER;

typedef struct _PLUGIN_INFO_
{
	unsigned int flashSize;
	char pluginId[PLUGIN_ID_MAX_LEN];
	char name[PLUGIN_NAME_MAX_LEN];
	char version[PLUGIN_VERSION_MAX_LEN];
	char author[PLUGIN_AUTHOR_MAX_LEN];
	char tag[PLUGIN_TAG_MAX_LEN];
	char description[PLUGIN_DESC_MAX_LEN];
	char updateLog[PLUGIN_UPDATE_LOG_MAX_LEN];
	char iconUrl[PLUGIN_ICON_URL_MAX_LEN];
	char dataUrl[PLUGIN_DATA_URL_MAX_LEN];
	char releaseTime[PLUGIN_RELEASE_TIME_MAX_LEN];
	char md5[PLUGIN_MD5_DIGEST_LEN];
	char signature[PLUGIN_SIGNATURE_MAX_LEN];
	char components[PLUGIN_COMPONETS_MAX_NUM][MAX_FILENAME_LEN];
	char hwIdList[PLUGIN_HW_ID_MAX_NUM][HW_ID_MAX_LEN];
	char fwIdList[PLUGIN_FW_ID_MAX_NUM][FW_ID_MAX_LEN];
} PLUGIN_INFO;

enum PLUGIN_OPT_TYPE
{
	MAKE_PLUGIN_OPT = 0,
	INST_PLUGIN_OPT = 1,
};

#define FREE_P(x) \
		do{\
			if (NULL != (x)){	\
				free(x);	\
				(x) = NULL;	\
			}\
		}while(0)

#endif



