BOARDNAME:=AK39XXEV330 rt-thread ref boards
FEATURES+=rt-thread
KERNEL_CC:=arm-eabi-gcc
KERNEL_CROSS:=arm-eabi-

#RT-Thread CLFAGS，剩下的在package-defaults.mk中定义
CFLAGS:=-O2 -mcpu=arm926ej-s -std=c99 -mlittle-endian -fno-short-enums -fno-builtin -nostdlib -static -nostartfiles -mlong-calls
RTOS_VERSION:=3.1.4

# 重载为rt-thread的configure方法，用scons解析内核根目录的.config
define Kernel/Configure
	@if [ \! -n $(PR_NAME) ]; then \
		echo "ERROR:PR_NAME NOT specified "; \
		exit 1; \
	fi
	@if [ \! -e $(T_KERNEL_CONFIG) ]; then \
		echo "ERROR:file $(T_KERNEL_CONFIG) was NOT found "; \
		exit 1; \
	fi
	cp $(T_KERNEL_CONFIG) $(RTOS_DIR)/.config
	export RTT_EXEC_PATH=$(call qstrip,$(CONFIG_TOOLCHAIN_ROOT)/bin); \
	cd $(RTOS_DIR)/bsp/anyka; \
	scons --useconfig=../../.config
endef

# 重载rt-thread的内核编译方法
define Kernel/CompileModules
	export RTT_EXEC_PATH=$(call qstrip,$(CONFIG_TOOLCHAIN_ROOT)/bin); \
	cd $(RTOS_DIR)/bsp/anyka; \
	scons; \
	cp ../../librt-thread.a ../../../; \
	cd dtc; \
	./build.sh; \
	cp dtb/EVB_CBD_AK3918EV33x_V1.0.0.dtb ../../../../skyOS.dtb
endef

define Target/Description
	Build firmware images for anyka rt-thread based boards.
endef

# 重载rt-thread的img链接方法
define Kernel/CompileImage
	rm -rf $(KERNEL_BUILD_DIR)/libraries
	mkdir -p $(KERNEL_BUILD_DIR)/libraries
	$(CP) $(STAGING_DIR)/usr/lib/nvmp/* $(KERNEL_BUILD_DIR)/libraries/
	$(call Kernel/CompileImage/Extract_Libraries)
	$(KERNEL_CROSS)ld -O2 -gc-sections -Map $(KERNEL_BUILD_DIR)/maps.txt -cref -u system_vectors -T $(PLATFORM_DIR)/image/link.lds -o $(KERNEL_BUILD_DIR)/skyOS.elf `find $(KERNEL_BUILD_DIR)/libraries/ -name "*.*o"` --whole-archive --start-group $(KERNEL_BUILD_DIR)/librt-thread.a --end-group --no-whole-archive $(CONFIG_LIBC_ROOT_DIR)/lib/libc.a  $(CONFIG_LIBC_ROOT_DIR)/lib/libm.a  $(CONFIG_LIBGCC_ROOT_DIR)/libgcc.a
	$(KERNEL_CROSS)objcopy -R .apply_head -R .apply_tail -O binary $(KERNEL_BUILD_DIR)/skyOS.elf $(KERNEL_BUILD_DIR)/skyOS.bin
	if [ -f $(KERNEL_BUILD_DIR)/skyOS.bin.lzma ];then rm -f $(KERNEL_BUILD_DIR)/skyOS.bin.lzma;fi
	xz --format=lzma -z -k $(KERNEL_BUILD_DIR)/skyOS.bin
	mkimage -A arm -O linux -T kernel -C lzma -a 0x80000000 -e 0x80000000 -n "RTT-3.1.4" -d $(KERNEL_BUILD_DIR)/skyOS.bin.lzma $(KERNEL_BUILD_DIR)/zImage
endef

define Target/Description
	Build firmware images for  ak39xxev330 rtthread based boards.
endef


