BOARDNAME:=AK39XXEV330 alios-things ref boards
FEATURES+=alios-things
KERNEL_CC:=arm-none-gcc
KERNEL_CROSS:=arm-none-

CFLAGS:= -mlittle-endian -mcpu=arm926ej-s -mfpu=auto -mfloat-abi=soft -fno-delete-null-pointer-checks -mno-unaligned-access -w -fno-short-enums -fno-builtin-memcopy -fno-builtin-memmove -fno-builtin-memset -ggdb -Os  -Wall -fsigned-char -ffunction-sections -fdata-sections -fno-common -std=gnu11 -nostdlib -static -nostartfiles  -mlong-calls
RTOS_VERSION:=3.2.0

# 重载为alios-things的configure方法
define Kernel/Configure
	@if [ \! -n $(PR_NAME) ]; then \
		echo "ERROR:PR_NAME NOT specified "; \
		exit 1; \
	fi
	@if [ \! -e $(T_KERNEL_CONFIG) ]; then \
		echo "ERROR:file $(T_KERNEL_CONFIG) was NOT found "; \
		exit 1; \
	fi
	cp $(T_KERNEL_CONFIG) $(RTOS_DIR)/.config
endef

# 重载alios-things的内核编译方法
define Kernel/CompileModules
	cd $(RTOS_DIR)/; \
	export ANYKA_TOOLCHAIN_PATH=$(call qstrip,$(CONFIG_TOOLCHAIN_ROOT)/); \
	./build/scripts/build_kernel.sh sky39ev33x DEBUG_ON; \
	cp ./out/alios_kernel@sky39ev33x-mkkernel/binary/alios_kernel@sky39ev33x-mk.kernel.bin $(KERNEL_BUILD_DIR)/alios.bin; \
	cp ./out/alios_kernel@sky39ev33x-mkkernel/binary/alios_kernel@sky39ev33x-mk.kernel.elf $(KERNEL_BUILD_DIR)/alios.elf; \
	cp ./out/alios_kernel@sky39ev33x-mkkernel/binary/alios_kernel@sky39ev33x-mk.kernel.map $(KERNEL_BUILD_DIR)/alios.map; \
	cd ./dtc; \
	./build.sh; \
	cp ./dtb/EVB_CBD_AK3918EV33x_V1.0.0.dtb $(KERNEL_BUILD_DIR)/skyOS.dtb
endef

define Target/Description
	Build firmware images for anyka alios-things based boards.
endef

ALIOS_USER_LIB_DIR := $(CONFIG_LIBC_ROOT_DIR)/lib/alios
ALIOS_ULIB := $(shell find $(ALIOS_USER_LIB_DIR)/ -maxdepth 1 -name *.a)
ALIOS_CLIB := $(CONFIG_LIBC_ROOT_DIR)/lib/libc.a  $(CONFIG_LIBC_ROOT_DIR)/lib/libm.a  $(CONFIG_LIBGCC_ROOT_DIR)/libgcc.a


# 重载alios-things的img链接方法，先链接user elf再打包kernel image
define Kernel/CompileImage
	@echo ---------------------[build alios user elf]----------------------------------
	rm -rf $(KERNEL_BUILD_DIR)/libraries
	mkdir -p $(KERNEL_BUILD_DIR)/libraries
	$(CP) $(STAGING_DIR)/usr/lib/nvmp/* $(KERNEL_BUILD_DIR)/libraries/
	$(CP) $(PLATFORM_SUBDIR)/*.ld $(KERNEL_BUILD_DIR)/
	cd $(KERNEL_BUILD_DIR);$(KERNEL_CROSS)ld -T $(PLATFORM_SUBDIR)/alios_app.ld -Map $(KERNEL_BUILD_DIR)/user.map -no-enum-size-warning -o $(KERNEL_BUILD_DIR)/user.elf --whole-archive --start-group `find $(KERNEL_BUILD_DIR)/libraries/ -name "*.a"` $(ALIOS_ULIB) --end-group --no-whole-archive $(ALIOS_CLIB) --gc-sections
	$(KERNEL_CROSS)strip -o $(KERNEL_BUILD_DIR)/user.strip.elf $(KERNEL_BUILD_DIR)/user.elf
	$(CP) $(KERNEL_BUILD_DIR)/user.strip.elf $(TARGET_DIR)/usr/

	@echo ---------------------[build alios image]----------------------------------
	mkimage -A arm -O linux -T kernel -C none -a 0x80000000 -e 0x80000000 -n "AliOS Things 3.2" -d $(KERNEL_BUILD_DIR)/alios.bin $(KERNEL_BUILD_DIR)/uImage

	@echo ---------------------[build alios zimage]---------------------------------
	xz --format=lzma -z -k $(KERNEL_BUILD_DIR)/alios.bin
	mkimage -A arm -O linux -T kernel -C lzma -a 0x80000000 -e 0x80000000 -n "Alios Things 3.2" -d $(KERNEL_BUILD_DIR)/alios.bin.lzma $(KERNEL_BUILD_DIR)/zImage
	@rm $(KERNEL_BUILD_DIR)/alios.bin.lzma

	mv $(KERNEL_BUILD_DIR)/zImage $(KERNEL_BUILD_DIR)/tmp_zImage
	dd if=$(KERNEL_BUILD_DIR)/skyOS.dtb of=$(KERNEL_BUILD_DIR)/zImage bs=4096 conv=fsync conv=notrunc
	dd if=$(KERNEL_BUILD_DIR)/tmp_zImage of=$(KERNEL_BUILD_DIR)/zImage bs=4096 seek=12 conv=fsync conv=notrunc
	rm $(KERNEL_BUILD_DIR)/tmp_zImage
endef

define Target/Description
	Build firmware images for  ak39xxev330 rtthread based boards.
endef


