#
# Copyright (C) 2006-2011 OpenWrt.org
#
# This is free software, licensed under the GNU General Public License v2.
# See /LICENSE for more information.
#

ifeq ($(__target_inc),)
  include $(INCLUDE_DIR)/rtos-target.mk
endif

ifeq ($(DUMP),1)
  KERNEL?=<KERNEL>
  BOARD?=<BOARD>
  RTOS_VERSION?=<RTOS_VERSION>
else
  KERNEL_CC?=$(TARGET_CC)
  KERNEL_CROSS?=$(TARGET_CROSS)
  KERNEL_BUILD_DIR ?= $(BUILD_DIR_BASE)/$(call qstrip,$(CONFIG_RTOS))-$(BOARD)$(if $(SUBTARGET),_$(SUBTARGET))$(if $(BUILD_SUFFIX),_$(BUILD_SUFFIX))
  RTOS_DIR ?= $(KERNEL_BUILD_DIR)/$(call qstrip,$(CONFIG_RTOS))-$(RTOS_VERSION)

  ifneq ($(TARGET_BUILD),1)
    PKG_BUILD_DIR ?= $(KERNEL_BUILD_DIR)/$(PKG_NAME)$(if $(PKG_VERSION),-$(PKG_VERSION))
  endif
endif

ifeq (,$(RTOS_KARCH))
  RTOS_KARCH=$(strip $(subst i386,x86,$(subst armeb,arm,$(subst mipsel,mips,$(subst mips64,mips,$(subst mips64el,mips,$(subst sh2,sh,$(subst sh3,sh,$(subst sh4,sh,$(ARCH))))))))))
endif


define KernelPackage/Defaults
  FILES:=
  AUTOLOAD:=
endef

define KernelPackage
  NAME:=$(1)
  $(eval $(call Package/Default))
  $(eval $(call KernelPackage/Defaults))
  $(eval $(call KernelPackage/$(1)))
  $(eval $(call KernelPackage/$(1)/$(BOARD)))

  define Package/kmod-$(1)
    TITLE:=$(TITLE)
    SECTION:=kernel
    CATEGORY:=Kernel modules
    DESCRIPTION:=$(DESCRIPTION)
    VERSION:=$(if $(PKG_VERSION),$(PKG_VERSION)-)$(if $(PKG_RELEASE),$(PKG_RELEASE))
    $(call KernelPackage/$(1))
    $(call KernelPackage/$(1)/$(BOARD))
  endef

  ifdef KernelPackage/$(1)/description
    define Package/kmod-$(1)/description
$(call KernelPackage/$(1)/description)
    endef
  endif

  ifdef KernelPackage/$(1)/config
    define Package/kmod-$(1)/config
$(call KernelPackage/$(1)/config)
    endef
  endif

  ifdef KernelPackage/$(1)/install
    define Package/kmod-$(1)/install
$(call KernelPackage/$(1)/install,$$(1))
    endef
  endif
endef

