#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <errno.h>
#include <config.h>
/*#include <asm/arch/sfc.h>*/
#include "nand_common.h"
#include "nand_param.h"

static struct nand_desc **nand = NULL;

static void file_head_print(void)
{
	printf("/*\n");
	printf(" * DO NOT MODIFY.\n");
	printf(" *\n");
	printf(" * This file was generated by sfc_nand_params\n");
	printf(" *\n");
	printf(" */\n");
	printf("\n");

	printf("#ifndef __SFC_NAND_PARAMS_H\n");
	printf("#define __SFC_NAND_PARAMS_H\n");
}

static void file_end_print(void)
{
	printf("#endif\n");
}

int nand_register(struct nand_desc *curr_nand) {

	static int count = 0;
	if(!curr_nand->id_manufactory &&
	   !curr_nand->device_counts &&
	    !curr_nand->device) {
		printf("ERR: add nand device failed, please check your nand desc\n");
		return -ENODEV;
	}

	if(count < sizeof(nand_param))
		nand[count++] = curr_nand;
	else {
		printf("nand_register function use err\n");
		return -EINVAL;
	}
	return 0;
}

static int print_nand_param(void) {

	int i = 0;
	printf("static struct spl_nand_param nand_param[] = {\n");
	for(i = 0; i < sizeof(nand_param) / sizeof(void *); i++) {
		if(!nand[i]) {
			printf("nand_desc addr error, please check your nand desc add\n");
			return -ENODEV;
		}
		{
			struct device_struct *device = nand[i]->device;
			int count = 0;
			for(count = 0; count < nand[i]->device_counts; count++) {
				printf("\t\t {\n");
				printf("\t\t\t .id_manufactory = 0x%02x,\n", nand[i]->id_manufactory);
				printf("\t\t\t .device_id = 0x%02x,\n", device->device_id);
				printf("\t\t\t .pagesize = %u,\n", device->page_size);
				printf("\t\t\t .addrlen = 0x%02x,\n", device->addr_len);
				printf("\t\t\t .ecc_bit = 0x%02x,\n", device->ecc_bit);
				printf("\t\t\t .bit_counts = 0x%02x,\n", device->bit_counts);
				printf("\t\t\t .eccstat_count = 0x%02x,\n", device->eccstat_count);
				printf("\t\t\t .eccerrstatus = {");
				while(device->eccstat_count--)
					printf("0x%02x, ", *(device->eccerrstatus++));
				printf("}\n");
				printf("\t\t },\n");
				device++;
			}
		}
	}
	printf("};\n");
}

int main(void) {
	int i = 0;
	nand = calloc(sizeof(nand_param) / sizeof(void *), sizeof(void *));
	if(!nand) {
		perror("alloc nand_desc addr space failed");
		return -1;
	}

	for(i = 0; i < sizeof(nand_param) / sizeof(void *); i++) {
		if(((int (*)())nand_param[i])()) {
			printf("ERR: register nand desc failed !\n");
		    	return -1;
		}
	}

	file_head_print();
	print_nand_param();
	file_end_print();

	return 0;
}




