# configs/compile.mk used due to compile code different according to platform

UBOOT_SOC_TYPE:=$(if $(CONFIG_TARGET_ingenic_t23),t23)

BOARD_CONFIG:=isvp_t23n_sfcnor

ifeq ($(CONFIG_COMPILE_factory_boot),y)
define Build/Prepare/factory_boot
	mkdir -p $(FACTORYBOOT_BUILD_DIR)
	$(CP) $(strip $(PKG_SRC_DIR))/src/* $(FACTORYBOOT_BUILD_DIR)/;
ifneq ($(CONFIG_FACTORY_BOOT_HTTP_CLIENT)$(CONFIG_FACTORY_BOOT_HTTPS_CLIENT),)
	$(CP) $(TOPDIR)/product_config/$(PR_NAME)/isp_config/Default-devName_Default-hwVer/base-files/etc/encrypt_key  \
		$(FACTORYBOOT_BUILD_DIR)/lib_uip/apps/httpd/webs/common/encrypt_key.cfg;
endif
	find $(FACTORYBOOT_BUILD_DIR)/ -name ".svn" | xargs rm -rf
endef
define Build/Configure/factory_boot
	($(foreach var,$(strip $(FACTORYBOOT_MAKEOPTS)), export $(var);) \
		$(MAKE) -C $(FACTORYBOOT_BUILD_DIR) mrproper \
			CONFIG_COMPILE_MODE=FACTORY_BOOT_COMPILE V=1);

endef
define Build/Compile/factory_boot
	(export STAGING_DIR_HOST=$(STAGING_DIR_HOST); \
		$(foreach var,$(strip $(FACTORYBOOT_MAKEOPTS)), export $(var);)\
		$(MAKE) -C $(FACTORYBOOT_BUILD_DIR) $(BOARD_CONFIG) \
		CONFIG_COMPILE_MODE=FACTORY_BOOT_COMPILE V=1);
endef
define Package/bootloader/install/factory_boot
	$(CP) $(FACTORYBOOT_BUILD_DIR)/$(FACTORY_BOOT_BINARY) $(KERNEL_BUILD_DIR)/factory_boot.bin
	$(CP) $(FACTORYBOOT_BUILD_DIR)/$(FACTORY_BOOT_BINARY) $(BIN_DIR)/$(FACTORY_BOOT_IMAGE)	
endef
endif

