#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "tool-util.h"
#include "dictionary.h"
#include "libiniparser.h"
#include "command.h"
#include "global_data.h"
#include "environment.h"

dictionary *dict;
struct platform_info info;
char *inifile;

//parse from ini file [path]
char *root_directory;
char *image_directory;
char *script_file;
char *outpath;

int bintype = 0;

gd_t *gd;

extern int nandbin_k6lite(int argc, char *argv[]);
extern int emmcbin(int argc, char *argv[]);

static void usage(void)
{
	printf("\n");
	printf("  usage\n\n");
	printf("  ./Mstarbin [-e | -n | -v] [.ini file path]\n");
	printf("      -v: check version\n");
	printf("      -e: make emmc bin\n");
	printf("      -n: make nand bin\n");
    printf("      -s: make spinand bin\n");
	printf("      Example1(check version): ./Mstarbin -v\n");
	printf("      Example1(make emmc bin file): ./Mstarbin -e /home/emmcupgrade.ini\n");
	printf("      Example2(make nand bin file): ./Mstarbin -n /home/spinandupgrade.ini\n");
    printf("      Example2(make nand bin file): ./Mstarbin -n /home/nandupgrade.ini\n\n");
}

int main(int argc, char *argv[])
{
	int ret = 0;

	if(argc < 2){
		usage();
		return;
	}

	if(argc == 2 && strcmp(argv[1], "-v") == 0){
		printf("version: %s\n", "20161209");
		return ret;
	}

	if(argc < 3){
		usage();
		return 0;
	}

	if(strcmp(argv[1], "-k") == 0){
		bintype = NANDBIN;
		ret = nandbin_k6lite(argc, argv);
		if(ret < 0){
			printf("[%s]: Make nand bin failed\n", __func__);
			return 0;
		}
	}
	else if(strcmp(argv[1], "-e") == 0){
		bintype = EMMCBIN;
		ret = emmcbin(argc, argv);
		if(ret < 0){
			printf("[%s]: Make emmc bin failed\n", __func__);
			return 0;
		}
	}
    else if(strcmp(argv[1], "-n") == 0){
		bintype = EMMCBIN;
		ret = nandbin(argc, argv);
		if(ret < 0){
			printf("[%s]: Make spinand bin failed\n", __func__);
			return 0;
		}
	}
	else{
		usage();
		return 0;
	}

	return 0;
}
