/***********************************************************
*
* Copyright (C), 2010-2014, TP-LINK TECHNOLOGIES CO., LTD.
* All rights reserved.
*
* File name  : tar-handler.h
* Version	 : 1.0
* Description: header file of compress-handler
*
* Author	 : Wang FuYu <wangfuyu@tp-link.net>
* Create Date: 2014-09-16
*
* History	 :
*------------------------------------------------------------
*
*01, 16Sep14, Wang FuYu, create file.
************************************************************/
#ifndef _TAR_HANDLER_H_
#define _TAR_HANDLER_H_

#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#define MAX_NAME_LEN 		64
#define MAX_EFS_ENTRY_NUM 	64
#define MAX_EFS_FOLDERS_NUM	64

#define EFS_ROOT_LEVEL 			1
#define EFS_ENTRY_TYPE_FOLDER 	0
#define EFS_ENTRY_TYPE_FILE 	1

typedef struct _FILE_PRO_
{
	unsigned int start;		/* offset to efsHeader. */
	unsigned int length;	/* length of file content */
}FILE_PRO;

typedef struct _FOLDER_PRO_
{
	unsigned int level;		/* depth of folder in dir tree, root's level is 1 */
}FOLDER_PRO;

typedef struct _EFS_ENTRY_
{
	unsigned char type;			/* 0 folder; 1 file; */
	unsigned int parentIndex;	/* node's father */
	char name[MAX_NAME_LEN];	/* node name, do not include '/' */

	union
	{
		FILE_PRO filePro;
		FOLDER_PRO folderPro;
	};
}EFS_ENTYR;

typedef struct _EFS_HEADER_
{
	unsigned int entryNum;    				/* node numuber of dir tree */
	EFS_ENTYR efsEntry[MAX_EFS_ENTRY_NUM];	/* node information of dir tree */
}EFS_HEADER;

typedef struct _ENTRY_INFO_
{
	char path[MAX_FILENAME_LEN];			/* absolute path */
	unsigned int level;
	unsigned int indexInImage;
}ENTRY_INFO;

/* folder level info */
typedef struct _EFS_FOLDER_LEVEL_
{
	unsigned int num;						/* folder level number */
	ENTRY_INFO entryInfo[MAX_EFS_FOLDERS_NUM];
}EFS_FOLDER_LEVEL;

/* EFS FILE HEAER INFORMATION */
typedef struct _EFS_FILE_
{
	unsigned int type;
	unsigned int start;
	unsigned int length;
}EFS_FILE;

/* image header info */
typedef struct _IMAGE_HEADER_
{
	unsigned int imgLen;
	EFS_FILE efsFiles;
}HEADER_TAG;

/* according entry msg tree, write file to buf */
int writeEfsEntriesToBuf(unsigned char *buf, char *filePathPrefix, int *compressLen);

/* create entry msg tree */
int mkEfsEntry(char* container, unsigned int *imgFileDataSize);

/* write buf content to file */
int writeBufToFile(char* filePath, unsigned char* buf, int len);

/* pack uc file */
unsigned char *packPluginIpk(char *srcDirPath, int *srcCompressBufLen);

/* unpack uc file */
int unpackUciCfg(unsigned char *unpackSrcDataBuf, int unpackSrcDataLen, char *dstDirPath);

#endif


