#include<linux/platform_device.h>
#include <mach/jzvo.h>
#include "board_base.h"

/* 480i */
static struct jzvo_config innersync525i = {
	.config_name		= INNERSYNC_525I,
	.xres		= 720,
	.yres		= 480,
	.clk		= 27 * MHZ,
	//.bw			= 134 - 4,
	.bw			= 134,
	.aw			= 720,
	.tbh0		= 17,
	.ah0		= 243,
	.bbh0		= 2,
	.tbh1		= 17,
	.ah1		= 243,
	.bbh1		= 3,
	.syncs		= INNER_SYNC,
	.ycpos		= LEEND,
	//.ycpos		= BIGEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.progr		= 0,
	.fseq		= TOPFST,
	.btmode		= BT656,
	//.btmode		= BT1120,
};

/* 576i */
static struct jzvo_config innersync625i = {
	.config_name		= INNERSYNC_625I,
	.xres		= 720,
	.yres		= 576,
	.clk		= 27 * MHZ,
	//.bw			= 140 - 4,
	.bw			= 140,
	.aw			= 720,
	.tbh0		= 22,
	.ah0		= 288,
	.bbh0		= 2,
	.tbh1		= 23,
	.ah1		= 288,
	.bbh1		= 2,
	.syncs		= INNER_SYNC,
	//.ycpos		= BIGEND,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.progr		= 0,
	.fseq		= TOPFST,
	.btmode		= BT656,
	//.btmode		= BT1120,
};

/* 720P */
static struct jzvo_config innersync720p24 = {
	.config_name		= INNERSYNC_720P24,
	.xres		= 1280,
	.yres		= 720,
	.clk		= 74.25 * MHZ,
	.bw			= 4125 - 1280 - 12,
	.aw			= 1280,
	.tbh0		= 25,
	.ah0		= 720,
	.bbh0		= 5,
	.syncs		= INNER_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.addcrc		= 1,
	.addln		= 1,
};

static struct jzvo_config innersync720p25 = {
	.config_name		= INNERSYNC_720P25,
	.xres		= 1280,
	.yres		= 720,
	.clk		= 74.25 * MHZ,
	.bw			= 3960 - 1280 - 12,
	.aw			= 1280,
	.tbh0		= 25,
	.ah0		= 720,
	.bbh0		= 5,
	.syncs		= INNER_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.addcrc		= 1,
	.addln		= 1,
};

static struct jzvo_config innersync720p30 = {
	.config_name		= INNERSYNC_720P30,
	.xres		= 1280,
	.yres		= 720,
	.clk		= 74.25 * MHZ,
	.bw			= 2020 - 12,
	.aw			= 1280,
	.tbh0		= 25,
	.ah0		= 720,
	.bbh0		= 5,
	.syncs		= INNER_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.addcrc		= 1,
	.addln		= 1,
};

static struct jzvo_config innersync720p60 = {
	.config_name		= INNERSYNC_720P60,
	.xres		= 1280,
	.yres		= 720,
	.clk		= 74.25 * MHZ,
	.bw			= 370 - 12,
	.aw			= 1280,
	.tbh0		= 25,
	.ah0		= 720,
	.bbh0		= 5,
	.syncs		= INNER_SYNC,
	//.ycpos		= LEEND,
	.ycpos		= BIGEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.addcrc		= 1,
	.addln		= 1,
};

/* 1080P */
static struct jzvo_config innersync1080p24 = {
	.config_name		= INNERSYNC_1080P24,
	.xres		= 1920,
	.yres		= 1080,
	.clk		= 74.25 * MHZ,
	.bw			= 830 - 12,
	.aw			= 1920,
	.tbh0		= 41,
	.ah0		= 1080,
	.bbh0		= 4,
	.syncs		= INNER_SYNC,
	//.ycpos		= LEEND,
	.ycpos		= BIGEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.addcrc		= 1,
	.addln		= 1,
};

static struct jzvo_config innersync1080p25 = {
	.config_name		= INNERSYNC_1080P25,
	.xres		= 1920,
	.yres		= 1080,
	.clk		= 74.25 * MHZ,
	.bw			= 720 - 12,
	.aw			= 1920,
	.tbh0		= 41,
	.ah0		= 1080,
	.bbh0		= 4,
	.syncs		= INNER_SYNC,
	//.ycpos		= LEEND,
	.ycpos		= BIGEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.addcrc		= 1,
	.addln		= 1,
};

static struct jzvo_config innersync1080p30 = {
	.config_name		= INNERSYNC_1080P30,
	.xres		= 1920,
	.yres		= 1080,
	.clk		= 74.25 * MHZ,
	.bw			= 280 - 4 - 4 - 4,
	.aw			= 1920,
	.tbh0		= 41,
	.ah0		= 1080,
	.bbh0		= 4,
	.syncs		= INNER_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.addcrc		= 1,
	.addln		= 1,
};

static struct jzvo_config innersync1080i50 = {
	.config_name		= INNERSYNC_1080I50,
	.xres		= 1920,
	.yres		= 1080,
	.clk		= 74.25 * MHZ,
	.bw			= 720 - 12,
	.aw			= 1920,
	.tbh0		= 20,
	.ah0		= 540,
	.bbh0		= 3,
	.tbh1		= 20,
	.ah1		= 540,
	.bbh1		= 2,
	.syncs		= INNER_SYNC,
	//.ycpos		= LEEND,
	.ycpos		= BIGEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 0,
	.fseq		= TOPFST,
	.addcrc		= 1,
	.addln		= 1,
};

static struct jzvo_config innersync1080i60 = {
	.config_name		= INNERSYNC_1080I60,
	.xres		= 1920,
	.yres		= 1080,
	.clk		= 74.25 * MHZ,
	.bw			= 280 - 12,
	.aw			= 1920,
	.tbh0		= 20,
	.ah0		= 540,
	.bbh0		= 3,
	.tbh1		= 20,
	.ah1		= 540,
	.bbh1		= 2,
	.syncs		= INNER_SYNC,
	//.ycpos		= LEEND,
	.ycpos		= BIGEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 0,
	.fseq		= TOPFST,
	.addcrc		= 1,
	.addln		= 1,
};

static struct jzvo_config outsync525i = {
	.config_name		= OUTSYNC_525I,
	.xres		= 720,
	.yres		= 480,
	.clk		= 27 * MHZ,
	.bw			= 138,
	.aw			= 720,
	.tbh0		= 21,
	.ah0		= 240,
	.bbh0		= 2,
	.tbh1		= 21,
	.ah1		= 240,
	.bbh1		= 1,
	.hdes		= 138,
	.hdee		= 138+720,
	.vdes0		= 21,
	.vdee0		= 261,
	.vdes1		= 21,
	.vdee1		= 261,
	.hps		= 19,
	.hpe		= 19+62,
	.vps0		= 3,
	.vpe0		= 6,
	.vps1		= 2,
	.vpe1		= 5,
	.vpss0		= 19,
	.vpss1		= 429 + 19,
	.syncs		= OUT_SYNC,
	.ycpos		= LEEND,
	//.ycpos		= BIGEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT656,
	//.btmode		= BT1120,
	.progr		= 0,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
};

static struct jzvo_config outsync625i = {
	.config_name		= OUTSYNC_625I,
	.xres		= 720,
	.yres		= 576,
	.clk		= 27 * MHZ,
	.bw			= 144,
	.aw			= 720,
	.tbh0		= 22,
	.ah0		= 288,
	.bbh0		= 2,
	.tbh1		= 23,
	.ah1		= 288,
	.bbh1		= 2,
	.hdes		= 144,
	.hdee		= 720 + 144,
	.vdes0		= 22,
	.vdee0		= 310,
	.vdes1		= 23,
	.vdee1		= 311,
	.hps		= 12,
	.hpe		= 75,
	.vps0		= 0,
	.vpe0		= 3,
	.vps1		= 0,
	.vpe1		= 3,
	.vpss0		= 12,
	.vpss1		= 432 + 12,
	.syncs		= OUT_SYNC,
	.ycpos		= LEEND,
	//.ycpos		= BIGEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.progr		= 0,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
	.btmode		= BT656,
	//.btmode		= BT1120,
};

static struct jzvo_config outsync720p60 = {
	.config_name		= OUTSYNC_720P60,
	.xres		= 1280,
	.yres		= 720,
	.clk		= 74.25 * MHZ,
	.bw			= 370,
	.aw			= 1280,
	.tbh0		= 25,
	.ah0		= 720,
	.bbh0		= 5,
	.hdes		= 370,
	.hdee		= 370 + 1280,
	.vdes0		= 25,
	.vdee0		= 745,
	.hps		= 110,
	.hpe		= 110 + 40,
	.vps0		= 0,
	.vpe0		= 5,
	.vpss0		= 110,
	.syncs		= OUT_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
	.hsyncp		= HIGH_ACT,
	.vsyncp		= HIGH_ACT,
};

static struct jzvo_config outsync720p50 = {
	.config_name		= OUTSYNC_720P50,
	.xres		= 1280,
	.yres		= 720,
	.clk		= 74.25 * MHZ,
	.bw			= 700, //370,
	.aw			= 1280,
	.tbh0		= 25,
	.ah0		= 720,
	.bbh0		= 5,
	.hdes		= 700, //370,
	.hdee		= 700 + 1280, //370 + 1280,
	.vdes0		= 25,
	.vdee0		= 745,
	.hps		= 440, //110,
	.hpe		= 440 + 40, //110 + 40,
	.vps0		= 0,
	.vpe0		= 5,
	.vpss0		= 440, //110,
	.syncs		= OUT_SYNC,
	//.ycpos		= LEEND,
	.ycpos		= BIGEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
	.hsyncp		= HIGH_ACT,
	.vsyncp		= HIGH_ACT,
};

static struct jzvo_config outsync720p30 = {
	.config_name		= OUTSYNC_720P30,
	.xres		= 1280,
	.yres		= 720,
	.clk		= 74.25 * MHZ,
	.bw			= 1650 + 110 + 40 + 220, //370, 110 + 40 + 220
	.aw			= 1280,
	.tbh0		= 25,
	.ah0		= 720,
	.bbh0		= 5,
	.hdes		= 1650 + 110 + 40 + 220, //370
	.hdee		= 1650 + 110 + 40 + 220 + 1280, //370 + 1280,
	.vdes0		= 25,
	.vdee0		= 745,
	.hps		= 1650 + 110, //110,
	.hpe		= 1650 + 110 + 40, //110 + 40,
	.vps0		= 0,
	.vpe0		= 5,
	.vpss0		= 1650 + 110, //110,
	.syncs		= OUT_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
	.hsyncp		= HIGH_ACT,
	.vsyncp		= HIGH_ACT,
};

static struct jzvo_config outsync720p24 = {
	.config_name		= OUTSYNC_720P24,
	.xres		= 1280,
	.yres		= 720,
	.clk		= 74.25 * MHZ,
//	.bw			= 2475 + 110 + 40 + 220, //370, 110 + 40 + 220
	.bw			= 2475 + 110 + 40, //370, 110 + 40 + 220
	.aw			= 1280,
	.tbh0		= 25,
	.ah0		= 720,
	.bbh0		= 5,
	.hps		= 2475 + 110, //110,
	.hpe		= 2475 + 110 + 40, //110 + 40,
	.vps0		= 0,
	.vpe0		= 5,
	.vpss0		= 2475 + 110, //110,
	.syncs		= OUT_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
	.hsyncp		= HIGH_ACT,
	.vsyncp		= HIGH_ACT,
};

static struct jzvo_config outsync1080p60 = {
	.config_name		= OUTSYNC_1080P60,
	.xres		= 1920,
	.yres		= 1080,
	.clk		= 148.5 * MHZ,
	.bw			= 280,
	.aw			= 1920,
	.tbh0		= 41,
	.ah0		= 1080,
	.bbh0		= 4,
	.hdes		= 280,
	.hdee		= 280 + 1920,
	.vdes0		= 41,
	.vdee0		= 1121,
	.hps		= 88,
	.hpe		= 88 + 44,
	.vps0		= 0,
	.vpe0		= 5,
	.vpss0		= 88,
	.syncs		= OUT_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
	.hsyncp		= HIGH_ACT,
	.vsyncp		= HIGH_ACT,
};

static struct jzvo_config outsync1080p50 = {
	.config_name		= OUTSYNC_1080P50,
	.xres		= 1920,
	.yres		= 1080,
	.clk		= 148.5 * MHZ,
	.bw			= 720,
	.aw			= 1920,
	.tbh0		= 41,
	.ah0		= 1080,
	.bbh0		= 4,
	.hdes		= 280,
	.hdee		= 280 + 1920,
	.vdes0		= 41,
	.vdee0		= 1121,
	.hps		= 528,
	.hpe		= 528 + 44,
	.vps0		= 0,
	.vpe0		= 5,
	.vpss0		= 528,
	.syncs		= OUT_SYNC,
	//.ycpos		= LEEND,
	.ycpos		= BIGEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
	.hsyncp		= HIGH_ACT,
	.vsyncp		= HIGH_ACT,
};

static struct jzvo_config outsync1080p30 = {
	.config_name		= OUTSYNC_1080P30,
	.xres		= 1920,
	.yres		= 1080,
	.clk		= 74.25 * MHZ,
	.bw			= 280,
	.aw			= 1920,
	.tbh0		= 41,
	.ah0		= 1080,
	.bbh0		= 4,
	.hdes		= 280,
	.hdee		= 280 + 1920,
	.vdes0		= 41,
	.vdee0		= 1121,
	.hps		= 88,
	.hpe		= 88 + 44,
	.vps0		= 0,
	.vpe0		= 5,
	.vpss0		= 88,
	.syncs		= OUT_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
	.hsyncp		= HIGH_ACT,
	.vsyncp		= HIGH_ACT,
};

static struct jzvo_config outsync1080p24 = {
	.config_name		= OUTSYNC_1080P24,
	.xres		= 1920,
	.yres		= 1080,
	.clk		= 74.25 * MHZ,
	.bw			= 830,
	.aw			= 1920,
	.tbh0		= 41,
	.ah0		= 1080,
	.bbh0		= 4,
	.hdes		= 280,
	.hdee		= 280 + 1920,
	.vdes0		= 41,
	.vdee0		= 1121,
	.hps		= 638,
	.hpe		= 638 + 44,
	.vps0		= 0,
	.vpe0		= 5,
	.vpss0		= 638,
	.syncs		= OUT_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 1,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
	.hsyncp		= HIGH_ACT,
	.vsyncp		= HIGH_ACT,
};

static struct jzvo_config outsync1080i60 = {
	.config_name		= OUTSYNC_1080I60,
	.xres		= 1920,
	.yres		= 1080,
	.clk		= 74.25 * MHZ,
	.bw			= 280,
	.aw			= 1920,
	.tbh0		= 20,
	.ah0		= 540,
	.bbh0		= 2,
	.tbh1		= 21,
	.ah1		= 540,
	.bbh1		= 2,
	.hdes		= 280,
	.hdee		= 280 + 1920,
	.vdes0		= 20,
	.vdee0		= 560,
	.vdes1		= 21,
	.vdee1		= 561,
	.hps		= 88,
	.hpe		= 88 + 44,
	.vps0		= 0,
	.vpe0		= 5,
	.vps1		= 0,
	.vpe1		= 5,
	.vpss0		= 88,
	.vpss1		= 88 + 1100,
	.syncs		= OUT_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 0,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
	.hsyncp		= HIGH_ACT,
	.vsyncp		= HIGH_ACT,
};

static struct jzvo_config outsync1080i50 = {
	.config_name		= OUTSYNC_1080I50,
	.xres		= 1920,
	.yres		= 1080,
	.clk		= 74.25 * MHZ,
	.bw			= 720,
	.aw			= 1920,
	.tbh0		= 20,
	.ah0		= 540,
	.bbh0		= 2,
	.tbh1		= 21,
	.ah1		= 540,
	.bbh1		= 2,
	.hdes		= 720,
	.hdee		= 720 + 1920,
	.vdes0		= 20,
	.vdee0		= 560,
	.vdes1		= 21,
	.vdee1		= 561,
	.hps		= 528,
	.hpe		= 528 + 44,
	.vps0		= 0,
	.vpe0		= 5,
	.vps1		= 0,
	.vpe1		= 5,
	.vpss0		= 528,
	.vpss1		= 528 + 1320,
	.syncs		= OUT_SYNC,
	.ycpos		= LEEND,
	.ddzero		= 0,
	.buffmt		= BUFFMT,
	.btmode		= BT1120,
	.progr		= 0,
	.fseq		= TOPFST,
	.dep		= HIGH_ACT,
	.hsyncp		= HIGH_ACT,
	.vsyncp		= HIGH_ACT,
};

static struct jzvo_config *config_all[] = {
	&innersync525i,
	&innersync625i,
	&innersync720p24,
	&innersync720p25,
	&innersync720p30,
	&innersync720p60,
	&innersync1080p24,
	&innersync1080p25,
	&innersync1080p30,
	&innersync1080i50,
	&innersync1080i60,
	&outsync525i,
	&outsync625i,
	&outsync720p24,
	&outsync720p30,
	&outsync720p50,
	&outsync720p60,
	&outsync1080p24,
	&outsync1080p30,
	&outsync1080p50,
	&outsync1080p60,
	&outsync1080i50,
	&outsync1080i60,
	NULL,
};

struct jzvo_platform_data jzvo_pdata = {
		.vo_config = (void *)config_all,
};
