//<MStar Software>
//******************************************************************************
// MStar Software
// Copyright (c) 2010 - 2012 MStar Semiconductor, Inc. All rights reserved.
// All software, firmware and related documentation herein ("MStar Software") are
// intellectual property of MStar Semiconductor, Inc. ("MStar") and protected by
// law, including, but not limited to, copyright law and international treaties.
// Any use, modification, reproduction, retransmission, or republication of all 
// or part of MStar Software is expressly prohibited, unless prior written 
// permission has been granted by MStar. 
//
// By accessing, browsing and/or using MStar Software, you acknowledge that you
// have read, understood, and agree, to be bound by below terms ("Terms") and to
// comply with all applicable laws and regulations:
//
// 1. MStar shall retain any and all right, ownership and interest to MStar
//    Software and any modification/derivatives thereof.
//    No right, ownership, or interest to MStar Software and any
//    modification/derivatives thereof is transferred to you under Terms.
//
// 2. You understand that MStar Software might include, incorporate or be
//    supplied together with third party`s software and the use of MStar
//    Software may require additional licenses from third parties.  
//    Therefore, you hereby agree it is your sole responsibility to separately
//    obtain any and all third party right and license necessary for your use of
//    such third party`s software. 
//
// 3. MStar Software and any modification/derivatives thereof shall be deemed as
//    MStar`s confidential information and you agree to keep MStar`s 
//    confidential information in strictest confidence and not disclose to any
//    third party.  
//
// 4. MStar Software is provided on an "AS IS" basis without warranties of any
//    kind. Any warranties are hereby expressly disclaimed by MStar, including
//    without limitation, any warranties of merchantability, non-infringement of
//    intellectual property rights, fitness for a particular purpose, error free
//    and in conformity with any international standard.  You agree to waive any
//    claim against MStar for any loss, damage, cost or expense that you may
//    incur related to your use of MStar Software.
//    In no event shall MStar be liable for any direct, indirect, incidental or
//    consequential damages, including without limitation, lost of profit or
//    revenues, lost or damage of data, and unauthorized system use.
//    You agree that this Section 4 shall still apply without being affected
//    even if MStar Software has been modified by MStar in accordance with your
//    request or instruction for your use, except otherwise agreed by both
//    parties in writing.
//
// 5. If requested, MStar may from time to time provide technical supports or
//    services in relation with MStar Software to you for your use of
//    MStar Software in conjunction with your or your customer`s product
//    ("Services").
//    You understand and agree that, except otherwise agreed by both parties in
//    writing, Services are provided on an "AS IS" basis and the warranty
//    disclaimer set forth in Section 4 above shall apply.  
//
// 6. Nothing contained herein shall be construed as by implication, estoppels
//    or otherwise:
//    (a) conferring any license or right to use MStar name, trademark, service
//        mark, symbol or any other identification;
//    (b) obligating MStar or any of its affiliates to furnish any person,
//        including without limitation, you and your customers, any assistance
//        of any kind whatsoever, or any information; or 
//    (c) conferring any license or right under any intellectual property right.
//
// 7. These terms shall be governed by and construed in accordance with the laws
//    of Taiwan, R.O.C., excluding its conflict of law rules.
//    Any and all dispute arising out hereof or related hereto shall be finally
//    settled by arbitration referred to the Chinese Arbitration Association,
//    Taipei in accordance with the ROC Arbitration Law and the Arbitration
//    Rules of the Association by three (3) arbitrators appointed in accordance
//    with the said Rules.
//    The place of arbitration shall be in Taipei, Taiwan and the language shall
//    be English.  
//    The arbitration award shall be final and binding to both parties.
//
//******************************************************************************
//<MStar Software>
#include <linux/string.h>
#include "../../inc/common/drvNAND.h"
#include "../../inc/common/drvNAND_utl.h"

//------------------------------------------------------------------------
// 1. when this function ok, the drvNAND_SearchCIS called at the end,
//    would setup NANDINFO & PARTINFO in NAND_DRIVER.
// 2. memory for pPartInfo (512B), setup by drvNAND_get_DrvContext_PartInfo.
//------------------------------------------------------------------------

#if (defined(__VER_UNFD_FTL__)&&__VER_UNFD_FTL__)
#define NAND_READ_TIMEOUT_MAX_RETRY_CNT  3

U32 drvNAND_WriteFAT(U32 u32_SrcPhyAddr, U32 u32_StartSector, U32 u32_SectorCnt)
{
	NAND_DRIVER *pNandDrv = drvNAND_get_DrvContext_address();
	U32 u32_Err = UNFD_ST_SUCCESS;
	U8 u8_DiskNum;
	U32 u32_LogiStartSector;

#if 0
	if(u32_SrcPhyAddr&(UNFD_CACHE_LINE-1))
	{
		printf("buffer is not cache line alignment:%X\n", u32_SrcPhyAddr);
		//return UNFD_ST_ERR_NOT_ALIGN;
	}
#endif

	u8_DiskNum = UNFD_PART_FAT & (~UNFD_LOGI_PART);

	if(u32_StartSector >= pNandDrv->DiskInfo_t[u8_DiskNum].u32_SectorCnt)
	{
		printf("ERROR, NAND Invalid parameter 0\n");
		return UNFD_ST_ERR_INVALID_PARAM;
	}
	if(u32_SectorCnt > pNandDrv->DiskInfo_t[u8_DiskNum].u32_SectorCnt)
	{
		printf("ERROR, NAND Invalid parameter 1\n");
		return UNFD_ST_ERR_INVALID_PARAM;
	}
	if((u32_StartSector+u32_SectorCnt) > pNandDrv->DiskInfo_t[u8_DiskNum].u32_SectorCnt)
	{
		printf("ERROR, NAND Invalid parameter 2\n");
		return UNFD_ST_ERR_INVALID_PARAM;
	}
	u32_LogiStartSector = pNandDrv->DiskInfo_t[u8_DiskNum].u32_StartSector + u32_StartSector;


	LABEL_WRITE_FLOW:
	printf(" SecAdr:%X, %X, SecCnt:%X +\n",
		u32_LogiStartSector-pNandDrv->DiskInfo_t[u8_DiskNum].u32_StartSector, u32_LogiStartSector, u32_SectorCnt);


	printf("nand_WriteFlow\n\n");
	u32_Err = nand_WriteFlow(u32_LogiStartSector, u32_SectorCnt, u32_SrcPhyAddr);
	if(UNFD_ST_SUCCESS != u32_Err)
	{
		printf("w fail!!\n");
		goto LABEL_WRITE_FLOW;
	}

    printf("-\n\n");


	if(UNFD_ST_SUCCESS != u32_Err)
		printf("ERROR, NAND fail: %X \n", u32_Err);

	drvNAND_FlushAll();
	
	return u32_Err;
}

U32 drvNAND_ReadFAT(U32 u32_SrcPhyAddr, U32 u32_StartSector, U32 u32_SectorCnt)
{
	NAND_DRIVER *pNandDrv = drvNAND_get_DrvContext_address();
	U32 u32_Err = UNFD_ST_SUCCESS;
	U8 u8_DiskNum, u8_RetryCnt;
	U32 u32_LogiStartSector;
	U8 sgau8_NandTemp512BBuf[512];

	u8_DiskNum = UNFD_PART_FAT & (~UNFD_LOGI_PART);

	if(u32_StartSector >= pNandDrv->DiskInfo_t[u8_DiskNum].u32_SectorCnt)
	{
		printf("ERROR, NAND Invalid parameter 0\n");
		return UNFD_ST_ERR_INVALID_PARAM;
	}
	if(u32_SectorCnt > pNandDrv->DiskInfo_t[u8_DiskNum].u32_SectorCnt)
	{
		printf("ERROR, NAND Invalid parameter 1\n");
		return UNFD_ST_ERR_INVALID_PARAM;
	}
	if((u32_StartSector+u32_SectorCnt) > pNandDrv->DiskInfo_t[u8_DiskNum].u32_SectorCnt)
	{
		printf("ERROR, NAND Invalid parameter 2\n");
		return UNFD_ST_ERR_INVALID_PARAM;
	}
	u32_LogiStartSector = pNandDrv->DiskInfo_t[u8_DiskNum].u32_StartSector + u32_StartSector;


	printf(" SecAdr:%X, %X, SecCnt:%X +\n",
		u32_LogiStartSector-pNandDrv->DiskInfo_t[u8_DiskNum].u32_StartSector, u32_LogiStartSector, u32_SectorCnt);

	if(u32_SrcPhyAddr&(UNFD_CACHE_LINE-1))
	{
		printf("buffer is not cache line alignment:%X\n", u32_SrcPhyAddr);

	    u8_RetryCnt = 0;
		do
		{
			u32_Err = nand_ReadFlow(u32_LogiStartSector, 1, (U32)sgau8_NandTemp512BBuf);
			if( u32_Err == UNFD_ST_SUCCESS)
			{
				memcpy((void*)u32_SrcPhyAddr, (const void*)sgau8_NandTemp512BBuf, 512);
			}
			else if( u32_Err == UNFD_ST_ERR_R_TIMEOUT)
			{
				if(++u8_RetryCnt>NAND_READ_TIMEOUT_MAX_RETRY_CNT)
					goto LABEL_ENDREADFAT;

				printf("ERROR, NAND, retry: %X \n", u8_RetryCnt);
			}
			else
				goto LABEL_ENDREADFAT;
		}while(u32_Err != UNFD_ST_SUCCESS);

		if(u32_SectorCnt>2)
		{
		    u8_RetryCnt = 0;
			do
			{
				u32_Err = nand_ReadFlow(u32_LogiStartSector+1, u32_SectorCnt-2, (u32_SrcPhyAddr+512));
				if( u32_Err == UNFD_ST_SUCCESS)
				{
				}
				else if( u32_Err == UNFD_ST_ERR_R_TIMEOUT)
				{
					if(++u8_RetryCnt>NAND_READ_TIMEOUT_MAX_RETRY_CNT)
						goto LABEL_ENDREADFAT;

					printf("ERROR, NAND, retry: %X \n", u8_RetryCnt);
				}
				else
					goto LABEL_ENDREADFAT;
			}while(u32_Err != UNFD_ST_SUCCESS);
		}

		if(u32_SectorCnt>1)
		{
		    u8_RetryCnt = 0;
			do
			{
				u32_Err = nand_ReadFlow(u32_LogiStartSector+u32_SectorCnt-1, 1, (U32)sgau8_NandTemp512BBuf);
				if( u32_Err == UNFD_ST_SUCCESS)
				{
					memcpy((void*)(u32_SrcPhyAddr+512*(u32_SectorCnt-1)), (const void*)sgau8_NandTemp512BBuf, 512);
				}
				else if( u32_Err == UNFD_ST_ERR_R_TIMEOUT)
				{
					if(++u8_RetryCnt>NAND_READ_TIMEOUT_MAX_RETRY_CNT)
						goto LABEL_ENDREADFAT;

					printf("ERROR, NAND, retry: %X \n", u8_RetryCnt);
				}
				else
					goto LABEL_ENDREADFAT;
			}while(u32_Err != UNFD_ST_SUCCESS);
		}
	}
	else
	{
	    u8_RetryCnt = 0;
		do
		{
			u32_Err = nand_ReadFlow(u32_LogiStartSector, u32_SectorCnt, u32_SrcPhyAddr);
			if( u32_Err == UNFD_ST_SUCCESS)
			{
			}
			else if( u32_Err == UNFD_ST_ERR_R_TIMEOUT)
			{
				if(++u8_RetryCnt>NAND_READ_TIMEOUT_MAX_RETRY_CNT)
					goto LABEL_ENDREADFAT;

				printf("ERROR, NAND, retry: %X \n", u8_RetryCnt);
			}
			else
				goto LABEL_ENDREADFAT;
		}while(u32_Err != UNFD_ST_SUCCESS);
	}

LABEL_ENDREADFAT:
	printf("-\n\n");

	if(UNFD_ST_SUCCESS != u32_Err)
		printf("ERROR, NAND fail: %X \n", u32_Err);
	return u32_Err;
}


U32 drvNAND_FlushAll(void)
{
	// Flush write-back queue and erase counter
	NAND_DRIVER *pNandDrv = drvNAND_get_DrvContext_address();
	U8 u8_i;
	U32 u32_Ret;

#if UNFD_FTL_WL
	for(u8_i=0 ; u8_i<(pNandDrv->u8_Zone1SubZoneCnt+1); u8_i++)
	{
			nand_SaveEraseCounter(u8_i);
	}
#endif

#if UNFD_FTL_WBQ
	for(u8_i=0; u8_i<MAX_WBQ_CNT; u8_i++)
	{
		u32_Ret = nand_FlushWBQ(u8_i);
		if(UNFD_ST_SUCCESS != u32_Ret)
		{
			return u32_Ret;
		}
	}
#endif

	return UNFD_ST_SUCCESS;
}

#endif

