//<MStar Software>
//******************************************************************************
// MStar Software
// Copyright (c) 2010 - 2012 MStar Semiconductor, Inc. All rights reserved.
// All software, firmware and related documentation herein ("MStar Software") are
// intellectual property of MStar Semiconductor, Inc. ("MStar") and protected by
// law, including, but not limited to, copyright law and international treaties.
// Any use, modification, reproduction, retransmission, or republication of all
// or part of MStar Software is expressly prohibited, unless prior written
// permission has been granted by MStar.
//
// By accessing, browsing and/or using MStar Software, you acknowledge that you
// have read, understood, and agree, to be bound by below terms ("Terms") and to
// comply with all applicable laws and regulations:
//
// 1. MStar shall retain any and all right, ownership and interest to MStar
//    Software and any modification/derivatives thereof.
//    No right, ownership, or interest to MStar Software and any
//    modification/derivatives thereof is transferred to you under Terms.
//
// 2. You understand that MStar Software might include, incorporate or be
//    supplied together with third party`s software and the use of MStar
//    Software may require additional licenses from third parties.
//    Therefore, you hereby agree it is your sole responsibility to separately
//    obtain any and all third party right and license necessary for your use of
//    such third party`s software.
//
// 3. MStar Software and any modification/derivatives thereof shall be deemed as
//    MStar`s confidential information and you agree to keep MStar`s
//    confidential information in strictest confidence and not disclose to any
//    third party.
//
// 4. MStar Software is provided on an "AS IS" basis without warranties of any
//    kind. Any warranties are hereby expressly disclaimed by MStar, including
//    without limitation, any warranties of merchantability, non-infringement of
//    intellectual property rights, fitness for a particular purpose, error free
//    and in conformity with any international standard.  You agree to waive any
//    claim against MStar for any loss, damage, cost or expense that you may
//    incur related to your use of MStar Software.
//    In no event shall MStar be liable for any direct, indirect, incidental or
//    consequential damages, including without limitation, lost of profit or
//    revenues, lost or damage of data, and unauthorized system use.
//    You agree that this Section 4 shall still apply without being affected
//    even if MStar Software has been modified by MStar in accordance with your
//    request or instruction for your use, except otherwise agreed by both
//    parties in writing.
//
// 5. If requested, MStar may from time to time provide technical supports or
//    services in relation with MStar Software to you for your use of
//    MStar Software in conjunction with your or your customer`s product
//    ("Services").
//    You understand and agree that, except otherwise agreed by both parties in
//    writing, Services are provided on an "AS IS" basis and the warranty
//    disclaimer set forth in Section 4 above shall apply.
//
// 6. Nothing contained herein shall be construed as by implication, estoppels
//    or otherwise:
//    (a) conferring any license or right to use MStar name, trademark, service
//        mark, symbol or any other identification;
//    (b) obligating MStar or any of its affiliates to furnish any person,
//        including without limitation, you and your customers, any assistance
//        of any kind whatsoever, or any information; or
//    (c) conferring any license or right under any intellectual property right.
//
// 7. These terms shall be governed by and construed in accordance with the laws
//    of Taiwan, R.O.C., excluding its conflict of law rules.
//    Any and all dispute arising out hereof or related hereto shall be finally
//    settled by arbitration referred to the Chinese Arbitration Association,
//    Taipei in accordance with the ROC Arbitration Law and the Arbitration
//    Rules of the Association by three (3) arbitrators appointed in accordance
//    with the said Rules.
//    The place of arbitration shall be in Taipei, Taiwan and the language shall
//    be English.
//    The arbitration award shall be final and binding to both parties.
//
//******************************************************************************
//<MStar Software>
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "common.h"
#include "tool-util.h"
#include "types.h"
#include "dictionary.h"
#include "libiniparser.h"
#include "inc/common/spinand.h"

extern char *root_directory;
extern char *image_directory;
extern dictionary *dict;
extern struct platform_info info;

SPI_NAND_DRIVER_t gtSpiNandDrv;

void *drvSPINAND_get_DrvContext_address(void) // exposed API
{
  return &gtSpiNandDrv;
}

static U32 CheckSum(U8 *pu8_Data, U16 u16_ByteCnt)
{
	U32 u32_Sum = 0;

	while (u16_ByteCnt--)
		u32_Sum += *pu8_Data++;

	return u32_Sum;
}

static void dump_part_records(PARTITION_RECORD_t *records, int cnt)
{
	int i;

	if (cnt > 1024) {
		printf("[%s]: broken\n", __func__);
		return;
	}

	for (i = 0; i < cnt; i++) {
		printf( "record[%d]       : 0x%04x, 0x%04x, 0x%04x, 0x%04x\n", i,
				records[i].u16_StartBlk, records[i].u16_BlkCnt,
				records[i].u16_PartType, records[i].u16_BackupBlkCnt);
	}
}

static void dump_part_info(PARTITION_INFO_t *pPartInfo)
{
	printf("###############################################\n");
	printf("#        PART INFO                            #\n");
	printf("###############################################\n");

	printf("pPartInfo: 0x%08lx\n", (U32)pPartInfo);
	printf("u32_ChkSum      : 0x%04lx\n", pPartInfo->u32_ChkSum);
//	printf("u32_BLSectorCnt : 0x%04lx\n", pPartInfo->u32_BLSectorCnt);
//	printf("u32_OSSectorCnt : 0x%04lx\n", pPartInfo->u32_OSSectorCnt);
	printf("u16_PartCnt     : 0x%04x\n", pPartInfo->u16_PartCnt);
	printf("u16_UnitByteCnt : 0x%04x\n", pPartInfo->u16_UnitByteCnt);

	dump_part_records(pPartInfo->records, pPartInfo->u16_PartCnt);
}


/*
 * Board-specific NAND initialization.
 * - hwcontrol: hardwarespecific function for accesing control-lines
 * - dev_ready: hardwarespecific function for  accesing device ready/busy line
 * - eccmode: mode of ecc, see defines
 */
int board_spinand_init()
{
	int fd, len, ret;
	char *pni_name;
	char pni_path[128];
	struct stat st;
	PARTITION_INFO_t *ptPartInfo;

	if(MDrv_SPINAND_Init(&(gtSpiNandDrv.tSpinandInfo))){
		printf("[%s]: search nni failed\n", __func__);
		return -1;
	}

	gtSpiNandDrv.u32_column = 0;
	gtSpiNandDrv.pu8_pagebuf = (U8 *)malloc(gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt);
	gtSpiNandDrv.pu8_sparebuf = (U8 *)malloc(gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt);
	if(!gtSpiNandDrv.pu8_pagebuf || !gtSpiNandDrv.pu8_sparebuf){
		printf("[%s] Can not alloc memory for page/spare buffer\n", __func__);
		return -1;
	}

	ptPartInfo = (PARTITION_INFO_t *)gtSpiNandDrv.pu8_pagebuf;

	pni_name = iniparser_getstring(dict, "cis:pni", "Not  Set");
	if(strcmp(pni_name, "Not Set") == 0){
		printf("pni file is not set\n");
		gtSpiNandDrv.u8_HasPNI = 0;
		return 0;
	}

	sprintf(pni_path, "%s%s%s", root_directory, image_directory, pni_name);
	fd = open(pni_path, O_RDWR);
	if(fd < 0){
		printf("[%s]: Cannot open pni file %s\n", __func__, pni_path);
		return -1;
	}

	stat(pni_path, &st);
	for(len = st.st_size; len >= 0x200; len -= 0x200){
		ret = read(fd, gtSpiNandDrv.pu8_pagebuf, 0x200);
		if(ret < 0){
			printf("[%s]: read file %s failed\n", __func__, pni_path);
			return -1;
		}
#if 0
		if(ptPartInfo->u16_SpareByteCnt == gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt &&
			ptPartInfo->u16_PageByteCnt == gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt &&
			ptPartInfo->u16_BlkPageCnt == gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt &&
			ptPartInfo->u16_BlkCnt == gtSpiNandDrv.tSpinandInfo.u16_BlkCnt)
#endif
        if(1)
		{ //Match Partition layout
				memcpy(&gtSpiNandDrv.tPartInfo, ptPartInfo, 0x200);
				gtSpiNandDrv.u8_HasPNI = 1;
				break;
		}
	}

	if(gtSpiNandDrv.u8_HasPNI == 0){
		printf("[%s][%d][%d]: CIS doesn't contain part info\n", __func__, len, ret);
	}
	else{
		dump_part_info(ptPartInfo);
	}
	return 0;
}

void board_spinand_exit(void)
{
	if(gtSpiNandDrv.pu8_pagebuf)
		free(gtSpiNandDrv.pu8_pagebuf);
	if(gtSpiNandDrv.pu8_sparebuf)
		free(gtSpiNandDrv.pu8_sparebuf);
}

/* return 1: Good block, 0: Bad block */
U32 MDrv_SPINAND_IsGoodBlk(U16 u16_PBA)
{
	return 1;
}

U32 MDrv_SPINAND_WriteCIS_for_ROM(SPINAND_FLASH_INFO_TAG_t *pSpiNandInfoTag)
{
	U32 u32_Err = ERR_SPINAND_SUCCESS;
	U16 u16_PBA;
	U32 u32_PageIdx;
	U8 u8_CISIdx;

	u8_CISIdx = 0;

	/* Search for two good blocks within the first 10 physical blocks */
	for (u16_PBA = 0; u16_PBA < 10; u16_PBA+=2)
	{
		/* Check first page of block */
		u32_PageIdx = u16_PBA * gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt;
		u32_Err = MDrv_SPINAND_Read(u32_PageIdx, gtSpiNandDrv.pu8_pagebuf, gtSpiNandDrv.pu8_sparebuf);
		if(u32_Err != ERR_SPINAND_SUCCESS)
			printf("MDrv_SPINAND_Read(0x%lX)=0x%lX\n", u32_PageIdx, u32_Err);
		if(gtSpiNandDrv.pu8_sparebuf[0] != 0xFF)
		{
			//printf("Skip bad blk 0x%04x\n", u16_PBA);
			//continue;
		}

		u32_Err = MDrv_SPINAND_BLOCK_ERASE(u32_PageIdx);
		if(u32_Err != ERR_SPINAND_SUCCESS)
		{
			printf("MDrv_SPINAND_BLOCK_ERASE(0x%X)=0x%lX\n", u16_PBA, u32_Err);
			continue;
		}

		memset(gtSpiNandDrv.pu8_pagebuf, 0xFF, gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt);
		memcpy(gtSpiNandDrv.pu8_pagebuf, pSpiNandInfoTag, sizeof(SPINAND_FLASH_INFO_TAG_t));
		memset(gtSpiNandDrv.pu8_sparebuf, 0xFF, gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt);

		u32_Err = MDrv_SPINAND_Write(u32_PageIdx, gtSpiNandDrv.pu8_pagebuf, gtSpiNandDrv.pu8_sparebuf);
		if(u32_Err != ERR_SPINAND_SUCCESS)
		{
			printf("MDrv_SPINAND_Write(0x%lX)=0x%lX\n", u32_PageIdx, u32_Err);
			continue;
		}

		/*
		**	Write Partition Info the 2nd page
		**/
		if(gtSpiNandDrv.u8_HasPNI == 1)
		{
			memset(gtSpiNandDrv.pu8_pagebuf, 0xFF, gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt);
			memcpy(gtSpiNandDrv.pu8_pagebuf, &gtSpiNandDrv.tPartInfo, 512);

			u32_Err = MDrv_SPINAND_Write(u32_PageIdx+1, gtSpiNandDrv.pu8_pagebuf, gtSpiNandDrv.pu8_sparebuf);
			if(u32_Err != ERR_SPINAND_SUCCESS)
			{
				printf("MDrv_SPINAND_Write(0x%lX)=0x%lX\n", u32_PageIdx+1, u32_Err);
				continue;
			}
		}

		printf("CIS%d is written to blk 0x%04x\n", u8_CISIdx, u16_PBA);
	    break;
	}

    return u32_Err;
}

int MDrv_SPINAND_SearchCIS_in_DRAM(U8 *pu8_CISAddr, U8 *pu8_PPMAddr, U8 *pu8_PNIAddr, SPINAND_FLASH_INFO_TAG_t *pSpiNandInfoTagOut)
{
	SPINAND_FLASH_INFO_TAG_t *pSpiNandInfoTag;
	SPINAND_FLASH_INFO_t *ptSpinandInfo;
	PARTITION_INFO_t *ptPartInfo;
	U32 u32_i, u32_j;
	U8 u8_IsEnd = 0;

	printf("Begin Search CIS in DRAM\n");

	//Search 20 pieces of possiable cis memory
	u32_i = 0;
	while(1)
	{
		pSpiNandInfoTag = (SPINAND_FLASH_INFO_TAG_t *)(pu8_CISAddr + u32_i);
		ptSpinandInfo = &pSpiNandInfoTag->tSpiNandInfo;

		for(u32_j=0; u32_j<gtSpiNandDrv.tSpinandInfo.u8_IDByteCnt; u32_j++)
		{
			if(gtSpiNandDrv.tSpinandInfo.au8_ID[u32_j] != ptSpinandInfo->au8_ID[u32_j])
				break;
		}
		if(u32_j == gtSpiNandDrv.tSpinandInfo.u8_IDByteCnt)
			break;

		if(memcmp((const void *) pSpiNandInfoTag->au8_Tag, (const void *) SPINAND_FLASH_INFO_TAG, 16))
		{
			u8_IsEnd = 1;
			break;
		}
		u32_i += 0x200;
	}
	if(u8_IsEnd == 1)
	{
		printf("[%s]: No available CIS match with current spi nand flash\n", __func__);
		return -1;
	}
	printf("[%s]: Found CIS in given memory\n", __func__);
	memcpy(&gtSpiNandDrv.tSpinandInfo, ptSpinandInfo, sizeof(SPINAND_FLASH_INFO_t));

	//search pni
	gtSpiNandDrv.u8_HasPNI = 0;
	if(pu8_PNIAddr != NULL)
	{
		for(u32_i = 0; u32_i < 0x200 * 20 ; u32_i += 0x200)
		{
			ptPartInfo = (PARTITION_INFO_t*) (pu8_PNIAddr + u32_i);
            #if 0
			if(ptPartInfo->u16_SpareByteCnt == gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt &&
				ptPartInfo->u16_PageByteCnt == gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt &&
				ptPartInfo->u16_BlkPageCnt == gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt &&
				ptPartInfo->u16_BlkCnt == gtSpiNandDrv.tSpinandInfo.u16_BlkCnt) //Match Partition layout
			#endif
            if(1)
			{
				memcpy(&gtSpiNandDrv.tPartInfo, ptPartInfo, 0x200);
				gtSpiNandDrv.u8_HasPNI = 1;
				break;
			}
		}
	}

	memcpy(pSpiNandInfoTagOut, pSpiNandInfoTag , sizeof(SPINAND_FLASH_INFO_TAG_t));

	return 0;
}

int MDrv_SPINAND_write_bootloader(U32 u32_Row,U8 * pu8_addr, U32 u32_size, U8 u8_BootStageId)
{
	U8 *pu8_DataBuf = pu8_addr;
	U16 u16_BlkPageCnt;
	U32 u32_pagecnt, u32_Err, u32_size_tmp = u32_size, u32_Row_Read = u32_Row;
	U16 u16_i;

	u16_BlkPageCnt = gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt;
	u32_pagecnt = (u32_size+gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt-1)/gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt;

	while(u32_pagecnt >= u16_BlkPageCnt)
	{
		while (MDrv_SPINAND_IsGoodBlk(u32_Row / gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt) == 0)
		{
			u32_Row += gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt;
			//bad block jump to next block
			if(u32_Row == (gtSpiNandDrv.tSpinandInfo.u16_BlkCnt*gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt))
			{
				printf("[%s]: There is no available GOOD block in current nand device\n", __func__);
				return -1;
			}
		}

		memset(gtSpiNandDrv.pu8_sparebuf, 0xFF, gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt);
		gtSpiNandDrv.pu8_sparebuf[4] = u8_BootStageId;

		for(u16_i = 0 ; u16_i<gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt ; u16_i++)
		{
			u32_Err = MDrv_SPINAND_Write(u32_Row+u16_i, pu8_DataBuf+(u16_i*gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt), gtSpiNandDrv.pu8_sparebuf);
			if(u32_Err != ERR_SPINAND_SUCCESS)
			{
				//jump to next block
				u32_Row += gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt;
				continue;
			}
		}
		pu8_DataBuf += u16_BlkPageCnt*gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt;

		u32_pagecnt -= u16_BlkPageCnt;
		u32_size -= u16_BlkPageCnt*gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt;
		u32_Row += gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt;
	}

	while(u32_size)
	{
		while (MDrv_SPINAND_IsGoodBlk(u32_Row/gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt) == 0)
		{
			u32_Row += gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt;
			//bad block jump to next block
			if(u32_Row == (gtSpiNandDrv.tSpinandInfo.u16_BlkCnt*gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt))
			{
				printf("Error : There is no available GOOD block in current nand device\n");
				return -1;
			}
		}

		memset(gtSpiNandDrv.pu8_sparebuf, 0xFF, gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt);
		gtSpiNandDrv.pu8_sparebuf[4] = u8_BootStageId;

		for(u16_i = 0 ; u16_i<u32_pagecnt ; u16_i++)
		{
			u32_Err = MDrv_SPINAND_Write(u32_Row+u16_i, pu8_DataBuf+(u16_i*gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt), gtSpiNandDrv.pu8_sparebuf);
			if(u32_Err != ERR_SPINAND_SUCCESS)
			{
				//jump to next block
				u32_Row += gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt;
				continue;
			}
		}

		u32_size-= u32_size;
	}

	return 0;
}

static u32 empty_check(const void *buf, u32 len)
{
	int i;

	for (i = (len >> 2) - 1; i >= 0; i--)
		if (((const uint32_t *)buf)[i] != 0xFFFFFFFF)
			break;

	/* The resulting length must be aligned to the minimum flash I/O size */
	len = ALIGN((i + 1) << 2, gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt + gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt);
	return len;
}

int MDrv_SPINAND_ReadCISBlk(U32 u32_off, U8* pu8_DataBuf)
{
	U32 u32_Err, i, pglen;
	U32  chk_len;
	U32 u32_Row = u32_off/gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt;
	U32 page_off = gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt + gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt;

	pglen = gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt + gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt;
	for(i=0 ; i<gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt; i++)
	{
		u32_Err = MDrv_SPINAND_Read(u32_Row+i, pu8_DataBuf+page_off*i, pu8_DataBuf+page_off*i+gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt);
		if(u32_Err != ERR_SPINAND_SUCCESS)
			return u32_Err;

		if(info.fullblkprg){
			chk_len = empty_check(pu8_DataBuf+page_off*i, pglen);
			if (!chk_len)
			{
		    		(pu8_DataBuf + page_off * i)[0] = 0xfe; // indicate empty page
			}
		}
	}

	return ERR_SPINAND_SUCCESS;
}

void MDrv_SPINAND_GetMtdParts(char *buf)
{
	PARTITION_INFO_t *pPartInfo = &gtSpiNandDrv.tPartInfo;
	U8 u8_i,u8_PartNo, u8_Unknown = 0;
	int len, Maxlen = 512;
	u32 PartSize = 0, PartSize1 = 0, PartSize2 = 0;
	U32 u32_Err;
	u32 virtual_boot;
	U32 u32_BlkIdx;
	U8	u8_MbootCnt= 0;
	U32 u32_MbootBlkIdx[2];
	char *mtd_buf=buf, tmp[128], PartName[16];
	U16 u16_LastPartType;

	if(gtSpiNandDrv.u8_HasPNI == 0)
		goto cleanup;

	sprintf(mtd_buf, "mtdparts=edb64M-nand:");
	mtd_buf += 21;
	if (Maxlen < 21)
		goto cleanup;
	Maxlen -= 21;

	u16_LastPartType = 0;
	for(u8_i = 0; u8_i < pPartInfo->u16_PartCnt; u8_i ++)
	{
		if( (pPartInfo->records[u8_i].u16_PartType & USFD_LOGI_PART) == USFD_LOGI_PART)
			break;

		PartSize = 0;
		if( u8_i )
		{
			memcpy(mtd_buf, ",", 1);
			mtd_buf ++;
			Maxlen --;
		}

		PartSize = gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt *
			(pPartInfo->records[u8_i].u16_BackupBlkCnt + pPartInfo->records[u8_i].u16_BlkCnt);

		u8_PartNo = u16_LastPartType != pPartInfo->records[u8_i].u16_PartType ? 0:1;

		u16_LastPartType = pPartInfo->records[u8_i].u16_PartType;

		switch(pPartInfo->records[u8_i].u16_PartType)
		{
			case USFD_PART_BOOTLOGO:
				sprintf(PartName,"UBILD" );
				break;
			case USFD_PART_UBOOT:
				sprintf(PartName,"MBOOT" );
				break;
			case USFD_PART_OS:
				sprintf(PartName,"KL" );
				break;
			case USFD_PART_SECINFO:
				sprintf(PartName,"KL_BP" );
				break;
			case USFD_PART_OTP:
				sprintf(PartName,"NTP" );
				break;
			case USFD_PART_RECOVERY:
				sprintf(PartName,"RECOVERY" );
				break;
			case USFD_PART_MISC:
				sprintf(PartName,"MISC" );
				break;
			case USFD_PART_TBL:
				sprintf(PartName,"TBL" );
				break;
			case USFD_PART_CTRL:
				sprintf(PartName,"CTRL" );
				break;
			case USFD_PART_UBIRO:
				sprintf(PartName,"UBIRO" );
				break;
			default:
				sprintf(PartName,"UNKNOWN%d", u8_Unknown++);
				break;
		}
		if (u8_i)
			sprintf(tmp, "%dk(%s)", PartSize/1024, PartName); //,pPartInfo->records[u8_i].u16_PartType);
		else
		{
			u8_MbootCnt = 0;
			if(gtSpiNandDrv.tSpinandInfo.u8_BL1PBA != 0)
			{
				printf("RET---------------------------------------------\n");
				//search vid chunk header for mboot partition beginning
				u32_BlkIdx = 1;
				while(1)
				{
					u32_Err = MDrv_SPINAND_Read((gtSpiNandDrv.tSpinandInfo.u8_BL1PBA + u32_BlkIdx)*gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt,
												gtSpiNandDrv.pu8_pagebuf, gtSpiNandDrv.pu8_sparebuf);
					//binary ID for chunk header
					if( ((U32 *)gtSpiNandDrv.pu8_pagebuf)[0x7] == 0x0000B007 && u32_Err == ERR_SPINAND_SUCCESS)
					{
						u32_MbootBlkIdx[u8_MbootCnt] = (gtSpiNandDrv.tSpinandInfo.u8_BL1PBA + u32_BlkIdx);
						u8_MbootCnt ++;
					}

					//support K7a removing mbootbak
					if(info.disablembootbak){
						if(u8_MbootCnt == 1)
							break;
					}
					else if(info.disablembootbak == 0){
						if(u8_MbootCnt == 2)
							break;
					}

					if((gtSpiNandDrv.tSpinandInfo.u8_BL1PBA + u32_BlkIdx) == 0xFF)
						break;

					u32_BlkIdx ++;
				}
				if((gtSpiNandDrv.tSpinandInfo.u8_BL1PBA + u32_BlkIdx) == 0xFF)
				{
					goto cleanup;
				}
				else
				{
					if(u8_MbootCnt == 1)
					{
						virtual_boot = u32_MbootBlkIdx[0] * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) / 1024;
						PartSize = PartSize - (u32_MbootBlkIdx[0] - 10) * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) ;
						sprintf(tmp, "%dk@%dk(%s)", PartSize/1024, virtual_boot, PartName);
					}
					else if(u8_MbootCnt == 2)
					{
						virtual_boot = u32_MbootBlkIdx[0] * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) / 1024;
						PartSize1 = (u32_MbootBlkIdx[1] - u32_MbootBlkIdx[0]) * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) ;
						PartSize2 = PartSize - (u32_MbootBlkIdx[1] - 10) * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) ;
						sprintf(tmp, "%dk@%dk(%s),%dk(%sBAK)", PartSize1/1024, virtual_boot, PartName,PartSize2/1024, PartName);
					}
					else
						goto cleanup;

					//virtual_boot = (gtSpiNandDrv.tSpinandInfo.u8_BL1PBA + u32_BlkIdx) * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) / 1024;
					//PartSize = PartSize - ((gtSpiNandDrv.tSpinandInfo.u8_BL1PBA + u32_BlkIdx - 10) * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt *gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt));
				}
			}
			else if(gtSpiNandDrv.tSpinandInfo.u8_HashPBA[1][1] != 0)
			{
				u32_BlkIdx = 1;
				while(1)
				{
					u32_Err = MDrv_SPINAND_Read((gtSpiNandDrv.tSpinandInfo.u8_HashPBA[1][1] + u32_BlkIdx)*gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt,
												gtSpiNandDrv.pu8_pagebuf, gtSpiNandDrv.pu8_sparebuf);
					//binary ID for chunk header
					if( ((U32 *)gtSpiNandDrv.pu8_pagebuf)[0x7] == 0x0000B007 && u32_Err == ERR_SPINAND_SUCCESS)
					{
						u32_MbootBlkIdx[u8_MbootCnt] = (gtSpiNandDrv.tSpinandInfo.u8_HashPBA[1][1] + u32_BlkIdx);
						u8_MbootCnt ++;
					}
					if(u8_MbootCnt == 2)
						break;
					if((gtSpiNandDrv.tSpinandInfo.u8_HashPBA[1][1] + u32_BlkIdx) == 0xFF)
						break;

					u32_BlkIdx ++;
				}
				if((gtSpiNandDrv.tSpinandInfo.u8_HashPBA[1][1] + u32_BlkIdx) == 0xFF)
				{
					goto cleanup;
				}
				else
				{
					if(u8_MbootCnt == 1)
					{
						virtual_boot = u32_MbootBlkIdx[0] * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) / 1024;
						PartSize = PartSize - (u32_MbootBlkIdx[0] - 10) * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) ;
						sprintf(tmp, "%dk@%dk(%s)", PartSize/1024, virtual_boot, PartName);
					}
					else if(u8_MbootCnt == 2)
					{
						virtual_boot = u32_MbootBlkIdx[0] * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) / 1024;
						//PartSize = PartSize - (u32_MbootBlkIdx[0] - 10) * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) ;
						PartSize1 = (u32_MbootBlkIdx[1] - u32_MbootBlkIdx[0]) * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) ;
						PartSize2 = PartSize - (u32_MbootBlkIdx[1] - 10) * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) ;
						sprintf(tmp, "%dk@%dk(%s),%dk(%sBAK)", PartSize1/1024, virtual_boot, PartName,PartSize2/1024, PartName);
					}
					else
						goto cleanup;
					//virtual_boot = (gtSpiNandDrv.tSpinandInfo.u8_HashPBA[1][1] + u32_BlkIdx) * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) / 1024;
					//PartSize = PartSize - (gtSpiNandDrv.tSpinandInfo.u8_HashPBA[1][1] + u32_BlkIdx - 10) * (gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt) ;
				}
			}
			else
				goto cleanup;

		}
		len = strlen(tmp);
		memcpy(mtd_buf, tmp, len);
		mtd_buf += len;
		if (Maxlen < len)
			goto cleanup;
		Maxlen -= len;

	}
	if( (pPartInfo->records[u8_i].u16_PartType & USFD_LOGI_PART) == USFD_LOGI_PART)
	{
		sprintf(tmp,",-(UBI)");
		len= strlen(tmp);
		memcpy(mtd_buf, tmp, len);
		mtd_buf += len;
		if (Maxlen < len)
			goto cleanup;
		Maxlen -= len;
	}
	*mtd_buf = '\0';
	return ;
	cleanup:
	buf[0] = '\0';
	return ;
}

static U8 MDrv_SPINAND_CheckAll0xFF(U8* pu8_Buf, U32 u32_ByteCnt)
{
	register U32 u32_i;

	for(u32_i=0; u32_i<u32_ByteCnt; u32_i++)
		if(0xFF != pu8_Buf[u32_i])
			return 0;

	return 0xFF;
}

////////////////////////////////////////////////
#define SPI_TEST_E
void spinand_test(void)
{
#if defined(SPI_TEST_W)
	int i;
	unsigned char *data;
	unsigned char *spare;
	int page = gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * 2 + 3;
	data = (unsigned char *)malloc(gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt * page);
	spare = (unsigned char *)malloc(gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt * page);
	for(i=0;i<page*4;i++){
		memset(data+i*512, i+1,512);
		memset(spare+i*16,i+8,16);
	}

	for(i = 0; i<page;i++){
		MDrv_SPINAND_Write(i, data, spare);
		data +=gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt;
		spare += gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt;
	}
#elif defined(SPI_TEST_R)
	int i;
	unsigned char *data;
	unsigned char *spare;
	int page = gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * 2 + 3;
	data = (unsigned char *)malloc(gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt * page);
	spare = (unsigned char *)malloc(gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt * page);

	for(i = 0; i<page;i++){
		MDrv_SPINAND_Read(i, data+gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt*i, spare+gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt*i);
	}

		{
			int a,b;
			for(i=0;i<page;i++){
				for(a=0;a<gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt;a+=16){
					for(b=0;b<16;b++){
						printf("0x%X ", data[a+b]);
					}
					printf("\n");
				}
				for(a=0;a<gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt;a+=16){
					for(b=0;b<16;b++){
						printf("0x%X ", spare[a+b]);
					}
					printf("\n");
				}
				data+=gtSpiNandDrv.tSpinandInfo.u16_PageByteCnt;
				spare+=gtSpiNandDrv.tSpinandInfo.u16_SpareByteCnt;
			}
		}

#elif defined(SPI_TEST_E)
	int i;
	int page = gtSpiNandDrv.tSpinandInfo.u16_BlkPageCnt * 2 + 3;
for(i=5;i<page;i++){
	MDrv_SPINAND_BLOCK_ERASE(i);
}
#endif
}



void spinand_test2(void)
{
	int fd;
	unsigned char *buf_nni,*buf_ppm,*buf_pni, path[128];
	SPINAND_FLASH_INFO_TAG_t *pSpiNandInfoTagOut;
	buf_nni = (unsigned char *)malloc(3*1024);
	buf_ppm = (unsigned char *)malloc(10*1024);
	buf_pni = (unsigned char *)malloc(4*1024);
	pSpiNandInfoTagOut = (SPINAND_FLASH_INFO_TAG_t *)malloc(512);

	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory,image_directory, iniparser_getstring(dict, "cis:nni",NULL));
	printf("---%s\n", path);
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("open %s failed\n", path);
		return;
	}
	read(fd, buf_nni, 3*1024);

	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory,image_directory, iniparser_getstring(dict, "cis:ppm",NULL));
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("open %s failed\n", path);
		return;
	}
	read(fd, buf_ppm, 10*1024);

	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory,image_directory, iniparser_getstring(dict, "cis:pni",NULL));
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("open %s failed\n", path);
		return;
	}
	read(fd, buf_pni, 4*1024);

	MDrv_SPINAND_SearchCIS_in_DRAM(buf_nni, buf_ppm, buf_pni, pSpiNandInfoTagOut);

	MDrv_SPINAND_WriteCIS_for_ROM(pSpiNandInfoTagOut);
}

void spinand_test3(void)
{
	int fd,ret;
	unsigned char path[128];
	unsigned char *buf;
	struct stat st;
	int len = 1024*1024;

	buf = (unsigned char *)malloc(len);
	memset(buf, 0x5A, len);

/*
	printf("---------0x%02X 0x%02X\n", buf[0], buf[len -10]);

	{
			int a,b;
				for(a=0;a<len;a+=16){
					for(b=0;b<16;b++){
						printf("0x%X ", buf[a+b]);
					}
					printf("\n");
				}
	}
	return;
*/
	memset(path, 0, sizeof(path));
	sprintf(path, "%s%s%s", root_directory,image_directory, "mboot_nand.bin");
	fd=open(path, O_RDWR);
	if(fd<0){
		printf("open %s failed\n", path);
		return;
	}
	stat(path, &st);
	printf("---------0x%02X\n", buf[1024 * 1024 -1]);

	ret= read(fd, buf, st.st_size);
	if(ret != st.st_size){
		printf("read failed ,0x%X\n, 0x%X",ret, st.st_size);
	}
	close(fd);

	printf("---------0x%02X\n", buf[1024 * 1024 -1]);

	MDrv_SPINAND_write_bootloader(68, buf, st.st_size, 0x51);
}
