/***********************************************************
*
* Copyright (C), 2010-2014, TP-LINK TECHNOLOGIES CO., LTD.
* All rights reserved.
*
* File name  : compress-handler.c
* Version	 : 1.0
* Description:
*
* Author	 : Wang FuYu <wangfuyu@tp-link.net>
* Create Date: 2014-04-08
*
* History	 :
*------------------------------------------------------------
*
*01, 08Apr14, Wang FuYu, create file.
************************************************************/

#include <inttypes.h>
#include "make-plugin.h"
#include "compress-handler.h"

/******************************************************************************
* FUNCTION		: compressFile()
* AUTHOR		: wangfuyu <wangfuyu@tp-link.net>
* DESCRIPTION	: compress file
* INPUT			:
* OUTPUT		:
* RETURN		:
******************************************************************************/
int compressFile(unsigned char *srcCompressBuf,
							unsigned long srcCompressBufLen,
							unsigned char *deCompressBuf,
							uLong *ucCmpLen)
{
	int ret = MK_PLUGIN_ERR;
	int bufOff = 0;
	uLong flen = 0;
	uLong clen = 0;
	uint32_t tmpFlen = 0;
	uint32_t tmpClen = 0;
	FILE *file = NULL;
	unsigned char *fbuf = NULL;
	unsigned char *cbuf = NULL;

	if (NULL == ucCmpLen || NULL == srcCompressBuf || 0 >= srcCompressBufLen)
	{
		MSG_ERR("NULL == ucCmpLen || NULL == srcCompressBuf || 0 >= srcCompressBufLen!\n");
		return -1;
	}

	flen = srcCompressBufLen;
	fbuf = srcCompressBuf;

	bufOff = sizeof(uint32_t) * 2;
	// calculate how many buf need when compress file

	clen = compressBound(flen);
	cbuf = deCompressBuf;
	if (NULL == cbuf)
	{
		FREE_P(fbuf);
		return -1;
	}

	memset(cbuf, 0, clen + bufOff);

	tmpFlen = (uint32_t)htonl(flen);
	tmpClen = (uint32_t)htonl(clen);

	memcpy(cbuf, &tmpFlen, sizeof(uint32_t));
	memcpy(cbuf + sizeof(uint32_t), &tmpClen, sizeof(uint32_t));

	// compress file
	ret = compress(cbuf + bufOff, &clen, fbuf, flen);
	if(Z_OK != ret)
	{
		MSG_ERR("Compress buf failed!\n");
		FREE_P(fbuf);
		FREE_P(cbuf);
		return -1;
	}

	// after compressing, msg's length
	*ucCmpLen = clen + bufOff;

	MSG_LOG("compress buf success, srcCompressBufLen is %ul, ucCmpLen is %ul, comp ratio is %f\n",
		srcCompressBufLen, *ucCmpLen, ((double)*ucCmpLen/(double)srcCompressBufLen));
	return 0;
}

