# Makefile for OpenWrt
#
# Copyright (c) 2013 The Linux Foundation. All rights reserved.
# Copyright (C) 2007-2011 OpenWrt.org
#
# This is free software, licensed under the GNU General Public License v2.
# See /LICENSE for more information.
#

RELEASE:=Attitude Adjustment
PREP_MK= OPENWRT_BUILD= QUIET=0

include $(TOPDIR)/include/verbose.mk

ifeq ($(SDK),1)
  include $(TOPDIR)/include/version.mk
else
  REVISION:=$(shell $(TOPDIR)/scripts/getver.sh)
endif

HOSTCC ?= gcc
OPENWRTVERSION:=$(RELEASE)$(if $(REVISION), ($(REVISION)))
export RELEASE
export REVISION
export OPENWRTVERSION
export IS_TTY=$(shell tty -s && echo 1 || echo 0)
-include $(T_PRODUCT_CONFIG_DIR)/$(PR_NAME)/buildroot.config
ifneq ($(CONFIG_TOOLCHAIN_LD_LIB_PATH),)
LD_LIBRARY_PATH:=$(subst ::,:,$(if $(LD_LIBRARY_PATH),$(LD_LIBRARY_PATH):)$(STAGING_DIR_HOST)/lib)
export LD_LIBRARY_PATH:=$(subst ::,:,$(if $(LD_LIBRARY_PATH),$(LD_LIBRARY_PATH):)$(subst ",,$(CONFIG_TOOLCHAIN_ROOT))/$(subst ",,$(CONFIG_TOOLCHAIN_LD_LIB_PATH)))
else
export LD_LIBRARY_PATH:=$(subst ::,:,$(if $(LD_LIBRARY_PATH),$(LD_LIBRARY_PATH):)$(STAGING_DIR_HOST)/lib)
endif
export DYLD_LIBRARY_PATH:=$(subst ::,:,$(if $(DYLD_LIBRARY_PATH),$(DYLD_LIBRARY_PATH):)$(STAGING_DIR_HOST)/lib)
export GIT_CONFIG_PARAMETERS='core.autocrlf=false'
export MAKE_JOBSERVER=$(filter --jobserver%,$(MAKEFLAGS))

# prevent perforce from messing with the patch utility
unexport P4PORT P4USER P4CONFIG P4CLIENT

# prevent user defaults for quilt from interfering
unexport QUILT_PATCHES QUILT_PATCH_OPTS

unexport C_INCLUDE_PATH CROSS_COMPILE ARCH

# prevent distro default LPATH from interfering
unexport LPATH

# make sure that a predefined CFLAGS variable does not disturb packages
export CFLAGS=

ifeq ($(FORCE),)
  .config scripts/config/conf scripts/config/mconf: tmp/.prereq-build
endif

SCAN_COOKIE?=$(shell echo $$$$)
export SCAN_COOKIE

SUBMAKE:=umask 022; $(SUBMAKE)

T_BUILDROOT_CONFIG := $(T_PRODUCT_CONFIG_DIR)/$(PR_NAME)/buildroot.config
T_BUILDAMS_CONFIG := $(T_PRODUCT_CONFIG_DIR)/$(PR_NAME)/buildams.config

GITPREFIX=${shell git remote -v | grep \(fetch\) | head -n 1 | sed 's/.*ssh:\/\/\(.*\)\@.*/\1/g'}

prepare-mk: FORCE ;

prepare-tmpinfo: FORCE
	mkdir -p tmp/info
	$(_SINGLE)$(NO_TRACE_MAKE) -j1 -r -s -f include/scan.mk SCAN_TARGET="packageinfo" SCAN_DIR="package" SCAN_NAME="package" SCAN_DEPS="$(TOPDIR)/include/package*.mk $(TOPDIR)/overlay/*/*.mk" SCAN_DEPTH=5 SCAN_EXTRA=""
	$(_SINGLE)$(NO_TRACE_MAKE) -j1 -r -s -f include/scan.mk SCAN_TARGET="targetinfo" SCAN_DIR="target" SCAN_NAME="target" SCAN_DEPS="profiles/*.mk $(TOPDIR)/include/kernel*.mk $(TOPDIR)/include/target.mk" SCAN_DEPTH=3 SCAN_EXTRA="" SCAN_MAKEOPTS="TARGET_BUILD=1"
	for type in package target; do \
		f=tmp/.$${type}info; t=tmp/.config-$${type}.in; \
		[ "$$t" -nt "$$f" ] || ./scripts/metadata.pl $${type}_config "$$f" > "$$t" || { rm -f "$$t"; echo "Failed to build $$t"; false; break; }; \
	done
	./scripts/metadata.pl package_mk tmp/.packageinfo > tmp/.packagedeps || { rm -f tmp/.packagedeps; false; }
	touch $(TOPDIR)/tmp/.build

# update ams libraries
ams_update: FORCE
	@if [ -d $(TOPDIR)/ams_package ]; then \
		cp $(TOPDIR)/ams_package/product_config/$(PR_NAME)/ams.config $(T_PRODUCT_CONFIG_DIR)/$(PR_NAME)/isp_config/common/base-files/etc/; \
		cp $(TOPDIR)/ams_package/product_config/$(PR_NAME)/buildams.config $(T_BUILDAMS_CONFIG); \
		echo "AMS: buildams.config and ams.config updated from ams source"; \
	elif [ -d $(TOPDIR)/tp_package/ams ]; then \
		cp $(TOPDIR)/tp_package/ams/product_config/$(PR_NAME)/ams.config $(T_PRODUCT_CONFIG_DIR)/$(PR_NAME)/isp_config/common/base-files/etc/; \
		cp $(TOPDIR)/tp_package/ams/product_config/$(PR_NAME)/buildams.config $(T_BUILDAMS_CONFIG); \
		echo "AMS: buildams.config and ams.config updated from local nvmp_artifact"; \
	fi

.config: ./scripts/config/conf $(if $(CONFIG_HAVE_DOT_CONFIG),,prepare-tmpinfo) FORCE
	@+if : || [ \! -e .config ] || ! grep CONFIG_HAVE_DOT_CONFIG .config >/dev/null; then \
		if [ $(PR_NAME)x != ""x ]; then \
			if [ \! -e $(T_BUILDROOT_CONFIG) ]; then \
				@echo "file $(T_BUILDROOT_CONFIG) was NOT found ";	\
			fi; \
			cp $(T_BUILDROOT_CONFIG) .config;	\
			if [ \! -e $(T_BUILDAMS_CONFIG) ]; then \
				@echo "file $(T_BUILDAMS_CONFIG) was NOT found ";	\
			fi; \
			cat $(T_BUILDAMS_CONFIG) >> .config;	\
			if [ -e .config_remove_sdk ]; then	\
				sed -i "s/CONFIG_SDK=y/# CONFIG_SDK is not set/g" `grep "CONFIG_SDK=y" -l .config`; \
				rm .config_remove_sdk;	\
			fi;	\
			if [ "$(PR_IB)" = "1" ]; then \
				if [ 'grep "# CONFIG_IB is not set" -l .config' ] ; then \
					sed -i "s/# CONFIG_IB is not set/CONFIG_IB=y/g" `grep "# CONFIG_IB is not set" -l .config`; \
				fi; \
			fi; \
			if [ "$(PR_SDK)" = "1" ]; then \
				if [ 'grep "# CONFIG_SDK is not set" -l .config' ] ; then \
					sed -i "s/# CONFIG_SDK is not set/CONFIG_SDK=y/g" `grep "# CONFIG_SDK is not set" -l .config`; \
				fi; \
			fi; \
			if [ "$(LOG_UPLOAD_DEBUG)" = "1" ]; then \
				if grep "# CONFIG_LOG_UPLOAD_SUPPORT is not set" -q .config; then \
					sed -i "s/# CONFIG_LOG_UPLOAD_SUPPORT is not set/CONFIG_LOG_UPLOAD_SUPPORT=y/g" `grep "# CONFIG_LOG_UPLOAD_SUPPORT is not set" -l .config`; \
				elif ! grep "CONFIG_LOG_UPLOAD_SUPPORT" -q .config; then \
					echo "CONFIG_LOG_UPLOAD_SUPPORT=y" >> .config;	\
				fi; \
			fi; \
			if [ "$(NO_UP_UBOOT)" = "1" ]; then \
				if [ 'grep "# CONFIG_NO_UP_UBOOT is not set" -l .config' ] ; then \
					sed -i "s/# CONFIG_NO_UP_UBOOT is not set/CONFIG_NO_UP_UBOOT=y/g" `grep "# CONFIG_NO_UP_UBOOT is not set" -l .config`; \
				fi; \
			fi; \
			if [ "$(PR_DBG_FW)" = "1" ]; then \
				if [ 'grep "# CONFIG_DBG_FW is not set" -l .config' ] ; then \
					sed -i "s/# CONFIG_DBG_FW is not set/CONFIG_DBG_FW=y/g" `grep "# CONFIG_DBG_FW is not set" -l .config`; \
				fi; \
			fi; \
			if [ "$(TELNETD_ENABLE)" = "1" ]; then \
				echo "CONFIG_BUSYBOX_CONFIG_TELNETD enable";\
				if [ 'grep "# CONFIG_BUSYBOX_CONFIG_TELNETD is not set" -l .config' ] ; then \
					sed -i "s/# CONFIG_BUSYBOX_CONFIG_TELNETD is not set/CONFIG_BUSYBOX_CONFIG_TELNETD=y/g" `grep "# CONFIG_BUSYBOX_CONFIG_TELNETD is not set" -l .config`; \
				fi; \
			fi; \
			if [ "$(TCPDUMP_ENABLE)" = "1" ]; then \
				if grep "# CONFIG_PACKAGE_libpcap is not set" -q .config; then \
					sed -i "s/# CONFIG_PACKAGE_libpcap is not set/CONFIG_PACKAGE_libpcap=y/g" `grep "# CONFIG_PACKAGE_libpcap is not set" -l .config`; \
				elif ! grep "CONFIG_PACKAGE_libpcap" -q .config; then \
					echo "CONFIG_PACKAGE_libpcap=y" >> .config;	\
				fi; \
				if grep "# CONFIG_PACKAGE_tcpdump is not set" -q .config; then \
					sed -i "s/# CONFIG_PACKAGE_tcpdump is not set/CONFIG_PACKAGE_tcpdump=y/g" `grep "# CONFIG_PACKAGE_tcpdump is not set" -l .config`; \
				elif ! grep "CONFIG_PACKAGE_tcpdump" -q .config; then \
					echo "CONFIG_PACKAGE_tcpdump=y" >> .config;	\
				fi; \
			fi; \
			if [ "$(LOGG_ENABLE)" = "1" ]; then \
				if grep "# CONFIG_PACKAGE_logg is not set" -q .config; then \
					sed -i "s/# CONFIG_PACKAGE_logg is not set/CONFIG_PACKAGE_logg=y/g" `grep "# CONFIG_PACKAGE_logg is not set" -l .config`; \
				else \
					echo "CONFIG_PACKAGE_logg=y" >> .config; \
				fi; \
			fi; \
			if [ "$(NFS_ENABLE)" = "1" ]; then \
				if grep "# CONFIG_BUSYBOX_CONFIG_FEATURE_MOUNT_NFS is not set" -q .config; then \
					sed -i "s/# CONFIG_BUSYBOX_CONFIG_FEATURE_MOUNT_NFS is not set/CONFIG_BUSYBOX_CONFIG_FEATURE_MOUNT_NFS=y/g" `grep "# CONFIG_BUSYBOX_CONFIG_FEATURE_MOUNT_NFS is not set" -l .config`; \
				else \
					echo "CONFIG_BUSYBOX_CONFIG_FEATURE_MOUNT_NFS=y" >> .config; \
				fi; \
				if grep "# CONFIG_PACKAGE_kmod-fs-nfs is not set" -q .config; then \
					sed -i "s/# CONFIG_PACKAGE_kmod-fs-nfs is not set/CONFIG_PACKAGE_kmod-fs-nfs=y/g" `grep "# CONFIG_PACKAGE_kmod-fs-nfs is not set" -l .config`; \
				else \
					echo "CONFIG_PACKAGE_kmod-fs-nfs=y" >> .config; \
				fi; \
				if grep "# CONFIG_PACKAGE_kmod-fs-nfs-common is not set" -q .config; then \
					sed -i "s/# CONFIG_PACKAGE_kmod-fs-nfs-common is not set/CONFIG_PACKAGE_kmod-fs-nfs-common=y/g" `grep "# CONFIG_PACKAGE_kmod-fs-nfs-common is not set" -l .config`; \
				else \
					echo "CONFIG_PACKAGE_kmod-fs-nfs-common=y" >> .config; \
				fi; \
				if grep "# CONFIG_NFS_SUPPORT is not set" -q .config; then \
					sed -i "s/# CONFIG_NFS_SUPPORT is not set/CONFIG_NFS_SUPPORT=y/g" `grep "# CONFIG_NFS_SUPPORT is not set" -l .config`; \
				else \
					echo "CONFIG_NFS_SUPPORT=y" >> .config; \
				fi; \
			fi; \
		else \
		[ -e $(HOME)/.openwrt/defconfig ] && cp $(HOME)/.openwrt/defconfig .config; \
		$(_SINGLE)$(NO_TRACE_MAKE) menuconfig $(PREP_MK); \
		fi; \
	fi

	@touch .config_tmp;
#	@grep -v -e "SYSUPGRADE_CHECK_RSA" -e "SYSUPGRADE_CHECK_FWLIST" .config --text> .config_tmp;
	@grep -v "SYSUPGRADE_CHECK_RSA" .config --text> .config_tmp;
	@if [ "$(PR_VERSION)" = "release" ] || [ -z "$(PR_VERSION)" ]; then \
		echo "CONFIG_SYSUPGRADE_CHECK_RSA=y" >> .config_tmp; \
#		echo "CONFIG_SYSUPGRADE_CHECK_FWLIST=y" >> .config_tmp; \
		mv .config_tmp .config; \
	 elif [ "$(PR_VERSION)" = "debug" ]; then \
		echo "# CONFIG_SYSUPGRADE_CHECK_RSA is not set" >> .config_tmp; \
#		echo "# CONFIG_SYSUPGRADE_CHECK_FWLIST is not set" >> .config_tmp; \
		mv .config_tmp .config; \
	 else \
		echo "PR_VERSION is not right"; \
		rm -f .config .config_tmp; \
	 fi;

scripts/config/mconf:
	@$(_SINGLE)$(SUBMAKE) -s -C scripts/config all CC="$(HOSTCC)"

$(eval $(call rdep,scripts/config,scripts/config/mconf))

scripts/config/conf:
	@$(_SINGLE)$(SUBMAKE) -s -C scripts/config conf CC="$(HOSTCC)"

config: scripts/config/conf prepare-tmpinfo FORCE
	$< Config.in

config-clean: FORCE
	$(_SINGLE)$(NO_TRACE_MAKE) -C scripts/config clean

defconfig: scripts/config/conf prepare-tmpinfo FORCE
	touch .config
	$< -D .config Config.in

oldconfig: scripts/config/conf prepare-tmpinfo FORCE
	$< -$(if $(CONFDEFAULT),$(CONFDEFAULT),o) Config.in

menuconfig: scripts/config/mconf prepare-tmpinfo FORCE
	if [ \! -e .config -a -e $(HOME)/.openwrt/defconfig ]; then \
		cp $(HOME)/.openwrt/defconfig .config; \
	fi
	$< Config.in

prepare_kernel_conf: .config FORCE

ifeq ($(wildcard staging_dir/host/bin/quilt),)
  prepare_kernel_conf:
	@+$(SUBMAKE) -r tools/quilt/install
else
  prepare_kernel_conf: ;
endif

kernel_oldconfig: prepare_kernel_conf
	$(_SINGLE)$(NO_TRACE_MAKE) -C target/linux oldconfig

kernel_menuconfig: prepare_kernel_conf
	$(_SINGLE)$(NO_TRACE_MAKE) -C target/linux menuconfig

kernel_nconfig: prepare_kernel_conf
	$(_SINGLE)$(NO_TRACE_MAKE) -C target/linux nconfig

tmp/.prereq-build: include/prereq-build.mk
	mkdir -p tmp
	rm -f tmp/.host.mk
	@$(_SINGLE)$(NO_TRACE_MAKE) -j1 -r -s -f $(TOPDIR)/include/prereq-build.mk prereq 2>/dev/null || { \
		echo "Prerequisite check failed. Use FORCE=1 to override."; \
		false; \
	}
	touch $@

printdb: FORCE
	@$(_SINGLE)$(NO_TRACE_MAKE) -p $@ V=99 DUMP_TARGET_DB=1 2>&1

download: .config FORCE
	@+$(SUBMAKE) tools/download
	@+$(SUBMAKE) toolchain/download
	@+$(SUBMAKE) package/download
	@+$(SUBMAKE) target/download

ifneq ($(CONFIG_HAVE_DOT_CONFIG),)
clean dirclean: .config
	@+$(SUBMAKE) -r $@

prereq:: prepare-tmpinfo ams_update .config
	@+$(MAKE) -r -s tmp/.prereq-build $(PREP_MK)
	@+$(NO_TRACE_MAKE) -r -s $@

%::
ifeq ($(filter package/symlinks,$(MAKECMDGOALS)),)
	@+$(PREP_MK) $(NO_TRACE_MAKE) -r -s prereq
	@( \
		cp .config tmp/.config; \
		./scripts/config/conf -D tmp/.config -w tmp/.config Config.in > /dev/null 2>&1; \
		if ./scripts/kconfig.pl '>' .config tmp/.config | grep -q CONFIG; then \
			echo "WARNING: your configuration is out of sync. Please run make menuconfig, oldconfig or defconfig!"; \
		fi \
	)
endif
	@+$(SUBMAKE) -r $@
else
clean dirclean: FORCE
	@echo "Do nothing when buildroot.config is not included."
endif

help:
	cat README

docs docs/compile: FORCE
	@$(_SINGLE)$(SUBMAKE) -C docs compile

docs/clean: FORCE
	@$(_SINGLE)$(SUBMAKE) -C docs clean

distclean:
	rm -rf tmp build_dir staging_dir dl .config* feeds package/feeds package/openwrt-packages bin
	@$(_SINGLE)$(SUBMAKE) -C scripts/config clean

ifeq ($(findstring v,$(DEBUG)),)
  .SILENT: symlinkclean clean dirclean distclean config-clean download help tmpinfo-clean .config scripts/config/mconf scripts/config/conf menuconfig tmp/.prereq-build tmp/.prereq-package prepare-tmpinfo
endif
.PHONY: help FORCE
.NOTPARALLEL:
