/*
 * IRQ number in JZ47xx INTC definition.
 *   Only support 4770 now. 2011-9-23
 *
 * Copyright (C) 2010 Ingenic Semiconductor Co., Ltd.
 */

#ifndef __INTC_IRQ_H__
#define __INTC_IRQ_H__

#include <irq.h>

enum {
// interrupt controller interrupts
	IRQ_IRQ_RESERVED0=IRQ_INTC_BASE,
	IRQ_AIC0,
	IRQ_RESERVED2,
	IRQ_SYS_OST,/*TODO*/
	IRQ_MIPI_RX,
	IRQ_LCDC,
	IRQ_IPU,
	IRQ_SFC,
	IRQ_SSI1,
	IRQ_SSI0,
	IRQ_PDMA,
	IRQ_RESERVED11,
	IRQ_RESERVED12,
	IRQ_RESERVED13,
	IRQ_GPIO3,
	IRQ_GPIO2,
	IRQ_GPIO1,
	IRQ_GPIO0,
#define IRQ_GPIO_PORT(N) (IRQ_GPIO0 - (N))
	IRQ_SADC,
	IRQ_MSCALER,
	IRQ_LDC,
	IRQ_OTG,
	IRQ_RESERVED22,
	IRQ_AES,
	IRQ_DES,/*TODO*/
	IRQ_TCU2,
	IRQ_TCU1,
	IRQ_TCU0,
	IRQ_RESERVED28,
	IRQ_ISP,
	IRQ_RESERVED30,
	IRQ_RESERVED31,

	IRQ_RTC,
	IRQ_NCU,
	IRQ_DTRNG,
	IRQ_NCU_P,
	IRQ_MSC1,
	IRQ_MSC0,
	IRQ_RESERVED38,
	IRQ_RESERVED39,
	IRQ_DMIC,
	IRQ_RESERVED41,
	IRQ_RESERVED42,
	IRQ_RESERVED43,
	IRQ_HARB2,
	IRQ_RADIX0,
	IRQ_HARB0,
	IRQ_CPM,
	IRQ_RESERVED48,
	IRQ_RESERVED49,
	IRQ_UART1,
	IRQ_UART0,
	IRQ_DDR,
	IRQ_RESERVED53,
	IRQ_EFUSE,
	IRQ_GMAC,
	IRQ_RESERVED56,
	IRQ_RESERVED57,
	IRQ_I2C2,
	IRQ_I2C1,
	IRQ_I2C0,
	IRQ_PDMAM,
	IRQ_HELIX0,
	IRQ_RESERVED63,
#define IRQ_MCU_GPIO_PORT(N) (IRQ_MCU_GPIO0 + (N))
	IRQ_MCU_GPIO0,
	IRQ_MCU_GPIO1,
	IRQ_MCU_GPIO2,
	IRQ_MCU_GPIO3,
	IRQ_MCU_GPIO4,
	IRQ_MCU_GPIO5,
};

enum {
	IRQ_OST = IRQ_OST_BASE,
};

enum {
	IRQ_MCU = IRQ_MCU_BASE,
};

#endif
