/***********************************************************
*
* Copyright (C), 2010-2014, TP-LINK TECHNOLOGIES CO., LTD.
* All rights reserved.
*
* File name  : plugin-handler.h
* Version	 : 1.0
* Description: header file of encrypt-handler
*
* Author	 : Wang FuYu <wangfuyu@tp-link.net>
* Create Date: 2014-04-14
*
* History	 :
*------------------------------------------------------------
*
*01, 14Apr14, Wang FuYu, create file.
************************************************************/
#ifndef _PLUGIN_UTIL_H_
#define _PLUGIN_UTIL_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <zlib.h>
#include "pkg.h"

#ifdef TARGETVER
#include <md5_interface.h>
#endif

#define UC_FLASH_MAGIC_VALUE	0xAB01CD23
#define UC_FLASH_VER			0x01AB

#define PLUGIN_DIRMODE 0700

#define MAX_FILENAME_LEN 	256

#define MAX_NAME_LEN 		64
#define MAX_EFS_ENTRY_NUM 	64
#define MAX_EFS_FOLDERS_NUM	64

#define MAX_MD5_LEN 16
#define MAX_NUM_PLUGIN_IPK 64

#define PLUGIN_TMP_DIR	"/tmp/plugin/"
#define PLUGIN_PARTS_DIR "/www/web-static/plugin/"

#define EFS_ROOT_LEVEL 			1
#define EFS_ENTRY_TYPE_FOLDER 	0
#define EFS_ENTRY_TYPE_FILE 	1

#ifdef TARGETVER
#define SLP_MD5_DIGEST md5_make_digest
#define SLP_UNCOMPRESS uncompress
#else
#define SLP_MD5_DIGEST 
#define SLP_UNCOMPRESS
#endif

/* types define. */
typedef char BOOL;
typedef char UINT8;
typedef unsigned int UINT32;

typedef struct _FILE_PRO_
{
	unsigned int start;		/* offset to efsHeader. */
	unsigned int length;	/* length of file content */
}FILE_PRO;

typedef struct _FOLDER_PRO_
{
	unsigned int level;		/* depth of folder in dir tree, root's level is 1 */
}FOLDER_PRO;

typedef struct _EFS_ENTRY_
{
	unsigned char type;			/* 0 folder; 1 file; */
	unsigned int parentIndex;	/* node's father */
	char name[MAX_NAME_LEN];	/* node name, do not include '/' */

	union
	{
		FILE_PRO filePro;
		FOLDER_PRO folderPro;
	};
}EFS_ENTYR;

typedef struct _EFS_HEADER_
{
	unsigned int entryNum;    				/* node numuber of dir tree */
	EFS_ENTYR efsEntry[MAX_EFS_ENTRY_NUM];	/* node information of dir tree */
}EFS_HEADER;

typedef struct _ENTRY_INFO_
{
	char path[MAX_FILENAME_LEN];			/* absolute path */
	unsigned int level;
	unsigned int indexInImage;
}ENTRY_INFO;

/* folder level info */
typedef struct _EFS_FOLDER_LEVEL_
{
	unsigned int num;						/* folder level number */
	ENTRY_INFO entryInfo[MAX_EFS_FOLDERS_NUM];
}EFS_FOLDER_LEVEL;

/* EFS FILE HEAER INFORMATION */
typedef struct _EFS_FILE_
{
	unsigned int type;
	unsigned int start;
	unsigned int length;
}EFS_FILE;

/* image header info */
typedef struct _IMAGE_HEADER_
{
	unsigned int imgLen;
	EFS_FILE efsFiles;
}HEADER_TAG;

typedef struct _UC_BIN_HEADER_
{
	unsigned int updateFlag;
	unsigned int magic;
	unsigned short ver;
	unsigned short rsv;
	unsigned int length;
} UC_BIN_HEADER;

/* _PLUGIN_PARTS_FILE_ and _PLUGIN_PARTS_HAEDER_ same with SDMP */
#define PLUGIN_FILE_MAX_SIZE 0x00040000 /* 256k */
typedef enum
{
	PLUGIN_BIN_FILE = 0,
	PLUGIN_WEB_ICON = 1,
	PLUGIN_APP_WEB = 2,
	PLUGIN_APP_ICON =3,
	PLUGIN_PARTS_MAX,
} PLUGIN_PARTS_TYPE;

typedef struct _PLUGIN_PARTS_FILE_
{
	UINT32 fileOffset;
	UINT32 fileSize;
	UINT8 fileName[64];
} PLUGIN_PARTS_FILE;

typedef struct _PLUGIN_PARTS_HAEDER_
{
	UINT32 headerVer;
	UINT8 pluginId[32];
	UINT8 pluginVer[16];
	UINT8 pluginName[32];
	UINT32 pluginSize;
	UINT8 pluginTag[16];
	UINT8 pluginComp[64];
	UINT8 pluginAuthor[64];
	UINT8 osVer[16];
	UINT8 md5[16];
	UINT32 pluginType;
	PLUGIN_PARTS_FILE pluginFile[16];
	UINT8 reserved[256]; 
} PLUGIN_PARTS_HAEDER;

#define FREE_P(x) \
		do{\
			if (NULL != (x)){	\
				free(x);	\
				(x) = NULL;	\
			}\
		}while(0)

int unzipPluginPkg(const char *url, char ipkDir[]);

#endif
