//<MStar Software>
//******************************************************************************
// MStar Software
// Copyright (c) 2010 - 2012 MStar Semiconductor, Inc. All rights reserved.
// All software, firmware and related documentation herein ("MStar Software") are
// intellectual property of MStar Semiconductor, Inc. ("MStar") and protected by
// law, including, but not limited to, copyright law and international treaties.
// Any use, modification, reproduction, retransmission, or republication of all
// or part of MStar Software is expressly prohibited, unless prior written
// permission has been granted by MStar.
//
// By accessing, browsing and/or using MStar Software, you acknowledge that you
// have read, understood, and agree, to be bound by below terms ("Terms") and to
// comply with all applicable laws and regulations:
//
// 1. MStar shall retain any and all right, ownership and interest to MStar
//    Software and any modification/derivatives thereof.
//    No right, ownership, or interest to MStar Software and any
//    modification/derivatives thereof is transferred to you under Terms.
//
// 2. You understand that MStar Software might include, incorporate or be
//    supplied together with third party`s software and the use of MStar
//    Software may require additional licenses from third parties.
//    Therefore, you hereby agree it is your sole responsibility to separately
//    obtain any and all third party right and license necessary for your use of
//    such third party`s software.
//
// 3. MStar Software and any modification/derivatives thereof shall be deemed as
//    MStar`s confidential information and you agree to keep MStar`s
//    confidential information in strictest confidence and not disclose to any
//    third party.
//
// 4. MStar Software is provided on an "AS IS" basis without warranties of any
//    kind. Any warranties are hereby expressly disclaimed by MStar, including
//    without limitation, any warranties of merchantability, non-infringement of
//    intellectual property rights, fitness for a particular purpose, error free
//    and in conformity with any international standard.  You agree to waive any
//    claim against MStar for any loss, damage, cost or expense that you may
//    incur related to your use of MStar Software.
//    In no event shall MStar be liable for any direct, indirect, incidental or
//    consequential damages, including without limitation, lost of profit or
//    revenues, lost or damage of data, and unauthorized system use.
//    You agree that this Section 4 shall still apply without being affected
//    even if MStar Software has been modified by MStar in accordance with your
//    request or instruction for your use, except otherwise agreed by both
//    parties in writing.
//
// 5. If requested, MStar may from time to time provide technical supports or
//    services in relation with MStar Software to you for your use of
//    MStar Software in conjunction with your or your customer`s product
//    ("Services").
//    You understand and agree that, except otherwise agreed by both parties in
//    writing, Services are provided on an "AS IS" basis and the warranty
//    disclaimer set forth in Section 4 above shall apply.
//
// 6. Nothing contained herein shall be construed as by implication, estoppels
//    or otherwise:
//    (a) conferring any license or right to use MStar name, trademark, service
//        mark, symbol or any other identification;
//    (b) obligating MStar or any of its affiliates to furnish any person,
//        including without limitation, you and your customers, any assistance
//        of any kind whatsoever, or any information; or
//    (c) conferring any license or right under any intellectual property right.
//
// 7. These terms shall be governed by and construed in accordance with the laws
//    of Taiwan, R.O.C., excluding its conflict of law rules.
//    Any and all dispute arising out hereof or related hereto shall be finally
//    settled by arbitration referred to the Chinese Arbitration Association,
//    Taipei in accordance with the ROC Arbitration Law and the Arbitration
//    Rules of the Association by three (3) arbitrators appointed in accordance
//    with the said Rules.
//    The place of arbitration shall be in Taipei, Taiwan and the language shall
//    be English.
//    The arbitration award shall be final and binding to both parties.
//
//******************************************************************************
//<MStar Software>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <stdint.h>
#include <sys/stat.h>

#include "common.h"
#include "jiffs2/load_kernel.h"
#include "tool-util.h"
#include "types.h"
#include "dictionary.h"
#include "libiniparser.h"
#include "inc/common/drvNAND.h"

extern dictionary *dict;
extern struct platform_info info;

char *root_directory;
char *image_directory;

U8 u8MainBuf[8192*4] UNFD_ALIGN1;
U8 u8SpareBuf[640*4] UNFD_ALIGN1;

U32 drvNAND_Init(void)
{
	int fd, ret, len;
	char file[512];
	unsigned char *nni_buf = NULL;
	unsigned char *pni_buf = NULL;
	unsigned char *ppm_buf = NULL;
	char *nni, *pni, *ppm;
	struct stat st;

	U32 u32_Err = 0;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();
	NAND_FLASH_INFO_t *pNandInfo = (NAND_FLASH_INFO_t *)drvNAND_get_DrvContext_NandInfo();

	memset(pNandDrv, 0, sizeof(*pNandDrv));
	memset(pNandInfo, 0, 512);

	//set nni buffer
	nni = iniparser_getstring(dict, "cis:nni", "Not set");
	if(strcmp(nni, "Not set") == 0){
		printf("[%s]: No nni file, cannot determine nand parameters\n", __func__);
		u32_Err = 1;
		goto out;
	}
	memset(file, 0, sizeof(file));
	sprintf(file, "%s%s%s", root_directory, image_directory, nni);
	fd = open(file, O_RDWR);
	if(fd < 0){
		printf("[%s]: Cannot open nni file %s\n", __func__);
		u32_Err = 1;
		goto out;
	}
	stat(file, &st);
	nni_buf = (unsigned char *)malloc(st.st_size);
	ret = read(fd, nni_buf, st.st_size);
	if(ret < 0){
		printf("[%s]: read nni file failed\n", __func__);
		close(fd);
		u32_Err = 1;
		goto out;
	}
	close(fd);

	//set pni buffer
	pni = iniparser_getstring(dict, "cis:pni", "Not set");
	if(strcmp(pni, "Not set") == 0){
		printf("[%s]: No pni file, cannot determine nand parameters\n", __func__);
	}
	else{
		memset(file, 0, sizeof(file));
		sprintf(file, "%s%s%s", root_directory, image_directory, pni);
		fd = open(file, O_RDWR);
		if(fd < 0){
			printf("[%s]: Cannot open pni file %s\n", __func__);
			u32_Err = 1;
			goto out;
		}
		stat(file, &st);
		pni_buf = (unsigned char *)malloc(st.st_size);
		ret = read(fd, pni_buf, st.st_size);
		if(ret < 0){
			printf("[%s]: read pni file failed\n", __func__);
			close(fd);
			u32_Err = 1;
			goto out;
		}
		close(fd);
	}

	//set ppm buffer
	ppm = iniparser_getstring(dict, "cis:ppm", "Not set");
	if(strcmp(ppm, "Not set") == 0){
		printf("[%s]: No ppm file, cannot determine nand parameters\n", __func__);
	}
	else{
		memset(file, 0, sizeof(file));
		sprintf(file, "%s%s%s", root_directory, image_directory, ppm);
		fd = open(file, O_RDWR);
		if(fd < 0){
			printf("[%s]: Cannot open ppm file %s\n", __func__);
			u32_Err = 1;
			goto out;
		}
		stat(file, &st);
		ppm_buf = (unsigned char *)malloc(st.st_size);
		ret = read(fd, ppm_buf, st.st_size);
		if(ret < 0){
			printf("[%s]: read ppm file failed\n", __func__);
			close(fd);
			u32_Err = 1;
			goto out;
		}
		close(fd);
	}

	memset(pNandDrv, 0, sizeof(NAND_DRIVER));

	NC_PlatformInit();

	pNandDrv->pPartInfo = (PARTITION_INFO_t *) drvNAND_get_DrvContext_PartInfo();
	memset(pNandDrv->pPartInfo, 0, NAND_PARTITAION_BYTE_CNT);

	u32_Err = search_cis_in_DRAM(nni_buf, ppm_buf, pni_buf, pNandInfo);

out:
	if(nni_buf)
		free(nni_buf);
	if(pni_buf)
		free(pni_buf);
	if(ppm_buf)
		free(ppm_buf);
    //dump_nand_driver(pNandDrv);

	return u32_Err;
}

int nand_unfd_init(void)
{
	U32 u32_Err, u32_Ret;
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();

	u32_Err = drvNAND_Init();
	if(u32_Err){
		printf("[%s]: nand driver init failed\n", __func__);
		return -1;
	}

	pNandDrv->PlatCtx_t.pu8_PageDataBuf = (U8 *)malloc(pNandDrv->u16_PageByteCnt);
	if(!pNandDrv->PlatCtx_t.pu8_PageDataBuf){
		printf("[%s]: malloc page buffer failed\n", __func__);
		return -1;
	}
	pNandDrv->PlatCtx_t.pu8_PageSpareBuf= (U8 *)malloc(pNandDrv->u16_PageByteCnt); //kylin??
	if(!pNandDrv->PlatCtx_t.pu8_PageSpareBuf){
		printf("[%s]: malloc spare buffer failed\n", __func__);
		return -1;
	}

#if defined(__VER_UNFD_FTL__)&&__VER_UNFD_FTL__
	pNandDrv->PlatCtxFTL_t.pu8_PageDataBuf = (U8 *)malloc(pNandDrv->u16_PageByteCnt);
	if(!pNandDrv->PlatCtxFTL_t.pu8_PageDataBuf){
		printf("[%s]: malloc FTL page buffer failed\n", __func__);
		return -1;
	}
	pNandDrv->PlatCtxFTL_t.pu8_PageSpareBuf= (U8 *)malloc(pNandDrv->u16_SpareByteCnt);
	if(!pNandDrv->PlatCtxFTL_t.pu8_PageSpareBuf){
		printf("[%s]: malloc FTL spare buffer failed\n", __func__);
		return -1;
	}
#endif //__VER_UNFD_FTL__

	dump_nand_driver(pNandDrv);

	return 0;
}


/*
 * Board-specific NAND initialization.
 * - hwcontrol: hardwarespecific function for accesing control-lines
 * - dev_ready: hardwarespecific function for  accesing device ready/busy line
 * - eccmode: mode of ecc, see defines
 */
int board_nand_init(struct nand_chip *nand)
{
	if( nand_unfd_init() != 0 )
		return -1;

	return 0;
}

void board_nand_exit(void)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();

	if(pNandDrv->PlatCtx_t.pu8_PageDataBuf)
		free(pNandDrv->PlatCtx_t.pu8_PageDataBuf);
	if(pNandDrv->PlatCtx_t.pu8_PageSpareBuf)
		free(pNandDrv->PlatCtx_t.pu8_PageSpareBuf);
}

U32 drvNAND_WriteCIS_for_ROM(NAND_FLASH_INFO_t * pNandInfo)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();
	PARTITION_INFO_t *pPartInfo = (PARTITION_INFO_t *)drvNAND_get_DrvContext_PartInfo();
	U8 *au8_PageBuf = (U8*)u8MainBuf;
	U8 *au8_SpareBuf = (U8*)u8SpareBuf;
	BLK_INFO_t *pBlkInfo = (BLK_INFO_t*)au8_SpareBuf;
	U32 u32_Err = UNFD_ST_SUCCESS;
	U16 u16_PBA;
	U32 u32_PageIdx;
	U8 u8_CISIdx;

	NC_ConfigContext();
	NC_ReInit();
	NC_Config();

	memcpy((void *) &pNandInfo->tDefaultDDR, (const void *) &pNandDrv->tDefaultDDR, sizeof(DDR_TIMING_GROUP_t));
	memcpy((void *) &pNandInfo->tMaxDDR, (const void *) &pNandDrv->tMaxDDR, sizeof(DDR_TIMING_GROUP_t));
	memcpy((void *) &pNandInfo->tMinDDR, (const void *) &pNandDrv->tMinDDR, sizeof(DDR_TIMING_GROUP_t));

	u8_CISIdx = 0;

	/* Search for two good blocks within the first 10 physical blocks */
	for (u16_PBA = 0; u16_PBA < 10; u16_PBA++) {

		/* Reeset NAND driver and FCIE to the original settings */
		pNandDrv->u16_SpareByteCnt = pNandInfo->u16_SpareByteCnt;
		pNandDrv->u16_PageByteCnt  = pNandInfo->u16_PageByteCnt;
		pNandDrv->u16_ECCType      = pNandInfo->u16_ECCType;
		NC_ConfigContext();
		NC_ReInit();
		pNandDrv->u16_Reg48_Spare &= ~(1 << 12);
		//Disable Randomizer for nni Read/Write
		#if defined(FCIE_LFSR) && FCIE_LFSR
		if(pNandDrv->u8_RequireRandomizer)
			NC_DisableLFSR();
		#endif
		NC_Config();

		u32_PageIdx = u16_PBA << pNandDrv->u8_BlkPageCntBits;

                /* Check block is good block */
		if(!drvNAND_IsGoodBlk(u16_PBA))
			continue;

		pNandDrv->u16_PageByteCnt = 2048;
		pNandDrv->u16_SpareByteCnt = 256;
		pNandDrv->u16_ECCType = NANDINFO_ECC_TYPE;

		NC_ConfigContext();
		NC_ReInit();

		pNandDrv->u16_Reg48_Spare |= (1 << 12);
		NC_Config();
        pNandInfo->u16_PhyOobsize = 0;
		memset(au8_PageBuf, 0xFF, pNandDrv->u16_PageByteCnt);
        memset(au8_PageBuf, '\0', 1024);
		memcpy(au8_PageBuf, pNandInfo, sizeof(NAND_FLASH_INFO_t));
		memset(au8_SpareBuf, 0xFF, pNandDrv->u16_SpareByteCnt);

		pBlkInfo->u8_BadBlkMark = 0xFF;
		pBlkInfo->u8_PartType = 0;

		u32_Err = NC_WriteSectors(u32_PageIdx, 0, au8_PageBuf, au8_SpareBuf, 1);
		if (u32_Err != UNFD_ST_SUCCESS)
		{
			printf("Write Nand Info failed with EC: 0x%08lx\n", u32_Err);
			drvNAND_MarkBadBlk(u16_PBA);
			continue;
		}
        pNandInfo->u16_PhyOobsize = 0x40;
		/* Reset NAND driver and FCIE to the original settings */
		pNandDrv->u16_SpareByteCnt = pNandInfo->u16_SpareByteCnt;
		pNandDrv->u16_PageByteCnt  = pNandInfo->u16_PageByteCnt;
		pNandDrv->u16_ECCType      = pNandInfo->u16_ECCType;
		NC_ConfigContext();
		NC_ReInit();

		pNandDrv->u16_Reg48_Spare &= ~BIT_NC_HW_AUTO_RANDOM_CMD_DISABLE;
		NC_Config();

		/*
		**	Write Partition Info the 2nd page
		**/
		if(pNandDrv->u8_HasPNI == 1)
		{
			memset(au8_PageBuf, '\0', pNandDrv->u16_PageByteCnt);
			memcpy(au8_PageBuf, pPartInfo, 0x200);
            printf("[%s]:%d u16_PageSectorCnt=%d\n", __func__, __LINE__, pNandDrv->u16_PageSectorCnt);
			u32_Err = NC_WriteSectors(u32_PageIdx + ga_tPairedPageMap[1].u16_LSB, 0, au8_PageBuf, au8_SpareBuf, pNandDrv->u16_PageSectorCnt);
			if (u32_Err != UNFD_ST_SUCCESS)
			{
				printf("Write Part Info failed with EC: 0x%08lx\n", u32_Err);
				drvNAND_MarkBadBlk(u16_PBA);
				continue;
			}
		}

		/*
		 *Sync CL#1268947 & simplify it
		 */
		if(info.boottype == BFN)
		{
			memset(au8_PageBuf, '\0', pNandDrv->u16_PageByteCnt);
			memset(au8_SpareBuf, 0xFF, pNandDrv->u16_SpareByteCnt);
            //printf("[%s]:%d \n", __func__, __LINE__);
			u32_Err = NC_WriteSectors(u32_PageIdx+ga_tPairedPageMap[2].u16_LSB, 0, au8_PageBuf, au8_SpareBuf, 1);
			if (u32_Err != UNFD_ST_SUCCESS) {
				printf("[%s]: Write Initial BBT failed with EC: 0x%08x\n", __FUNCTION__, (unsigned int)u32_Err);
				return u32_Err;
			}
		}

		/*
		**  Write Paired Page Map to the 4th page
		**/
		if(pNandDrv->u8_CellType == 1)  // MLC
		{
			memset(au8_PageBuf, '\0', pNandDrv->u16_PageByteCnt);
			memcpy(au8_PageBuf, &ga_tPairedPageMap, 2048);
			u32_Err = NC_WriteSectors(u32_PageIdx+pNandInfo->u8_PairPageMapLoc, 0, au8_PageBuf, au8_SpareBuf, pNandDrv->u16_PageSectorCnt);
			if (u32_Err != UNFD_ST_SUCCESS) {
				printf("Write Paired-Page Map failed with EC: 0x%08lx\n", u32_Err);
				drvNAND_MarkBadBlk(u16_PBA);
				continue;
			}
		}

		/*
		if(pNandDrv->u8_RequireReadRetry && pNandDrv->u8_ReadRetryLoc != 0)  // MLC
		{
			memset(au8_PageBuf, '\0', pNandDrv->u16_PageByteCnt);
			memcpy(au8_PageBuf, &gau8_ReadRetryTable, 512);
			u32_Err = NC_WritePages(u32_PageIdx+pNandInfo->u8_ReadRetryLoc, au8_PageBuf, au8_SpareBuf, 1);
			if (u32_Err != UNFD_ST_SUCCESS) {
				nand_debug(UNFD_DEBUG_LEVEL_ERROR, 1, "Write Customize Read-Retry Table failed with EC: 0x%08lx\n", u32_Err);
				drvNAND_MarkBadBlk(u16_PBA);
				continue;
			}
		}
		*/

		printf("CIS%d is written to blk 0x%04x\n", u8_CISIdx, u16_PBA);

		pNandDrv->u16_CISPBA[u8_CISIdx] = u16_PBA;

		if ((++u8_CISIdx) == 2)
			break;
	}

	/* Reset NAND driver and FCIE to the original settings */
	pNandDrv->u16_SpareByteCnt = pNandInfo->u16_SpareByteCnt;
	pNandDrv->u16_PageByteCnt  = pNandInfo->u16_PageByteCnt;
	pNandDrv->u16_ECCType      = pNandInfo->u16_ECCType;
	NC_ConfigContext();
	NC_ReInit();
	pNandDrv->u16_Reg48_Spare &= ~(1 << 12);
	NC_Config();

	switch (u8_CISIdx) {
		case 0:
			u32_Err = UNFD_ST_ERR_NO_BLK_FOR_CIS0;
			break;
		case 1:
			u32_Err = UNFD_ST_ERR_NO_BLK_FOR_CIS1;
			break;
		case 2:
			u32_Err = UNFD_ST_SUCCESS;
			break;
	}

    return u32_Err;
}

int search_cis_in_DRAM(U8* pu8_CISAddr, U8* pu8_PPMAddr, U8* pu8_PNIAddr, NAND_FLASH_INFO_t *pNandInfoOut)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
	NAND_FLASH_INFO_t  *pNandInfo;
	PARTITION_INFO_t  *pPartInfo;
	U32 u32_i, u32_j, u32_Err, u32_ChkSum;
	U8 u8_IsEnd = 0;

	NC_PlatformInit();

	u32_Err = NC_ResetNandFlash();
	if(u32_Err != UNFD_ST_SUCCESS)
	{
		printf("NAND Reset Fail\n");
		return -1;
	}

	u32_Err = NC_ReadID();
	if(u32_Err!= UNFD_ST_SUCCESS)
	{
		printf("Read ID Fail\n");
		return -1;
	}

	printf("Begin Search CIS in DRAM\n");

	//Search 20 pieces of possiable cis memory
	//for(u32_i = 0; u32_i < 0x200 * 20; u32_i += 0x200)
	u32_i = 0;
	while(1)
	{
		pNandInfo = (NAND_FLASH_INFO_t*)(pu8_CISAddr + u32_i);
		for(u32_j=0; u32_j<pNandInfo->u8_IDByteCnt; u32_j++)
		{
			if(pNandInfo->au8_ID[u32_j] != pNandDrv->au8_ID[u32_j])
				break;
		}
		if(u32_j == pNandInfo->u8_IDByteCnt)
			break;

		u32_ChkSum = drvNAND_CheckSum(((void*)pNandInfo) + 0x24, 0x32 - 0x24);
		if (drvNAND_CompareCISTag(pNandInfo->au8_Tag) ||(u32_ChkSum != pNandInfo->u32_ChkSum) )
		{
			u8_IsEnd = 1;
			break;
		}
		u32_i += 0x200;
	}
	if(u8_IsEnd)
	{
		printf("No available CIS match with current nand flash\n");
		return -1;
	}
	printf("NAND ID:");
	for(u32_j=0; u32_j<pNandInfo->u8_IDByteCnt; u32_j++)
	{
		printf("0x%X ", pNandDrv->au8_ID[u32_j]);
	}
	printf("\nFound CIS in given memory\n");
	drvNAND_ParseNandInfo(pNandInfo);

	NC_ConfigContext();

	/*Re-Search DDR timing again*/
	u32_Err = NC_Init();
	if(u32_Err != UNFD_ST_SUCCESS)
	{
		printf("NC_Init Fail ErrCode: %lX\n", u32_Err);
		return -1;
	}
	NC_Config();

	//search pni
	pNandDrv->u8_HasPNI = 0;
	if(pu8_PNIAddr != NULL)
	{
		for(u32_i = 0; u32_i < NAND_PARTITAION_BYTE_CNT * 20 ; u32_i += NAND_PARTITAION_BYTE_CNT)
		{
			pPartInfo = (PARTITION_INFO_t*) (pu8_PNIAddr + u32_i);

			if(pPartInfo->u16_SpareByteCnt == pNandDrv->u16_SpareByteCnt &&
				pPartInfo->u16_PageByteCnt == pNandDrv->u16_PageByteCnt &&
				pPartInfo->u16_BlkPageCnt == pNandDrv->u16_BlkPageCnt &&
				pPartInfo->u16_BlkCnt == pNandDrv->u16_BlkCnt)				//Match Partition layout
			{
				memcpy(pNandDrv->pPartInfo, pPartInfo, 0x200);
				dump_part_info(pNandDrv->pPartInfo);
				pNandDrv->u8_HasPNI = 1;
				break;
			}
		}
        if(u32_i >= NAND_PARTITAION_BYTE_CNT * 20)
        {
            pNandDrv->u8_HasPNI = 1;
            printf("%s:%d **********pni file not match,use first pni**********\n", __func__, __LINE__);
            memcpy(pNandDrv->pPartInfo, pu8_PNIAddr, 0x200);
            dump_part_info(pNandDrv->pPartInfo);
        }
	}
	//memcpy pair page map

	printf("Cell Type %d, Randomizer %d\n", pNandDrv->u8_CellType, pNandDrv->u8_RequireRandomizer);
	if(pNandDrv->u8_CellType)
		memcpy(&ga_tPairedPageMap, pu8_PPMAddr + (pNandInfo->u8_PairPageMapType * 0x800), 0x800);
	else
	{
		for(u32_i = 0; u32_i < 0x200; u32_i++)
		{
			ga_tPairedPageMap[u32_i].u16_LSB = u32_i;
			ga_tPairedPageMap[u32_i].u16_MSB = u32_i;
		}
	}

	memcpy(pNandInfoOut, pNandInfo, sizeof(NAND_FLASH_INFO_t));

	return 0;
}

int nand_write_block_slcmode(U32 u32_BlkRow, U8* p_buffer, U32 u32_PageCnt, U32 (*nand_markbad)(U32))
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

	int i, j, BlkPageCnt;
	U32 u32_TmpRow, u32_Err;
	U8 *pu8_buffer = p_buffer;
	U8 *pu8_PageDataBuf = pNandDrv->PlatCtx_t.pu8_PageDataBuf;
	BlkPageCnt = pNandDrv->u16_BlkPageCnt >> 1;

	memset(pu8_PageDataBuf, 0x5a5a, pNandDrv->u16_PageByteCnt);

	for(i = 0; i < u32_PageCnt; i ++)
	{
		u32_TmpRow = u32_BlkRow + ga_tPairedPageMap[i].u16_LSB;
		u32_Err = drvNAND_LFSRWritePhyPage(u32_TmpRow, pu8_buffer, NULL);
		if(u32_Err)
		{
			printf ("NAND write to offset %lx failed %ld\n", u32_TmpRow, u32_Err);
			printf("Mark current block as bad block\n");
			//mark bad
			if(nand_markbad == NULL)
				drvNAND_MarkBadBlk(u32_BlkRow >> pNandDrv->u8_BlkPageCntBits);
			else
				nand_markbad(u32_BlkRow >> pNandDrv->u8_BlkPageCntBits);

			pu8_buffer -= pNandDrv->u16_PageByteCnt * i;
			u32_BlkRow += pNandDrv->u16_BlkPageCnt;

			return -1;
		}
		pu8_buffer += pNandDrv->u16_PageByteCnt;

		//Write Dummy data to MSB Page of MLC NAND
		if(i != BlkPageCnt - 1)
		{
			if(ga_tPairedPageMap[i].u16_LSB != (ga_tPairedPageMap[i + 1].u16_LSB - 1))
			{
				for(j = ga_tPairedPageMap[i].u16_LSB + 1; j < ga_tPairedPageMap[i + 1].u16_LSB; j ++)
				{
					u32_Err = drvNAND_LFSRWritePhyPage(u32_BlkRow + j, pu8_PageDataBuf, NULL);
					if(u32_Err)
					{
						printf ("NAND write to offset %lx failed %ld\n", u32_BlkRow + j, u32_Err);
						printf("Mark current block as bad block\n");
						//mark bad
						if(nand_markbad == NULL)
							drvNAND_MarkBadBlk(u32_BlkRow >> pNandDrv->u8_BlkPageCntBits);
						else
							nand_markbad(u32_BlkRow >> pNandDrv->u8_BlkPageCntBits);

						pu8_buffer -= pNandDrv->u16_PageByteCnt * i;
						u32_BlkRow += pNandDrv->u16_BlkPageCnt;

						return -1;
					}
				}
			}
		}
		else{
			for(j = ga_tPairedPageMap[i].u16_LSB + 1; j < pNandDrv->u16_BlkPageCnt; j ++)
			{
				u32_Err = drvNAND_LFSRWritePhyPage(u32_BlkRow + j, pu8_PageDataBuf, NULL);
				if(u32_Err)
				{
					printf ("NAND write to offset %lx failed %ld\n", u32_BlkRow + j, u32_Err);
					printf("Mark current block as bad block\n");
					//mark bad
					if(nand_markbad == NULL)
						drvNAND_MarkBadBlk(u32_BlkRow >> pNandDrv->u8_BlkPageCntBits);
					else
						nand_markbad(u32_BlkRow >> pNandDrv->u8_BlkPageCntBits);

					pu8_buffer -= pNandDrv->u16_PageByteCnt * i;
					u32_BlkRow += pNandDrv->u16_BlkPageCnt;

					return -1;
				}
			}
		}
	}
	return 0;
}

int nand_write_bootloader(U32 u32_Row,U8 * pu8_addr, U32 u32_size, U8 u8_BootStageId)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

	U8 * pu8_DataBuf = pu8_addr;
	U16 u16_BlkPageCnt;
	U32 u32_pagecnt, u32_Err, u32_size_tmp = u32_size, u32_Row_Read = u32_Row;
	U8 u8_IdWritten = 0;
	u16_BlkPageCnt = (pNandDrv->u8_CellType) ? pNandDrv->u16_BlkPageCnt/2: pNandDrv->u16_BlkPageCnt;

	memset(u8SpareBuf, 0xFF, pNandDrv->u16_SpareByteCnt);

	u32_pagecnt = u32_size >> pNandDrv->u8_PageByteCntBits;

	#if defined(FCIE_LFSR) && FCIE_LFSR
	if(pNandDrv->u8_RequireRandomizer)
		NC_DisableLFSR();
	#endif
	while(u32_pagecnt >= u16_BlkPageCnt)
	{
		while (drvNAND_IsGoodBlk(u32_Row >> pNandDrv->u8_BlkPageCntBits) == 0)
		{
			u32_Row += pNandDrv->u16_BlkPageCnt;
			//bad block jump to next block
			if(u32_Row == (pNandDrv->u16_BlkCnt << pNandDrv->u8_BlkPageCntBits))
			{
				printf("Error : There is no available GOOD block in current nand device\n");
				return -1;
			}
		}

		if(u8_IdWritten == 0)
			u8SpareBuf[1] = u8_BootStageId;
		else
			u8SpareBuf[1] = 0xFF;

		if(pNandDrv->u8_CellType)
		{
			U16 u16_i, u16_flag = 0;
			U32 u32_TmpRow;
			for(u16_i =0; u16_i < u16_BlkPageCnt; u16_i ++)
			{
				u32_TmpRow = u32_Row + ga_tPairedPageMap[u16_i].u16_LSB;
				u32_Err = NC_WritePages(u32_TmpRow, pu8_DataBuf, u8SpareBuf, 1);
				if(u32_Err != UNFD_ST_SUCCESS)
				{
					drvNAND_MarkBadBlk(u32_Row >> pNandDrv->u8_BlkPageCntBits);
					//jump to next block
					u32_Row += pNandDrv->u16_BlkPageCnt;
					u16_flag = 1;
					break;
				}
				pu8_DataBuf += pNandDrv->u16_PageByteCnt;
			}
			if(u16_flag == 1)
			{
				pu8_DataBuf -= pNandDrv->u16_PageByteCnt * u16_i;
				continue;
			}
		}
		else
		{

			U16 u16_i;
			for(u16_i =0; u16_i < pNandDrv->u16_BlkPageCnt; u16_i ++)
			{
			   u32_Err = NC_WritePages(u32_Row+u16_i, pu8_DataBuf, u8SpareBuf, 1);
			    if(u32_Err != UNFD_ST_SUCCESS)
			    {
				    drvNAND_MarkBadBlk(u32_Row >> pNandDrv->u8_BlkPageCntBits);
				    //jump to next block
				    u32_Row += pNandDrv->u16_BlkPageCnt;
				    break;
			    }
			   pu8_DataBuf += pNandDrv->u16_PageByteCnt;
			}

		}
		u8_IdWritten = 1;

		u32_pagecnt -= u16_BlkPageCnt;
		u32_size -= (u16_BlkPageCnt << pNandDrv->u8_PageByteCntBits);
		u32_Row += pNandDrv->u16_BlkPageCnt;
	}

	while(u32_size)
	{
		while (drvNAND_IsGoodBlk(u32_Row >> pNandDrv->u8_BlkPageCntBits) == 0)
		{
			u32_Row += pNandDrv->u16_BlkPageCnt;
			//bad block jump to next block
			if(u32_Row == (pNandDrv->u16_BlkCnt << pNandDrv->u8_BlkPageCntBits))
			{
				printf("Error : There is no available GOOD block in current nand device\n");
				return -1;
			}
		}

		if(u8_IdWritten == 0)
			u8SpareBuf[1] = u8_BootStageId;
		else
			u8SpareBuf[1] = 0xFF;

		u32_pagecnt = u32_size >> pNandDrv->u8_PageByteCntBits;
		if((u32_size & (pNandDrv->u16_PageByteCnt -1)))
			 u32_pagecnt += 1;

		if(pNandDrv->u8_CellType)
		{
			U16 u16_i, u16_flag = 0;
			U32 u32_TmpRow;
			for(u16_i =0; u16_i < u32_pagecnt; u16_i ++)
			{
				u32_TmpRow = u32_Row + ga_tPairedPageMap[u16_i].u16_LSB;
				u32_Err = NC_WritePages(u32_TmpRow, pu8_DataBuf, u8SpareBuf, 1);
				if(u32_Err != UNFD_ST_SUCCESS)
				{
					drvNAND_MarkBadBlk(u32_Row >> pNandDrv->u8_BlkPageCntBits);
					//jump to next block
					u32_Row += pNandDrv->u16_BlkPageCnt;
					u16_flag = 1;
					break;
				}
				pu8_DataBuf += pNandDrv->u16_PageByteCnt;
			}
			if(u16_flag == 1)
			{
				pu8_DataBuf -= pNandDrv->u16_PageByteCnt * u16_i;
				continue;
			}
		}
		else
		{
			U16 u16_i;
			for(u16_i =0; u16_i < u32_pagecnt; u16_i ++)
			{
			   u32_Err = NC_WritePages(u32_Row+u16_i, pu8_DataBuf, u8SpareBuf, 1);
			    if(u32_Err != UNFD_ST_SUCCESS)
			    {
				    drvNAND_MarkBadBlk(u32_Row >> pNandDrv->u8_BlkPageCntBits);
				    //jump to next block
				    u32_Row += pNandDrv->u16_BlkPageCnt;
				    break;
			    }
			   pu8_DataBuf += pNandDrv->u16_PageByteCnt;
			}

		}
			u8_IdWritten = 1;

			u32_size-= u32_size;
	}
	return 0;
}

static u32 empty_check(const void *buf, u32 len)
{
	int i;
	NAND_DRIVER * pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

	//if ((!len) || (len & (meminfo->oobblock + meminfo->oobsize - 1)))
		//return -1;

	for (i = (len >> 2) - 1; i >= 0; i--)
		if (((const uint32_t *)buf)[i] != 0xFFFFFFFF)
			break;

	/* The resulting length must be aligned to the minimum flash I/O size */
	len = ALIGN((i + 1) << 2, pNandDrv->u16_PageByteCnt + pNandDrv->u16_SpareByteCnt);
	return len;
}

int fullblockprogram_and_randomizer(uint64_t filesize)
{
    struct mtd_device *dev=NULL;
	struct part_info *part=NULL;
    char *databuf = NULL, *sparebuf = NULL;
    uint64_t partsize, partoffset, offset;
    u32 u32_pageidx, u32_blocksize, u32_PhyRowIdx;
    u16 u16_pagelen, u16_chklen;
    u8 pnum, eflag, ret, i;
    u8 pagecnt = 32, readpagecnt;

    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    if( !info.fullblkprg && !pNandDrv->u8_RequireRandomizer )
    {
        printf("\n[%s]: ***this nand havn't set fullblkprg and Randomizer***!!!\n",  __func__);
        return -1;
    }
    if(info.fullblkprg)
        printf("\n[%s]: ***this nand have set fullblkprg ***!!!\n",  __func__);
    if(pNandDrv->u8_RequireRandomizer)
        printf("\n[%s]: ***this nand have set Randomizer ***!!!\n",  __func__);

    if((find_dev_and_part("ubi", &dev, &pnum, &part) != 0) && (find_dev_and_part("UBI", &dev, &pnum, &part) != 0))
    {
	    printf("%s: Error: find dev and part, at %d\n", __func__, __LINE__);
		return -1;
	}
    if(part == NULL)
	{
	    printf("%s: Error: null part, at %d\n", __func__, __LINE__);
	    return -1;
	}

    u16_pagelen = pNandDrv->u16_PageByteCnt + pNandDrv->u16_SpareByteCnt;
    u32_blocksize = (u32)u16_pagelen * pNandDrv->u16_BlkPageCnt;
    partoffset = (part->offset/ pNandDrv->u16_PageByteCnt) * u16_pagelen;
	//partsize = (part->size / pNandDrv->u16_PageByteCnt) * u16_pagelen;
	partsize =filesize / (pNandDrv->u16_PageByteCnt + pNandDrv->u16_PhyOobsize) * u16_pagelen - partoffset;        //truncate file with 0xff when ubi is in last part,or run fail
    //printf("\n*******Start to full_block_program part %s at offset: 0x%llx, length: 0x%llx*****\n", part->name, partoffset, partsize);

    printf("\n\n[%s]: ********wait*******!!!\n\n",  __func__);

    databuf = (char *)malloc(pNandDrv->u16_PageByteCnt*pagecnt);
    sparebuf = (char *)malloc(pNandDrv->u16_SpareByteCnt*pagecnt);
    if (!databuf || !sparebuf)
    {
	    printf("[%s]: out of memory\n", __func__);
        free(databuf);
        free(sparebuf);
	    return -1;
	}


    for(offset = 10*u32_blocksize; offset < partoffset + partsize; offset += u32_blocksize)
    {
        u32_pageidx = (u32)offset / u16_pagelen;
        u32_PhyRowIdx = u32_pageidx;
        eflag = 1;
        readpagecnt = pagecnt;
        while( u32_PhyRowIdx < u32_pageidx + pNandDrv->u16_BlkPageCnt)
        {
            if(u32_PhyRowIdx + readpagecnt >= u32_pageidx + pNandDrv->u16_BlkPageCnt)
                readpagecnt = u32_pageidx + pNandDrv->u16_BlkPageCnt - u32_PhyRowIdx;
            memset(databuf, 0xFF, pNandDrv->u16_PageByteCnt*readpagecnt);
            memset(sparebuf, 0xFF, pNandDrv->u16_SpareByteCnt*readpagecnt);
            ret = NC_ReadPages(u32_PhyRowIdx, databuf, sparebuf, readpagecnt);
            //printf("\n*******Start to  offset: 0x%llx, length: 0x%lx*****\n",offset, u32_PhyRowIdx);
            if(ret)
            {
				printf("[%s]: read page %lu failed\n", __func__, u32_PhyRowIdx);
				return ret;
		    }
            u16_chklen = empty_check(sparebuf, pNandDrv->u16_SpareByteCnt);
            //u16_chklen = empty_check(databuf, pNandDrv->u16_PageByteCnt);
            if (eflag == 1 && u16_chklen == 0) // first page of a block
                break;

            for(i = 0; i < readpagecnt; i++)
            {
                if(offset >= partoffset && info.fullblkprg)
                {
                    if (eflag == 1) // first page of a block
                    {
                        if (u16_chklen != 0)
                            /* non-empty, maybe need empty flag bits in the following empty page */
                            eflag = 3;
                    }
                    else if ((eflag == 3) && (u16_chklen == 0))
                    {
                        // indicate empty page,excute fullblockprogram
                        nand_fullblockprogram(databuf);
                        //printf("\n*******Start to write page %s at offset: 0x%llx, PhyRowIdx: 0x%llx*****\n",part->name, offset, u32_PhyRowIdx);

                    }
                }
                //excute nand_randomizer
                nand_randomizer(databuf, sparebuf, u32_PhyRowIdx + i);
                databuf = databuf + pNandDrv->u16_PageByteCnt;
                sparebuf = sparebuf + pNandDrv->u16_SpareByteCnt;
            }

            databuf = databuf - readpagecnt * pNandDrv->u16_PageByteCnt;
            sparebuf = sparebuf - readpagecnt * pNandDrv->u16_SpareByteCnt;
            ret = NC_WritePages(u32_PhyRowIdx, databuf, sparebuf, readpagecnt);
            if(ret)
            {
				printf("[%s]: write page %lu failed\n", __func__, u32_PhyRowIdx);
				return ret;
		    }

            u32_PhyRowIdx += readpagecnt;
        }
    }

    free(databuf);
    free(sparebuf);
}


int nand_fullblockprogram(char *databuf)
{
    int i;
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    int bytecnt = (pNandDrv->u16_BitflipThreshold) >> 3;
    int bitcnt = (pNandDrv->u16_BitflipThreshold) % 8;
    for (i = 0; i < bytecnt; i++)
    {
        databuf[i] = 0;
    }
	for (i = 0; i < bitcnt; i++)
	{
	    databuf[bytecnt] &= ~(0x1 << i);
	}


}

int nand_randomizer(char *pu8_PageDataBuf, char *pu8_PageSpareBuf, u32 u32_PhyRowIdx)
{
    int page_len, sector_len, sector_idx;
    char *data_buf = NULL, *data_LFSR_buf = NULL;
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    sector_len = pNandDrv->u16_SectorByteCnt + pNandDrv->u16_SectorSpareByteCnt;
    page_len = pNandDrv->u16_PageByteCnt + pNandDrv->u16_SpareByteCnt;
    data_buf = (char *)malloc(page_len);
    data_LFSR_buf = (char *)malloc(page_len);
    if (!data_buf || !data_LFSR_buf)
    {
	    printf("[%s]: out of memory\n", __func__);
        free(data_buf);
        free(data_LFSR_buf);
	    return 1;
	}

    if(pNandDrv->u8_RequireRandomizer)
    {
            memset(data_buf, 0xff, page_len);
            memset(data_LFSR_buf, 0xff, page_len);
		    for (sector_idx = 0; sector_idx < pNandDrv->u16_PageSectorCnt; sector_idx++)
		    {
			    memcpy((data_buf + sector_idx * sector_len),
					  (pu8_PageDataBuf + sector_idx * pNandDrv->u16_SectorByteCnt), pNandDrv->u16_SectorByteCnt);
			    memcpy((data_buf + pNandDrv->u16_SectorByteCnt + sector_idx * sector_len),
				      (pu8_PageSpareBuf + sector_idx * pNandDrv->u16_SectorSpareByteCnt),
				       pNandDrv->u16_SectorSpareByteCnt);
		    }
            LFSR1_16Lines_8IOs_SectorUnit((unsigned short *)data_buf, (unsigned short *)data_LFSR_buf, page_len, (unsigned short )u32_PhyRowIdx);
            //LFSR1_16Lines_8IOs((unsigned short *)data_buf, (unsigned short *)data_LFSR_buf, page_len, (unsigned short )u32_PhyRowIdx);
            for (sector_idx = 0; sector_idx < pNandDrv->u16_PageSectorCnt; sector_idx++)
		    {
			    memcpy((pu8_PageDataBuf + sector_idx * pNandDrv->u16_SectorByteCnt),
					  (data_LFSR_buf + sector_idx * sector_len), pNandDrv->u16_SectorByteCnt);
			    memcpy((pu8_PageSpareBuf + sector_idx * pNandDrv->u16_SectorSpareByteCnt),
				      (data_LFSR_buf + pNandDrv->u16_SectorByteCnt + sector_idx * sector_len), pNandDrv->u16_SectorSpareByteCnt);
		    }
	}

    free(data_buf);
    free(data_LFSR_buf);

}
int drvNAND_ReadCISBlk(U32 u32_off, U8* pu8_DataBuf)
{
	NAND_DRIVER * pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
	U32 u32_Ret, i, pglen;
	U32 u32_Row = u32_off >> pNandDrv->u8_PageByteCntBits;
	U16 u16_BlkCntTmp, u16_BlkPageCntTmp, u16_PageByteCntTmp, u16_SpareByteCntTmp, u16_ECCTypeTmp;
	U32 page_off = pNandDrv->u16_PageByteCnt + pNandDrv->u16_SpareByteCnt;

	//set 0xff for nni page
	memset((void*)pu8_DataBuf, 0xff, pNandDrv->u16_PageByteCnt);
	u16_BlkCntTmp = pNandDrv->u16_BlkCnt;
	u16_BlkPageCntTmp = pNandDrv->u16_BlkPageCnt;
	u16_PageByteCntTmp = pNandDrv->u16_PageByteCnt;
	u16_SpareByteCntTmp = pNandDrv->u16_SpareByteCnt;
	u16_ECCTypeTmp = pNandDrv->u16_ECCType;
	//reconfig nni read setting

	pNandDrv->u16_BlkCnt = 0x400;
	pNandDrv->u16_BlkPageCnt = 0x20;
	pNandDrv->u16_PageByteCnt = 0x800;
	pNandDrv->u16_SpareByteCnt = 0x100;
	pNandDrv->u16_ECCType = NANDINFO_ECC_TYPE;

	#if defined(FCIE_LFSR) && FCIE_LFSR
	if(pNandDrv->u8_RequireRandomizer)
		NC_DisableLFSR();
	#endif

	NC_ConfigContext();
	NC_ReInit();
	pNandDrv->u16_Reg48_Spare |= (1 << 12);
	NC_Config();

	u32_Ret = NC_ReadSectors(u32_Row, 0, pu8_DataBuf, (U8*)((U32)pu8_DataBuf + pNandDrv->u16_SectorByteCnt), 1);
	if(u32_Ret != 0)
		return u32_Ret;

	//restore original setting
	pNandDrv->u16_BlkCnt = u16_BlkCntTmp;
	pNandDrv->u16_BlkPageCnt = u16_BlkPageCntTmp;
	pNandDrv->u16_PageByteCnt = u16_PageByteCntTmp;
	pNandDrv->u16_SpareByteCnt = u16_SpareByteCntTmp;
	pNandDrv->u16_ECCType = u16_ECCTypeTmp;
	pglen = pNandDrv->u16_PageByteCnt + pNandDrv->u16_SpareByteCnt;

	NC_ConfigContext();
	NC_ReInit();
	pNandDrv->u16_Reg48_Spare &= ~(1 << 12);
	NC_Config();

	for(i = 1 ; i < pNandDrv->u16_BlkPageCnt; i ++)
	{
		u32_Ret = NC_ReadSectors(u32_Row + i, 0, (U8*) ((U32)pu8_DataBuf + page_off * i),
							(U8*) ((U32)pu8_DataBuf + (page_off * i) + pNandDrv->u16_PageByteCnt), pNandDrv->u16_PageSectorCnt);
		if(u32_Ret)
			return u32_Ret;

		if(info.fullblkprg)
		{
			U32 chk_len;
			chk_len = empty_check((pu8_DataBuf + page_off * i), pglen);
			if (!chk_len)
			{
			    (pu8_DataBuf + page_off * i)[0] = 0xfe; // indicate empty page
			}
		}
	}

	return UNFD_ST_SUCCESS;
}

void drvNAND_GetMtdParts(char *buf)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER *)drvNAND_get_DrvContext_address();
	PARTITION_INFO_t *pPartInfo = pNandDrv->pPartInfo;
	U8 u8_i,u8_PartNo, u8_Unknown = 0;
	int len, Maxlen = 512;
	u32 PartSize = 0, PartSize1 = 0, PartSize2 = 0;
	U32 u32_Err;
	u32 virtual_boot;
	U32 u32_BlkIdx;
	U8	u8_MbootCnt= 0;
	U32 u32_MbootBlkIdx[2];
	char *mtd_buf=buf, tmp[128], PartName[16];
	U16 u16_LastPartType;

	if(pNandDrv->u8_HasPNI == 0)
		goto cleanup;

	sprintf(mtd_buf, "mtdparts=edb64M-nand:");
	printf("%s\r\n",buf);
	mtd_buf += 21;
	if (Maxlen < 21)
		goto cleanup;
	Maxlen -= 21;

	u16_LastPartType = 0;
	for(u8_i = 0; u8_i < pPartInfo->u16_PartCnt; u8_i ++)
	{
		if( (pPartInfo->records[u8_i].u16_PartType & UNFD_LOGI_PART) == UNFD_LOGI_PART)
			break;

		PartSize = 0;
		if( u8_i )
		{
			memcpy(mtd_buf, ",", 1);
			mtd_buf ++;
			Maxlen --;
		}

		PartSize = pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt *
			(pPartInfo->records[u8_i].u16_BackupBlkCnt + pPartInfo->records[u8_i].u16_BlkCnt);

		u8_PartNo = u16_LastPartType != pPartInfo->records[u8_i].u16_PartType ? 0:1;

		u16_LastPartType = pPartInfo->records[u8_i].u16_PartType;


		switch(pPartInfo->records[u8_i].u16_PartType)
		{

			case UNFD_PART_BOOTLOGO:
				sprintf(PartName,"UBILD" );
				break;
			case UNFD_PART_UBOOT:
				sprintf(PartName,"MBOOT" );
				break;
			case UNFD_PART_OS:
				sprintf(PartName,"KL" );
				break;
			case UNFD_PART_SECINFO:
				sprintf(PartName,"KL_BP" );
				break;
			case UNFD_PART_OTP:
				sprintf(PartName,"NTP" );
				break;
			case UNFD_PART_RECOVERY:
				sprintf(PartName,"RECOVERY" );
				break;
			case UNFD_PART_MISC:
				sprintf(PartName,"MISC" );
				break;
			case UNFD_PART_TBL:
				sprintf(PartName,"TBL" );
				break;
			case UNFD_PART_CTRL:
				sprintf(PartName,"CTRL" );
				break;
			case UNFD_PART_UBIRO:
				sprintf(PartName,"UBIRO" );
				break;
			default:
				sprintf(PartName,"UNKNOWN%d", u8_Unknown++);
				break;

		}
		if (u8_i)
			sprintf(tmp, "%dk(%s)", PartSize/1024, PartName); //,pPartInfo->records[u8_i].u16_PartType);
		else
		{
			u8_MbootCnt = 0;
			if(pNandDrv->u8_BL1PBA != 0)
			{
				//search vid chunk header for mboot partition beginning
				u32_BlkIdx = 1;
				while(1)
				{
					u32_Err = NC_ReadPages((pNandDrv->u8_BL1PBA + u32_BlkIdx) << pNandDrv->u8_BlkPageCntBits, u8MainBuf, u8SpareBuf, 1);
					//binary ID for chunk header
					if( ((U32 *)u8MainBuf)[0x7] == 0x0000B007 && u32_Err == UNFD_ST_SUCCESS)
					{
						u32_MbootBlkIdx[u8_MbootCnt] = (pNandDrv->u8_BL1PBA + u32_BlkIdx);
						u8_MbootCnt ++;
					}

					//support K7a removing mbootbak
					if(info.disablembootbak){
						if(u8_MbootCnt == 1)
							break;
					}
					else if(info.disablembootbak == 0){
						if(u8_MbootCnt == 2)
							break;
					}

					if((pNandDrv->u8_BL1PBA + u32_BlkIdx) == 0xFF)
						break;

					u32_BlkIdx ++;
				}
				if((pNandDrv->u8_BL1PBA + u32_BlkIdx) == 0xFF)
				{
					goto cleanup;
				}
				else
				{
					 if(u8_MbootCnt == 1)
					{
						virtual_boot = u32_MbootBlkIdx[0] * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) / 1024;
						PartSize = PartSize - (u32_MbootBlkIdx[0] - 10) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
						sprintf(tmp, "%dk@%dk(%s)", PartSize/1024, virtual_boot, PartName);
					}
					else if(u8_MbootCnt == 2)
					{
						virtual_boot = u32_MbootBlkIdx[0] * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) / 1024;
						PartSize1 = (u32_MbootBlkIdx[1] - u32_MbootBlkIdx[0]) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
						PartSize2 = PartSize - (u32_MbootBlkIdx[1] - 10) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
						sprintf(tmp, "%dk@%dk(%s),%dk(%sBAK)", PartSize1/1024, virtual_boot, PartName,PartSize2/1024, PartName);
					}
					else
						goto cleanup;

					//virtual_boot = (pNandDrv->u8_BL1PBA + u32_BlkIdx) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) / 1024;
					//PartSize = PartSize - ((pNandDrv->u8_BL1PBA + u32_BlkIdx - 10) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt));
				}
			}
			else if(pNandDrv->u8_HashPBA[1][1] != 0)
			{
				u32_BlkIdx = 1;
				while(1)
				{
					u32_Err = NC_ReadPages((pNandDrv->u8_HashPBA[1][1] + u32_BlkIdx) << pNandDrv->u8_BlkPageCntBits, u8MainBuf, u8SpareBuf, 1);
					//binary ID for chunk header
					if( ((U32 *)u8MainBuf)[0x7] == 0x0000B007 && u32_Err == UNFD_ST_SUCCESS)
					{
						u32_MbootBlkIdx[u8_MbootCnt] = (pNandDrv->u8_HashPBA[1][1] + u32_BlkIdx);
						u8_MbootCnt ++;
					}
					if(u8_MbootCnt == 2)
						break;
					if((pNandDrv->u8_HashPBA[1][1] + u32_BlkIdx) == 0xFF)
						break;

					u32_BlkIdx ++;
				}
				if((pNandDrv->u8_HashPBA[1][1] + u32_BlkIdx) == 0xFF)
				{
					goto cleanup;
				}
				else
				{
					 if(u8_MbootCnt == 1)
					{
						virtual_boot = u32_MbootBlkIdx[0] * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) / 1024;
						PartSize = PartSize - (u32_MbootBlkIdx[0] - 10) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
						sprintf(tmp, "%dk@%dk(%s)", PartSize/1024, virtual_boot, PartName);
					}
					else if(u8_MbootCnt == 2)
					{
						virtual_boot = u32_MbootBlkIdx[0] * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) / 1024;
						//PartSize = PartSize - (u32_MbootBlkIdx[0] - 10) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
						PartSize1 = (u32_MbootBlkIdx[1] - u32_MbootBlkIdx[0]) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
						PartSize2 = PartSize - (u32_MbootBlkIdx[1] - 10) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
						sprintf(tmp, "%dk@%dk(%s),%dk(%sBAK)", PartSize1/1024, virtual_boot, PartName,PartSize2/1024, PartName);
					}
					else
						goto cleanup;
					//virtual_boot = (pNandDrv->u8_HashPBA[1][1] + u32_BlkIdx) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) / 1024;
					//PartSize = PartSize - (pNandDrv->u8_HashPBA[1][1] + u32_BlkIdx - 10) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
				}
			}
			else{ // BFN case
				//search vid chunk header for mboot partition beginning
				u32_BlkIdx = 1;
				while(1){
					u32_Err = NC_ReadPages((10 + u32_BlkIdx) << pNandDrv->u8_BlkPageCntBits, u8MainBuf, u8SpareBuf, 1);
					//binary ID for chunk header
					if( memcmp((const void *)u8MainBuf, "BIN0", 4) == 0 && u32_Err == UNFD_ST_SUCCESS){
						u32_MbootBlkIdx[u8_MbootCnt] = (10 + u32_BlkIdx);
						u8_MbootCnt ++;
					}
					if(u8_MbootCnt == 2)
						break;
					if((10 + u32_BlkIdx) == 0xFF)
						break;
					u32_BlkIdx ++;
				}
				if((10 + u32_BlkIdx) == 0xFF){
					//only one mboot or upgrade power cut
					//goto cleanup;
					if(u8_MbootCnt == 1)        //one mboot ->powercut during upgrade->layout ubild
					{
						virtual_boot = u32_MbootBlkIdx[0] * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) / 1024;
						PartSize = PartSize - (u32_MbootBlkIdx[0] - 10) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
						sprintf(tmp, "%dk@%dk(%s)", PartSize/1024, virtual_boot, PartName);
						printf("Warning: Only One Mboot found, Please re-upgrade your mboot, in case of read ecc fail\n");
					}
					else    //no mboot  using default for ubild partition, impossible in normal case or tool programming case
						goto cleanup;
				}
				else
				{
					if(u8_MbootCnt == 1){
						virtual_boot = u32_MbootBlkIdx[0] * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) / 1024;
						PartSize = PartSize - (u32_MbootBlkIdx[0] - 10) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
						sprintf(tmp, "%dk@%dk(%s)", PartSize/1024, virtual_boot, PartName);
					}
					else if(u8_MbootCnt == 2){
						virtual_boot = u32_MbootBlkIdx[0] * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) / 1024;
						PartSize1 = (u32_MbootBlkIdx[1] - u32_MbootBlkIdx[0]) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
						PartSize2 = PartSize - (u32_MbootBlkIdx[1] - 10) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) ;
						sprintf(tmp, "%dk@%dk(%s),%dk(%sBAK)", PartSize1/1024, virtual_boot, PartName,PartSize2/1024, PartName);
					}
					else
						goto cleanup;

					//virtual_boot = (10 + u32_BlkIdx) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt) / 1024;
					//PartSize = PartSize - ((10 + u32_BlkIdx - 10) * (pNandDrv->u16_BlkPageCnt * pNandDrv->u16_PageByteCnt));
				}
            }
		}
		len = strlen(tmp);
		memcpy(mtd_buf, tmp, len);
		mtd_buf += len;
		if (Maxlen < len)
			goto cleanup;
		Maxlen -= len;

	}

	if( (pPartInfo->records[u8_i].u16_PartType & UNFD_LOGI_PART) == UNFD_LOGI_PART)
	{
		sprintf(tmp,",-(UBI)");
		len= strlen(tmp);
		memcpy(mtd_buf, tmp, len);
		mtd_buf += len;
		if (Maxlen < len)
			goto cleanup;
		Maxlen -= len;
	}
	*mtd_buf = '\0';
	return ;
	cleanup:
	buf[0] = '\0';
	return ;
}

#define ENABLE_MODULE_BFN_WRITE_NAND 1

#if ENABLE_MODULE_BFN_WRITE_NAND
#define CHIPCFG_CMD_BASE       0xFE00
#define CHIPCFG_CMD_END        0xFFF0
#define CHIPCFG_CMD_WAIT       0xFF00
#define CHIPCFG_CMD_DBG        0xFFE0

unsigned char *nand_buffer;
static unsigned char nand_buffer2[16384] __attribute((aligned(64)));
static unsigned char nand_buffer_spare[16384] __attribute((aligned(64)));

#define MIUIDTAG    (0x4D495530)      // 'MIU0'
#define LDRIDTAG    (0x4C445230)      // 'LDR0'
#define BINIDTAG    (0x42494E30)      // 'BIN0'

/*
#define MIUIDTAG    (0x3055494D)      // 'MIU0'
#define LDRIDTAG    (0x3052444C)      // 'LDR0'
#define BINIDTAG    (0x304E4942)      // 'BIN0'
*/

static int reg_x = 0;
#define REG(x) (reg_x)

static U32 BFN_WritePage_MIU(U32 u32Row, U8 *u8Buf, U8 *u8Spare, U16 u16Repeat, U16 autodis)
{
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    U32 u32_Err = UNFD_ST_SUCCESS;


    if(autodis)
    {
        pNandDrv->u16_Reg48_Spare |= BIT_NC_HW_AUTO_RANDOM_CMD_DISABLE;
        NC_Config();
    }

    u32_Err = NC_WritePages( u32Row, u8Buf, u8Spare, u16Repeat);
    if( u32_Err != UNFD_ST_SUCCESS)
    {
        printf("NC_WritePages error\n");
    }

    if(autodis)
    {
        pNandDrv->u16_Reg48_Spare &= ~BIT_NC_HW_AUTO_RANDOM_CMD_DISABLE;
        NC_Config();
    }

    return u32_Err;
}

static U32 BFN_ReadPage_MIU(U32 u32Row, U8 *u8Buf, U8 *u8Spare, U16 u16Repeat, U16 autodis)
{
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    U32 u32_Err = UNFD_ST_SUCCESS;

    if(autodis)
    {
        pNandDrv->u16_Reg48_Spare |= BIT_NC_HW_AUTO_RANDOM_CMD_DISABLE;
        NC_Config();
    }

    u32_Err = NC_ReadPages( u32Row, u8Buf, u8Spare, u16Repeat);
    if( u32_Err != UNFD_ST_SUCCESS)
    {
        printf("NC_ReadPages error\n");
    }

    if(autodis)
    {
        pNandDrv->u16_Reg48_Spare &= ~BIT_NC_HW_AUTO_RANDOM_CMD_DISABLE;
        NC_Config();
    }

    return u32_Err;
}

static U32 BFN_WriteSector(U32 u32PageIndex, U8 *u8Buf, U8 *u8Spare, U16 autodis)
{
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    U32 u32_Err = UNFD_ST_SUCCESS;


    if(autodis)
    {
        pNandDrv->u16_Reg48_Spare |= BIT_NC_HW_AUTO_RANDOM_CMD_DISABLE;
        NC_Config();
    }

    u32_Err = NC_WriteSectors( u32PageIndex, 0, u8Buf, u8Spare, 1);
    if( u32_Err != UNFD_ST_SUCCESS)
    {
        printf("NC_WriteSectors error\n");
    }

    NC_Write_RandomOut(u32PageIndex,0,u8Buf,16);

    if(autodis)
    {
        pNandDrv->u16_Reg48_Spare &= ~BIT_NC_HW_AUTO_RANDOM_CMD_DISABLE;
        NC_Config();
    }

    return u32_Err;
}

static U32 BFN_ReadSector_RIU(U32 u32Row, U32 u32Col, U8 *u8Buf, U8 *u8SprBuf ,U16 autodis)
{
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    U32 u32_Err = UNFD_ST_SUCCESS;

    if(autodis)
    {
        pNandDrv->u16_Reg48_Spare |= BIT_NC_HW_AUTO_RANDOM_CMD_DISABLE;
        NC_Config();
    }

    u32_Err = NC_ReadSector_RIUMode(u32Row, u32Col, u8Buf, u8SprBuf);

    if(autodis)
    {
        pNandDrv->u16_Reg48_Spare &= ~BIT_NC_HW_AUTO_RANDOM_CMD_DISABLE;
        NC_Config();
    }

    return u32_Err;
}

int drvNAND_ReadMIUParam(U32 u32MIUPos)
{
    /*
    int              retlen=0;
    while (1)
    {
        U16 reg = *(U16*)u32MIUPos;

        retlen += 4;

        if (reg == CHIPCFG_CMD_END)
            return retlen;

        u32MIUPos += 4;
    }
    return 0;
    */
     return 0x2000;
}


U32 drvNAND_WriteMIUParam(int MIUBLOCK, U32 MIUPOS)
{
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    int ParamMIUSize;
    int ProgramPage=0;
    U32 u32_Err = UNFD_ST_SUCCESS;

    u32_Err = NC_EraseBlk( MIUBLOCK * pNandDrv->u16_BlkPageCnt );//use first block as test item
    if (u32_Err != UNFD_ST_SUCCESS)
    {
        printf("MIU write blk error!!\n");
        drvNAND_MarkBadBlk(MIUBLOCK);
        return 0;
    }

    //==============write MIU position==============
    // read MIU parameter

    ParamMIUSize = drvNAND_ReadMIUParam(MIUPOS);

    *((U32*)(nand_buffer2+0x00)) = MIUIDTAG;//0x4D495530
    *((U32*)(nand_buffer2+0x04)) = pNandDrv->u16_PageByteCnt;
    *((U32*)(nand_buffer2+0x10)) = ParamMIUSize>>9; // number of MIU page (in 512 bytes size)
    *((U32*)(nand_buffer2+0x14)) = pNandDrv->u16_BlkPageCnt;

    memset(nand_buffer_spare, -1, sizeof(nand_buffer_spare));

    printf("MIU parameter size %d\n",ParamMIUSize);
    BFN_WritePage_MIU(MIUBLOCK * pNandDrv->u16_BlkPageCnt + ProgramPage, (U8*)nand_buffer2,(U8*)nand_buffer_spare,1,1);
    ProgramPage++;
    printf("Write First Page, ParamMIUSize left %d program page number %d\n",ParamMIUSize,ProgramPage);

    while(ParamMIUSize > 0)
    {
        BFN_WritePage_MIU(MIUBLOCK * pNandDrv->u16_BlkPageCnt+ProgramPage,(U8*)nand_buffer+((ProgramPage-1)*(512)), (U8*)nand_buffer_spare,1,1);
        ParamMIUSize -= 512;
        ProgramPage ++;
        printf("Write next Page, ParamMIUSize left %d program page number %d\n",ParamMIUSize,ProgramPage);
    }

    return 1;
}

U32 drvNAND_NCISLDRAPP_WriteCISMIUParam(int MIUBLOCK, U8 *MIUBUFFER)
{
	NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
	U32 u32_Err = 0;
	int ProgramPage=10;
	int ParamMIUSize = 0x2000;

	U16 u16_PageByteCn_Tmp = pNandDrv->u16_PageByteCnt ;
	U16 u16_SpareByteCnt_Tmp = pNandDrv->u16_SpareByteCnt ;
	U16 u16_ECCType_Tmp = pNandDrv->u16_ECCType ;

	ParamMIUSize = drvNAND_ReadMIUParam(0);

	pNandDrv->u16_PageByteCnt = 2048;
	pNandDrv->u16_SpareByteCnt = 256;
	pNandDrv->u16_ECCType = NANDINFO_ECC_TYPE;

	NC_ConfigNandFlashContext();
	NC_RegInit();

	memset(nand_buffer_spare, 0xFF, sizeof(nand_buffer_spare));

	while(ParamMIUSize > 0)
	{
		printf("Write Page, ParamMIUSize left %d program page number %d\n",ParamMIUSize,ProgramPage);
		u32_Err = BFN_WriteSector(MIUBLOCK * pNandDrv->u16_BlkPageCnt+ProgramPage,(U8*)MIUBUFFER+((ProgramPage-10)*(pNandDrv->u16_SectorByteCnt)), (U8*)nand_buffer_spare,1);
		if (u32_Err != UNFD_ST_SUCCESS)
		{
			printf("MIU write blk error!!%s %x\n",__FUNCTION__,__LINE__);
			return u32_Err;
		}

		ParamMIUSize -= pNandDrv->u16_SectorByteCnt;
		ProgramPage ++;
	}
	printf("totally write %x\n",ProgramPage-10);

	/* Reset NAND driver and FCIE to the original settings */
	pNandDrv->u16_SpareByteCnt = u16_PageByteCn_Tmp;
	pNandDrv->u16_PageByteCnt  = u16_SpareByteCnt_Tmp;
	pNandDrv->u16_ECCType      = u16_ECCType_Tmp;
	NC_ConfigNandFlashContext();
	NC_RegInit();
	pNandDrv->u16_Reg48_Spare &= ~(1 << 12);
	NC_Config();

	return 0;
}


U32 drvNAND_WriteCISMIUParam(int MIUBLOCK, U32 MIUPOS, NAND_FLASH_INFO_t * pNandInfo)
{
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    PARTITION_INFO_t *pPartInfo = drvNAND_get_DrvContext_PartInfo();
    BLK_INFO_t *pBlkInfo = (BLK_INFO_t*)nand_buffer_spare;

    int ParamMIUSize;
    int ProgramPage=0;
    U32 u32_Err = UNFD_ST_SUCCESS;
    U32 u32_PageIdx;
    U16 u16_CISIdx;

    /* Check first page of block */
    u32_PageIdx = MIUBLOCK << pNandDrv->u8_BlkPageCntBits;
    u32_Err = BFN_ReadPage_MIU(u32_PageIdx,nand_buffer2,nand_buffer_spare,1,1);
    if (u32_Err != UNFD_ST_SUCCESS)
    {
        printf("MIU write blk error!!%s %x\n",__FUNCTION__,__LINE__);
    }
    if (nand_buffer_spare[0] != 0xFF)
    {
        printf("MIU write blk error!!%s %x\n",__FUNCTION__,__LINE__);
        return 0;
    }

    u32_Err = NC_EraseBlk( MIUBLOCK * pNandDrv->u16_BlkPageCnt );//use first block as test item
    if (u32_Err != UNFD_ST_SUCCESS)
    {
        printf("MIU write blk error!!%s %x\n",__FUNCTION__,__LINE__);
        drvNAND_MarkBadBlk(MIUBLOCK);
        return 0;
    }

    //==============write MIU position==============
    // read MIU parameter

    ParamMIUSize = drvNAND_ReadMIUParam(MIUPOS);

    /* original drvNAND_WriteCIS_for_ROM*/
    NC_ConfigNandFlashContext();
    NC_RegInit();
    NC_Config();

    nand_config_clock(pNandInfo->u16_tRC);

    if(info.fcietype >= FCIE4){
   	 memcpy((void *) &pNandInfo->tDefaultDDR, (const void *) &pNandDrv->tDefaultDDR, sizeof(DDR_TIMING_GROUP_t));
   	 memcpy((void *) &pNandInfo->tMaxDDR, (const void *) &pNandDrv->tMaxDDR, sizeof(DDR_TIMING_GROUP_t));
   	 memcpy((void *) &pNandInfo->tMinDDR, (const void *) &pNandDrv->tMinDDR, sizeof(DDR_TIMING_GROUP_t));
    }

    u16_CISIdx = REG(RIU_BASE + (0x1980 << 2) + (0x41 << 2) );
    switch (u16_CISIdx) {
        case 2:
            printf("for first cis index\n");
            u16_CISIdx = 0;
            break;
        case 3:
            printf("for second cis index");
            u16_CISIdx = 1;
            break;
        default:
            printf("for first cis index");
            REG(RIU_BASE + (0x1980 << 2) + (0x41 << 2) ) = 0;
            u16_CISIdx = 0;
            break;
    }

    /* Reeset NAND driver and FCIE to the original settings */
    pNandDrv->u16_SpareByteCnt = pNandInfo->u16_SpareByteCnt;
    pNandDrv->u16_PageByteCnt  = pNandInfo->u16_PageByteCnt;
    pNandDrv->u16_ECCType      = pNandInfo->u16_ECCType;
    NC_ConfigNandFlashContext();
    NC_RegInit();
    pNandDrv->u16_Reg48_Spare &= ~(1 << 12);

    if(pNandDrv->u8_RequireRandomizer)
        NC_DisableLFSR();

    NC_Config();

    pNandDrv->u16_PageByteCnt = 2048;
    pNandDrv->u16_SpareByteCnt = 256;
    pNandDrv->u16_ECCType = NANDINFO_ECC_TYPE;

    NC_ConfigNandFlashContext();
    NC_RegInit();

    // copy CIS to the buffer offset 0x20
    memset(nand_buffer2, 0xFF, sizeof(nand_buffer2));
    //memset(nand_buffer2, '\0', 512);
    memcpy(nand_buffer2,pNandInfo,512);
    memset(nand_buffer_spare, -1, sizeof(nand_buffer_spare));

    pBlkInfo->u8_BadBlkMark = 0xFF;
    pBlkInfo->u8_PartType = 0;

    u32_Err = BFN_WriteSector(MIUBLOCK * pNandDrv->u16_BlkPageCnt + ProgramPage, (U8*)nand_buffer2,(U8*)nand_buffer_spare,1);

    if (u32_Err != UNFD_ST_SUCCESS)
    {
        printf("MIU write blk error!!%s %x\n",__FUNCTION__,__LINE__);
        drvNAND_MarkBadBlk(MIUBLOCK);
        return 0;
    }

    /*
        **  Write Partition Info the 2nd page
        **/
    if(pNandDrv->u8_HasPNI == 1)
    {
        memset(nand_buffer2, '\0', pNandDrv->u16_PageByteCnt);
        memcpy(nand_buffer2, pPartInfo, 512);

        u32_Err = BFN_WriteSector(MIUBLOCK * pNandDrv->u16_BlkPageCnt + ga_tPairedPageMap[1].u16_LSB, (U8*)nand_buffer2,(U8*)nand_buffer_spare,1);
        if (u32_Err != UNFD_ST_SUCCESS)
        {
            printf("MIU write blk error!!%s %x\n",__FUNCTION__,__LINE__);
            drvNAND_MarkBadBlk(MIUBLOCK);
            return 0;
        }
    }

    /*
    **  Write Paired Page Map to the 4th page
    **/
    if(pNandDrv->u8_CellType == 1)  // MLC
    {
        memset(nand_buffer2, '\0', pNandDrv->u16_PageByteCnt);
        memcpy(nand_buffer2, &ga_tPairedPageMap, 2048);

        u32_Err = BFN_WriteSector(MIUBLOCK * pNandDrv->u16_BlkPageCnt + pNandInfo->u8_PairPageMapLoc, (U8*)nand_buffer2,(U8*)nand_buffer_spare,1);
        if (u32_Err != UNFD_ST_SUCCESS) {
            printf("MIU write blk error!!%s %x\n",__FUNCTION__,__LINE__);
            drvNAND_MarkBadBlk(MIUBLOCK);
            return 0;
        }
    }
    u16_CISIdx++;

    printf("CIS is written to blk 0x%04x\n", MIUBLOCK);

    // chk cis index
    switch (u16_CISIdx) {
        case 0:
            REG(RIU_BASE + (0x1980 << 2) + (0x41 << 2) )  = 0x0002;
            u32_Err = UNFD_ST_ERR_NO_BLK_FOR_CIS0;
            break;
        case 1:
            REG(RIU_BASE + (0x1980 << 2) + (0x41 << 2) )  = 0x0003;
            u32_Err = UNFD_ST_ERR_NO_BLK_FOR_CIS1;
            break;
        case 2:
            u32_Err = UNFD_ST_SUCCESS;
            break;
    }

    printf("MIU parameter size %d, sector byte count %d\n",ParamMIUSize, pNandDrv->u16_SectorByteCnt);

    ProgramPage = 10;


    while(ParamMIUSize > 0)
    {
        printf("Write Page, ParamMIUSize left %d program page number %d\n",ParamMIUSize,ProgramPage);
        u32_Err = BFN_WriteSector(MIUBLOCK * pNandDrv->u16_BlkPageCnt+ProgramPage,(U8*)nand_buffer+((ProgramPage-10)*(pNandDrv->u16_SectorByteCnt)), (U8*)nand_buffer_spare,1);
        if (u32_Err != UNFD_ST_SUCCESS)
        {
            printf("MIU write blk error!!%s %x\n",__FUNCTION__,__LINE__);
        }

        ParamMIUSize -= pNandDrv->u16_SectorByteCnt;
        ProgramPage ++;
    }
    printf("totally write %x\n",ProgramPage-10);

    /* Reset NAND driver and FCIE to the original settings */
    pNandDrv->u16_SpareByteCnt = pNandInfo->u16_SpareByteCnt;
    pNandDrv->u16_PageByteCnt  = pNandInfo->u16_PageByteCnt;
    pNandDrv->u16_ECCType      = pNandInfo->u16_ECCType;
    NC_ConfigNandFlashContext();
    NC_RegInit();
    pNandDrv->u16_Reg48_Spare &= ~(1 << 12);
    NC_Config();

    return 1;
}

U32 drvNAND_RefreshCISMIUParam(int MIUBLOCK, U32 MIUPOS)
{
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    NAND_FLASH_INFO_t * pNandInfo = (NAND_FLASH_INFO_t* )malloc(512);
    PARTITION_INFO_t *pPartInfo = pNandDrv->pPartInfo;
    U32 u32_BlkIdx, u32_MBootBegin = 0, u32_MBootEnd = 0;
    U32 u32_Err;
    U8  u8_i;
    int bl_count = 0;

    if(!pNandInfo)
    {
        printf("Memory Allocate fail for pNandInfo\n");
        return -1;
    }

    //setup pNandInfo for CIS
    memset(pNandInfo, 0, 512);
    memcpy(pNandInfo->au8_Tag, "MSTARSEMIUNFDCIS", 16);
    pNandInfo->u8_IDByteCnt = pNandDrv->u8_IDByteCnt;
    memset(pNandInfo->au8_ID, 0, NAND_ID_BYTE_CNT);
    memcpy(pNandInfo->au8_ID, pNandDrv->au8_ID, pNandDrv->u8_IDByteCnt);
    pNandInfo->u16_SpareByteCnt = pNandDrv->u16_SpareByteCnt;
    pNandInfo->u16_PageByteCnt = pNandDrv->u16_PageByteCnt;
    pNandInfo->u16_BlkPageCnt = pNandDrv->u16_BlkPageCnt;
    pNandInfo->u16_BlkCnt = pNandDrv->u16_BlkCnt;
    pNandInfo->u32_Config = pNandDrv->u32_Config;

    pNandInfo->u16_ECCType = pNandDrv->u16_ECCType;
    pNandInfo->u16_tRC          = pNandDrv->u16_tRC;
    pNandInfo->u8_tRP           = pNandDrv->u8_tRP;
    pNandInfo->u8_tREH          = pNandDrv->u8_tREH;
    pNandInfo->u8_tREA          = pNandDrv->u8_tREA;
    pNandInfo->u8_tRR           = pNandDrv->u8_tRR;
    pNandInfo->u16_tADL         = pNandDrv->u16_tADL;
    pNandInfo->u16_tRHW         = pNandDrv->u16_tRHW;
    pNandInfo->u16_tWHR         = pNandDrv->u16_tWHR;
    pNandInfo->u16_tCCS         = pNandDrv->u16_tCCS;
    pNandInfo->u8_tCS           = pNandDrv->u8_tCS;
    pNandInfo->u16_tWC          = pNandDrv->u16_tWC;
    pNandInfo->u8_tWP           = pNandDrv->u8_tWP;
    pNandInfo->u8_tWH           = pNandDrv->u8_tWH;
    pNandInfo->u16_tCWAW        = pNandDrv->u16_tCWAW;
    pNandInfo->u8_tCLHZ         = pNandDrv->u8_tCLHZ;
    pNandInfo->u8_AddrCycleIdx  = pNandDrv->u8_AddrCycleIdx;
    pNandInfo->u16_tWW          = pNandDrv->u16_tWW;

    pNandInfo->u8_PairPageMapLoc = pNandDrv->u8_PairPageMapLoc;
    pNandInfo->u8_ReadRetryType =   pNandDrv->u8_ReadRetryType;
    //pNandInfo->u8_BitflipThreshold = pNandDrv->u16_BitflipThreshold;     guess this won't changed

    pNandInfo->u32_ChkSum       = drvNAND_CheckSum((U8*) (pNandInfo) + 0x24, 0x32 - 0x24);

    memcpy(pNandInfo->u8_Vendor, pNandDrv->u8_Vendor, 16);
    memcpy(pNandInfo->u8_PartNumber, pNandDrv->u8_PartNumber, 16);

    pNandInfo->u8_Hash0PageIdx = pNandDrv->u8_Hash0PageIdx;
    pNandInfo->u8_Hash1PageIdx = pNandDrv->u8_Hash1PageIdx;
    pNandInfo->u32_BootSize = pNandDrv->u32_BootSize;

    //search MBOOT partition in partinfo

    if(pNandDrv->u8_HasPNI == 1)
    {
        for(u8_i = 0; u8_i < pPartInfo->u16_PartCnt; u8_i ++)
        {
            if(pPartInfo->records[u8_i].u16_PartType == UNFD_PART_UBOOT)
            {
                u32_MBootBegin = pPartInfo->records[u8_i].u16_StartBlk;
                u32_MBootEnd = pPartInfo->records[u8_i].u16_StartBlk + pPartInfo->records[u8_i].u16_BlkCnt + pPartInfo->records[u8_i].u16_BackupBlkCnt;
                break;
            }
        }
        if(u8_i == pPartInfo->u16_PartCnt)
        {
            printf("ERROR: Partition info does not contain MBOOT partition\n");
            return -1;
        }

        //search sboot uboot/ HashX location for update nni infomation

        if(pNandDrv->u8_BL0PBA != 0)    //for bl uboot
        {
            bl_count = 0;
            //search bl location in MBOOT PARTITION
            for(u32_BlkIdx = u32_MBootBegin; u32_BlkIdx < u32_MBootEnd; u32_BlkIdx ++)
            {
                u32_Err = NC_ReadPages(u32_BlkIdx << pNandDrv->u8_BlkPageCntBits, u8MainBuf, u8SpareBuf, 1);
                if(u32_Err != UNFD_ST_SUCCESS || u8SpareBuf[0] !=0xFF)
                    continue;
                if(!drvNAND_CheckAll0xFF(u8MainBuf, pNandDrv->u16_PageByteCnt))
                {
                    if(bl_count == 0)
                        pNandInfo->u8_BL0PBA = pNandDrv->u8_BL0PBA = (U8)u32_BlkIdx;
                    else if(bl_count == 1)
                    {
                        pNandInfo->u8_BL1PBA = pNandDrv->u8_BL1PBA = (U8)u32_BlkIdx;
                        bl_count ++;
                        break;
                    }
                    bl_count ++;
                }
            }

            printf("BL0_PBA %X, BL1_PBA %X\n", pNandDrv->u8_BL0PBA, pNandDrv->u8_BL1PBA);
            if(bl_count != 2)
            {
                printf("WARNING: there is no two sboots in NAND Flash, Please Reupgrade Sboot\n");
                return -1;
            }

            if(pNandDrv->u8_UBOOTPBA != 0)
            {
                bl_count = 0;
                for(u32_BlkIdx = u32_MBootBegin; u32_BlkIdx < u32_MBootEnd; u32_BlkIdx ++)
                {
                    u32_Err = NC_ReadPages(u32_BlkIdx << pNandDrv->u8_BlkPageCntBits, u8MainBuf, u8SpareBuf, 1);
                    if(u32_Err != UNFD_ST_SUCCESS || u8SpareBuf[0] !=0xFF)
                        continue;
                    if(((U32 *)u8MainBuf)[0x7] == 0x0000B007)
                    {
                        if(bl_count == 1)
                        {
                            pNandInfo->u8_UBOOTPBA = pNandDrv->u8_UBOOTPBA = (U8)u32_BlkIdx;
                            bl_count ++;
                            break;
                        }
                        bl_count ++;
                    }
                }
                if(bl_count != 2)
                {
                    printf("WARNING: there is no two Mboots in NAND Flash, Please Reupgrade Mboot\n");
                    return -1;
                }

                printf("UBOOTPBA %X\n", pNandDrv->u8_UBOOTPBA);
            }
        }
        else if(pNandDrv->u8_HashPBA[0][0] != 0)    //for hash
        {
            bl_count = 0;
            //search bl location in MBOOT PARTITION
            for(u32_BlkIdx = u32_MBootBegin; u32_BlkIdx < u32_MBootEnd; u32_BlkIdx ++)
            {
                u32_Err = NC_ReadPages(u32_BlkIdx << pNandDrv->u8_BlkPageCntBits, u8MainBuf, u8SpareBuf, 1);
                if(u32_Err != UNFD_ST_SUCCESS || u8SpareBuf[0] !=0xFF)
                    continue;
                if(!drvNAND_CheckAll0xFF(u8MainBuf, pNandDrv->u16_PageByteCnt))
                {
                    pNandInfo->u8_HashPBA[bl_count>>1][bl_count&1] = pNandDrv->u8_HashPBA[bl_count>>1][bl_count&1] = (U8)u32_BlkIdx;
                    if(++bl_count == 4)
                        break;
                }
            }

            printf("HASH00_PBA %X, HASH01_PBA %X\n", pNandInfo->u8_HashPBA[0][0], pNandInfo->u8_HashPBA[0][1]);
            printf("HASH10_PBA %X, HASH11_PBA %X\n", pNandInfo->u8_HashPBA[1][0], pNandInfo->u8_HashPBA[1][1]);
            //printf("HASH00_PBA %X, HASH01_PBA %X\n", pNandInfo->u8_HashPBA[0][0], pNandInfo->u8_HashPBA[0][1]);
            if(bl_count != 4)
            {
                printf("WARNING: there is no two sboots in NAND Flash, Please Reupgrade Sboot\n");
                return -1;
            }

            bl_count = 0;
            for(u32_BlkIdx = pNandDrv->u8_HashPBA[1][1]+1; u32_BlkIdx < u32_MBootEnd; u32_BlkIdx ++)
            {
                u32_Err = NC_ReadPages(u32_BlkIdx << pNandDrv->u8_BlkPageCntBits, u8MainBuf, u8SpareBuf, 1);
                if(u32_Err != UNFD_ST_SUCCESS || u8SpareBuf[0] !=0xFF)
                    continue;
                if(((U32 *)u8MainBuf)[0x7] == 0x0000B007)
                {
                    pNandInfo->u8_HashPBA[2][bl_count] = pNandDrv->u8_HashPBA[2][bl_count] = (U8)u32_BlkIdx;
                    if(++bl_count == 2)
                        break;
                }
            }
            if(bl_count != 2)
            {
                printf("WARNING: there is no two Mboots in NAND Flash, Please Reupgrade Mboot\n");
                return -1;
            }

            printf("HASH20_PBA %X, HASH21_PBA %X\n", pNandInfo->u8_HashPBA[2][0], pNandInfo->u8_HashPBA[2][1]);
        }
        else
        {
            printf("loop\n");
        }
    }

    dump_nand_info(pNandInfo);

    NC_PlatformInit();

    u32_Err = NC_ResetNandFlash();
    if(u32_Err != UNFD_ST_SUCCESS)
    {
        printf("[%s]: NAND Reset Fail\n", __func__);
        return -1;
    }
    if(info.fcietype >= FCIE4){
	memset((void *) &pNandDrv->tDefaultDDR, 0, sizeof(DDR_TIMING_GROUP_t));
	memset((void *) &pNandDrv->tMaxDDR, 0, sizeof(DDR_TIMING_GROUP_t));
	memset((void *) &pNandDrv->tMinDDR, 0, sizeof(DDR_TIMING_GROUP_t));
    }
    NC_ConfigNandFlashContext();
    /*Re-Search DDR timing again*/
    u32_Err = NC_Init();
    if(u32_Err != UNFD_ST_SUCCESS)
    {
       printf("NC_Init Fail ErrCode: %lX\n", u32_Err);
        return -1;
    }
    NC_Config();

    nand_config_clock(pNandInfo->u16_tRC);


    drvNAND_WriteCISMIUParam(MIUBLOCK,MIUPOS,pNandInfo);

    printf("sizeof CIS is %x\n",sizeof(NAND_FLASH_INFO_t));
    return 0;
}

U32 drvNAND_SearchCISMIUParam(void)
{
    printf("[%s]: Not support\n", __func__);
    return 0;
}

U32 drvNAND_WriteLoader(int LOADERBLOCK, U8* u8LDRPos, int size)
{
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    U32 u32Row = LOADERBLOCK * pNandDrv->u16_BlkPageCnt;
    U32 u8Spare[256 / sizeof(U32)];
    int i;
    memset(u8Spare, 0xff, sizeof(u8Spare));
    u8Spare[1] = 0x42000000;
    while(size > 0) {
        printf("[LDR] u32Row=%d u8LDRPos=0x%08x u8Spare[1]=0x%08x\n", u32Row, u8LDRPos, u8Spare[1]);
        if(u32Row % pNandDrv->u16_BlkPageCnt == 0 && u32Row != LOADERBLOCK * pNandDrv->u16_BlkPageCnt)
            u8Spare[1]++;
        U32 v = NC_WritePages(u32Row, u8LDRPos, u8Spare, 1);
        printf("[LDR] v=%lu\n", v);
        size -= pNandDrv->u16_PageByteCnt;
        u8LDRPos += pNandDrv->u16_PageByteCnt;
        u32Row++;
    }


    printf("[LDR]end blk:%d written \n",u32Row/pNandDrv->u16_BlkPageCnt-1);
    return 0;
}

static U16 HEADER_OFFSET = 0x100;

U32 drvNAND_WriteBINParam(int BINBLOCK,U8* u8BINPos)
{

#if 0
	NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();
    U32 u32Row = BINBLOCK * pNandDrv->u16_BlkPageCnt;
    U32 u8Spare[256 / sizeof(U32)];
	int size = *((U32*)(u8BINPos+12));
	U32 U32Ret = UNFD_ST_SUCCESS;

	printf("Bin size %d",size);
    memset(u8Spare, 0xff, sizeof(u8Spare));
    u8Spare[1] = 0x42010000;
    while(size > 0) {

        if(u32Row % pNandDrv->u16_BlkPageCnt == 0 && u32Row != BINBLOCK * pNandDrv->u16_BlkPageCnt)
        {
            u8Spare[1]++;
			printf("[APP] u32Row=%ld u8APPPos=0x%08lx u8Spare[1]=0x%08lx size=0x%08x data=0x%08lx\n", u32Row, (U32)u8BINPos, u8Spare[1],size,*(U32*)u8BINPos);
        }
        U32 v = NC_WritePages(u32Row, u8BINPos, (U8 *)u8Spare, 1);
		U32Ret|=v;
		if (v!=UNFD_ST_SUCCESS)
        {
        	printf("[APP] NC_WritePages failed v=%lu,u32Row=%ld u8APPPos=0x%08lx \n", v, u32Row, (U32)u8BINPos);
		}
        size -= pNandDrv->u16_PageByteCnt;
        u8BINPos += pNandDrv->u16_PageByteCnt;
        u32Row++;
    }


    printf("[APP]end blk:%ld written \n",u32Row /pNandDrv->u16_BlkPageCnt);
	if (U32Ret!=UNFD_ST_SUCCESS)
	{
		printf("!!!!May occurring NC_WritePages failed\n ");
	}
    return 0;

#else

    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

    U32 u32Row = BINBLOCK * pNandDrv->u16_BlkPageCnt;
    U32 u32Spare[256 / sizeof(U32)];

    U32 Bin2MIUPos = 0;
    U32 BinSize = 0;
    U32 APPEntryOffset = 0; // means the actually position offset from u8BINPos for bin file to store
    U32 u32ret = 0;

    memset(nand_buffer2, 0, 0x100);
    memset(u32Spare, 0xff, sizeof(u32Spare));

    Bin2MIUPos = *((U32*)(u8BINPos));
    BinSize = *((U32*)(u8BINPos+8));
    APPEntryOffset = *((U32*)(u8BINPos+4));
    Bin2MIUPos += HEADER_OFFSET; //APPEntryOffset;
    u8BINPos += HEADER_OFFSET;//APPEntryOffset;
    BinSize -= HEADER_OFFSET;//APPEntryOffset;
    APPEntryOffset -= HEADER_OFFSET;
    *((U32*)(nand_buffer2+0x00)) = BINIDTAG;
    *((U32*)(nand_buffer2+0x04)) = Bin2MIUPos;
    *((U32*)(nand_buffer2+0x10)) = BINIDTAG; // the position we are going to put to MIU and jump
    *((U32*)(nand_buffer2+0x14)) = BinSize;
    *((U32*)(nand_buffer2+0x20)) = BINIDTAG; // the position we are going to put to MIU and jump
    *((U32*)(nand_buffer2+0x24)) = APPEntryOffset;

    u32Spare[1] = 0x42010000;

    //write first page
    if(NC_WritePages(u32Row,(U8*)nand_buffer2,(U8*)u32Spare,1)!=UNFD_ST_SUCCESS)
    {
        printf("[APP]Write first page failed\n");
        return 0;
    }

    u32Row ++;
    //u32Spare[1] ++;

    while(BinSize > 0) {
        //printf("[APP] u32Row=%d u8LDRPos=0x%08x u8Spare[0]=0x%08x\n", u32Row, u8BINPos, u32Spare[1]);

        if(u32Row % pNandDrv->u16_BlkPageCnt == 0)
        {
            u32Spare[1]++;
            printf("[APP]blk:%d written, u32Spare[1]:0x%x\n",u32Row/pNandDrv->u16_BlkPageCnt-1,u32Spare[1]);
        }

        if (NC_WritePages(u32Row, u8BINPos, u32Spare, 1)!=UNFD_ST_SUCCESS)
        {
            printf("[APP] write page failed\n");
        }

        BinSize -= ((BinSize < pNandDrv->u16_PageByteCnt ) ? BinSize : pNandDrv->u16_PageByteCnt);
        u8BINPos += pNandDrv->u16_PageByteCnt;

        u32Row++;
    }

    return 1;

#endif
}


U32 drvNAND_ReadNANDMIUParam(void)
{
    U32 row_pos = 0;
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

    while(1) {
        printf("next row position %lx\n",row_pos);
        BFN_ReadSector_RIU(row_pos, 0,nand_buffer,nand_buffer_spare,1);

        printf("%lx\n",*((U32*)(nand_buffer)));
        if (*((U32*)(nand_buffer)) == MIUIDTAG)
        {
            printf("tag correct\n");
            printf("read next block\n");

            break;
        }

        row_pos += pNandDrv->u16_BlkPageCnt;
        if (row_pos > (0x10*pNandDrv->u16_BlkPageCnt ))
            return 1;

    }
    U32 BINSize=0;
    while (1)
    {
        printf("2next row position %lx\n",row_pos);
        BFN_ReadPage_MIU(row_pos, nand_buffer,nand_buffer_spare,1,0);
        //_PUTDW(*((MS_U32*)(MIUPos)));
        printf("%lx\n",*((U32*)(nand_buffer)));
        if (*((U32*)(nand_buffer)) == LDRIDTAG)
        {
            printf("tag correct\n");
            printf("size %lx miu pos %lx\n",*((U32*)(nand_buffer+20)),*((U32*)(nand_buffer+4)));
            BINSize=*((U32*)(nand_buffer+20));
            break;
        }
        row_pos += pNandDrv->u16_BlkPageCnt;
    }

    U32 i=0;

    while(BINSize)
    {
        //_PUTDW(row_pos);
        printf("3next row position %lx %lx\n",row_pos,i);
        BFN_ReadPage_MIU(row_pos, nand_buffer,nand_buffer_spare,1,0);
        if (i==0)
        {
            if (*((U32*)(nand_buffer)) != LDRIDTAG)
            {
                row_pos += pNandDrv->u16_BlkPageCnt;
            }
            else
            {
                i++;
            }
            continue;
        }

        //_PUTC('E');
        i++;
        nand_buffer += pNandDrv->u16_PageByteCnt;
        BINSize -= ((BINSize < pNandDrv->u16_PageByteCnt)?BINSize:pNandDrv->u16_PageByteCnt);
        if (i==pNandDrv->u16_BlkPageCnt)
        {
            row_pos += pNandDrv->u16_BlkPageCnt;
            i=0;
        }
        //_PUTDW(BINSize);
    }
    return 0;
}




U32 drvNAND_BFN_FLASH_INFO(U32 bfn_type,U32 bfn_blk,U32 bfn_addr, int size)
{
    NAND_DRIVER *pNandDrv = (NAND_DRIVER*)drvNAND_get_DrvContext_address();

    printf("byte per page %d page per block %d total block %d\n", pNandDrv->u16_PageByteCnt, pNandDrv->u16_BlkPageCnt, pNandDrv->u16_BlkCnt);

    nand_buffer = (unsigned char *)bfn_addr;

    switch (bfn_type)
    {
    case 1://miu
        // if Partial Mode (if not 512B/page, set Partial Mode)
        drvNAND_WriteMIUParam(bfn_blk,bfn_addr);
        //drvNAND_ReadNANDMIUParam(); /* for Test */
        break;
    case 2://ldr
        drvNAND_WriteLoader(bfn_blk,(U8*)bfn_addr, size);
        break;
    case 3://app
        printf("bfn block %lx bfn address %lx\n",bfn_blk,bfn_addr);
        drvNAND_WriteBINParam(bfn_blk,(U8*)bfn_addr);
        break;
    case 4://chk
        printf("gogogogog\n");
        drvNAND_ReadNANDMIUParam();
        break;
    case 5://cis for box
        printf("refreshCIS for box use\n");
        drvNAND_RefreshCISMIUParam(bfn_blk,bfn_addr);
        break;
    case 6:
        printf("check for CIS correctness\n");
        drvNAND_SearchCISMIUParam();
    default:
        return 1;
    }

    return 0;
}
//=====================
#endif

