#!/bin/sh

# 用法：modify_ubi_partition.sh 128MiB 0x3000000 ubinize.cfg
# $1 为Flash的大小，单位为MiB
# $2 为JFFS2分区的偏移，单位为字节，用16进制表示
# $3 ubinize.cfg配置文件

FLASH_SIZE=$1
IMG_JFFS2_OFFSET=$2
UBI_CFG_FILE=$3

# 从128MiB中得到提取得到128整数
FLASH_SIZE=`echo $FLASH_SIZE|grep -o '[0-9]\+'`

# 将IMG_JFFS2_OFFSET转化为10进制
OFFSET=`printf "%d\n" $IMG_JFFS2_OFFSET`

# 将IMG_JFFS2_OFFSET的单位转化为MiB
val=`expr $OFFSET / 1024`
val2=`expr $val / 1024`

# 计算JFFS2分区的大小
UBI_SIZE=`expr $FLASH_SIZE - $val2`

# 按比例预留UBIFS的空间，用于卷标等信息， 每32MiB预留2MiB
UBI_SIZE_RESERVED=`expr $UBI_SIZE / 16`
UBI_SIZE_REST=`expr $UBI_SIZE - $UBI_SIZE_RESERVED`

#将原来的vol_size改为计算得到的vol_size
sed -i "s/vol_size=\([0-9]*\)MiB/vol_size=${UBI_SIZE_REST}MiB/" ${UBI_CFG_FILE};

