#!/bin/sh
# Version v1.00 20220229
# Used to compile nvmp dockers

# Changes and History:
# v1.01     - adapt for ssc33x
# v1.00	- first release

# License and Copyright:
# You can use, redistribute or modify this script in all cases for free.

cd ~/Camera_NVMP
git pull --rebase
_prib=0
_prsdk=0
_patch=
_branch=
_sdk=nvt9856x
#parse parameters
echo $@
for arg in $@
do
        case $arg in
		branch*)
               		_branch=${arg##branch=}
			;;
		patch*)
               		_patch=${arg##patch=}
			;;
		PR_IB*)
			_prib=${arg##PR_IB=}
			;;
		PR_SDK*)
			_prsdk=${arg##PR_SDK=}
			;;
		sdk*)	
			_sdk=${arg##sdk=}
			;;
		*)      
			PRODUCT_NAME=$arg
			#product name is like c310v3/c320wsv2/...
			;;
        esac
done

#git checkout to branch
if [ -z "$_branch" ];then
        echo "no need to checkout"
else
        echo "need to checkout to certain branch"
	git checkout $_branch
fi

#git pull certain changes that not merged yet
if [ -z "$_patch" ];then
        echo "no need to pull"
else
	PATCH_ARRAY=`echo $_patch | tr ',' ' '`
        echo "need to pull certain change that not merges"
	#how to check validation?
	for var in ${PATCH_ARRAY[@]}
	do
		git pull ssh://like@sohoicigit.rd.tp-link.net:29418/IPC/Camera_NVMP refs/changes/${var} --rebase
		git pull --rebase
	done
fi

#compile
cd ~/Camera_NVMP/nvmp
PRODUCT_ARRAY=`echo $PRODUCT_NAME | tr '/' ' '`
RM_LIST=`echo $PRODUCT_NAME | tr '/' '|'`
for var in ${PRODUCT_ARRAY[@]}
do
	echo $var
	if [ ! -d product_config/$var ]; then
		echo "invalid product name"
	else
		make PR_NAME=$var PR_IB=${_prib} PR_SDK=${_prsdk} V=s || exit 1
	fi
done

#delete files
cd ~/Camera_NVMP/nvmp
if [ "$_sdk" = "ssc33x" ]; then
	echo "remain ssc33x, rm nvt9856x"
        rm tp_package/ ../sdk/soc/nvt9856x ../sdk/soc/t31x ../sdk/wlan/ ../.git/ -rf
        cd ~/Camera_NVMP/sdk/soc/ssc33x/
        rm boot/ build/ linux-4.9.84/ -rf
else
        echo "remain nvt9856x, rm ssc33x"
        rm tp_package/ ../sdk/soc/ssc33x ../sdk/soc/t31x ../sdk/wlan/ ../.git/ -rf
        cd ~/Camera_NVMP/sdk/soc/nvt9856x/
        rm boot/ build/ linux-4.19.91/ -rf
fi

cd ~/Camera_NVMP/nvmp/build_dir
find . -name '*.c' -type f -print -exec rm -rf {} \;
rm -rf ~/.ssh/
cd ~/Camera_NVMP/nvmp/product_config
echo "rm list ${RM_LIST}"
rm -rf `ls |egrep -v "(${RM_LIST})"`






